/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FileSaverDescriptor
extends FileChooserDescriptor
implements Cloneable {
    private final List<String> extensions;

    public FileSaverDescriptor(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String description, String ... extensions2) {
        if (title == null) {
            FileSaverDescriptor.$$$reportNull$$$0(0);
        }
        if (description == null) {
            FileSaverDescriptor.$$$reportNull$$$0(1);
        }
        super(true, true, true, true, false, false);
        this.setTitle(title);
        this.setDescription(description);
        this.extensions = Arrays.asList(extensions2);
    }

    @Override
    public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
        return this.extensions.isEmpty() || file2.isDirectory() ? super.isFileVisible(file2, showHiddenFiles) : this.extensions.contains(file2.getExtension());
    }

    public String[] getFileExtensions() {
        return ArrayUtilRt.toStringArray(this.extensions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "description";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/fileChooser/FileSaverDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

