/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;

public class FileTypeDescriptor
extends FileChooserDescriptor {
    private final ImmutableList<String> myExtensions;

    public FileTypeDescriptor(String title, String ... extensions2) {
        if (extensions2 == null) {
            FileTypeDescriptor.$$$reportNull$$$0(0);
        }
        super(true, false, false, true, false, false);
        assert (extensions2.length > 0) : "There should be at least one extension";
        this.myExtensions = ContainerUtil.immutableList(ContainerUtil.map(extensions2, ext -> {
            if (ext.startsWith(".")) {
                return ext;
            }
            return "." + ext;
        }));
        this.setTitle(title);
    }

    @Override
    public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
        if (!showHiddenFiles && FileElement.isFileHidden(file2)) {
            return false;
        }
        if (file2.isDirectory()) {
            return true;
        }
        String name = file2.getName();
        for (String extension : this.myExtensions) {
            if (!name.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFileSelectable(VirtualFile file2) {
        return !file2.isDirectory() && this.isFileVisible(file2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/openapi/fileChooser/FileTypeDescriptor", "<init>"));
    }
}

