/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.ide.ui.ProductIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public final class GotoProjectDirectory
extends FileChooserAction {
    @Override
    protected void actionPerformed(FileSystemTree fileSystemTree, AnActionEvent e) {
        VirtualFile projectPath = GotoProjectDirectory.getProjectDir(e);
        if (projectPath != null) {
            fileSystemTree.select(projectPath, () -> fileSystemTree.expand(projectPath, null));
        }
    }

    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setIcon(ProductIcons.getInstance().getProjectIcon());
        VirtualFile projectPath = GotoProjectDirectory.getProjectDir(e);
        presentation.setEnabled(projectPath != null && fileSystemTree.isUnderRoots(projectPath));
    }

    @Nullable
    private static VirtualFile getProjectDir(AnActionEvent e) {
        VirtualFile projectFileDir = e.getData(PlatformDataKeys.PROJECT_FILE_DIRECTORY);
        return projectFileDir != null && projectFileDir.isValid() ? projectFileDir : null;
    }
}

