/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class VirtualFileDeleteProvider
implements DeleteProvider {
    private static final Logger LOG = Logger.getInstance(VirtualFileDeleteProvider.class);

    @Override
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        VirtualFile[] files2;
        if (dataContext == null) {
            VirtualFileDeleteProvider.$$$reportNull$$$0(0);
        }
        return (files2 = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && files2.length > 0;
    }

    @Override
    public void deleteElement(@NotNull DataContext dataContext) {
        VirtualFile[] files2;
        if (dataContext == null) {
            VirtualFileDeleteProvider.$$$reportNull$$$0(1);
        }
        if ((files2 = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) == null || files2.length == 0) {
            return;
        }
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        String message = VirtualFileDeleteProvider.createConfirmationMessage(files2);
        int returnValue = Messages.showOkCancelDialog(message, UIBundle.message("delete.dialog.title", new Object[0]), ApplicationBundle.message("button.delete", new Object[0]), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon());
        if (returnValue != 0) {
            return;
        }
        Arrays.sort(files2, FileComparator.getInstance());
        final LinkedList problems = new LinkedList();
        CommandProcessor.getInstance().executeCommand(project2, () -> new Task.Modal(project2, IdeBundle.message("progress.title.deleting.files", new Object[0]), true){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                int i = 0;
                for (VirtualFile file2 : files2) {
                    indicator.checkCanceled();
                    indicator.setText2(file2.getPresentableUrl());
                    indicator.setFraction((double)i / (double)files2.length);
                    ++i;
                    try {
                        WriteAction.runAndWait(() -> file2.delete(this));
                    }
                    catch (IOException e) {
                        LOG.info("Error when deleting " + file2, e);
                        problems.add(file2.getName());
                    }
                }
            }

            @Override
            public void onSuccess() {
                this.reportProblems();
            }

            @Override
            public void onCancel() {
                this.reportProblems();
            }

            private void reportProblems() {
                if (!problems.isEmpty()) {
                    VirtualFileDeleteProvider.reportDeletionProblem(problems);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileChooser/actions/VirtualFileDeleteProvider$1", "run"));
            }
        }.queue(), IdeBundle.message("command.deleting.files", new Object[0]), null);
    }

    private static void reportDeletionProblem(List<String> problems) {
        boolean more = false;
        if (problems.size() > 10) {
            problems = problems.subList(0, 10);
            more = true;
        }
        Messages.showMessageDialog(IdeBundle.message("dialog.message.could.not.erase.files.or.folders.0.1", StringUtil.join(problems, ",\n  "), more ? "\n  ..." : ""), UIBundle.message("error.dialog.title", new Object[0]), Messages.getErrorIcon());
    }

    private static String createConfirmationMessage(VirtualFile[] filesToDelete) {
        if (filesToDelete.length == 1) {
            if (filesToDelete[0].isDirectory()) {
                return UIBundle.message("are.you.sure.you.want.to.delete.selected.folder.confirmation.message", filesToDelete[0].getName());
            }
            return UIBundle.message("are.you.sure.you.want.to.delete.selected.file.confirmation.message", filesToDelete[0].getName());
        }
        boolean hasFiles = false;
        boolean hasFolders = false;
        for (VirtualFile file2 : filesToDelete) {
            boolean isDirectory = file2.isDirectory();
            hasFiles |= !isDirectory;
            hasFolders |= isDirectory;
        }
        LOG.assertTrue(hasFiles || hasFolders);
        if (hasFiles && hasFolders) {
            return UIBundle.message("are.you.sure.you.want.to.delete.selected.files.and.directories.confirmation.message", filesToDelete.length);
        }
        if (hasFolders) {
            return UIBundle.message("are.you.sure.you.want.to.delete.selected.folders.confirmation.message", filesToDelete.length);
        }
        return UIBundle.message("are.you.sure.you.want.to.delete.selected.files.and.files.confirmation.message", filesToDelete.length);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/openapi/fileChooser/actions/VirtualFileDeleteProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FileComparator
    implements Comparator<VirtualFile> {
        private static final FileComparator ourInstance = new FileComparator();

        private FileComparator() {
        }

        public static FileComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o2.getPath().compareTo(o1.getPath());
        }
    }
}

