/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSaverDialogImpl
extends FileChooserDialogImpl
implements FileSaverDialog {
    protected final JTextField myFileName;
    protected final JComboBox myExtensions;
    protected final FileSaverDescriptor myDescriptor;

    public FileSaverDialogImpl(@NotNull FileSaverDescriptor descriptor2, @NotNull Component parent) {
        if (descriptor2 == null) {
            FileSaverDialogImpl.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            FileSaverDialogImpl.$$$reportNull$$$0(1);
        }
        super((FileChooserDescriptor)descriptor2, parent);
        this.myFileName = new JTextField(20);
        this.myExtensions = new JComboBox();
        this.myDescriptor = descriptor2;
        for (String ext : descriptor2.getFileExtensions()) {
            this.myExtensions.addItem(ext);
        }
        this.setTitle(FileSaverDialogImpl.getChooserTitle(descriptor2));
    }

    public FileSaverDialogImpl(@NotNull FileSaverDescriptor descriptor2, @Nullable Project project2) {
        if (descriptor2 == null) {
            FileSaverDialogImpl.$$$reportNull$$$0(2);
        }
        super((FileChooserDescriptor)descriptor2, project2);
        this.myFileName = new JTextField(20);
        this.myExtensions = new JComboBox();
        this.myDescriptor = descriptor2;
        for (String ext : descriptor2.getFileExtensions()) {
            this.myExtensions.addItem(ext);
        }
        this.setTitle(FileSaverDialogImpl.getChooserTitle(descriptor2));
    }

    private static String getChooserTitle(FileSaverDescriptor descriptor2) {
        String title = descriptor2.getTitle();
        return title != null ? title : UIBundle.message("file.chooser.save.dialog.default.title", new Object[0]);
    }

    @Override
    @Nullable
    public VirtualFileWrapper save(@Nullable VirtualFile baseDir, @Nullable String filename) {
        this.init();
        this.restoreSelection(baseDir);
        this.myFileSystemTree.addListener(new FileSystemTree.Listener(){

            @Override
            public void selectionChanged(@NotNull List<? extends VirtualFile> selection) {
                if (selection == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileSaverDialogImpl.this.updateFileName(selection);
                FileSaverDialogImpl.this.updateOkButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/openapi/fileChooser/ex/FileSaverDialogImpl$1", "selectionChanged"));
            }
        }, this.myDisposable);
        if (filename != null) {
            this.myFileName.setText(filename);
        }
        this.show();
        if (this.getExitCode() == 0) {
            File file2 = this.getFile();
            return file2 == null ? null : new VirtualFileWrapper(file2);
        }
        return null;
    }

    @Nullable
    protected File getFile() {
        String selectedExtension;
        VirtualFile selected2 = this.myFileSystemTree.getSelectedFile();
        if (selected2 != null && !selected2.isDirectory()) {
            return new File(selected2.getPath());
        }
        String path2 = selected2 == null ? this.myPathTextField.getTextFieldText() : selected2.getPath();
        File dir = new File(path2);
        if (!dir.exists()) {
            return null;
        }
        if (dir.isDirectory()) {
            path2 = path2 + File.separator + this.myFileName.getText();
        }
        boolean correctExt = true;
        for (String ext : this.myDescriptor.getFileExtensions()) {
            correctExt = path2.endsWith("." + ext);
            if (correctExt) break;
        }
        if (!correctExt && !StringUtil.isEmpty(selectedExtension = ObjectUtils.doIfNotNull(this.myExtensions.getSelectedItem(), item -> item.toString()))) {
            path2 = path2 + "." + selectedExtension;
        }
        return new File(path2);
    }

    private void updateFileName(List<? extends VirtualFile> selection) {
        for (VirtualFile virtualFile2 : selection) {
            if (virtualFile2.isDirectory()) {
                this.myPathTextField.getField().setText(VfsUtil.getReadableUrl(virtualFile2));
                continue;
            }
            this.myFileName.setText(virtualFile2.getName());
            VirtualFile parent = virtualFile2.getParent();
            if (parent == null) continue;
            this.myPathTextField.getField().setText(VfsUtil.getReadableUrl(parent));
        }
        this.updateOkButton();
    }

    @Override
    protected JComponent createCenterPanel() {
        JComponent component2 = super.createCenterPanel();
        FileChooserDialogImpl.MyPanel panel2 = new FileChooserDialogImpl.MyPanel();
        panel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel2.add((Component)component2, "Center");
        panel2.add((Component)this.createFileNamePanel(), "South");
        return panel2;
    }

    protected JComponent createFileNamePanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JLabel(UIBundle.message("file.chooser.save.dialog.file.name", new Object[0])), "West");
        this.myFileName.setText("");
        this.myFileName.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileSaverDialogImpl.this.updateOkButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileChooser/ex/FileSaverDialogImpl$2", "textChanged"));
            }
        });
        panel2.add((Component)this.myFileName, "Center");
        if (this.myExtensions.getModel().getSize() > 0) {
            this.myExtensions.setSelectedIndex(0);
            panel2.add((Component)this.myExtensions, "East");
        }
        return panel2;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myFileName;
    }

    private boolean isFileNameExist() {
        if (this.myPathTextField == null) {
            return false;
        }
        String path2 = this.myPathTextField.getTextFieldText();
        return path2 != null && new File(path2.trim()).exists() && this.myFileName.getText().trim().length() > 0;
    }

    protected void updateOkButton() {
        this.setOKActionEnabled(true);
    }

    @Override
    public void setOKActionEnabled(boolean isEnabled) {
        super.setOKActionEnabled(this.isFileNameExist());
    }

    @Override
    protected void doOKAction() {
        File file2 = this.getFile();
        if (file2 != null && file2.exists() && 0 != Messages.showYesNoDialog(this.getRootPane(), UIBundle.message("file.chooser.save.dialog.confirmation", file2.getName()), UIBundle.message("file.chooser.save.dialog.confirmation.title", new Object[0]), Messages.getWarningIcon())) {
            return;
        }
        this.storeSelection(this.myFileSystemTree.getSelectedFile());
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/fileChooser/ex/FileSaverDialogImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

