/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.impl.FileComparator;
import com.intellij.openapi.fileChooser.impl.FileTreeBuilder;
import com.intellij.openapi.fileChooser.impl.FileTreeStructure;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.fileChooser.tree.FileNodeVisitor;
import com.intellij.openapi.fileChooser.tree.FileRefresher;
import com.intellij.openapi.fileChooser.tree.FileRenderer;
import com.intellij.openapi.fileChooser.tree.FileTreeModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSystemTreeImpl
implements FileSystemTree {
    private final Tree myTree;
    private final FileTreeStructure myTreeStructure;
    private final AbstractTreeBuilder myTreeBuilder;
    private final Project myProject;
    private final ArrayList<Runnable> myOkActions = new ArrayList(2);
    private final FileChooserDescriptor myDescriptor;
    private final FileTreeModel myFileTreeModel;
    private final AsyncTreeModel myAsyncTreeModel;
    private final List<FileSystemTree.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final MyExpansionListener myExpansionListener = new MyExpansionListener();
    private final Set<VirtualFile> myEverExpanded = new THashSet<VirtualFile>();

    public FileSystemTreeImpl(@Nullable Project project2, FileChooserDescriptor descriptor2) {
        this(project2, descriptor2, new Tree(), null, null, null);
        this.myTree.setRootVisible(descriptor2.isTreeRootVisible());
        this.myTree.setShowsRootHandles(true);
    }

    public FileSystemTreeImpl(@Nullable Project project2, FileChooserDescriptor descriptor2, Tree tree, @Nullable TreeCellRenderer renderer, @Nullable Runnable onInitialized, @Nullable Convertor<? super TreePath, String> speedSearchConverter) {
        this.myProject = project2;
        if (renderer == null && this.useNewAsyncModel()) {
            renderer = new FileRenderer().forTree();
            this.myFileTreeModel = this.createFileTreeModel(descriptor2, tree);
            this.myAsyncTreeModel = this.createAsyncTreeModel(this.myFileTreeModel);
            this.myTreeStructure = null;
        } else {
            this.myFileTreeModel = null;
            this.myAsyncTreeModel = null;
            this.myTreeStructure = new FileTreeStructure(project2, descriptor2);
        }
        this.myDescriptor = descriptor2;
        this.myTree = tree;
        if (this.myAsyncTreeModel != null) {
            this.myTree.setModel(this.myAsyncTreeModel);
            this.myTreeBuilder = null;
        } else {
            DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
            this.myTree.setModel(treeModel);
            this.myTree.addTreeExpansionListener(this.myExpansionListener);
            this.myTreeBuilder = this.createTreeBuilder(this.myTree, treeModel, this.myTreeStructure, FileComparator.getInstance(), descriptor2, () -> {
                this.myTree.expandPath(new TreePath(treeModel.getRoot()));
                if (onInitialized != null) {
                    onInitialized.run();
                }
            });
            Disposer.register(this.myTreeBuilder, new Disposable(){

                @Override
                public void dispose() {
                    FileSystemTreeImpl.this.myTree.removeTreeExpansionListener(FileSystemTreeImpl.this.myExpansionListener);
                }
            });
            if (project2 != null) {
                Disposer.register(project2, this.myTreeBuilder);
            }
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FileSystemTreeImpl.this.processSelectionChange();
            }
        });
        if (speedSearchConverter != null) {
            new TreeSpeedSearch(this.myTree, speedSearchConverter);
        } else {
            new TreeSpeedSearch(this.myTree);
        }
        TreeUtil.installActions(this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(descriptor2.isChooseMultiple() ? 4 : 1);
        this.registerTreeActions();
        if (renderer == null) {
            renderer = new NodeRenderer(){

                @Override
                public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    String comment;
                    if (tree == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    super.customizeCellRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
                    Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
                    if (userObject instanceof FileNodeDescriptor && (comment = ((FileNodeDescriptor)userObject).getComment()) != null) {
                        this.append(comment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/fileChooser/ex/FileSystemTreeImpl$3", "customizeCellRenderer"));
                }
            };
        }
        this.myTree.setCellRenderer(renderer);
    }

    @Deprecated
    protected boolean useNewAsyncModel() {
        return Registry.is("file.chooser.async.tree.model");
    }

    @NotNull
    protected FileTreeModel createFileTreeModel(@NotNull FileChooserDescriptor descriptor2, @NotNull Tree tree) {
        if (descriptor2 == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(1);
        }
        return new FileTreeModel(descriptor2, new FileRefresher(true, 3L, () -> ModalityState.stateForComponent(tree)));
    }

    @NotNull
    protected AsyncTreeModel createAsyncTreeModel(@NotNull FileTreeModel fileTreeModel) {
        if (fileTreeModel == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(2);
        }
        return new AsyncTreeModel(fileTreeModel, false, this);
    }

    protected AbstractTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor<?>> comparator2, FileChooserDescriptor descriptor2, @Nullable Runnable onInitialized) {
        return new FileTreeBuilder(tree, treeModel, treeStructure, comparator2, descriptor2, onInitialized);
    }

    private void registerTreeActions() {
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSystemTreeImpl.this.performEnterAction(true);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                FileSystemTreeImpl.this.performEnterAction(false);
                return true;
            }
        }.installOn(this.myTree);
    }

    private void performEnterAction(boolean toggleNodeState) {
        TreePath path2 = this.myTree.getSelectionPath();
        if (path2 != null) {
            if (this.isLeaf(path2)) {
                this.fireOkAction();
            } else if (toggleNodeState) {
                if (this.myTree.isExpanded(path2)) {
                    this.myTree.collapsePath(path2);
                } else {
                    this.myTree.expandPath(path2);
                }
            }
        }
    }

    public void addOkAction(Runnable action2) {
        this.myOkActions.add(action2);
    }

    private void fireOkAction() {
        for (Runnable action2 : this.myOkActions) {
            action2.run();
        }
    }

    public void registerMouseListener(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler(this.myTree, group, ActionManager.getInstance());
    }

    @Override
    public boolean areHiddensShown() {
        if (this.myAsyncTreeModel != null) {
            return this.myDescriptor.isShowHiddenFiles();
        }
        return this.myTreeStructure.areHiddensShown();
    }

    @Override
    public void showHiddens(boolean showHidden) {
        if (this.myAsyncTreeModel != null) {
            this.myDescriptor.withShowHiddenFiles(showHidden);
            if (this.myFileTreeModel != null) {
                this.myFileTreeModel.invalidate();
            }
        } else {
            this.myTreeStructure.showHiddens(showHidden);
        }
        this.updateTree();
    }

    @Override
    public void updateTree() {
        if (this.myTreeBuilder != null) {
            this.myTreeBuilder.queueUpdate();
        }
    }

    @Override
    public void dispose() {
        if (this.myTreeBuilder != null) {
            Disposer.dispose(this.myTreeBuilder);
        }
        this.myEverExpanded.clear();
    }

    public AbstractTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    @Override
    public void select(VirtualFile file2, @Nullable Runnable onDone) {
        this.select(new VirtualFile[]{file2}, onDone);
    }

    @Override
    public void select(VirtualFile[] file2, @Nullable Runnable onDone) {
        block7: {
            block6: {
                if (this.myAsyncTreeModel == null) break block6;
                switch (file2.length) {
                    case 0: {
                        this.myTree.clearSelection();
                        if (onDone != null) {
                            onDone.run();
                            break;
                        }
                        break block7;
                    }
                    case 1: {
                        this.myTree.clearSelection();
                        TreeUtil.promiseSelect((JTree)this.myTree, new FileNodeVisitor(file2[0])).onProcessed(path2 -> {
                            if (onDone != null) {
                                onDone.run();
                            }
                        });
                        break;
                    }
                    default: {
                        this.myTree.clearSelection();
                        TreeUtil.promiseSelect((JTree)this.myTree, Stream.of(file2).map(FileNodeVisitor::new)).onProcessed(paths -> {
                            if (onDone != null) {
                                onDone.run();
                            }
                        });
                        break;
                    }
                }
                break block7;
            }
            Object[] elements2 = new Object[file2.length];
            for (int i = 0; i < file2.length; ++i) {
                VirtualFile eachFile = file2[i];
                elements2[i] = FileSystemTreeImpl.getFileElementFor(eachFile);
            }
            this.myTreeBuilder.select(elements2, onDone);
        }
    }

    @Override
    public void expand(VirtualFile file2, @Nullable Runnable onDone) {
        if (this.myAsyncTreeModel != null) {
            TreeUtil.promiseExpand((JTree)this.myTree, new FileNodeVisitor(file2)).onSuccess(path2 -> {
                if (path2 != null && onDone != null) {
                    onDone.run();
                }
            });
        } else {
            this.myTreeBuilder.expand(FileSystemTreeImpl.getFileElementFor(file2), onDone);
        }
    }

    @Nullable
    private static FileElement getFileElementFor(@NotNull VirtualFile file2) {
        VirtualFile selectFile;
        if (file2 == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(3);
        }
        if (file2.getFileSystem() instanceof JarFileSystem && file2.getParent() == null) {
            selectFile = JarFileSystem.getInstance().getVirtualFileForJar(file2);
            if (selectFile == null) {
                return null;
            }
        } else {
            selectFile = file2;
        }
        return new FileElement(selectFile, selectFile.getName());
    }

    public Exception createNewFolder(final VirtualFile parentDirectory, final String newFolderName) {
        final Exception[] failReason = new Exception[]{null};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VirtualFile parent = parentDirectory;
                            for (String name : StringUtil.tokenize(newFolderName, "\\/")) {
                                VirtualFile folder = parent.createChildDirectory(this, name);
                                FileSystemTreeImpl.this.updateTree();
                                FileSystemTreeImpl.this.select(folder, null);
                                parent = folder;
                            }
                        }
                        catch (IOException e) {
                            failReason[0] = e;
                        }
                    }
                });
            }
        }, UIBundle.message("file.chooser.create.new.folder.command.name", new Object[0]), null);
        return failReason[0];
    }

    public Exception createNewFile(final VirtualFile parentDirectory, final String newFileName, final FileType fileType, final String initialContent) {
        final Exception[] failReason = new Exception[]{null};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String newFileNameWithExtension = newFileName.endsWith('.' + fileType.getDefaultExtension()) ? newFileName : newFileName + '.' + fileType.getDefaultExtension();
                            VirtualFile file2 = parentDirectory.createChildData(this, newFileNameWithExtension);
                            VfsUtil.saveText(file2, initialContent != null ? initialContent : "");
                            FileSystemTreeImpl.this.updateTree();
                            FileSystemTreeImpl.this.select(file2, null);
                        }
                        catch (IOException e) {
                            failReason[0] = e;
                        }
                    }
                });
            }
        }, UIBundle.message("file.chooser.create.new.file.command.name", new Object[0]), null);
        return failReason[0];
    }

    @Override
    public JTree getTree() {
        return this.myTree;
    }

    @Override
    @Nullable
    public VirtualFile getSelectedFile() {
        TreePath path2 = this.myTree.getSelectionPath();
        if (path2 == null) {
            return null;
        }
        return FileSystemTreeImpl.getVirtualFile(path2);
    }

    @Override
    @Nullable
    public VirtualFile getNewFileParent() {
        VirtualFile selected2 = this.getSelectedFile();
        if (selected2 != null) {
            return selected2;
        }
        List<VirtualFile> roots = this.myDescriptor.getRoots();
        return roots.size() == 1 ? roots.get(0) : null;
    }

    @Override
    public <T> T getData(@NotNull DataKey<T> key) {
        if (key == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(4);
        }
        return this.myDescriptor.getUserData(key);
    }

    @Override
    public VirtualFile @NotNull [] getSelectedFiles() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                FileSystemTreeImpl.$$$reportNull$$$0(5);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (TreePath path2 : paths) {
            VirtualFile file2 = FileSystemTreeImpl.getVirtualFile(path2);
            if (file2 == null || !file2.isValid()) continue;
            files2.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files2);
        if (virtualFileArray == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(6);
        }
        return virtualFileArray;
    }

    private boolean isLeaf(TreePath path2) {
        Object component2 = path2.getLastPathComponent();
        if (component2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component2;
            return node.isLeaf();
        }
        return this.myAsyncTreeModel != null && this.myAsyncTreeModel.isLeaf(component2);
    }

    static VirtualFile getVirtualFile(TreePath path2) {
        Object node;
        Object userObject;
        Object component2 = path2.getLastPathComponent();
        if (component2 instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)(node = (DefaultMutableTreeNode)component2)).getUserObject()) instanceof FileNodeDescriptor) {
            FileNodeDescriptor descriptor2 = (FileNodeDescriptor)userObject;
            return descriptor2.getElement().getFile();
        }
        if (component2 instanceof FileNode) {
            node = (FileNode)component2;
            return ((FileNode)node).getFile();
        }
        return null;
    }

    @Override
    public boolean selectionExists() {
        TreePath[] selectedPaths = this.myTree.getSelectionPaths();
        return selectedPaths != null && selectedPaths.length != 0;
    }

    @Override
    public boolean isUnderRoots(@NotNull VirtualFile file2) {
        List<VirtualFile> roots;
        if (file2 == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(7);
        }
        if ((roots = this.myDescriptor.getRoots()).size() == 0) {
            return true;
        }
        for (VirtualFile root : roots) {
            if (root == null || !VfsUtilCore.isAncestor(root, file2, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(final FileSystemTree.Listener listener2, Disposable parent) {
        this.myListeners.add(listener2);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                FileSystemTreeImpl.this.myListeners.remove(listener2);
            }
        });
    }

    private void fireSelection(@NotNull List<? extends VirtualFile> selection) {
        if (selection == null) {
            FileSystemTreeImpl.$$$reportNull$$$0(8);
        }
        for (FileSystemTree.Listener each : this.myListeners) {
            each.selectionChanged(selection);
        }
    }

    private void processSelectionChange() {
        if (this.myListeners.size() == 0) {
            return;
        }
        ArrayList<VirtualFile> selection = new ArrayList<VirtualFile>();
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath each : paths) {
                VirtualFile file2 = FileSystemTreeImpl.getVirtualFile(each);
                if (file2 == null) continue;
                selection.add(file2);
            }
        }
        this.fireSelection(selection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTreeModel";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/ex/FileSystemTreeImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileSystemTreeImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAsyncTreeModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileElementFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyExpansionListener
    implements TreeExpansionListener {
        private MyExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            FileNodeDescriptor nodeDescriptor;
            FileElement fileDescriptor;
            VirtualFile virtualFile2;
            if (FileSystemTreeImpl.this.myTreeBuilder == null || !FileSystemTreeImpl.this.myTreeBuilder.isNodeBeingBuilt(event.getPath())) {
                return;
            }
            TreePath path2 = event.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
            if (node.getUserObject() instanceof FileNodeDescriptor && (virtualFile2 = (fileDescriptor = (nodeDescriptor = (FileNodeDescriptor)node.getUserObject()).getElement()).getFile()) != null) {
                if (!FileSystemTreeImpl.this.myEverExpanded.contains(virtualFile2)) {
                    if (virtualFile2 instanceof NewVirtualFile) {
                        ((NewVirtualFile)virtualFile2).markDirty();
                    }
                    FileSystemTreeImpl.this.myEverExpanded.add(virtualFile2);
                }
                boolean async = FileSystemTreeImpl.this.myTreeBuilder.isToBuildChildrenInBackground(virtualFile2);
                if (virtualFile2 instanceof NewVirtualFile) {
                    RefreshQueue.getInstance().refresh(async, false, null, ModalityState.stateForComponent(FileSystemTreeImpl.this.myTree), virtualFile2);
                } else {
                    virtualFile2.refresh(async, false);
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

