/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.update.LazyUiDisposable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTextFieldImpl
implements FileLookup,
Disposable,
FileTextField {
    private static final Logger LOG = Logger.getInstance(FileTextFieldImpl.class);
    private final Object myLock = new Object();
    private final JTextField myPathTextField;
    private CompletionResult myCurrentCompletion;
    private JBPopup myCurrentPopup;
    private JBPopup myNoSuggestionsPopup;
    private JList myList;
    private MergingUpdateQueue myUiUpdater;
    private boolean myPathIsUpdating;
    private FileLookup.Finder myFinder;
    private FileLookup.LookupFilter myFilter;
    private String myCompletionBase;
    private int myCurrentCompletionsPos = 1;
    private String myFileSpitRegExp;
    protected boolean myAutopopup = false;
    private CancelAction myCancelAction;
    private final Set<Action> myDisabledTextActions;
    private Map<String, String> myMacroMap;

    public FileTextFieldImpl(FileLookup.Finder finder, FileLookup.LookupFilter filter2, Map<String, String> macroMap) {
        this(new JTextField(), finder, filter2, macroMap, null);
    }

    public FileTextFieldImpl(JTextField field, FileLookup.Finder finder, FileLookup.LookupFilter filter2, Map<String, String> macroMap, Disposable parent) {
        this.myPathTextField = field;
        this.myMacroMap = new TreeMap<String, String>(macroMap);
        InputMap listMap = (InputMap)UIManager.getDefaults().get("List.focusInputMap");
        KeyStroke[] listKeys = listMap.keys();
        this.myDisabledTextActions = new HashSet<Action>();
        for (KeyStroke eachListStroke : listKeys) {
            Action textAction;
            Object textActionID;
            String listActionID = (String)listMap.get(eachListStroke);
            if (!"selectNextRow".equals(listActionID) && !"selectPreviousRow".equals(listActionID) || (textActionID = field.getInputMap().get(eachListStroke)) == null || (textAction = field.getActionMap().get(textActionID)) == null) continue;
            this.myDisabledTextActions.add(textAction);
        }
        FileTextFieldImpl assigned = (FileTextFieldImpl)this.myPathTextField.getClientProperty("fileTextField");
        if (assigned != null) {
            assigned.myFinder = finder;
            assigned.myFilter = filter2;
            return;
        }
        this.myPathTextField.putClientProperty("fileTextField", this);
        boolean headless = ApplicationManager.getApplication().isUnitTestMode();
        this.myUiUpdater = new MergingUpdateQueue("FileTextField.UiUpdater", 200, false, this.myPathTextField);
        if (!headless) {
            new UiNotifyConnector(this.myPathTextField, this.myUiUpdater);
        }
        this.myFinder = finder;
        this.myFilter = filter2;
        this.myFileSpitRegExp = this.myFinder.getSeparator().replaceAll("\\\\", "\\\\\\\\");
        this.myPathTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileTextFieldImpl.this.processTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileTextFieldImpl.this.processTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FileTextFieldImpl.this.processTextChanged();
            }
        });
        this.myPathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FileTextFieldImpl.this.processListSelection(e);
            }
        });
        this.myPathTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileTextFieldImpl.this.closePopup();
            }
        });
        this.myCancelAction = new CancelAction();
        new LazyUiDisposable<FileTextFieldImpl>(parent, (JComponent)field, this){

            @Override
            protected void initialize(@NotNull Disposable parent, @NotNull FileTextFieldImpl child2, @Nullable Project project2) {
                if (parent == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (child2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                Disposer.register(child2, FileTextFieldImpl.this.myUiUpdater);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "child";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl$4";
                objectArray[2] = "initialize";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMacroMap(Map<String, String> macroMap) {
        Object object = this.myLock;
        synchronized (object) {
            this.myMacroMap = new TreeMap<String, String>(macroMap);
        }
    }

    @Override
    public void dispose() {
    }

    private void processTextChanged() {
        if (this.myAutopopup && !this.isPathUpdating()) {
            this.hideCurrentPopup();
            this.suggestCompletion(false, false);
        }
        this.onTextChanged(this.getTextFieldText());
    }

    protected void onTextChanged(String newValue) {
    }

    private void suggestCompletion(final boolean selectReplacedText, final boolean isExplicitCall) {
        int index;
        if (isExplicitCall) {
            this.myAutopopup = true;
        }
        if (!this.getField().isFocusOwner()) {
            return;
        }
        final CompletionResult result2 = new CompletionResult();
        if (this.myList != null && this.myCurrentCompletion != null && (index = this.myList.getSelectedIndex()) >= 0 && index < this.myList.getModel().getSize()) {
            result2.myPreselected = (FileLookup.LookupFile)this.myList.getSelectedValue();
        }
        this.myUiUpdater.queue(new Update((Object)"textField.suggestCompletion"){

            @Override
            public void run() {
                FileLookup.LookupFile file2;
                String completionBase = FileTextFieldImpl.this.getCompletionBase();
                if (completionBase != null && (file2 = FileTextFieldImpl.this.myFinder.find(completionBase)) != null && file2.exists() && !file2.isDirectory()) {
                    return;
                }
                result2.myCompletionBase = completionBase;
                if (result2.myCompletionBase == null) {
                    return;
                }
                result2.myFieldText = FileTextFieldImpl.this.myPathTextField.getText();
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    FileTextFieldImpl.this.processCompletion(result2);
                    SwingUtilities.invokeLater(() -> {
                        if (!result22.myCompletionBase.equals(FileTextFieldImpl.this.getCompletionBase())) {
                            return;
                        }
                        int pos = FileTextFieldImpl.this.selectCompletionRemoveText(result2, selectReplacedText);
                        FileTextFieldImpl.this.showCompletionPopup(result2, pos, isExplicitCall);
                    });
                });
            }
        });
    }

    private int selectCompletionRemoveText(CompletionResult result2, boolean selectReplacedText) {
        int pos = this.myPathTextField.getCaretPosition();
        if (result2.myToComplete.size() > 0 && selectReplacedText) {
            this.myPathTextField.setCaretPosition(this.myPathTextField.getText().length());
            this.myPathTextField.moveCaretPosition(pos);
        }
        return pos;
    }

    @Nullable
    public String getAdText(CompletionResult result2) {
        if (result2.myCompletionBase == null) {
            return null;
        }
        if (result2.myCompletionBase.length() == result2.myFieldText.length()) {
            return null;
        }
        String strokeText = KeymapUtil.getFirstKeyboardShortcutText(ActionManager.getInstance().getAction("EditorChooseLookupItemReplace"));
        return IdeBundle.message("file.chooser.completion.ad.text", strokeText);
    }

    private void showCompletionPopup(CompletionResult result2, int position, boolean isExplicit) {
        if (this.myList == null) {
            this.myList = new JBList();
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter(){

                public String getTextFor(Object value2) {
                    FileLookup.LookupFile file2 = (FileLookup.LookupFile)value2;
                    if (file2.getMacro() != null) {
                        return file2.getMacro();
                    }
                    return (FileTextFieldImpl.this.myCurrentCompletion != null && ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myKidsAfterSeparator.contains(file2) ? FileTextFieldImpl.this.myFinder.getSeparator() : "") + file2.getName();
                }

                public Icon getIconFor(Object value2) {
                    FileLookup.LookupFile file2 = (FileLookup.LookupFile)value2;
                    return file2.getIcon();
                }

                @Nullable
                private Separator getSeparatorAboveOf(Object value2) {
                    FileLookup.LookupFile prev;
                    if (FileTextFieldImpl.this.myCurrentCompletion == null) {
                        return null;
                    }
                    FileLookup.LookupFile file2 = (FileLookup.LookupFile)value2;
                    int fileIndex = ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.indexOf(file2);
                    if (fileIndex > 0 && !((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myMacros.contains(file2) && ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myMacros.contains(prev = ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.get(fileIndex - 1))) {
                        return new Separator("");
                    }
                    if (((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myKidsAfterSeparator.indexOf(file2) == 0 && ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.mySiblings.size() > 0) {
                        FileLookup.LookupFile parent = file2.getParent();
                        return parent == null ? new Separator("") : new Separator(parent.getName());
                    }
                    if (((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myMacros.size() > 0 && fileIndex == 0) {
                        return new Separator(FileTextFieldImpl.this.getPathVariablesSeparatorText());
                    }
                    return null;
                }

                public boolean hasSeparatorAboveOf(Object value2) {
                    return this.getSeparatorAboveOf(value2) != null;
                }

                public String getCaptionAboveOf(Object value2) {
                    Separator separator = this.getSeparatorAboveOf(value2);
                    return separator != null ? separator.getText() : null;
                }
            }));
        }
        if (this.myCurrentPopup != null) {
            this.closePopup();
        }
        this.myCurrentCompletion = result2;
        this.myCurrentCompletionsPos = position;
        if (this.myCurrentCompletion.myToComplete.size() == 0) {
            this.showNoSuggestions(isExplicit);
            return;
        }
        this.myList.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.size();
            }

            @Override
            public Object getElementAt(int index) {
                return ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.get(index);
            }
        });
        this.myList.getSelectionModel().clearSelection();
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createListPopupBuilder(this.myList);
        builder2.addListener(new JBPopupListener(){

            @Override
            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                FileTextFieldImpl.this.myPathTextField.registerKeyboardAction(FileTextFieldImpl.this.myCancelAction, KeyStroke.getKeyStroke(27, 0), 2);
                for (Action each : FileTextFieldImpl.this.myDisabledTextActions) {
                    each.setEnabled(false);
                }
            }

            @Override
            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(1);
                }
                FileTextFieldImpl.this.myPathTextField.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
                for (Action each : FileTextFieldImpl.this.myDisabledTextActions) {
                    each.setEnabled(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myCurrentPopup = ((PopupChooserBuilder)((PopupChooserBuilder)((PopupChooserBuilder)((PopupChooserBuilder)((PopupChooserBuilder)((PopupChooserBuilder)((PopupChooserBuilder)builder2.setRequestFocus(false)).setAdText(this.getAdText(this.myCurrentCompletion))).setAutoSelectIfEmpty(false)).setResizable(false)).setCancelCallback(() -> {
            int caret = this.myPathTextField.getCaretPosition();
            this.myPathTextField.setSelectionStart(caret);
            this.myPathTextField.setSelectionEnd(caret);
            this.myPathTextField.setFocusTraversalKeysEnabled(true);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.getField(), true));
            return Boolean.TRUE;
        })).setItemChoosenCallback(() -> this.processChosenFromCompletion(false)).setCancelKeyEnabled(false)).setAlpha(0.1f)).setFocusOwners(new Component[]{this.myPathTextField}).createPopup();
        if (result2.myPreselected != null) {
            this.myList.setSelectedValue(result2.myPreselected, false);
        }
        this.myPathTextField.setFocusTraversalKeysEnabled(false);
        this.myCurrentPopup.showInScreenCoordinates(this.getField(), FileTextFieldImpl.getLocationForCaret(this.myPathTextField));
    }

    @NotNull
    protected String getPathVariablesSeparatorText() {
        String string = IdeBundle.message("file.chooser.completion.path.variables.text", new Object[0]);
        if (string == null) {
            FileTextFieldImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void showNoSuggestions(boolean isExplicit) {
        this.hideCurrentPopup();
        if (!isExplicit) {
            return;
        }
        JComponent message = HintUtil.createErrorLabel(IdeBundle.message("file.chooser.completion.no.suggestions", new Object[0]));
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder(message, message);
        builder2.setRequestFocus(false).setResizable(false).setAlpha(0.1f).setFocusOwners(new Component[]{this.myPathTextField});
        this.myNoSuggestionsPopup = builder2.createPopup();
        this.myNoSuggestionsPopup.showInScreenCoordinates(this.getField(), FileTextFieldImpl.getLocationForCaret(this.myPathTextField));
    }

    private void hideCurrentPopup() {
        if (this.myCurrentPopup != null) {
            this.myCurrentPopup.cancel();
            this.myCurrentPopup = null;
        }
        if (this.myNoSuggestionsPopup != null) {
            this.myNoSuggestionsPopup.cancel();
            this.myNoSuggestionsPopup = null;
        }
    }

    private static Point getLocationForCaret(JTextComponent pathTextField) {
        Point point;
        int position = pathTextField.getCaretPosition();
        try {
            Rectangle rec = pathTextField.modelToView(position);
            point = new Point((int)rec.getMaxX(), (int)rec.getMaxY());
        }
        catch (BadLocationException e) {
            point = pathTextField.getCaret().getMagicCaretPosition();
        }
        SwingUtilities.convertPointToScreen(point, pathTextField);
        point.y += 2;
        return point;
    }

    public void processCompletion(final CompletionResult result2) {
        result2.myToComplete = new ArrayList<FileLookup.LookupFile>();
        result2.mySiblings = new ArrayList<FileLookup.LookupFile>();
        result2.myKidsAfterSeparator = new ArrayList<FileLookup.LookupFile>();
        final String typed = result2.myCompletionBase;
        if (typed == null) {
            return;
        }
        this.addMacroPaths(result2, typed);
        String typedText = this.myFinder.normalize(typed);
        result2.myClosestParent = result2.current = this.getClosestParent(typed);
        if (result2.current != null) {
            String currentGrandparentText;
            result2.currentParentMatch = SystemInfo.isFileSystemCaseSensitive ? typedText.equals(result2.current.getAbsolutePath()) : typedText.equalsIgnoreCase(result2.current.getAbsolutePath());
            result2.closedPath = typed.endsWith(this.myFinder.getSeparator()) && typedText.length() > this.myFinder.getSeparator().length();
            String currentParentText = result2.current.getAbsolutePath();
            if (!StringUtil.toUpperCase(typedText).startsWith(StringUtil.toUpperCase(currentParentText))) {
                return;
            }
            String prefix = typedText.substring(currentParentText.length());
            if (prefix.startsWith(this.myFinder.getSeparator())) {
                prefix = prefix.substring(this.myFinder.getSeparator().length());
            } else if (typed.endsWith(this.myFinder.getSeparator())) {
                prefix = "";
            }
            result2.effectivePrefix = prefix;
            result2.currentGrandparent = result2.current.getParent();
            if (result2.currentGrandparent != null && result2.currentParentMatch && !result2.closedPath && StringUtil.startsWithConcatenation(typedText, currentGrandparentText = result2.currentGrandparent.getAbsolutePath(), this.myFinder.getSeparator())) {
                result2.grandparentPrefix = currentParentText.substring(currentGrandparentText.length() + this.myFinder.getSeparator().length());
            }
        } else {
            result2.effectivePrefix = typedText;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (result2.current != null) {
                    result2.myToComplete.addAll(this.getMatchingChildren(result2.effectivePrefix, result2.current));
                    if (result2.currentParentMatch && !result2.closedPath && !typed.isEmpty()) {
                        result2.myKidsAfterSeparator.addAll(result2.myToComplete);
                    }
                    if (result2.grandparentPrefix != null) {
                        List<FileLookup.LookupFile> siblings = this.getMatchingChildren(result2.grandparentPrefix, result2.currentGrandparent);
                        result2.myToComplete.addAll(0, siblings);
                        result2.mySiblings.addAll(siblings);
                    }
                }
                int currentDiff = Integer.MIN_VALUE;
                FileLookup.LookupFile toPreselect = result2.myPreselected;
                if (toPreselect == null || !result2.myToComplete.contains(toPreselect)) {
                    boolean toPreselectFixed = false;
                    if (result2.effectivePrefix.length() > 0) {
                        for (FileLookup.LookupFile each : result2.myToComplete) {
                            int diff;
                            String eachName = StringUtil.toUpperCase(each.getName());
                            if (!eachName.startsWith(result2.effectivePrefix) || (currentDiff = Math.max(diff = result2.effectivePrefix.compareTo(eachName), currentDiff)) != diff) continue;
                            toPreselect = each;
                            toPreselectFixed = true;
                            break;
                        }
                        if (!toPreselectFixed) {
                            toPreselect = null;
                        }
                    } else {
                        toPreselect = null;
                    }
                    if (toPreselect == null) {
                        if (result2.myToComplete.size() == 1) {
                            toPreselect = result2.myToComplete.get(0);
                        } else if (result2.effectivePrefix.length() == 0 && result2.mySiblings.size() > 0) {
                            toPreselect = result2.mySiblings.get(0);
                        }
                        if (toPreselect == null && !result2.myToComplete.contains(toPreselect) && result2.myToComplete.size() > 0) {
                            toPreselect = result2.myToComplete.get(0);
                        }
                    }
                }
                if (result2.currentParentMatch && result2.mySiblings.size() > 0) {
                    toPreselect = null;
                }
                result2.myPreselected = toPreselect;
            }

            private List<FileLookup.LookupFile> getMatchingChildren(String prefix, FileLookup.LookupFile parent) {
                final MinusculeMatcher matcher = FileTextFieldImpl.createMatcher(prefix);
                return parent.getChildren(new FileLookup.LookupFilter(){

                    @Override
                    public boolean isAccepted(FileLookup.LookupFile file2) {
                        return !file2.equals(result2.current) && FileTextFieldImpl.this.myFilter.isAccepted(file2) && matcher.matches(file2.getName());
                    }
                });
            }
        });
    }

    private static MinusculeMatcher createMatcher(String prefix) {
        return NameUtil.buildMatcher("*" + prefix, NameUtil.MatchingCaseSensitivity.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMacroPaths(CompletionResult result2, String typedText) {
        Map<String, String> macroMap;
        result2.myMacros = new ArrayList<FileLookup.LookupFile>();
        MinusculeMatcher matcher = FileTextFieldImpl.createMatcher(typedText);
        Iterator<String> iterator2 = this.myLock;
        synchronized (iterator2) {
            macroMap = this.myMacroMap;
        }
        for (String eachMacro : macroMap.keySet()) {
            FileLookup.LookupFile macroFile;
            String eachPath;
            if (!matcher.matches(eachMacro) || (eachPath = macroMap.get(eachMacro)) == null || (macroFile = this.myFinder.find(eachPath)) == null || !macroFile.exists()) continue;
            result2.myMacros.add(macroFile);
            result2.myToComplete.add(macroFile);
            macroFile.setMacro(eachMacro);
        }
    }

    @Nullable
    private FileLookup.LookupFile getClosestParent(String typed) {
        if (typed == null) {
            return null;
        }
        FileLookup.LookupFile lastFound = this.myFinder.find(typed);
        if (lastFound == null) {
            return null;
        }
        if (typed.isEmpty()) {
            return lastFound;
        }
        if (lastFound.exists()) {
            if (typed.charAt(typed.length() - 1) != File.separatorChar) {
                return lastFound.getParent();
            }
            return lastFound;
        }
        String[] splits = this.myFinder.normalize(typed).split(this.myFileSpitRegExp);
        StringBuilder fullPath = new StringBuilder();
        for (int i = 0; i < splits.length; ++i) {
            FileLookup.LookupFile file2;
            String each = splits[i];
            fullPath.append(each);
            if (i < splits.length - 1) {
                fullPath.append(this.myFinder.getSeparator());
            }
            if ((file2 = this.myFinder.find(fullPath.toString())) == null || !file2.exists()) {
                return lastFound;
            }
            lastFound = file2;
        }
        return lastFound;
    }

    @Nullable
    public FileLookup.LookupFile getFile() {
        String text2 = this.getTextFieldText();
        if (text2 == null) {
            return null;
        }
        return this.myFinder.find(text2);
    }

    private void processChosenFromCompletion(boolean nameOnly) {
        block12: {
            FileLookup.LookupFile file2 = this.getSelectedFileFromCompletionPopup();
            if (file2 == null) {
                return;
            }
            if (nameOnly) {
                try {
                    int end;
                    int start2;
                    int caretPos;
                    Document doc = this.myPathTextField.getDocument();
                    if (this.myFinder.getSeparator().equals(doc.getText(caretPos, 1))) {
                        for (caretPos = this.myPathTextField.getCaretPosition(); caretPos < doc.getLength(); ++caretPos) {
                            String eachChar = doc.getText(caretPos, 1);
                            if (!this.myFinder.getSeparator().equals(eachChar)) break;
                        }
                    }
                    int n = start2 = caretPos > 0 ? caretPos - 1 : caretPos;
                    while (start2 >= 0) {
                        String each = doc.getText(start2, 1);
                        if (this.myFinder.getSeparator().equals(each)) {
                            ++start2;
                            break;
                        }
                        --start2;
                    }
                    int n2 = end = start2 < caretPos ? caretPos : start2;
                    while (end <= doc.getLength()) {
                        String each = doc.getText(end, 1);
                        if (this.myFinder.getSeparator().equals(each)) break;
                        ++end;
                    }
                    if (end > doc.getLength()) {
                        end = doc.getLength();
                    }
                    if (start2 > end || start2 < 0 || end > doc.getLength()) {
                        this.setTextToFile(file2);
                        break block12;
                    }
                    this.replacePathComponent(file2, caretPos, start2, end);
                }
                catch (BadLocationException e) {
                    LOG.error(e);
                }
            } else {
                this.setTextToFile(file2);
            }
        }
    }

    private void replacePathComponent(FileLookup.LookupFile file2, int caretPos, int start2, int end) throws BadLocationException {
        int newPos;
        boolean toRemoveExistingName;
        Document doc = this.myPathTextField.getDocument();
        this.myPathTextField.setSelectionStart(0);
        this.myPathTextField.setSelectionEnd(0);
        String name = file2.getName();
        String prefix = "";
        if (caretPos >= start2) {
            prefix = doc.getText(start2, caretPos - start2);
            if (prefix.length() == 0) {
                prefix = doc.getText(start2, end - start2);
            }
            toRemoveExistingName = SystemInfo.isFileSystemCaseSensitive ? name.startsWith(prefix) && prefix.length() > 0 : StringUtil.toUpperCase(name).startsWith(StringUtil.toUpperCase(prefix)) && prefix.length() > 0;
        } else {
            toRemoveExistingName = true;
        }
        if (toRemoveExistingName) {
            doc.remove(start2, end - start2);
            doc.insertString(start2, name, doc.getDefaultRootElement().getAttributes());
            newPos = start2 + name.length();
        } else {
            doc.insertString(caretPos, name, doc.getDefaultRootElement().getAttributes());
            newPos = caretPos + name.length();
        }
        if (file2.isDirectory() && !this.myFinder.getSeparator().equals(doc.getText(newPos, 1))) {
            doc.insertString(newPos, this.myFinder.getSeparator(), doc.getDefaultRootElement().getAttributes());
            ++newPos;
        }
        if (newPos < doc.getLength() && this.myFinder.getSeparator().equals(doc.getText(newPos, 1))) {
            ++newPos;
        }
        this.myPathTextField.setCaretPosition(newPos);
    }

    protected void setTextToFile(FileLookup.LookupFile file2) {
        String text2 = file2.getAbsolutePath();
        if (file2.isDirectory() && !text2.endsWith(this.myFinder.getSeparator())) {
            text2 = text2 + this.myFinder.getSeparator();
        }
        this.myPathTextField.setText(text2);
    }

    private void processListSelection(KeyEvent e) {
        Action action2;
        Object object;
        if (this.togglePopup(e)) {
            return;
        }
        if (!this.isPopupShowing()) {
            return;
        }
        InputMap map2 = this.myPathTextField.getInputMap(2);
        if (map2 != null && (object = map2.get(KeyStroke.getKeyStrokeForEvent(e))) instanceof Action && (action2 = (Action)object).isEnabled()) {
            action2.actionPerformed(new ActionEvent(this, 1001, "action"));
            e.consume();
            return;
        }
        Object action3 = FileTextFieldImpl.getAction(e, this.myList);
        if ("selectNextRow".equals(action3)) {
            if (this.ensureSelectionExists()) {
                ScrollingUtil.moveDown(this.myList, e.getModifiersEx());
                e.consume();
            }
        } else if ("selectPreviousRow".equals(action3)) {
            ScrollingUtil.moveUp(this.myList, e.getModifiersEx());
            e.consume();
        } else if ("scrollDown".equals(action3)) {
            ScrollingUtil.movePageDown(this.myList);
            e.consume();
        } else if ("scrollUp".equals(action3)) {
            ScrollingUtil.movePageUp(this.myList);
            e.consume();
        } else if (this.getSelectedFileFromCompletionPopup() != null && (e.getKeyCode() == 10 || e.getKeyCode() == 9) && e.getModifiers() == 0) {
            this.hideCurrentPopup();
            e.consume();
            this.processChosenFromCompletion(e.getKeyCode() == 9);
        }
    }

    @Nullable
    private FileLookup.LookupFile getSelectedFileFromCompletionPopup() {
        if (this.myList == null) {
            return null;
        }
        return (FileLookup.LookupFile)this.myList.getSelectedValue();
    }

    private boolean ensureSelectionExists() {
        if ((this.myList.getSelectedIndex() < 0 || this.myList.getSelectedIndex() >= this.myList.getModel().getSize()) && this.myList.getModel().getSize() >= 0) {
            this.myList.setSelectedIndex(0);
            return false;
        }
        return true;
    }

    private boolean togglePopup(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        Object action2 = ((InputMap)UIManager.get("ComboBox.ancestorInputMap")).get(stroke);
        if ("selectNext".equals(action2)) {
            return !this.isPopupShowing();
        }
        if ("togglePopup".equals(action2)) {
            if (this.isPopupShowing()) {
                this.closePopup();
            } else {
                this.suggestCompletion(true, true);
            }
            return true;
        }
        Keymap active = KeymapManager.getInstance().getActiveKeymap();
        for (String id2 : active.getActionIds(stroke)) {
            if (!"CodeCompletion".equals(id2)) continue;
            this.suggestCompletion(true, true);
        }
        return false;
    }

    private static Object getAction(KeyEvent e, JComponent comp) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        return comp.getInputMap().get(stroke);
    }

    @Override
    public JTextField getField() {
        return this.myPathTextField;
    }

    @Override
    public boolean isPopupDisplayed() {
        return this.myCurrentPopup != null && this.myCurrentPopup.isVisible();
    }

    public FileLookup.Finder getFinder() {
        return this.myFinder;
    }

    private boolean isPopupShowing() {
        return this.myCurrentPopup != null && this.myList != null && this.myList.isShowing();
    }

    private void closePopup() {
        this.hideCurrentPopup();
        this.myCurrentCompletion = null;
    }

    @Nullable
    public String getTextFieldText() {
        String text2 = this.myPathTextField.getText();
        if (text2 == null) {
            return null;
        }
        return text2;
    }

    public final void setText(final String text2, boolean now, final @Nullable Runnable onDone) {
        Update update2 = new Update((Object)"pathFromTree"){

            @Override
            public void run() {
                FileTextFieldImpl.this.myPathIsUpdating = true;
                FileTextFieldImpl.this.getField().setText(text2);
                FileTextFieldImpl.this.myPathIsUpdating = false;
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        if (now) {
            update2.run();
        } else {
            this.myUiUpdater.queue(update2);
        }
    }

    public boolean isPathUpdating() {
        return this.myPathIsUpdating;
    }

    @Nullable
    public String getCompletionBase() {
        String text2 = this.getTextFieldText();
        if (text2 == null) {
            return null;
        }
        int pos = this.myPathTextField.getCaretPosition();
        return pos < text2.length() ? text2.substring(0, pos) : text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl", "getPathVariablesSeparatorText"));
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FileTextFieldImpl.this.myCurrentPopup != null) {
                FileTextFieldImpl.this.myAutopopup = false;
                FileTextFieldImpl.this.hideCurrentPopup();
            }
        }
    }

    public static class Vfs
    extends FileTextFieldImpl {
        public Vfs(JTextField field, Map<String, String> macroMap, Disposable parent, FileLookup.LookupFilter chooserFilter) {
            super(field, new LocalFsFinder(), chooserFilter, macroMap, parent);
        }

        public Vfs(Map<String, String> macroMap, Disposable parent, FileLookup.LookupFilter chooserFilter) {
            this(new JTextField(), macroMap, parent, chooserFilter);
        }

        @Override
        public VirtualFile getSelectedFile() {
            FileLookup.LookupFile lookupFile = this.getFile();
            return lookupFile != null ? ((LocalFsFinder.VfsFile)lookupFile).getFile() : null;
        }
    }

    private static class Separator {
        private final String myText;

        private Separator(String text2) {
            this.myText = text2;
        }

        public String getText() {
            return this.myText;
        }
    }

    public static class CompletionResult {
        public List<FileLookup.LookupFile> myMacros;
        public List<FileLookup.LookupFile> myToComplete;
        public List<FileLookup.LookupFile> mySiblings;
        public List<FileLookup.LookupFile> myKidsAfterSeparator;
        public String myCompletionBase;
        public FileLookup.LookupFile myClosestParent;
        public FileLookup.LookupFile myPreselected;
        public FileLookup.LookupFile current;
        public boolean currentParentMatch;
        public String effectivePrefix;
        public FileLookup.LookupFile currentGrandparent;
        public String grandparentPrefix;
        public boolean closedPath;
        public String myFieldText;
    }
}

