/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalFsFinder
implements FileLookup.Finder,
FileLookup {
    private File myBaseDir = new File(SystemProperties.getUserHome());

    @Override
    public FileLookup.LookupFile find(@NotNull String path2) {
        File[] roots;
        VirtualFile byUrl;
        if (path2 == null) {
            LocalFsFinder.$$$reportNull$$$0(0);
        }
        if ((byUrl = VirtualFileManager.getInstance().findFileByUrl(path2)) != null) {
            return new VfsFile(this, byUrl);
        }
        String toFind = this.normalize(path2);
        if (toFind.length() == 0 && (roots = File.listRoots()).length > 0) {
            toFind = roots[0].getAbsolutePath();
        }
        File file2 = new File(toFind);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
        if (vFile != null) {
            return new VfsFile(this, vFile);
        }
        if (file2.isAbsolute()) {
            return new IoFile(new File(path2));
        }
        return null;
    }

    @Override
    public String normalize(@NotNull String path2) {
        File file2;
        if (path2 == null) {
            LocalFsFinder.$$$reportNull$$$0(1);
        }
        if ((file2 = new File(path2 = FileUtil.expandUserHome(path2))).isAbsolute()) {
            return file2.getAbsolutePath();
        }
        if (this.myBaseDir != null) {
            return new File(this.myBaseDir, path2).getAbsolutePath();
        }
        return path2;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    public void setBaseDir(@Nullable File baseDir) {
        this.myBaseDir = baseDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "path";
        objectArray2[1] = "com/intellij/openapi/fileChooser/ex/LocalFsFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "normalize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class IoFile
    extends VfsFile {
        private final File myIoFile;

        public IoFile(File ioFile) {
            super(null, null);
            this.myIoFile = ioFile;
        }

        @Override
        public String getName() {
            return this.myIoFile.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.myIoFile != null && this.myIoFile.isDirectory();
        }

        @Override
        public FileLookup.LookupFile getParent() {
            return this.myIoFile != null && this.myIoFile.getParentFile() != null ? new IoFile(this.myIoFile.getParentFile()) : null;
        }

        @Override
        public String getAbsolutePath() {
            return this.myIoFile.getAbsolutePath();
        }

        @Override
        public List<FileLookup.LookupFile> getChildren(FileLookup.LookupFilter filter2) {
            ArrayList<FileLookup.LookupFile> result2 = new ArrayList<FileLookup.LookupFile>();
            File[] files2 = this.myIoFile.listFiles(pathname -> filter2.isAccepted(new IoFile(pathname)));
            if (files2 == null) {
                return result2;
            }
            for (File each : files2) {
                result2.add(new IoFile(each));
            }
            Collections.sort(result2, (o1, o2) -> FileUtil.comparePaths(o1.getName(), o2.getName()));
            return result2;
        }

        @Override
        public boolean exists() {
            return this.myIoFile.exists();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IoFile ioFile = (IoFile)o;
            return !(this.myIoFile != null ? !this.myIoFile.equals(ioFile.myIoFile) : ioFile.myIoFile != null);
        }

        @Override
        public int hashCode() {
            return this.myIoFile != null ? this.myIoFile.hashCode() : 0;
        }
    }

    public static class VfsFile
    implements FileLookup.LookupFile {
        private final VirtualFile myFile;
        private final LocalFsFinder myFinder;
        private String myMacro;

        public VfsFile(LocalFsFinder finder, VirtualFile file2) {
            this.myFinder = finder;
            this.myFile = file2;
        }

        @Override
        public String getName() {
            if (this.myFile.getParent() == null && this.myFile.getName().length() == 0) {
                return "/";
            }
            return this.myFile.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.myFile != null && this.myFile.isDirectory();
        }

        @Override
        public void setMacro(String macro) {
            this.myMacro = macro;
        }

        @Override
        public String getMacro() {
            return this.myMacro;
        }

        @Override
        public FileLookup.LookupFile getParent() {
            return this.myFile != null && this.myFile.getParent() != null ? new VfsFile(this.myFinder, this.myFile.getParent()) : null;
        }

        @Override
        public String getAbsolutePath() {
            if (this.myFile.getParent() == null && this.myFile.getName().length() == 0) {
                return "/";
            }
            return this.myFile.getPresentableUrl();
        }

        @Override
        public List<FileLookup.LookupFile> getChildren(FileLookup.LookupFilter filter2) {
            VirtualFile[] kids;
            ArrayList<FileLookup.LookupFile> result2 = new ArrayList<FileLookup.LookupFile>();
            if (this.myFile == null) {
                return result2;
            }
            for (VirtualFile each : kids = this.myFile.getChildren()) {
                VfsFile eachFile = new VfsFile(this.myFinder, each);
                if (!filter2.isAccepted(eachFile)) continue;
                result2.add(eachFile);
            }
            Collections.sort(result2, (o1, o2) -> FileUtil.comparePaths(o1.getName(), o2.getName()));
            return result2;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        @Override
        public boolean exists() {
            return this.myFile.exists();
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myFile != null ? (this.myFile.isDirectory() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)this.myFile)) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VfsFile vfsFile = (VfsFile)o;
            return !(this.myFile != null ? !this.myFile.equals(vfsFile.myFile) : vfsFile.myFile != null);
        }

        public int hashCode() {
            return this.myFile != null ? this.myFile.hashCode() : 0;
        }
    }

    public static class FileChooserFilter
    implements FileLookup.LookupFilter {
        private final FileChooserDescriptor myDescriptor;
        private final Computable<Boolean> myShowHidden;

        public FileChooserFilter(FileChooserDescriptor descriptor2, boolean showHidden) {
            this.myShowHidden = new Computable.PredefinedValueComputable<Boolean>(showHidden);
            this.myDescriptor = descriptor2;
        }

        public FileChooserFilter(FileChooserDescriptor descriptor2, FileSystemTree tree) {
            this.myDescriptor = descriptor2;
            this.myShowHidden = () -> tree.areHiddensShown();
        }

        @Override
        public boolean isAccepted(FileLookup.LookupFile file2) {
            VirtualFile vFile = ((VfsFile)file2).getFile();
            if (vFile == null) {
                return false;
            }
            return this.myDescriptor.isFileVisible(vFile, this.myShowHidden.compute());
        }
    }
}

