/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class RootFileElement
extends FileElement {
    private List<VirtualFile> myFiles;
    private Object[] myChildren;

    public RootFileElement(@NotNull List<VirtualFile> files2, String name, boolean showFileSystemRoots) {
        if (files2 == null) {
            RootFileElement.$$$reportNull$$$0(0);
        }
        super(files2.size() == 1 ? files2.get(0) : null, name);
        this.myFiles = files2.size() == 0 && showFileSystemRoots ? null : files2;
    }

    public Object[] getChildren() {
        if (this.myChildren == null) {
            if (this.myFiles == null) {
                this.myFiles = RootFileElement.getFileSystemRoots();
            }
            this.myChildren = this.myFiles.stream().filter(Objects::nonNull).map(file2 -> new FileElement((VirtualFile)file2, file2.getPresentableUrl())).toArray();
        }
        return this.myChildren;
    }

    private static List<VirtualFile> getFileSystemRoots() {
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).map(root -> localFileSystem2.findFileByPath(FileUtil.toSystemIndependentName(root.toString()))).collect(Collectors.toList()));
        if (SystemInfo.isWin10OrNewer && Experiments.getInstance().isFeatureEnabled("wsl.p9.show.roots.in.file.chooser")) {
            List<VirtualFile> wslRoots = ContainerUtil.mapNotNull(WSLUtil.getExistingUNCRoots(), root -> localFileSystem2.findFileByPath(FileUtil.toSystemIndependentName(root.getAbsolutePath())));
            result2.addAll(wslRoots);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileChooser/ex/RootFileElement", "<init>"));
    }
}

