/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.MacFileSaverDialog;
import com.intellij.ui.mac.MacPathChooserDialog;
import com.intellij.ui.win.WinPathChooserDialog;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserFactoryImpl
extends FileChooserFactory {
    @Override
    @NotNull
    public FileChooserDialog createFileChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable Component parent) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(0);
        }
        if (FileChooserFactoryImpl.useNativeMacChooser(descriptor2)) {
            return new MacPathChooserDialog(descriptor2, parent, project2);
        }
        if (FileChooserFactoryImpl.useNativeWinChooser(descriptor2)) {
            return new WinPathChooserDialog(descriptor2, parent, project2);
        }
        if (parent != null) {
            return new FileChooserDialogImpl(descriptor2, parent, project2);
        }
        return new FileChooserDialogImpl(descriptor2, project2);
    }

    @Nullable
    public static PathChooserDialog createNativePathChooserIfEnabled(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable Component parent) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(1);
        }
        if (FileChooserFactoryImpl.useNativeMacChooser(descriptor2)) {
            return new MacPathChooserDialog(descriptor2, parent, project2);
        }
        if (FileChooserFactoryImpl.useNativeWinChooser(descriptor2)) {
            return new WinPathChooserDialog(descriptor2, parent, project2);
        }
        return null;
    }

    @Override
    @NotNull
    public PathChooserDialog createPathChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable Component parent) {
        PathChooserDialog chooser;
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(2);
        }
        if ((chooser = FileChooserFactoryImpl.createNativePathChooserIfEnabled(descriptor2, project2, parent)) != null) {
            PathChooserDialog pathChooserDialog = chooser;
            if (pathChooserDialog == null) {
                FileChooserFactoryImpl.$$$reportNull$$$0(3);
            }
            return pathChooserDialog;
        }
        if (parent != null) {
            return new FileChooserDialogImpl(descriptor2, parent, project2);
        }
        return new FileChooserDialogImpl(descriptor2, project2);
    }

    private static boolean useNativeWinChooser(FileChooserDescriptor descriptor2) {
        return SystemInfo.isWindows && !descriptor2.isForcedToUseIdeaFileChooser() && Registry.is("ide.win.file.chooser.native", false);
    }

    private static boolean useNativeMacChooser(FileChooserDescriptor descriptor2) {
        return SystemInfo.isMac && SystemInfo.isJetBrainsJvm && !descriptor2.isForcedToUseIdeaFileChooser() && Registry.is("ide.mac.file.chooser.native", true);
    }

    @Override
    @NotNull
    public FileTextField createFileTextField(@NotNull FileChooserDescriptor descriptor2, boolean showHidden, @Nullable Disposable parent) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(4);
        }
        return new FileTextFieldImpl.Vfs(new JTextField(), FileChooserFactoryImpl.getMacroMap(), parent, new LocalFsFinder.FileChooserFilter(descriptor2, showHidden));
    }

    @Override
    public void installFileCompletion(@NotNull JTextField field, @NotNull FileChooserDescriptor descriptor2, boolean showHidden, @Nullable Disposable parent) {
        if (field == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(6);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new FileTextFieldImpl.Vfs(field, FileChooserFactoryImpl.getMacroMap(), parent, new LocalFsFinder.FileChooserFilter(descriptor2, showHidden));
        }
    }

    public static Map<String, String> getMacroMap() {
        PathMacros macros = PathMacros.getInstance();
        Set<String> allNames = macros.getAllMacroNames();
        THashMap<String, String> map2 = new THashMap<String, String>(allNames.size());
        for (String eachMacroName : allNames) {
            map2.put("$" + eachMacroName + "$", macros.getValue(eachMacroName));
        }
        return map2;
    }

    @Override
    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor2, @Nullable Project project2) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(7);
        }
        return SystemInfo.isMac && Registry.is("ide.mac.native.save.dialog", true) ? new MacFileSaverDialog(descriptor2, project2) : new FileSaverDialogImpl(descriptor2, project2);
    }

    @Override
    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor2, @NotNull Component parent) {
        if (descriptor2 == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            FileChooserFactoryImpl.$$$reportNull$$$0(9);
        }
        return SystemInfo.isMac && Registry.is("ide.mac.native.save.dialog", true) ? new MacFileSaverDialog(descriptor2, parent) : new FileSaverDialogImpl(descriptor2, parent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/impl/FileChooserFactoryImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileChooser";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createNativePathChooserIfEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPathChooser";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFileTextField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installFileCompletion";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSaveFileDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

