/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.NotNullProducer;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class FileRefresher
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FileRefresher.class);
    private final ScheduledExecutorService executor;
    private final boolean recursive;
    private final long delay;
    private final NotNullProducer<? extends ModalityState> producer;
    private final ArrayList<Object> watchers;
    private final ArrayList<VirtualFile> files;
    private final AtomicBoolean scheduled;
    private final AtomicBoolean launched;
    private final AtomicBoolean paused;
    private final AtomicBoolean disposed;
    private RefreshSession session;

    /*
     * WARNING - void declaration
     */
    public FileRefresher(boolean recursive, long delay, @NotNull NotNullProducer<? extends ModalityState> notNullProducer) {
        void producer;
        if (notNullProducer == null) {
            FileRefresher.$$$reportNull$$$0(0);
        }
        this.executor = EdtExecutorService.getScheduledExecutorInstance();
        this.watchers = new ArrayList();
        this.files = new ArrayList();
        this.scheduled = new AtomicBoolean();
        this.launched = new AtomicBoolean();
        this.paused = new AtomicBoolean();
        this.disposed = new AtomicBoolean();
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay");
        }
        this.recursive = recursive;
        this.delay = delay;
        this.producer = producer;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    protected Object watch(VirtualFile file2, boolean recursive) {
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof LocalFileSystem) {
            return LocalFileSystem.getInstance().addRootToWatch(file2.getPath(), recursive);
        }
        return null;
    }

    protected void unwatch(Object watcher) {
        if (watcher instanceof LocalFileSystem.WatchRequest) {
            LocalFileSystem.getInstance().removeWatchedRoot((LocalFileSystem.WatchRequest)watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(VirtualFile file2) {
        if (file2 != null && !this.disposed.get()) {
            ArrayList<Object> arrayList;
            LOG.debug("add file to watch recursive=", this.recursive, ": ", file2);
            Object watcher = this.watch(file2, this.recursive);
            if (watcher != null) {
                arrayList = this.watchers;
                synchronized (arrayList) {
                    this.watchers.add(watcher);
                }
            }
            arrayList = this.files;
            synchronized (arrayList) {
                this.files.add(file2);
            }
            if (!this.paused.get()) {
                this.schedule();
            }
        }
    }

    public final void pause() {
        LOG.debug("pause");
        this.paused.set(true);
    }

    public final void start() {
        LOG.debug("start");
        this.paused.set(false);
        this.launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule() {
        LOG.debug("schedule");
        if (this.disposed.get() || this.scheduled.getAndSet(true)) {
            return;
        }
        ArrayList<VirtualFile> arrayList = this.files;
        synchronized (arrayList) {
            if (this.session != null || this.files.isEmpty()) {
                return;
            }
        }
        LOG.debug("scheduled for ", this.delay, " seconds");
        this.executor.schedule(this::launch, this.delay, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launch() {
        RefreshSession session2;
        LOG.debug("launch");
        if (this.disposed.get() || this.launched.getAndSet(true)) {
            return;
        }
        ArrayList<VirtualFile> arrayList = this.files;
        synchronized (arrayList) {
            if (this.session != null || this.files.isEmpty()) {
                return;
            }
            ModalityState state = this.producer.produce();
            LOG.debug("modality state ", state);
            session2 = RefreshQueue.getInstance().createSession(true, this.recursive, this::finish, state);
            session2.addAllFiles(this.files);
            this.session = session2;
        }
        this.scheduled.set(false);
        this.launched.set(false);
        LOG.debug("launched at ", System.currentTimeMillis());
        session2.launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        LOG.debug("finished at ", System.currentTimeMillis());
        ArrayList<VirtualFile> arrayList = this.files;
        synchronized (arrayList) {
            this.session = null;
        }
        if (this.launched.getAndSet(false)) {
            this.launch();
        } else if (this.scheduled.getAndSet(false) || !this.paused.get()) {
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        LOG.debug("dispose");
        if (!this.disposed.getAndSet(true)) {
            RefreshSession session2;
            ArrayList<Object> arrayList = this.watchers;
            synchronized (arrayList) {
                this.watchers.forEach(this::unwatch);
                this.watchers.clear();
            }
            ArrayList<VirtualFile> arrayList2 = this.files;
            synchronized (arrayList2) {
                this.files.clear();
                session2 = this.session;
                this.session = null;
            }
            if (session2 != null) {
                RefreshQueue.getInstance().cancelSession(session2.getId());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/openapi/fileChooser/tree/FileRefresher", "<init>"));
    }
}

