/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public class PsiElementNavigatable
implements Navigatable {
    private final SmartPsiElementPointer<PsiElement> myPointer;

    public PsiElementNavigatable(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiElementNavigatable.$$$reportNull$$$0(0);
        }
        this.myPointer = SmartPointerManager.getInstance(element2.getProject()).createSmartPsiElementPointer(element2);
    }

    @Override
    public final void navigate(final boolean requestFocus) {
        VirtualFile file2;
        final PsiElement element2 = this.getElement();
        if (element2 != null && (file2 = element2.getContainingFile().getVirtualFile()) != null) {
            new Task.Modal(element2.getProject(), EditorBundle.message("editor.open.file.progress", file2.getName()), true){

                @Override
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int offset = ReadAction.compute(() -> element2.isValid() ? element2.getTextOffset() : -1);
                    indicator.checkCanceled();
                    if (offset >= 0) {
                        Navigatable descriptor2 = PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file2, offset);
                        Condition<Object> isValid = __ -> !file2.isValid();
                        Condition<?> isDisposed = this.myProject.getDisposed();
                        Condition<Object> expired = Conditions.or(isDisposed, isValid);
                        ApplicationManager.getApplication().invokeLater(() -> descriptor2.navigate(requestFocus), expired);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileEditor/PsiElementNavigatable$1", "run"));
                }
            }.queue();
        }
    }

    @Override
    public boolean canNavigate() {
        PsiElement element2 = this.getElement();
        return element2 != null && element2.getContainingFile().getVirtualFile() != null;
    }

    private PsiElement getElement() {
        PsiElement element2 = this.myPointer.getElement();
        if (element2 != null && element2.isValid()) {
            PsiElement navigationElement = element2.getNavigationElement();
            return navigationElement != null ? navigationElement : element2;
        }
        return null;
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/PsiElementNavigatable", "<init>"));
    }
}

