/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorComposite
implements Disposable {
    private static final Logger LOG = Logger.getInstance(EditorComposite.class);
    @NotNull
    private final VirtualFile myFile;
    private boolean myPinned;
    volatile FileEditor[] myEditors;
    private final long myInitialFileTimeStamp;
    TabbedPaneWrapper myTabbedPaneWrapper;
    private final MyComponent myComponent;
    private final FocusWatcher myFocusWatcher;
    private FileEditor mySelectedEditor;
    private final FileEditorManagerEx myFileEditorManager;
    private final Map<FileEditor, JComponent> myTopComponents;
    private final Map<FileEditor, JComponent> myBottomComponents;
    private final Map<FileEditor, String> myDisplayNames;
    private FileEditorProvider[] myProviders;

    EditorComposite(@NotNull VirtualFile file2, FileEditor @NotNull [] editors, FileEditorProvider @NotNull [] providers, @NotNull FileEditorManagerEx fileEditorManager) {
        if (file2 == null) {
            EditorComposite.$$$reportNull$$$0(0);
        }
        if (fileEditorManager == null) {
            EditorComposite.$$$reportNull$$$0(1);
        }
        if (editors == null) {
            EditorComposite.$$$reportNull$$$0(2);
        }
        if (providers == null) {
            EditorComposite.$$$reportNull$$$0(3);
        }
        this.myTopComponents = new HashMap<FileEditor, JComponent>();
        this.myBottomComponents = new HashMap<FileEditor, JComponent>();
        this.myDisplayNames = new HashMap<FileEditor, String>();
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myFile = file2;
        this.myEditors = editors;
        this.myProviders = providers;
        if (ArrayUtil.contains(null, editors)) {
            throw new IllegalArgumentException("Must not pass null editors in " + Arrays.asList(editors));
        }
        this.myFileEditorManager = fileEditorManager;
        this.myInitialFileTimeStamp = this.myFile.getTimeStamp();
        final Project project2 = fileEditorManager.getProject();
        Disposer.register(project2, this);
        if (editors.length > 1) {
            this.myTabbedPaneWrapper = this.createTabbedPaneWrapper(editors);
            JComponent component2 = this.myTabbedPaneWrapper.getComponent();
            this.myComponent = new MyComponent(component2, () -> component2);
        } else if (editors.length == 1) {
            this.myTabbedPaneWrapper = null;
            FileEditor editor = editors[0];
            this.myComponent = new MyComponent(this.createEditorComponent(editor), editor::getPreferredFocusedComponent);
        } else {
            throw new IllegalArgumentException("editors array cannot be empty");
        }
        this.mySelectedEditor = editors[0];
        this.myFocusWatcher = new FocusWatcher();
        this.myFocusWatcher.install(this.myComponent);
        project2.getMessageBus().connect(this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, new FileEditorManagerListener(){

            @Override
            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                VirtualFile newFile;
                VirtualFile oldFile;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (Comparing.equal(oldFile = event.getOldFile(), newFile = event.getNewFile()) && Comparing.equal(EditorComposite.this.getFile(), newFile)) {
                    Runnable runnable2 = () -> {
                        FileEditor newEditor;
                        FileEditor oldEditor = event.getOldEditor();
                        if (oldEditor != null) {
                            oldEditor.deselectNotify();
                        }
                        if ((newEditor = event.getNewEditor()) != null) {
                            newEditor.selectNotify();
                            FUCounterUsageLogger.getInstance().logEvent(project2, "file.editor", "alternative.file.editor.selected", new FeatureUsageData().addData("fileEditor", newEditor.getClass().getName()).addAnonymizedPath(newFile.getPath()));
                        }
                        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).providerSelected(EditorComposite.this);
                        ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(EditorComposite.this.myFileEditorManager.getProject())).onSelectionChanged();
                    };
                    if (ApplicationManager.getApplication().isDispatchThread()) {
                        CommandProcessor.getInstance().executeCommand(EditorComposite.this.myFileEditorManager.getProject(), runnable2, IdeBundle.message("command.switch.active.editor", new Object[0]), null);
                    } else {
                        runnable2.run();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/EditorComposite$1", "selectionChanged"));
            }
        });
    }

    public FileEditorProvider @NotNull [] getProviders() {
        if (this.myProviders == null) {
            EditorComposite.$$$reportNull$$$0(4);
        }
        return this.myProviders;
    }

    @NotNull
    private TabbedPaneWrapper.AsJBTabs createTabbedPaneWrapper(FileEditor[] editors) {
        PrevNextActionsDescriptor descriptor2 = new PrevNextActionsDescriptor("NextEditorTab", "PreviousEditorTab");
        TabbedPaneWrapper.AsJBTabs wrapper2 = new TabbedPaneWrapper.AsJBTabs(this.myFileEditorManager.getProject(), 3, descriptor2, this);
        boolean firstEditor = true;
        for (FileEditor editor : editors) {
            JComponent component2 = firstEditor && this.myComponent != null ? (JComponent)this.myComponent.getComponent(0) : this.createEditorComponent(editor);
            wrapper2.addTab(this.getDisplayName(editor), component2);
            firstEditor = false;
        }
        wrapper2.addChangeListener(new MyChangeListener());
        TabbedPaneWrapper.AsJBTabs asJBTabs = wrapper2;
        if (asJBTabs == null) {
            EditorComposite.$$$reportNull$$$0(5);
        }
        return asJBTabs;
    }

    private JComponent createEditorComponent(FileEditor editor) {
        JPanel component2 = new JPanel(new BorderLayout());
        JComponent comp = editor.getComponent();
        if (!FileEditorManagerImpl.isDumbAware(editor)) {
            comp = DumbService.getInstance(this.myFileEditorManager.getProject()).wrapGently(comp, editor);
        }
        component2.add((Component)comp, "Center");
        TopBottomPanel topPanel = new TopBottomPanel();
        this.myTopComponents.put(editor, topPanel);
        component2.add((Component)topPanel, "North");
        TopBottomPanel bottomPanel = new TopBottomPanel();
        this.myBottomComponents.put(editor, bottomPanel);
        component2.add((Component)bottomPanel, "South");
        return component2;
    }

    public boolean isPinned() {
        return this.myPinned;
    }

    void setPinned(boolean pinned) {
        this.myPinned = pinned;
    }

    private void fireSelectedEditorChanged(FileEditor oldSelectedEditor, FileEditor newSelectedEditor) {
        if (!(EventQueue.isDispatchThread() && this.myFileEditorManager.isInsideChange() || Comparing.equal(oldSelectedEditor, newSelectedEditor))) {
            this.myFileEditorManager.notifyPublisher(() -> {
                FileEditorManagerEvent event = new FileEditorManagerEvent(this.myFileEditorManager, this.myFile, oldSelectedEditor, this.myFile, newSelectedEditor);
                FileEditorManagerListener publisher = this.myFileEditorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
                publisher.selectionChanged(event);
            });
            JComponent component2 = newSelectedEditor.getComponent();
            EditorWindowHolder holder = ComponentUtil.getParentOfType(EditorWindowHolder.class, component2);
            if (holder != null) {
                ((FileEditorManagerImpl)this.myFileEditorManager).addSelectionRecord(this.myFile, holder.getEditorWindow());
            }
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.mySelectedEditor == null) {
            return null;
        }
        Component component2 = this.myFocusWatcher.getFocusedComponent();
        if (!(component2 instanceof JComponent && component2.isShowing() && component2.isEnabled() && component2.isFocusable())) {
            return this.getSelectedEditor().getPreferredFocusedComponent();
        }
        return (JComponent)component2;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            EditorComposite.$$$reportNull$$$0(6);
        }
        return virtualFile2;
    }

    public FileEditorManager getFileEditorManager() {
        return this.myFileEditorManager;
    }

    public long getInitialFileTimeStamp() {
        return this.myInitialFileTimeStamp;
    }

    public FileEditor @NotNull [] getEditors() {
        if (this.myEditors == null) {
            EditorComposite.$$$reportNull$$$0(7);
        }
        return this.myEditors;
    }

    @NotNull
    List<JComponent> getTopComponents(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(8);
        }
        return this.getTopBottomComponents(editor, true);
    }

    @NotNull
    private List<JComponent> getTopBottomComponents(@NotNull FileEditor editor, boolean top) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(9);
        }
        SmartList<JComponent> result2 = new SmartList<JComponent>();
        JComponent container2 = top ? this.myTopComponents.get(editor) : this.myBottomComponents.get(editor);
        for (Component each : container2.getComponents()) {
            if (!(each instanceof NonOpaquePanel)) continue;
            result2.add(((NonOpaquePanel)each).getTargetComponent());
        }
        List<JComponent> list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            EditorComposite.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Nullable
    public JBTabs getTabs() {
        return this.myTabbedPaneWrapper == null ? null : ((TabbedPaneWrapper.AsJBTabs)this.myTabbedPaneWrapper).getTabs();
    }

    public void addTopComponent(FileEditor editor, JComponent component2) {
        this.manageTopOrBottomComponent(editor, component2, true, false);
    }

    public void removeTopComponent(FileEditor editor, JComponent component2) {
        this.manageTopOrBottomComponent(editor, component2, true, true);
    }

    public void addBottomComponent(FileEditor editor, JComponent component2) {
        this.manageTopOrBottomComponent(editor, component2, false, false);
    }

    public void removeBottomComponent(FileEditor editor, JComponent component2) {
        this.manageTopOrBottomComponent(editor, component2, false, true);
    }

    private void manageTopOrBottomComponent(FileEditor editor, JComponent component2, boolean top, boolean remove2) {
        JComponent container2;
        JComponent jComponent = container2 = top ? this.myTopComponents.get(editor) : this.myBottomComponents.get(editor);
        assert (container2 != null);
        if (remove2) {
            container2.remove(component2.getParent());
        } else {
            NonOpaquePanel wrapper2 = new NonOpaquePanel(component2);
            if (!Boolean.TRUE.equals(component2.getClientProperty(FileEditorManager.SEPARATOR_DISABLED))) {
                wrapper2.setBorder(EditorComposite.createTopBottomSideBorder(top));
            }
            container2.add((Component)wrapper2, EditorComposite.calcComponentInsertionIndex(component2, container2));
        }
        container2.revalidate();
    }

    private static int calcComponentInsertionIndex(@NotNull JComponent newComponent, @NotNull JComponent container2) {
        if (newComponent == null) {
            EditorComposite.$$$reportNull$$$0(11);
        }
        if (container2 == null) {
            EditorComposite.$$$reportNull$$$0(12);
        }
        int max = container2.getComponentCount();
        for (int i = 0; i < max; ++i) {
            double w2;
            Component childWrapper = container2.getComponent(i);
            Component childComponent = childWrapper instanceof Wrapper ? ((Wrapper)childWrapper).getTargetComponent() : childWrapper;
            boolean weighted1 = newComponent instanceof Weighted;
            boolean weighted2 = childComponent instanceof Weighted;
            if (!weighted2) continue;
            if (!weighted1) {
                return i;
            }
            double w1 = ((Weighted)((Object)newComponent)).getWeight();
            if (!(w1 < (w2 = ((Weighted)((Object)childComponent)).getWeight()))) continue;
            return i;
        }
        return -1;
    }

    public void setDisplayName(@NotNull FileEditor editor, @NotNull String name) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(13);
        }
        if (name == null) {
            EditorComposite.$$$reportNull$$$0(14);
        }
        int index = ContainerUtil.indexOfIdentity(ContainerUtil.immutableList(this.myEditors), editor);
        assert (index != -1);
        this.myDisplayNames.put(editor, name);
        if (this.myTabbedPaneWrapper != null) {
            this.myTabbedPaneWrapper.setTitleAt(index, name);
        }
    }

    @NotNull
    protected String getDisplayName(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(15);
        }
        String string = ObjectUtils.notNull(this.myDisplayNames.get(editor), editor.getName());
        if (string == null) {
            EditorComposite.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    FileEditor getSelectedEditor() {
        FileEditor fileEditor = this.getSelectedWithProvider().getFileEditor();
        if (fileEditor == null) {
            EditorComposite.$$$reportNull$$$0(17);
        }
        return fileEditor;
    }

    @NotNull
    public FileEditorWithProvider getSelectedWithProvider() {
        LOG.assertTrue(this.myEditors.length > 0, this.myEditors.length);
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
            return new FileEditorWithProvider(this.myEditors[0], this.myProviders[0]);
        }
        LOG.assertTrue(this.myTabbedPaneWrapper != null);
        int index = this.myTabbedPaneWrapper.getSelectedIndex();
        if (index == -1) {
            index = 0;
        }
        LOG.assertTrue(index >= 0, index);
        LOG.assertTrue(index < this.myEditors.length, index);
        return new FileEditorWithProvider(this.myEditors[index], this.myProviders[index]);
    }

    @Deprecated
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider() {
        FileEditorWithProvider info = this.getSelectedWithProvider();
        return Pair.create(info.getFileEditor(), info.getProvider());
    }

    void setSelectedEditor(int index) {
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
        } else {
            LOG.assertTrue(this.myTabbedPaneWrapper != null);
            this.myTabbedPaneWrapper.setSelectedIndex(index);
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public boolean isModified() {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.getEditors()) {
            if (!editor.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        for (FileEditor editor : this.myEditors) {
            if (Disposer.isDisposed(editor)) continue;
            Disposer.dispose(editor);
        }
        this.myFocusWatcher.deinstall(this.myFocusWatcher.getTopComponent());
    }

    void addEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditors = ArrayUtil.append(this.myEditors, editor);
        if (this.myTabbedPaneWrapper == null) {
            this.myTabbedPaneWrapper = this.createTabbedPaneWrapper(this.myEditors);
            this.myComponent.setComponent(this.myTabbedPaneWrapper.getComponent());
        } else {
            JComponent component2 = this.createEditorComponent(editor);
            this.myTabbedPaneWrapper.addTab(this.getDisplayName(editor), component2);
        }
        this.myFocusWatcher.deinstall(this.myFocusWatcher.getTopComponent());
        this.myFocusWatcher.install(this.myComponent);
    }

    @NotNull
    private static SideBorder createTopBottomSideBorder(final boolean top) {
        return new SideBorder(null, top ? 8 : 2){

            @Override
            public Color getLineColor() {
                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                Color result2 = scheme.getColor(top ? EditorColors.SEPARATOR_ABOVE_COLOR : EditorColors.SEPARATOR_BELOW_COLOR);
                if (result2 == null) {
                    result2 = scheme.getColor(EditorColors.TEARLINE_COLOR);
                }
                return result2 == null ? JBColor.BLACK : result2;
            }
        };
    }

    @NotNull
    public HistoryEntry currentStateAsHistoryEntry() {
        FileEditor[] editors = this.getEditors();
        FileEditorState[] states = new FileEditorState[editors.length];
        for (int j = 0; j < states.length; ++j) {
            states[j] = editors[j].getState(FileEditorStateLevel.FULL);
            LOG.assertTrue(states[j] != null);
        }
        int selectedProviderIndex = ArrayUtil.find(editors, this.getSelectedEditor());
        LOG.assertTrue(selectedProviderIndex != -1);
        FileEditorProvider[] providers = this.getProviders();
        HistoryEntry historyEntry = HistoryEntry.createLight(this.getFile(), providers, states, providers[selectedProviderIndex]);
        if (historyEntry == null) {
            EditorComposite.$$$reportNull$$$0(19);
        }
        return historyEntry;
    }

    public void addEditor(@NotNull FileEditor editor, FileEditorProvider provider) {
        if (editor == null) {
            EditorComposite.$$$reportNull$$$0(20);
        }
        this.addEditor(editor);
        this.myProviders = ArrayUtil.append(this.myProviders, provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorComposite";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newComponent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorComposite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabbedPaneWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopBottomComponents";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "currentStateAsHistoryEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTopComponents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTopBottomComponents";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcComponentInsertionIndex";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TopBottomPanel
    extends JBPanelWithEmptyText {
        private TopBottomPanel() {
            this.setLayout(new BoxLayout(this, 1));
        }

        @Override
        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
            return color == null ? EditorColors.GUTTER_BACKGROUND.getDefaultColor() : color;
        }
    }

    private class MyComponent
    extends JPanel
    implements DataProvider {
        @NotNull
        private Supplier<JComponent> myFocusComponent;

        MyComponent(@NotNull JComponent realComponent, Supplier<JComponent> focusComponent) {
            if (realComponent == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            if (focusComponent == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myFocusComponent = focusComponent;
            this.add((Component)realComponent, "Center");
        }

        void setComponent(JComponent newComponent) {
            this.add((Component)newComponent, "Center");
            this.myFocusComponent = () -> newComponent;
        }

        @Override
        public boolean requestFocusInWindow() {
            JComponent focusComponent = this.myFocusComponent.get();
            return focusComponent != null && focusComponent.requestFocusInWindow();
        }

        @Override
        public void requestFocus() {
            JComponent focusComponent = this.myFocusComponent.get();
            if (focusComponent != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(focusComponent, true));
            }
        }

        @Override
        public boolean requestDefaultFocus() {
            JComponent focusComponent = this.myFocusComponent.get();
            return focusComponent != null && focusComponent.requestDefaultFocus();
        }

        @Override
        public final Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyComponent.$$$reportNull$$$0(2);
            }
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return EditorComposite.this.getSelectedEditor();
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return EditorComposite.this.myFile.isValid() ? EditorComposite.this.myFile : null;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                VirtualFile[] virtualFileArray;
                if (EditorComposite.this.myFile.isValid()) {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = EditorComposite.this.myFile;
                } else {
                    virtualFileArray = null;
                }
                return virtualFileArray;
            }
            JComponent component2 = EditorComposite.this.getPreferredFocusedComponent();
            if (component2 instanceof DataProvider && component2 != this) {
                return ((DataProvider)((Object)component2)).getData(dataId);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "realComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusComponent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorComposite$MyComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FileEditor oldSelectedEditor = EditorComposite.this.mySelectedEditor;
            LOG.assertTrue(oldSelectedEditor != null);
            int selectedIndex = EditorComposite.this.myTabbedPaneWrapper.getSelectedIndex();
            LOG.assertTrue(selectedIndex != -1);
            EditorComposite.this.mySelectedEditor = EditorComposite.this.myEditors[selectedIndex];
            EditorComposite.this.fireSelectedEditorChanged(oldSelectedEditor, EditorComposite.this.mySelectedEditor);
        }
    }
}

