/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBRectangle;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorWindow {
    private static final Logger LOG = Logger.getInstance(EditorWindow.class);
    public static final DataKey<EditorWindow> DATA_KEY = DataKey.create("editorWindow");
    protected JPanel myPanel;
    @NotNull
    private final EditorTabbedContainer myTabbedPane;
    private final EditorsSplitters myOwner;
    private boolean myIsDisposed;
    public static final Key<Integer> INITIAL_INDEX_KEY = Key.create("initial editor index");
    private final Stack<Pair<String, FileEditorOpenOptions>> myRemovedTabs;

    protected EditorWindow(@NotNull EditorsSplitters owner, @NotNull Disposable parentDisposable) {
        if (owner == null) {
            EditorWindow.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            EditorWindow.$$$reportNull$$$0(1);
        }
        this.myRemovedTabs = new Stack<Pair<String, FileEditorOpenOptions>>(){

            @Override
            public void push(Pair<String, FileEditorOpenOptions> pair) {
                if (this.size() >= EditorWindow.getTabLimit()) {
                    this.remove(0);
                }
                super.push(pair);
            }
        };
        this.myOwner = owner;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setOpaque(false);
        this.myPanel.setFocusable(false);
        this.myTabbedPane = new EditorTabbedContainer(this, this.getManager().getProject(), parentDisposable);
        this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        if (UISettings.getInstance().getScrollTabLayoutInEditor()) {
            this.setTabLayoutPolicy(1);
        } else {
            this.setTabLayoutPolicy(0);
        }
        this.myOwner.addWindow(this);
        if (this.myOwner.getCurrentWindow() == null) {
            this.myOwner.setCurrentWindow(this, false);
        }
        this.updateTabsVisibility(UISettings.getInstance());
    }

    void updateTabsVisibility(@NotNull UISettings settings) {
        if (settings == null) {
            EditorWindow.$$$reportNull$$$0(2);
        }
        this.myTabbedPane.getTabs().getPresentation().setHideTabs(settings.getEditorTabPlacement() == 0 || settings.getPresentationMode());
    }

    public boolean isShowing() {
        return this.myPanel.isShowing();
    }

    public void closeAllExcept(VirtualFile selectedFile) {
        this.getManager().runBulkTabChange(this.myOwner, splitters -> {
            for (VirtualFile file2 : this.getFiles()) {
                if (Comparing.equal(file2, selectedFile) || this.isFilePinned(file2)) continue;
                this.closeFile(file2);
            }
        });
    }

    void dispose() {
        try {
            this.myOwner.removeWindow(this);
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void closeFile(VirtualFile file2) {
        this.closeFile(file2, true);
    }

    public void closeFile(VirtualFile file2, boolean disposeIfNeeded) {
        this.closeFile(file2, disposeIfNeeded, true);
    }

    boolean hasClosedTabs() {
        return !this.myRemovedTabs.empty();
    }

    void restoreClosedTab() {
        assert (this.hasClosedTabs()) : "Nothing to restore";
        Pair<String, FileEditorOpenOptions> info = this.myRemovedTabs.pop();
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(info.getFirst());
        if (file2 != null) {
            this.getManager().openFileImpl4(this, file2, null, new FileEditorOpenOptions().withPin(info.getSecond().getPin()).withCurrentTab(true).withFocusEditor(true).withIndex(info.getSecond().getIndex()));
        }
    }

    public void closeFile(@NotNull VirtualFile file2, boolean disposeIfNeeded, boolean transferFocus) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(3);
        }
        FileEditorManagerImpl editorManager = this.getManager();
        editorManager.runBulkTabChange(this.myOwner, splitters -> {
            List<EditorWithProviderComposite> editors = splitters.findEditorComposites(file2);
            if (editors.isEmpty()) {
                return;
            }
            try {
                EditorWithProviderComposite editor = this.findFileComposite(file2);
                FileEditorManagerListener.Before beforePublisher = editorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER);
                beforePublisher.beforeFileClosed(editorManager, file2);
                if (editor != null) {
                    int componentIndex = this.findComponentIndex(editor.getComponent());
                    if (componentIndex >= 0) {
                        int indexToSelect = this.calcIndexToSelect(file2, componentIndex);
                        FileEditorOpenOptions options = new FileEditorOpenOptions().withIndex(componentIndex).withPin(editor.isPinned());
                        Pair<String, FileEditorOpenOptions> pair = Pair.create(file2.getUrl(), options);
                        this.myRemovedTabs.push(pair);
                        this.myTabbedPane.removeTabAt(componentIndex, indexToSelect, transferFocus);
                        editorManager.disposeComposite(editor);
                    }
                } else {
                    Splitter splitter;
                    JComponent otherComponent;
                    if (this.inSplitter() && (otherComponent = (splitter = (Splitter)this.myPanel.getParent()).getOtherComponent(this.myPanel)) != null) {
                        IdeFocusManager.findInstance().requestFocus(otherComponent, true);
                    }
                    this.myPanel.removeAll();
                }
                if (disposeIfNeeded && this.getTabCount() == 0) {
                    this.removeFromSplitter();
                } else {
                    this.myPanel.revalidate();
                }
            }
            finally {
                editorManager.removeSelectionRecord(file2, this);
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                editorManager.notifyPublisher(() -> {
                    Project project2 = editorManager.getProject();
                    if (!project2.isDisposed()) {
                        FileEditorManagerListener afterPublisher = project2.getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
                        afterPublisher.fileClosed(editorManager, file2);
                    }
                });
                splitters.afterFileClosed(file2);
            }
        });
    }

    void removeFromSplitter() {
        if (!this.inSplitter()) {
            return;
        }
        if (this.myOwner.getCurrentWindow() == this) {
            EditorWindow[] siblings = this.findSiblings();
            this.myOwner.setCurrentWindow(siblings[0], true);
        }
        Splitter splitter = (Splitter)this.myPanel.getParent();
        JComponent otherComponent = splitter.getOtherComponent(this.myPanel);
        Container parent = splitter.getParent().getParent();
        if (parent instanceof Splitter) {
            Splitter parentSplitter = (Splitter)parent;
            if (parentSplitter.getFirstComponent() == splitter.getParent()) {
                parentSplitter.setFirstComponent(otherComponent);
            } else {
                parentSplitter.setSecondComponent(otherComponent);
            }
        } else if (parent instanceof EditorsSplitters) {
            Component currentFocusComponent = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor(parent);
            parent.removeAll();
            parent.add((Component)otherComponent, "Center");
            parent.revalidate();
            if (currentFocusComponent != null) {
                currentFocusComponent.requestFocusInWindow();
            }
        } else {
            throw new IllegalStateException("Unknown container: " + parent);
        }
        this.dispose();
    }

    int calcIndexToSelect(VirtualFile fileBeingClosed, int fileIndex) {
        int currentlySelectedIndex = this.myTabbedPane.getSelectedIndex();
        if (currentlySelectedIndex != fileIndex) {
            return currentlySelectedIndex;
        }
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getState().getActiveMruEditorOnClose()) {
            List<VirtualFile> histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFileList();
            for (int idx = histFiles.size() - 1; idx >= 0; --idx) {
                int histFileIndex;
                EditorWithProviderComposite editor;
                VirtualFile histFile = histFiles.get(idx);
                if (histFile.equals(fileBeingClosed) || (editor = this.findFileComposite(histFile)) == null || (histFileIndex = this.findComponentIndex(editor.getComponent())) < 0) continue;
                return histFileIndex;
            }
        } else if (uiSettings.getActiveRightEditorOnClose() && fileIndex + 1 < this.myTabbedPane.getTabCount()) {
            return fileIndex + 1;
        }
        if (fileIndex > 0) {
            return fileIndex - 1;
        }
        return -1;
    }

    public FileEditorManagerImpl getManager() {
        return this.myOwner.getManager();
    }

    public int getTabCount() {
        return this.myTabbedPane.getTabCount();
    }

    void setForegroundAt(int index, Color color) {
        this.myTabbedPane.setForegroundAt(index, color);
    }

    void setWaveColor(int index, @Nullable Color color) {
        this.myTabbedPane.setWaveColor(index, color);
    }

    private void setIconAt(int index, Icon icon2) {
        this.myTabbedPane.setIconAt(index, icon2);
    }

    private void setTitleAt(int index, String text2) {
        this.myTabbedPane.setTitleAt(index, text2);
    }

    private void setBackgroundColorAt(int index, Color color) {
        this.myTabbedPane.setBackgroundColorAt(index, color);
    }

    private void setToolTipTextAt(int index, String text2) {
        this.myTabbedPane.setToolTipTextAt(index, text2);
    }

    void setTabLayoutPolicy(int policy) {
        this.myTabbedPane.setTabLayoutPolicy(policy);
    }

    void setTabsPlacement(int tabPlacement) {
        this.myTabbedPane.setTabPlacement(tabPlacement);
    }

    void updateTabsLayout(TabsLayoutInfo newTabsLayoutInfo) {
        this.myTabbedPane.updateTabsLayout(newTabsLayoutInfo);
    }

    public void setAsCurrentWindow(boolean requestFocus) {
        this.myOwner.setCurrentWindow(this, requestFocus);
    }

    void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        int index;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(4);
        }
        if ((index = this.findEditorIndex(this.findFileComposite(file2))) != -1) {
            Color color = EditorTabPresentationUtil.getEditorTabBackgroundColor(this.getManager().getProject(), file2, this);
            this.setBackgroundColorAt(index, color);
        }
    }

    public EditorsSplitters getOwner() {
        return this.myOwner;
    }

    boolean isEmptyVisible() {
        return this.myTabbedPane.isEmptyVisible();
    }

    public Dimension getSize() {
        return this.myPanel.getSize();
    }

    @NotNull
    public EditorTabbedContainer getTabbedPane() {
        EditorTabbedContainer editorTabbedContainer = this.myTabbedPane;
        if (editorTabbedContainer == null) {
            EditorWindow.$$$reportNull$$$0(5);
        }
        return editorTabbedContainer;
    }

    public void requestFocus(boolean forced) {
        this.myTabbedPane.requestFocus(forced);
    }

    public boolean isValid() {
        return this.myPanel.isShowing();
    }

    private void checkConsistency() {
        LOG.assertTrue(this.myOwner.containsWindow(this), "EditorWindow not in collection");
    }

    @Nullable
    public EditorWithProviderComposite getSelectedEditor() {
        return this.getSelectedEditor(false);
    }

    @Nullable
    public EditorWithProviderComposite getSelectedEditor(boolean ignorePopup) {
        TComp comp = ObjectUtils.tryCast(this.myTabbedPane.getSelectedComponent(ignorePopup), TComp.class);
        return comp == null ? null : comp.myEditor;
    }

    public EditorWithProviderComposite @NotNull [] getEditors() {
        int tabCount = this.getTabCount();
        EditorWithProviderComposite[] res2 = new EditorWithProviderComposite[tabCount];
        for (int i = 0; i != tabCount; ++i) {
            res2[i] = this.getEditorAt(i);
        }
        if (res2 == null) {
            EditorWindow.$$$reportNull$$$0(6);
        }
        return res2;
    }

    public VirtualFile @NotNull [] getFiles() {
        int tabCount = this.getTabCount();
        VirtualFile[] res2 = new VirtualFile[tabCount];
        for (int i = 0; i != tabCount; ++i) {
            res2[i] = this.getEditorAt(i).getFile();
        }
        if (res2 == null) {
            EditorWindow.$$$reportNull$$$0(7);
        }
        return res2;
    }

    public void setSelectedEditor(EditorComposite editor, boolean focusEditor) {
        if (editor == null) {
            return;
        }
        int index = this.findFileIndex(editor.getFile());
        if (index != -1) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!this.isDisposed()) {
                    this.myTabbedPane.setSelectedIndex(index, focusEditor);
                }
            });
        }
    }

    public void setEditor(@Nullable EditorWithProviderComposite editor, boolean focusEditor) {
        this.setEditor(editor, true, focusEditor);
    }

    public void setEditor(@Nullable EditorWithProviderComposite editor, boolean selectEditor, boolean focusEditor) {
        if (editor != null) {
            this.onBeforeSetEditor(editor.getFile());
            int index = this.findEditorIndex(editor);
            if (index != -1) {
                if (selectEditor) {
                    this.setSelectedEditor(editor, focusEditor);
                }
            } else {
                int selectedIndex;
                Integer initialIndex = editor.getFile().getUserData(INITIAL_INDEX_KEY);
                int indexToInsert = initialIndex != null ? initialIndex : (UISettings.getInstance().getOpenTabsAtTheEnd() ? this.myTabbedPane.getTabCount() : ((selectedIndex = this.myTabbedPane.getSelectedIndex()) >= 0 ? selectedIndex + 1 : 0));
                VirtualFile file2 = editor.getFile();
                Icon template = AllIcons.FileTypes.Text;
                EmptyIcon emptyIcon = EmptyIcon.create(template.getIconWidth(), template.getIconHeight());
                this.myTabbedPane.insertTab(file2, emptyIcon, new TComp(this, editor), null, indexToInsert, editor);
                this.trimToSize(file2, false);
                if (selectEditor) {
                    this.setSelectedEditor(editor, focusEditor);
                }
                this.myOwner.updateFileIconImmediately(file2);
                this.myOwner.updateFileColor(file2);
            }
            this.myOwner.setCurrentWindow(this, false);
        }
        this.myOwner.validate();
    }

    protected void onBeforeSetEditor(VirtualFile file2) {
    }

    private boolean splitAvailable() {
        return this.getTabCount() >= 1;
    }

    @Nullable
    public EditorWindow split(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile2, boolean focusNew) {
        this.checkConsistency();
        if (!this.splitAvailable()) {
            return null;
        }
        FileEditorManagerImpl fileEditorManager = this.myOwner.getManager();
        if (!forceSplit && this.inSplitter()) {
            EditorWindow[] siblings = this.findSiblings();
            EditorWindow target2 = siblings[0];
            if (virtualFile2 != null) {
                FileEditor[] editors = (FileEditor[])fileEditorManager.openFileImpl3((EditorWindow)target2, (VirtualFile)virtualFile2, (boolean)focusNew, null).first;
                this.syncCaretIfPossible(editors);
            }
            return target2;
        }
        JPanel panel2 = this.myPanel;
        panel2.setBorder(null);
        int tabCount = this.getTabCount();
        if (tabCount != 0) {
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.setOpaque(false);
            OnePixelSplitter splitter = new OnePixelSplitter(orientation == 0, 0.5f, 0.1f, 0.9f);
            EditorWindow res2 = new EditorWindow(this.myOwner, this.myOwner.parentDisposable);
            EditorWithProviderComposite selectedEditor = this.getSelectedEditor();
            panel2.remove(this.myTabbedPane.getComponent());
            panel2.add((Component)splitter, "Center");
            splitter.setFirstComponent(this.myPanel);
            this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
            splitter.setSecondComponent(res2.myPanel);
            VirtualFile file2 = selectedEditor.getFile();
            if (virtualFile2 == null) {
                for (FileEditorAssociateFinder finder : FileEditorAssociateFinder.EP_NAME.getExtensionList()) {
                    VirtualFile associatedFile = finder.getAssociatedFileToOpen(fileEditorManager.getProject(), file2);
                    if (associatedFile == null) continue;
                    virtualFile2 = associatedFile;
                    break;
                }
            }
            VirtualFile nextFile = virtualFile2 == null ? file2 : virtualFile2;
            HistoryEntry currentState = selectedEditor.currentStateAsHistoryEntry();
            FileEditor[] editors = (FileEditor[])fileEditorManager.openFileImpl4((EditorWindow)res2, (VirtualFile)nextFile, (HistoryEntry)currentState, (FileEditorOpenOptions)new FileEditorOpenOptions().withCurrentTab((boolean)true).withFocusEditor((boolean)focusNew).withExactState()).first;
            this.syncCaretIfPossible(editors);
            res2.setFilePinned(nextFile, this.isFilePinned(file2));
            if (!focusNew) {
                res2.setSelectedEditor(selectedEditor, true);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(selectedEditor.getComponent(), true));
            }
            panel2.revalidate();
            return res2;
        }
        return null;
    }

    private void syncCaretIfPossible(FileEditor @Nullable [] toSync) {
        if (toSync == null) {
            return;
        }
        EditorWithProviderComposite from = this.getSelectedEditor();
        if (from == null) {
            return;
        }
        FileEditor caretSource = from.getSelectedEditor();
        if (!(caretSource instanceof TextEditor)) {
            return;
        }
        Editor editorFrom = ((TextEditor)caretSource).getEditor();
        int offset = editorFrom.getCaretModel().getOffset();
        if (offset <= 0) {
            return;
        }
        int scrollOffset = editorFrom.getScrollingModel().getVerticalScrollOffset();
        for (FileEditor fileEditor : toSync) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            if (editorFrom.getDocument() != editor.getDocument()) continue;
            editor.getCaretModel().moveToOffset(offset);
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.scrollVertically(scrollOffset);
            SwingUtilities.invokeLater(() -> {
                if (!editor.isDisposed()) {
                    scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
                }
            });
        }
    }

    public EditorWindow[] findSiblings() {
        this.checkConsistency();
        ArrayList<EditorWindow> res2 = new ArrayList<EditorWindow>();
        if (this.myPanel.getParent() instanceof Splitter) {
            Splitter splitter = (Splitter)this.myPanel.getParent();
            for (EditorWindow win : this.myOwner.getWindows()) {
                if (win == this || !SwingUtilities.isDescendingFrom(win.myPanel, splitter)) continue;
                res2.add(win);
            }
        }
        return res2.toArray(new EditorWindow[0]);
    }

    void changeOrientation() {
        this.checkConsistency();
        Container parent = this.myPanel.getParent();
        if (parent instanceof Splitter) {
            Splitter splitter;
            splitter.setOrientation(!(splitter = (Splitter)parent).getOrientation());
        }
    }

    void updateFileIcon(VirtualFile file2) {
        int index = this.findEditorIndex(this.findFileComposite(file2));
        LOG.assertTrue(index != -1);
        this.setIconAt(index, this.getFileIcon(file2));
    }

    void updateFileName(VirtualFile file2) {
        int index = this.findEditorIndex(this.findFileComposite(file2));
        if (index != -1) {
            this.setTitleAt(index, EditorTabPresentationUtil.getEditorTabTitle(this.getManager().getProject(), file2, this));
            this.setToolTipTextAt(index, UISettings.getInstance().getShowTabsTooltips() ? this.getManager().getFileTooltipText(file2) : null);
        }
    }

    private Icon getFileIcon(@NotNull VirtualFile file2) {
        Icon modifiedIcon;
        Icon pinIcon;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(8);
        }
        if (!file2.isValid()) {
            Icon fakeIcon = FileTypes.UNKNOWN.getIcon();
            assert (fakeIcon != null) : "Can't find the icon for unknown file type";
            return fakeIcon;
        }
        Icon baseIcon = IconUtil.getIcon((VirtualFile)file2, (int)2, (Project)this.getManager().getProject());
        int count = 1;
        EditorWithProviderComposite composite = this.findFileComposite(file2);
        if (composite != null && composite.isPinned()) {
            ++count;
            pinIcon = AllIcons.Nodes.TabPin;
        } else {
            pinIcon = null;
        }
        UISettings settings = UISettings.getInstance();
        if (settings.getMarkModifiedTabsWithAsterisk()) {
            Icon crop = IconUtil.cropIcon((Icon)AllIcons.General.Modified, (Rectangle)new JBRectangle(3, 3, 7, 7));
            modifiedIcon = settings.getMarkModifiedTabsWithAsterisk() && composite != null && composite.isModified() ? crop : new EmptyIcon(7, 7);
            ++count;
        } else {
            modifiedIcon = null;
        }
        if (count == 1) {
            return baseIcon;
        }
        int i = 0;
        LayeredIcon result2 = new LayeredIcon(count);
        result2.setIcon(baseIcon, i++);
        if (pinIcon != null) {
            result2.setIcon(pinIcon, i++);
        }
        if (modifiedIcon != null) {
            result2.setIcon(modifiedIcon, i++, -modifiedIcon.getIconWidth() / 2, 0);
        }
        return JBUI.scale(result2);
    }

    public void unsplit(boolean setCurrent) {
        this.checkConsistency();
        Container splitter = this.myPanel.getParent();
        if (!(splitter instanceof Splitter)) {
            return;
        }
        EditorWithProviderComposite editorToSelect = this.getSelectedEditor();
        EditorWindow[] siblings = this.findSiblings();
        JPanel parent = (JPanel)splitter.getParent();
        for (EditorWindow eachSibling : siblings) {
            EditorWithProviderComposite selected2 = eachSibling.getSelectedEditor();
            if (editorToSelect != null) continue;
            editorToSelect = selected2;
        }
        for (EditorWindow sibling : siblings) {
            EditorWithProviderComposite[] siblingEditors;
            for (EditorWithProviderComposite siblingEditor : siblingEditors = sibling.getEditors()) {
                if (editorToSelect == null) {
                    editorToSelect = siblingEditor;
                }
                this.processSiblingEditor(siblingEditor);
            }
            LOG.assertTrue(sibling != this);
            sibling.dispose();
        }
        parent.remove(splitter);
        parent.add((Component)this.myTabbedPane.getComponent(), "Center");
        parent.revalidate();
        this.myPanel = parent;
        if (editorToSelect != null) {
            this.setSelectedEditor(editorToSelect, true);
        }
        if (setCurrent) {
            this.myOwner.setCurrentWindow(this, false);
        }
    }

    private void processSiblingEditor(EditorWithProviderComposite siblingEditor) {
        if (this.getTabCount() < UISettings.getInstance().getState().getEditorTabLimit() && this.findFileComposite(siblingEditor.getFile()) == null) {
            this.setEditor(siblingEditor, true);
        } else {
            this.getManager().disposeComposite(siblingEditor);
        }
    }

    void unsplitAll() {
        this.checkConsistency();
        while (this.inSplitter()) {
            this.unsplit(true);
        }
    }

    public boolean inSplitter() {
        this.checkConsistency();
        return this.myPanel.getParent() instanceof Splitter;
    }

    public VirtualFile getSelectedFile() {
        this.checkConsistency();
        EditorWithProviderComposite editor = this.getSelectedEditor();
        return editor == null ? null : editor.getFile();
    }

    @Nullable
    public EditorWithProviderComposite findFileComposite(VirtualFile file2) {
        if (file2 instanceof BackedVirtualFile) {
            file2 = ((BackedVirtualFile)((Object)file2)).getOriginFile();
        }
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.getFile().equals(file2)) continue;
            return editor;
        }
        return null;
    }

    private int findComponentIndex(Component component2) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.getComponent().equals(component2)) continue;
            return i;
        }
        return -1;
    }

    int findEditorIndex(EditorComposite editorToFind) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            EditorWithProviderComposite editor = this.getEditorAt(i);
            if (!editor.equals(editorToFind)) continue;
            return i;
        }
        return -1;
    }

    int findFileIndex(VirtualFile fileToFind) {
        for (int i = 0; i != this.getTabCount(); ++i) {
            VirtualFile file2 = this.getFileAt(i);
            if (!file2.equals(fileToFind)) continue;
            return i;
        }
        return -1;
    }

    private EditorWithProviderComposite getEditorAt(int i) {
        return ((TComp)this.myTabbedPane.getComponentAt((int)i)).myEditor;
    }

    public boolean isFileOpen(VirtualFile file2) {
        return this.findFileComposite(file2) != null;
    }

    public boolean isFilePinned(VirtualFile file2) {
        EditorWithProviderComposite editorComposite = this.findFileComposite(file2);
        if (editorComposite == null) {
            throw new IllegalArgumentException("file is not open: " + file2.getPath());
        }
        return editorComposite.isPinned();
    }

    public void setFilePinned(VirtualFile file2, boolean pinned) {
        EditorWithProviderComposite editorComposite = this.findFileComposite(file2);
        if (editorComposite == null) {
            throw new IllegalArgumentException("file is not open: " + file2.getPath());
        }
        boolean wasPinned = editorComposite.isPinned();
        editorComposite.setPinned(pinned);
        if (wasPinned != pinned && ApplicationManager.getApplication().isDispatchThread()) {
            this.updateFileIcon(file2);
        }
    }

    void trimToSize(@Nullable VirtualFile fileToIgnore, boolean transferFocus) {
        this.getManager().getReady(this).doWhenDone(() -> {
            if (!this.isDisposed()) {
                this.doTrimSize(fileToIgnore, UISettings.getInstance().getState().getCloseNonModifiedFilesFirst(), transferFocus);
            }
        });
    }

    private void doTrimSize(@Nullable VirtualFile fileToIgnore, boolean closeNonModifiedFilesFirst, boolean transferFocus) {
        int limit = EditorWindow.getTabLimit();
        LinkedHashSet<VirtualFile> closingOrder = this.getTabClosingOrder(closeNonModifiedFilesFirst);
        VirtualFile selectedFile = this.getSelectedFile();
        if (this.shouldCloseSelected(fileToIgnore)) {
            this.defaultCloseFile(selectedFile, transferFocus);
            closingOrder.remove(selectedFile);
        }
        for (VirtualFile file2 : closingOrder) {
            if (this.myTabbedPane.getTabCount() <= limit || this.myTabbedPane.getTabCount() == 0 || this.areAllTabsPinned(fileToIgnore)) {
                return;
            }
            if (!this.fileCanBeClosed(file2, fileToIgnore)) continue;
            this.defaultCloseFile(file2, transferFocus);
        }
    }

    public static int getTabLimit() {
        int limit = UISettings.getInstance().getEditorTabLimit();
        if (ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled() && ToggleDistractionFreeModeAction.getStandardTabPlacement() == 0) {
            limit = 1;
        }
        return limit;
    }

    private LinkedHashSet<VirtualFile> getTabClosingOrder(boolean closeNonModifiedFilesFirst) {
        VirtualFile[] allFiles = this.getFiles();
        List<VirtualFile> histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFileList();
        LinkedHashSet<VirtualFile> closingOrder = new LinkedHashSet<VirtualFile>();
        for (VirtualFile file2 : allFiles) {
            if (histFiles.contains(file2)) continue;
            closingOrder.add(file2);
        }
        if (closeNonModifiedFilesFirst) {
            for (VirtualFile file3 : histFiles) {
                EditorWithProviderComposite composite = this.findFileComposite(file3);
                if (composite == null || this.myOwner.getManager().isChanged(composite)) continue;
                closingOrder.add(file3);
            }
            for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                VirtualFile file4 = this.getFileAt(i);
                if (this.myOwner.getManager().isChanged(this.getEditorAt(i))) continue;
                closingOrder.add(file4);
            }
        }
        closingOrder.addAll(histFiles);
        for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
            closingOrder.add(this.getFileAt(i));
        }
        VirtualFile selectedFile = this.getSelectedFile();
        closingOrder.remove(selectedFile);
        closingOrder.add(selectedFile);
        return closingOrder;
    }

    private boolean shouldCloseSelected(VirtualFile fileToIgnore) {
        Component owner;
        if (!UISettings.getInstance().getReuseNotModifiedTabs() || !this.myOwner.getManager().getProject().isInitialized()) {
            return false;
        }
        VirtualFile file2 = this.getSelectedFile();
        if (file2 == null || !this.isFileOpen(file2) || this.isFilePinned(file2)) {
            return false;
        }
        if (file2.equals(fileToIgnore)) {
            return false;
        }
        EditorWithProviderComposite composite = this.findFileComposite(file2);
        if (composite == null) {
            return false;
        }
        if (!(ApplicationManager.getApplication().isUnitTestMode() || (owner = IdeFocusManager.getInstance(this.myOwner.getManager().getProject()).getFocusOwner()) != null && SwingUtilities.isDescendingFrom(owner, composite.getSelectedEditor().getComponent()))) {
            return false;
        }
        return !this.myOwner.getManager().isChanged(composite);
    }

    private boolean areAllTabsPinned(VirtualFile fileToIgnore) {
        for (int i = this.myTabbedPane.getTabCount() - 1; i >= 0; --i) {
            if (!this.fileCanBeClosed(this.getFileAt(i), fileToIgnore)) continue;
            return false;
        }
        return true;
    }

    private void defaultCloseFile(VirtualFile file2, boolean transferFocus) {
        this.closeFile(file2, true, transferFocus);
    }

    private boolean fileCanBeClosed(VirtualFile file2, @Nullable VirtualFile fileToIgnore) {
        return this.isFileOpen(file2) && !file2.equals(fileToIgnore) && !this.isFilePinned(file2);
    }

    VirtualFile getFileAt(int i) {
        return this.getEditorAt(i).getFile();
    }

    public String toString() {
        return "EditorWindow: files=" + Arrays.asList(this.getFiles());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabbedPane";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateTabsVisibility";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateFileBackgroundColor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class TComp
    extends JPanel
    implements DataProvider,
    EditorWindowHolder {
        @NotNull
        final EditorWithProviderComposite myEditor;
        protected final EditorWindow myWindow;

        TComp(@NotNull EditorWindow window, @NotNull EditorWithProviderComposite editor) {
            if (window == null) {
                TComp.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                TComp.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myEditor = editor;
            this.myWindow = window;
            this.add((Component)editor.getComponent(), "Center");
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!this.hasFocus()) {
                            return;
                        }
                        JComponent focus = myEditor.getSelectedWithProvider().getFileEditor().getPreferredFocusedComponent();
                        if (focus != null && !focus.hasFocus()) {
                            IdeFocusManager.getGlobalInstance().requestFocus(focus, true);
                        }
                    });
                }
            });
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container aContainer, Component aComponent) {
                    return myEditor.getComponent();
                }

                @Override
                public Component getComponentBefore(Container aContainer, Component aComponent) {
                    return myEditor.getComponent();
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return myEditor.getComponent();
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    return myEditor.getComponent();
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return myEditor.getComponent();
                }
            });
        }

        @Override
        @NotNull
        public EditorWindow getEditorWindow() {
            EditorWindow editorWindow = this.myWindow;
            if (editorWindow == null) {
                TComp.$$$reportNull$$$0(2);
            }
            return editorWindow;
        }

        @Override
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                TComp.$$$reportNull$$$0(3);
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile virtualFile2 = this.myEditor.getFile();
                return virtualFile2.isValid() ? virtualFile2 : null;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myEditor.getFileEditorManager().getProject();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

