/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.AppTopics;
import com.intellij.CommonBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileEditor.impl.MemoryDiskConflictResolver;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseHandler;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentManagerImpl
extends FileDocumentManager
implements SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance(FileDocumentManagerImpl.class);
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create("HARD_REF_TO_DOCUMENT_KEY");
    public static final Key<Object> NOT_RELOADABLE_DOCUMENT_KEY = new Key("NOT_RELOADABLE_DOCUMENT_KEY");
    private static final Key<String> LINE_SEPARATOR_KEY = Key.create("LINE_SEPARATOR_KEY");
    private static final Key<VirtualFile> FILE_KEY = Key.create("FILE_KEY");
    private static final Key<Boolean> MUST_RECOMPUTE_FILE_TYPE = Key.create("Must recompute file type");
    private static final Key<Boolean> BIG_FILE_PREVIEW = Key.create("BIG_FILE_PREVIEW");
    private final Set<Document> myUnsavedDocuments = ContainerUtil.newConcurrentSet();
    private final MessageBus myBus;
    private static final Object lock = new Object();
    private final FileDocumentManagerListener myMultiCaster;
    private final TrailingSpacesStripper myTrailingSpacesStripper = new TrailingSpacesStripper();
    private boolean myOnClose;
    private volatile MemoryDiskConflictResolver myConflictResolver = new MemoryDiskConflictResolver();
    private final PrioritizedDocumentListener myPhysicalDocumentChangeTracker = new PrioritizedDocumentListener(){

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        @Override
        public void documentChanged(@NotNull DocumentEvent e) {
            Runnable currentCommand;
            Project project2;
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            Document document = e.getDocument();
            if (!ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.ExternalDocumentChange.class)) {
                FileDocumentManagerImpl.this.myUnsavedDocuments.add(document);
            }
            Project project3 = project2 = (currentCommand = CommandProcessor.getInstance().getCurrentCommand()) == null ? null : CommandProcessor.getInstance().getCurrentCommandProject();
            if (project2 == null) {
                project2 = ProjectUtil.guessProjectForFile(FileDocumentManagerImpl.this.getFile(document));
            }
            String lineSeparator = CodeStyle.getProjectOrDefaultSettings(project2).getLineSeparator();
            document.putUserData(LINE_SEPARATOR_KEY, lineSeparator);
            if (FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(FileDocumentManagerImpl.this.myUnsavedDocuments)) {
                FileDocumentManagerImpl.this.saveAllDocumentsLater();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$1", "documentChanged"));
        }
    };
    private final Map<VirtualFile, Document> myDocumentCache = ContainerUtil.createConcurrentWeakValueMap();
    public static boolean ourConflictsSolverEnabled = true;

    public FileDocumentManagerImpl() {
        this.myBus = ApplicationManager.getApplication().getMessageBus();
        InvocationHandler handler2 = (proxy, method2, args) -> {
            this.multiCast(method2, args);
            return null;
        };
        ClassLoader loader = FileDocumentManagerListener.class.getClassLoader();
        this.myMultiCaster = (FileDocumentManagerListener)Proxy.newProxyInstance(loader, new Class[]{FileDocumentManagerListener.class}, handler2);
    }

    private static void unwrapAndRethrow(@NotNull Exception e) {
        if (e == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(0);
        }
        Exception unwrapped = e;
        if (e instanceof InvocationTargetException) {
            unwrapped = e.getCause() == null ? e : e.getCause();
        }
        ExceptionUtil.rethrowUnchecked(unwrapped);
        LOG.error(unwrapped);
    }

    private void multiCast(@NotNull Method method2, Object[] args) {
        if (method2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(1);
        }
        try {
            method2.invoke((Object)this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC), args);
        }
        catch (ClassCastException e) {
            LOG.error("Arguments: " + Arrays.toString(args), e);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
        for (FileDocumentManagerListener listener2 : FileDocumentManagerImpl.getListeners()) {
            try {
                method2.invoke((Object)listener2, args);
            }
            catch (Exception e) {
                FileDocumentManagerImpl.unwrapAndRethrow(e);
            }
        }
        try {
            method2.invoke((Object)this.myTrailingSpacesStripper, args);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Document getDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DocumentEx document = (DocumentEx)this.getCachedDocument(file2);
        if (document == null) {
            if (!file2.isValid() || file2.isDirectory() || FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                return null;
            }
            boolean tooLarge = FileUtilRt.isTooLarge(file2.getLength());
            if (file2.getFileType().isBinary() && tooLarge) {
                return null;
            }
            CharSequence text2 = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerImpl.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
            Object object = lock;
            synchronized (object) {
                document = (DocumentEx)this.getCachedDocument(file2);
                if (document != null) {
                    return document;
                }
                document = (DocumentEx)FileDocumentManagerImpl.createDocument(text2, file2);
                document.setModificationStamp(file2.getModificationStamp());
                document.putUserData(BIG_FILE_PREVIEW, tooLarge ? Boolean.TRUE : null);
                FileType fileType = file2.getFileType();
                document.setReadOnly(tooLarge || !file2.isWritable() || fileType.isBinary());
                if (!(file2 instanceof LightVirtualFile) && !(file2.getFileSystem() instanceof NonPhysicalFileSystem)) {
                    document.addDocumentListener(this.myPhysicalDocumentChangeTracker);
                }
                if (file2 instanceof LightVirtualFile) {
                    FileDocumentManagerImpl.registerDocument(document, file2);
                } else {
                    document.putUserData(FILE_KEY, file2);
                    this.cacheDocument(file2, document);
                }
            }
            this.myMultiCaster.fileContentLoaded(file2, document);
        }
        return document;
    }

    public static boolean areTooManyDocumentsInTheQueue(@NotNull Collection<? extends Document> documents) {
        if (documents == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(3);
        }
        if (documents.size() > 100) {
            return true;
        }
        int totalSize = 0;
        for (Document document : documents) {
            if ((totalSize += document.getTextLength()) <= FileUtilRt.LARGE_FOR_CONTENT_LOADING) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Document createDocument(@NotNull CharSequence text2, @NotNull VirtualFile file2) {
        if (text2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(5);
        }
        boolean acceptSlashR = file2 instanceof LightVirtualFile && StringUtil.indexOf(text2, '\r') >= 0;
        boolean freeThreaded = Boolean.TRUE.equals(file2.getUserData(AbstractFileViewProvider.FREE_THREADED));
        DocumentImpl document = (DocumentImpl)((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(text2, acceptSlashR, freeThreaded);
        document.documentCreatedFrom(file2);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(6);
        }
        return documentImpl;
    }

    @Override
    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file2) {
        Document hard;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(7);
        }
        return (hard = file2.getUserData(HARD_REF_TO_DOCUMENT_KEY)) != null ? hard : this.getDocumentFromCache(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile2) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(8);
        }
        if (virtualFile2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(9);
        }
        Object object = lock;
        synchronized (object) {
            document.putUserData(FILE_KEY, virtualFile2);
            virtualFile2.putUserData(HARD_REF_TO_DOCUMENT_KEY, document);
        }
    }

    @Override
    @Nullable
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(10);
        }
        if (document instanceof FrozenDocument) {
            return null;
        }
        return document.getUserData(FILE_KEY);
    }

    public void dropAllUnsavedDocuments() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("This method is only for test mode!");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myUnsavedDocuments.clear();
            this.myMultiCaster.unsavedDocumentsDropped();
        }
    }

    private void saveAllDocumentsLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Document[] unsavedDocuments;
            for (Document document : unsavedDocuments = this.getUnsavedDocuments()) {
                Project project2;
                VirtualFile file2 = this.getFile(document);
                if (file2 == null || (project2 = ProjectUtil.guessProjectForFile(file2)) == null || PsiDocumentManager.getInstance(project2).isDocumentBlockedByPsi(document)) continue;
                this.saveDocument(document);
            }
        });
    }

    @Override
    public void saveAllDocuments() {
        this.saveAllDocuments(true);
    }

    public void saveAllDocuments(boolean isExplicit) {
        int count;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myMultiCaster.beforeAllDocumentsSaving();
        if (this.myUnsavedDocuments.isEmpty()) {
            return;
        }
        HashMap<Document, IOException> failedToSave = new HashMap<Document, IOException>();
        HashSet<Document> vetoed = new HashSet<Document>();
        do {
            count = 0;
            for (Document document : this.myUnsavedDocuments) {
                if (failedToSave.containsKey(document) || vetoed.contains(document)) continue;
                try {
                    this.doSaveDocument(document, isExplicit);
                }
                catch (IOException e) {
                    failedToSave.put(document, e);
                }
                catch (SaveVetoException e) {
                    vetoed.add(document);
                }
                ++count;
            }
        } while (count != 0);
        if (!failedToSave.isEmpty()) {
            this.handleErrorsOnSave(failedToSave);
        }
    }

    @Override
    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(11);
        }
        this.saveDocument(document, true);
    }

    public void saveDocument(@NotNull Document document, boolean explicit) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (!this.myUnsavedDocuments.contains(document)) {
            return;
        }
        try {
            this.doSaveDocument(document, explicit);
        }
        catch (IOException e) {
            this.handleErrorsOnSave(Collections.singletonMap(document, e));
        }
        catch (SaveVetoException saveVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(13);
        }
        VirtualFile file2 = this.getFile(document);
        boolean spaceStrippingEnabled = true;
        if (file2 != null) {
            spaceStrippingEnabled = TrailingSpacesStripper.isEnabled(file2);
            TrailingSpacesStripper.setEnabled(file2, false);
        }
        try {
            this.saveDocument(document);
        }
        finally {
            if (file2 != null) {
                TrailingSpacesStripper.setEnabled(file2, spaceStrippingEnabled);
            }
        }
    }

    private void doSaveDocument(@NotNull Document document, boolean isExplicit) throws IOException, SaveVetoException {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(14);
        }
        VirtualFile file2 = this.getFile(document);
        if (LOG.isTraceEnabled()) {
            LOG.trace("saving: " + file2);
        }
        if (file2 == null || file2 instanceof LightVirtualFile || file2.isValid() && !this.isFileModified(file2)) {
            this.removeFromUnsaved(document);
            return;
        }
        if (file2.isValid() && FileDocumentManagerImpl.needsRefresh(file2)) {
            LOG.trace("  refreshing...");
            file2.refresh(false, false);
            if (!this.myUnsavedDocuments.contains(document)) {
                return;
            }
        }
        if (!this.maySaveDocument(file2, document, isExplicit)) {
            throw new SaveVetoException();
        }
        LOG.trace("  writing...");
        WriteAction.run(() -> this.doSaveDocumentInWriteAction(document, file2));
        LOG.trace("  done");
    }

    private boolean maySaveDocument(@NotNull VirtualFile file2, @NotNull Document document, boolean isExplicit) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(15);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(16);
        }
        return !this.myConflictResolver.hasConflict(file2) && FileDocumentSynchronizationVetoer.EP_NAME.getExtensionList().stream().allMatch(vetoer -> vetoer.maySaveDocument(document, isExplicit));
    }

    private void doSaveDocumentInWriteAction(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(18);
        }
        if (!file2.isValid()) {
            this.removeFromUnsaved(document);
            return;
        }
        if (!file2.equals(this.getFile(document))) {
            FileDocumentManagerImpl.registerDocument(document, file2);
        }
        boolean saveNeeded = false;
        IOException ioException = null;
        try {
            saveNeeded = FileDocumentManagerImpl.isSaveNeeded(document, file2);
        }
        catch (IOException e) {
            ioException = e;
        }
        if (!saveNeeded) {
            if (document instanceof DocumentEx) {
                ((DocumentEx)document).setModificationStamp(file2.getModificationStamp());
            }
            this.removeFromUnsaved(document);
            FileDocumentManagerImpl.updateModifiedProperty(file2);
            if (ioException != null) {
                throw ioException;
            }
            return;
        }
        PomModelImpl.guardPsiModificationsIn(() -> {
            this.myMultiCaster.beforeDocumentSaving(document);
            LOG.assertTrue(file2.isValid());
            String text2 = document.getText();
            String lineSeparator = FileDocumentManagerImpl.getLineSeparator(document, file2);
            if (!lineSeparator.equals("\n")) {
                text2 = StringUtil.convertLineSeparators(text2, lineSeparator);
            }
            Project project2 = ProjectLocator.getInstance().guessProjectForFile(file2);
            LoadTextUtil.write(project2, file2, this, text2, document.getModificationStamp());
            this.myUnsavedDocuments.remove(document);
            LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
            this.myTrailingSpacesStripper.clearLineModificationFlags(document);
        });
    }

    private static void updateModifiedProperty(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(19);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance(project2);
            for (FileEditor editor : fileEditorManager.getAllEditors(file2)) {
                if (!(editor instanceof TextEditorImpl)) continue;
                ((TextEditorImpl)editor).updateModifiedProperty();
            }
        }
    }

    private void removeFromUnsaved(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(20);
        }
        this.myUnsavedDocuments.remove(document);
        this.myMultiCaster.unsavedDocumentDropped(document);
        LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
    }

    private static boolean isSaveNeeded(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(21);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(22);
        }
        if (file2.getFileType().isBinary() || document.getTextLength() > 1000000) {
            return true;
        }
        byte[] bytes = file2.contentsToByteArray();
        CharSequence loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, file2, false, false);
        return !Comparing.equal(document.getCharsSequence(), loaded);
    }

    private static boolean needsRefresh(@NotNull VirtualFile file2) {
        VirtualFileSystem fs;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(23);
        }
        return (fs = file2.getFileSystem()) instanceof NewVirtualFileSystem && file2.getTimeStamp() != ((NewVirtualFileSystem)fs).getTimeStamp(file2);
    }

    @NotNull
    public static String getLineSeparator(@NotNull Document document, @NotNull VirtualFile file2) {
        String lineSeparator;
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(25);
        }
        if ((lineSeparator = file2.getDetectedLineSeparator()) == null) {
            lineSeparator = document.getUserData(LINE_SEPARATOR_KEY);
            assert (lineSeparator != null) : document;
        }
        String string = lineSeparator;
        if (string == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @NotNull
    public String getLineSeparator(@Nullable VirtualFile file2, @Nullable Project project2) {
        String lineSeparator;
        String string = lineSeparator = file2 == null ? null : file2.getDetectedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = CodeStyle.getProjectOrDefaultSettings(project2).getLineSeparator();
        }
        String string2 = lineSeparator;
        if (string2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(27);
        }
        return string2;
    }

    @Override
    public boolean requestWriting(@NotNull Document document, Project project2) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(28);
        }
        return this.requestWritingStatus(document, project2).hasWriteAccess();
    }

    @Override
    @NotNull
    public FileDocumentManager.WriteAccessStatus requestWritingStatus(@NotNull Document document, @Nullable Project project2) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(29);
        }
        VirtualFile file2 = FileDocumentManagerImpl.getInstance().getFile(document);
        if (project2 != null && file2 != null && file2.isValid()) {
            if (file2.getFileType().isBinary()) {
                FileDocumentManager.WriteAccessStatus writeAccessStatus = FileDocumentManager.WriteAccessStatus.NON_WRITABLE;
                if (writeAccessStatus == null) {
                    FileDocumentManagerImpl.$$$reportNull$$$0(30);
                }
                return writeAccessStatus;
            }
            ReadonlyStatusHandler.OperationStatus writableStatus = ReadonlyStatusHandler.getInstance(project2).ensureFilesWritable(Collections.singletonList(file2));
            if (writableStatus.hasReadonlyFiles()) {
                return new FileDocumentManager.WriteAccessStatus(writableStatus.getReadonlyFilesMessage());
            }
            assert (file2.isWritable());
        }
        if (document.isWritable()) {
            FileDocumentManager.WriteAccessStatus writeAccessStatus = FileDocumentManager.WriteAccessStatus.WRITABLE;
            if (writeAccessStatus == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(31);
            }
            return writeAccessStatus;
        }
        document.fireReadOnlyModificationAttempt();
        FileDocumentManager.WriteAccessStatus writeAccessStatus = FileDocumentManager.WriteAccessStatus.NON_WRITABLE;
        if (writeAccessStatus == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(32);
        }
        return writeAccessStatus;
    }

    @Override
    public void reloadFiles(VirtualFile ... files2) {
        if (files2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(33);
        }
        for (VirtualFile file2 : files2) {
            Document doc;
            if (!file2.exists() || (doc = this.getCachedDocument(file2)) == null) continue;
            this.reloadFromDisk(doc);
        }
    }

    @Override
    public Document @NotNull [] getUnsavedDocuments() {
        if (this.myUnsavedDocuments.isEmpty()) {
            if (Document.EMPTY_ARRAY == null) {
                FileDocumentManagerImpl.$$$reportNull$$$0(34);
            }
            return Document.EMPTY_ARRAY;
        }
        ArrayList<Document> list2 = new ArrayList<Document>(this.myUnsavedDocuments);
        Document[] documentArray = list2.toArray(Document.EMPTY_ARRAY);
        if (documentArray == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(35);
        }
        return documentArray;
    }

    @Override
    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(36);
        }
        return this.myUnsavedDocuments.contains(document);
    }

    @Override
    public boolean isFileModified(@NotNull VirtualFile file2) {
        Document doc;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(37);
        }
        return (doc = this.getCachedDocument(file2)) != null && this.isDocumentUnsaved(doc) && doc.getModificationStamp() != file2.getModificationStamp();
    }

    @Override
    public boolean isPartialPreviewOfALargeFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(38);
        }
        return document.getUserData(BIG_FILE_PREVIEW) == Boolean.TRUE;
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
        Document document;
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(39);
        }
        VirtualFile file2 = event.getFile();
        if ("writable".equals(event.getPropertyName())) {
            Document document2 = this.getCachedDocument(file2);
            if (document2 != null) {
                ApplicationManager.getApplication().runWriteAction(() -> document2.setReadOnly(!file2.isWritable()));
            }
        } else if ("name".equals(event.getPropertyName()) && (document = this.getCachedDocument(file2)) != null && FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
            this.unbindFileFromDocument(file2, document);
        }
    }

    private void unbindFileFromDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(40);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(41);
        }
        this.removeDocumentFromCache(file2);
        file2.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document.putUserData(FILE_KEY, null);
    }

    private static boolean isBinaryWithDecompiler(@NotNull VirtualFile file2) {
        FileType ft;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(42);
        }
        return (ft = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(ft) != null;
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(43);
        }
        return (fileType = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(fileType) == null;
    }

    public void contentsChanged(@NotNull VFileContentChangeEvent event) {
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(44);
        }
        VirtualFile virtualFile2 = event.getFile();
        Document document = this.getCachedDocument(virtualFile2);
        if (event.isFromSave()) {
            return;
        }
        if (document == null || FileDocumentManagerImpl.isBinaryWithDecompiler(virtualFile2)) {
            this.myMultiCaster.fileWithNoDocumentChanged(virtualFile2);
        }
        if (!(document == null || document.getModificationStamp() != event.getOldModificationStamp() && this.isDocumentUnsaved(document))) {
            this.reloadFromDisk(document);
        }
    }

    @Override
    public void reloadFromDisk(final @NotNull Document document) {
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(45);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final VirtualFile file2 = this.getFile(document);
        assert (file2 != null);
        if (!file2.isValid()) {
            return;
        }
        if (!this.fireBeforeFileContentReload(file2, document)) {
            return;
        }
        final Project project2 = ProjectLocator.getInstance().guessProjectForFile(file2);
        final boolean[] isReloadable = new boolean[]{FileDocumentManagerImpl.isReloadable(file2, document, project2)};
        if (isReloadable[0]) {
            CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(new ExternalChangeAction.ExternalDocumentChange(document, project2){

                @Override
                public void run() {
                    if (!FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                        LoadTextUtil.clearCharsetAutoDetectionReason(file2);
                        file2.setBOM(null);
                        file2.setCharset(null, null, false);
                        boolean wasWritable = document.isWritable();
                        document.setReadOnly(false);
                        boolean tooLarge = FileUtilRt.isTooLarge(file2.getLength());
                        isReloadable[0] = FileDocumentManagerImpl.isReloadable(file2, document, project2);
                        if (isReloadable[0]) {
                            CharSequence reloaded2 = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerImpl.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
                            ((DocumentEx)document).replaceText(reloaded2, file2.getModificationStamp());
                            document.putUserData(BIG_FILE_PREVIEW, tooLarge ? Boolean.TRUE : null);
                        }
                        document.setReadOnly(!wasWritable);
                    }
                }
            }), UIBundle.message("file.cache.conflict.action", new Object[0]), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        }
        if (isReloadable[0]) {
            this.myMultiCaster.fileContentReloaded(file2, document);
        } else {
            this.unbindFileFromDocument(file2, document);
            this.myMultiCaster.fileWithNoDocumentChanged(file2);
        }
        this.myUnsavedDocuments.remove(document);
    }

    private static boolean isReloadable(@NotNull VirtualFile file2, @NotNull Document document, @Nullable Project project2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(46);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(47);
        }
        PsiFile cachedPsiFile = project2 == null ? null : PsiDocumentManager.getInstance(project2).getCachedPsiFile(document);
        return !(FileUtilRt.isTooLarge(file2.getLength()) && file2.getFileType().isBinary() || cachedPsiFile != null && !(cachedPsiFile instanceof PsiFileImpl) && !FileDocumentManagerImpl.isBinaryWithDecompiler(file2) || document.getUserData(NOT_RELOADABLE_DOCUMENT_KEY) != null);
    }

    void setAskReloadFromDisk(@NotNull Disposable disposable2, @NotNull MemoryDiskConflictResolver newProcessor) {
        if (disposable2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(48);
        }
        if (newProcessor == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(49);
        }
        MemoryDiskConflictResolver old = this.myConflictResolver;
        this.myConflictResolver = newProcessor;
        Disposer.register(disposable2, () -> {
            this.myConflictResolver = old;
        });
    }

    private void fileDeleted(@NotNull VFileDeleteEvent event) {
        Document doc;
        if (event == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(50);
        }
        if ((doc = this.getCachedDocument(event.getFile())) != null) {
            this.myTrailingSpacesStripper.documentDeleted(doc);
        }
    }

    public static boolean recomputeFileTypeIfNecessary(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(51);
        }
        if (virtualFile2.getUserData(MUST_RECOMPUTE_FILE_TYPE) != null) {
            virtualFile2.getFileType();
            virtualFile2.putUserData(MUST_RECOMPUTE_FILE_TYPE, null);
            return true;
        }
        return false;
    }

    private boolean fireBeforeFileContentReload(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(52);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(53);
        }
        for (FileDocumentSynchronizationVetoer vetoer : FileDocumentSynchronizationVetoer.EP_NAME.getExtensionList()) {
            try {
                if (vetoer.mayReloadFileContent(file2, document)) continue;
                return false;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        this.myMultiCaster.beforeFileContentReload(file2, document);
        return true;
    }

    @NotNull
    private static List<FileDocumentManagerListener> getListeners() {
        List<FileDocumentManagerListener> list2 = FileDocumentManagerListener.EP_NAME.getExtensionList();
        if (list2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(54);
        }
        return list2;
    }

    private static int getPreviewCharCount(@NotNull VirtualFile file2) {
        Charset charset;
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(55);
        }
        float bytesPerChar = (charset = EncodingManager.getInstance().getEncoding(file2, false)) == null ? 2.0f : charset.newEncoder().averageBytesPerChar();
        return (int)((float)FileUtilRt.LARGE_FILE_PREVIEW_SIZE / bytesPerChar);
    }

    private void handleErrorsOnSave(@NotNull Map<Document, IOException> failures) {
        if (failures == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(56);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            IOException ioException = ContainerUtil.getFirstItem(failures.values());
            if (ioException != null) {
                throw new RuntimeException(ioException);
            }
            return;
        }
        for (IOException exception : failures.values()) {
            LOG.warn(exception);
        }
        final String text2 = StringUtil.join(failures.values(), Throwable::getMessage, "\n");
        DialogWrapper dialog2 = new DialogWrapper(null){
            {
                super(arg0);
                this.init();
                this.setTitle(UIBundle.message("cannot.save.files.dialog.title", new Object[0]));
            }

            @Override
            protected void createDefaultActions() {
                super.createDefaultActions();
                this.myOKAction.putValue("Name", UIBundle.message(FileDocumentManagerImpl.this.myOnClose ? "cannot.save.files.dialog.ignore.changes" : "cannot.save.files.dialog.revert.changes", new Object[0]));
                this.myOKAction.putValue("DefaultAction", null);
                if (!FileDocumentManagerImpl.this.myOnClose) {
                    this.myCancelAction.putValue("Name", CommonBundle.getCloseButtonText());
                }
            }

            @Override
            protected JComponent createCenterPanel() {
                JPanel panel2 = new JPanel(new BorderLayout(0, 5));
                panel2.add((Component)new JLabel(UIBundle.message("cannot.save.files.dialog.message", new Object[0])), "North");
                JTextPane area = new JTextPane();
                area.setText(text2);
                area.setEditable(false);
                area.setMinimumSize(new Dimension(area.getMinimumSize().width, 50));
                panel2.add((Component)new JBScrollPane(area, 22, 31), "Center");
                return panel2;
            }
        };
        if (dialog2.showAndGet()) {
            for (Document document : failures.keySet()) {
                this.reloadFromDisk(document);
            }
        }
    }

    protected void cacheDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(57);
        }
        if (document == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(58);
        }
        this.myDocumentCache.put(file2, document);
    }

    protected void removeDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(59);
        }
        this.myDocumentCache.remove(file2);
    }

    protected Document getDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerImpl.$$$reportNull$$$0(60);
        }
        return this.myDocumentCache.get(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documents";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 36: 
            case 38: 
            case 41: 
            case 45: 
            case 47: 
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 39: 
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProcessor";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSeparator";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWritingStatus";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAndRethrow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "multiCast";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "areTooManyDocumentsInTheQueue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 6: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 54: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerDocument";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentAsIs";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doSaveDocument";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "maySaveDocument";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doSaveDocumentInWriteAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateModifiedProperty";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeFromUnsaved";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSaveNeeded";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "needsRefresh";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparator";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "requestWritingStatus";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "reloadFiles";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentUnsaved";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isFileModified";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "unbindFileFromDocument";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithDecompiler";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "contentsChanged";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isReloadable";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setAskReloadFromDisk";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fileDeleted";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "recomputeFileTypeIfNecessary";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeFileContentReload";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewCharCount";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "handleErrorsOnSave";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "cacheDocument";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentFromCache";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFromCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyAsyncFileListener
    implements AsyncFileListener {
        private final FileDocumentManagerImpl myFileDocumentManager = (FileDocumentManagerImpl)FileDocumentManager.getInstance();

        MyAsyncFileListener() {
        }

        @Override
        public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MyAsyncFileListener.$$$reportNull$$$0(0);
            }
            final ArrayList<VirtualFile> toRecompute = new ArrayList<VirtualFile>();
            final HashMap<VirtualFile, Document> strongRefsToDocuments = new HashMap<VirtualFile, Document>();
            final List<VFileContentChangeEvent> contentChanges = ContainerUtil.findAll(events, VFileContentChangeEvent.class);
            for (VFileContentChangeEvent event : contentChanges) {
                ProgressManager.checkCanceled();
                VirtualFile virtualFile2 = event.getFile();
                long lastRecordedLength = PersistentFS.getInstance().getLastRecordedLength(virtualFile2);
                if (lastRecordedLength == 0L && FileTypeRegistry.getInstance().isFileOfType(virtualFile2, UnknownFileType.INSTANCE)) {
                    toRecompute.add(virtualFile2);
                }
                this.prepareForRangeMarkerUpdate(strongRefsToDocuments, virtualFile2);
            }
            return new AsyncFileListener.ChangeApplier(){

                @Override
                public void beforeVfsChange() {
                    for (VFileContentChangeEvent event : contentChanges) {
                        this.prepareForRangeMarkerUpdate(strongRefsToDocuments, event.getFile());
                        if (!ourConflictsSolverEnabled) continue;
                        myFileDocumentManager.myConflictResolver.beforeContentChange(event);
                    }
                    for (VirtualFile file2 : toRecompute) {
                        file2.putUserData(MUST_RECOMPUTE_FILE_TYPE, Boolean.TRUE);
                    }
                }

                @Override
                public void afterVfsChange() {
                    for (VFileEvent event : events) {
                        if (event instanceof VFileContentChangeEvent && ((VFileContentChangeEvent)event).getFile().isValid()) {
                            myFileDocumentManager.contentsChanged((VFileContentChangeEvent)event);
                            continue;
                        }
                        if (event instanceof VFileDeleteEvent && ((VFileDeleteEvent)event).getFile().isValid()) {
                            myFileDocumentManager.fileDeleted((VFileDeleteEvent)event);
                            continue;
                        }
                        if (!(event instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)event).getFile().isValid()) continue;
                        myFileDocumentManager.propertyChanged((VFilePropertyChangeEvent)event);
                    }
                    ObjectUtils.reachabilityFence(strongRefsToDocuments);
                }
            };
        }

        private void prepareForRangeMarkerUpdate(Map<VirtualFile, Document> strongRefsToDocuments, VirtualFile virtualFile2) {
            Document document = this.myFileDocumentManager.getCachedDocument(virtualFile2);
            if (document == null && DocumentImpl.areRangeMarkersRetainedFor(virtualFile2)) {
                document = this.myFileDocumentManager.getDocument(virtualFile2);
            }
            if (document != null) {
                strongRefsToDocuments.put(virtualFile2, document);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$MyAsyncFileListener", "prepareChange"));
        }
    }

    private static class SaveVetoException
    extends Exception {
        private SaveVetoException() {
        }
    }

    static final class MyProjectCloseHandler
    implements ProjectCloseHandler {
        MyProjectCloseHandler() {
        }

        @Override
        public boolean canClose(@NotNull Project project2) {
            FileDocumentManagerImpl manager;
            if (project2 == null) {
                MyProjectCloseHandler.$$$reportNull$$$0(0);
            }
            if (!(manager = (FileDocumentManagerImpl)FileDocumentManager.getInstance()).myUnsavedDocuments.isEmpty()) {
                manager.myOnClose = true;
                try {
                    manager.saveAllDocuments();
                }
                finally {
                    manager.myOnClose = false;
                }
            }
            return manager.myUnsavedDocuments.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl$MyProjectCloseHandler", "canClose"));
        }
    }
}

