/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ProjectTopics;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.DockableEditorContainerFactory;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerChange;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.fileEditor.impl.FilePreviewPanelProvider;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutSettingsManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.impl.MessageListenerList;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@State(name="FileEditorManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public class FileEditorManagerImpl
extends FileEditorManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(FileEditorManagerImpl.class);
    private static final Key<Boolean> DUMB_AWARE = Key.create("DUMB_AWARE");
    private static final FileEditor[] EMPTY_EDITOR_ARRAY = new FileEditor[0];
    private static final FileEditorProvider[] EMPTY_PROVIDER_ARRAY = new FileEditorProvider[0];
    public static final Key<Boolean> CLOSING_TO_REOPEN = Key.create("CLOSING_TO_REOPEN");
    public static final String FILE_EDITOR_MANAGER = "FileEditorManager";
    private EditorsSplitters mySplitters;
    private final Project myProject;
    private final List<Pair<VirtualFile, EditorWindow>> mySelectionHistory;
    private Reference<EditorComposite> myLastSelectedComposite;
    private final MergingUpdateQueue myQueue;
    private final BusyObject.Impl.Simple myBusyObject;
    private final PropertyChangeListener myEditorPropertyChangeListener;
    private final DockManager myDockManager;
    private DockableEditorContainerFactory myContentFactory;
    private static final AtomicInteger ourOpenFilesSetModificationCount = new AtomicInteger();
    static final ModificationTracker OPEN_FILE_SET_MODIFICATION_COUNT = ourOpenFilesSetModificationCount::get;
    private final List<EditorComposite> myOpenedEditors;
    private final MessageListenerList<FileEditorManagerListener> myListenerList;
    private final Object myInitLock;

    public FileEditorManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(0);
        }
        this.mySelectionHistory = new ArrayList<Pair<VirtualFile, EditorWindow>>();
        this.myLastSelectedComposite = new WeakReference<Object>(null);
        this.myQueue = new MergingUpdateQueue("FileEditorManagerUpdateQueue", 50, true, MergingUpdateQueue.ANY_COMPONENT, this);
        this.myBusyObject = new BusyObject.Impl.Simple();
        this.myEditorPropertyChangeListener = new MyEditorPropertyChangeListener();
        this.myOpenedEditors = new CopyOnWriteArrayList<EditorComposite>();
        this.myInitLock = new Object();
        this.myProject = project2;
        this.myDockManager = DockManager.getInstance(this.myProject);
        this.myListenerList = new MessageListenerList<FileEditorManagerListener>(this.myProject.getMessageBus(), FileEditorManagerListener.FILE_EDITOR_MANAGER);
        if (FileEditorAssociateFinder.EP_NAME.hasAnyExtensions()) {
            this.myListenerList.add(new FileEditorManagerListener(){

                @Override
                public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    EditorsSplitters splitters = FileEditorManagerImpl.this.getSplitters();
                    FileEditorManagerImpl.this.openAssociatedFile(event.getNewFile(), splitters.getCurrentWindow(), splitters);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$1", "selectionChanged"));
                }
            });
        }
        this.myQueue.setTrackUiActivity(true);
        final MessageBusConnection connection = project2.getMessageBus().connect(this);
        connection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            @Override
            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> FileEditorManagerImpl.this.dumbModeFinished(FileEditorManagerImpl.this.myProject), FileEditorManagerImpl.this.myProject.getDisposed());
            }
        });
        connection.subscribe(ProjectManager.TOPIC, new ProjectManagerListener(){

            @Override
            public void projectOpened(@NotNull Project project2) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project2 == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.projectOpened(connection);
                }
            }

            @Override
            public void projectClosing(@NotNull Project project2) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (project2 == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.closeAllFiles();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        FileEditorProvider.EP_FILE_EDITOR_PROVIDER.addExtensionPointListener(new ExtensionPointListener<FileEditorProvider>(){

            @Override
            public void extensionRemoved(@NotNull FileEditorProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                block0: for (EditorComposite editor : FileEditorManagerImpl.this.myOpenedEditors) {
                    for (FileEditorProvider provider : editor.getProviders()) {
                        if (!provider.equals(extension)) continue;
                        FileEditorManagerImpl.this.closeFile(editor.getFile());
                        continue block0;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$4";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    @Override
    public void dispose() {
    }

    private void dumbModeFinished(Project project2) {
        VirtualFile[] files2;
        for (VirtualFile file2 : files2 = this.getOpenFiles()) {
            HashSet providers = new HashSet();
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            for (EditorWithProviderComposite composite : composites) {
                ContainerUtil.addAll(providers, composite.getProviders());
            }
            FileEditorProvider[] newProviders = FileEditorProviderManager.getInstance().getProviders(project2, file2);
            ArrayList<FileEditorProvider> toOpen = new ArrayList<FileEditorProvider>(Arrays.asList(newProviders));
            toOpen.removeAll(providers);
            for (EditorWithProviderComposite composite : composites) {
                for (FileEditorProvider provider : toOpen) {
                    FileEditor editor = provider.createEditor(this.myProject, file2);
                    composite.addEditor(editor, provider);
                }
            }
        }
        this.updateFileName(null);
    }

    public void initDockableContentFactory() {
        if (this.myContentFactory != null) {
            return;
        }
        this.myContentFactory = new DockableEditorContainerFactory(this.myProject, this);
        this.myDockManager.register("file-editors", this.myContentFactory, this);
    }

    public static boolean isDumbAware(@NotNull FileEditor editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(1);
        }
        return Boolean.TRUE.equals(editor.getUserData(DUMB_AWARE)) && (!(editor instanceof PossiblyDumbAware) || ((PossiblyDumbAware)((Object)editor)).isDumbAware());
    }

    @Override
    public JComponent getComponent() {
        return this.initUI();
    }

    @NotNull
    public EditorsSplitters getMainSplitters() {
        return this.initUI();
    }

    @NotNull
    public Set<EditorsSplitters> getAllSplitters() {
        LinkedHashSet<EditorsSplitters> all = new LinkedHashSet<EditorsSplitters>();
        all.add(this.getMainSplitters());
        Set<DockContainer> dockContainers = this.myDockManager.getContainers();
        for (DockContainer each : dockContainers) {
            if (!(each instanceof DockableEditorTabbedContainer)) continue;
            all.add(((DockableEditorTabbedContainer)each).getSplitters());
        }
        Set<EditorsSplitters> set = Collections.unmodifiableSet(all);
        if (set == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private Promise<EditorsSplitters> getActiveSplittersAsync() {
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager fm = IdeFocusManager.getInstance(this.myProject);
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        fm.doWhenFocusSettlesDown(() -> {
            if (this.myProject.isDisposed()) {
                result2.cancel();
                return;
            }
            Component focusOwner = fm.getFocusOwner();
            DockContainer container2 = this.myDockManager.getContainerFor(focusOwner);
            if (container2 instanceof DockableEditorTabbedContainer) {
                result2.setResult((Object)((DockableEditorTabbedContainer)container2).getSplitters());
            } else {
                result2.setResult((Object)this.getMainSplitters());
            }
        }, ModalityState.defaultModalityState());
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(3);
        }
        return asyncPromise;
    }

    private EditorsSplitters getActiveSplittersSync() {
        DockContainer container2;
        FileEditorManagerImpl.assertDispatchThread();
        IdeFocusManager fm = IdeFocusManager.getInstance(this.myProject);
        Component focusOwner = fm.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (focusOwner == null) {
            focusOwner = fm.getLastFocusedFor(fm.getLastFocusedIdeWindow());
        }
        if ((container2 = this.myDockManager.getContainerFor(focusOwner)) == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            container2 = this.myDockManager.getContainerFor(focusOwner);
        }
        if (container2 instanceof DockableEditorTabbedContainer) {
            return ((DockableEditorTabbedContainer)container2).getSplitters();
        }
        return this.getMainSplitters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private EditorsSplitters initUI() {
        EditorsSplitters result2 = this.mySplitters;
        if (result2 != null) {
            EditorsSplitters editorsSplitters = result2;
            if (editorsSplitters == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(4);
            }
            return editorsSplitters;
        }
        Object object = this.myInitLock;
        synchronized (object) {
            result2 = this.mySplitters;
            if (result2 == null) {
                this.mySplitters = result2 = new EditorsSplitters(this, true, this);
            }
        }
        EditorsSplitters editorsSplitters = result2;
        if (editorsSplitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(5);
        }
        return editorsSplitters;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        EditorWithProviderComposite editor;
        FileEditorManagerImpl.assertReadAccess();
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (editor = window.getSelectedEditor()) != null) {
            return editor.getPreferredFocusedComponent();
        }
        return null;
    }

    public Color getFileColor(@NotNull VirtualFile file2) {
        FileStatusManager fileStatusManager;
        Color statusColor;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(6);
        }
        Color color = statusColor = (fileStatusManager = FileStatusManager.getInstance(this.myProject)) != null ? fileStatusManager.getStatus(file2).getColor() : UIUtil.getLabelForeground();
        if (statusColor == null) {
            statusColor = UIUtil.getLabelForeground();
        }
        return statusColor;
    }

    public boolean isProblem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(7);
        }
        return false;
    }

    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(8);
        }
        List<EditorTabTitleProvider> availableProviders = DumbService.getDumbAwareExtensions(this.myProject, EditorTabTitleProvider.EP_NAME);
        for (EditorTabTitleProvider provider : availableProviders) {
            String text2 = provider.getEditorTabTooltipText(this.myProject, file2);
            if (text2 == null) continue;
            String string = text2;
            if (string == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome(file2.getPresentableUrl());
        if (string == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(11);
        }
        if (!this.isFileOpen(file2)) {
            return;
        }
        this.updateFileName(file2);
        this.queueUpdateFile(file2);
    }

    private void updateFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(12);
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileColor(file2);
        }
    }

    private void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(13);
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileBackgroundColor(file2);
        }
    }

    protected void updateFileIcon(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(14);
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileIcon(file2);
        }
    }

    void updateFileName(final @Nullable VirtualFile file2) {
        this.myQueue.queue(new Update((Object)("UpdateFileName " + (file2 == null ? "" : file2.getPath()))){

            @Override
            public boolean isExpired() {
                return FileEditorManagerImpl.this.myProject.isDisposed() || !FileEditorManagerImpl.this.myProject.isOpen() || (file2 == null ? super.isExpired() : !file2.isValid());
            }

            @Override
            public void run() {
                for (EditorsSplitters each : FileEditorManagerImpl.this.getAllSplitters()) {
                    each.updateFileName(file2);
                }
            }
        });
    }

    void updateFrameTitle() {
        this.getActiveSplittersAsync().onSuccess(splitters -> splitters.updateFileName(null));
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        EditorWithProviderComposite editorComposite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(15);
        }
        return (editorComposite = this.getEditorComposite(editor)) == null ? null : editorComposite.getFile();
    }

    @Override
    public void unsplitWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplit(true);
        }
    }

    @Override
    public void unsplitAllWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplitAll();
        }
    }

    @Override
    public int getWindowSplitCount() {
        return this.getActiveSplittersSync().getSplitCount();
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        Set<EditorsSplitters> splitters = this.getAllSplitters();
        if (splitters.size() > 1) {
            return true;
        }
        return this.getWindowSplitCount() > 1;
    }

    @Override
    public EditorWindow @NotNull [] getWindows() {
        ArrayList windows = new ArrayList();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            EditorWindow[] eachList = each.getWindows();
            ContainerUtil.addAll(windows, eachList);
        }
        EditorWindow[] editorWindowArray = windows.toArray(new EditorWindow[0]);
        if (editorWindowArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(16);
        }
        return editorWindowArray;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(17);
        }
        List<EditorWindow> windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.size(); ++i) {
            if (!windows.get(i).equals(window)) continue;
            return windows.get((i + 1) % windows.size());
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(18);
        }
        List<EditorWindow> windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.size(); ++i) {
            if (!windows.get(i).equals(window)) continue;
            return windows.get((i + windows.size() - 1) % windows.size());
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public void createSplitter(int orientation, @Nullable EditorWindow window) {
        if (window != null) {
            window.split(orientation, true, null, false);
        } else {
            EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
            if (currentWindow != null) {
                currentWindow.split(orientation, true, null, false);
            }
        }
    }

    @Override
    public void changeSplitterOrientation() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.changeOrientation();
        }
    }

    @Override
    public boolean isInSplitter() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.inSplitter();
    }

    @Override
    public boolean hasOpenedFile() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.getSelectedEditor() != null;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.getActiveSplittersSync().getCurrentFile();
    }

    @Override
    @NotNull
    public Promise<EditorWindow> getActiveWindow() {
        Promise<EditorWindow> promise2 = this.getActiveSplittersAsync().then(EditorsSplitters::getCurrentWindow);
        if (promise2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(19);
        }
        return promise2;
    }

    @Override
    public EditorWindow getCurrentWindow() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        EditorsSplitters splitters = this.getActiveSplittersSync();
        return splitters == null ? null : splitters.getCurrentWindow();
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
        this.getActiveSplittersSync().setCurrentWindow(window, true);
    }

    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window, boolean transferFocus) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(20);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(21);
        }
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (window.isFileOpen(file2)) {
                window.closeFile(file2, true, transferFocus);
            }
        }, IdeBundle.message("command.close.active.editor", new Object[0]), null);
        this.removeSelectionRecord(file2, window);
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(22);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(23);
        }
        this.closeFile(file2, window, true);
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(24);
        }
        this.closeFile(file2, true, false);
    }

    public void closeFile(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(25);
        }
        FileEditorManagerImpl.assertDispatchThread();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.closeFileImpl(file2, moveFocus, closeAllCopies), "", null);
    }

    private void closeFileImpl(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(26);
        }
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        this.runChange(splitters -> splitters.closeFile(file2, moveFocus), closeAllCopies ? null : this.getActiveSplittersSync());
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForSplitter) {
        Pair<FileEditor[], FileEditorProvider[]> previewResult;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(27);
        }
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (FileEditorManagerImpl.isOpenInNewWindow()) {
            Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileInNewWindow(file2);
            if (pair == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(28);
            }
            return pair;
        }
        EditorWindow wndToOpenIn = null;
        if (searchForSplitter && UISettings.getInstance().getEditorTabPlacement() != 0) {
            Set<EditorsSplitters> all = this.getAllSplitters();
            EditorsSplitters active = this.getActiveSplittersSync();
            if (active.getCurrentWindow() != null && active.getCurrentWindow().isFileOpen(file2)) {
                wndToOpenIn = active.getCurrentWindow();
            } else {
                for (EditorsSplitters splitters : all) {
                    EditorWindow window = splitters.getCurrentWindow();
                    if (window == null || !window.isFileOpen(file2)) continue;
                    wndToOpenIn = window;
                    break;
                }
            }
        } else {
            wndToOpenIn = this.getSplitters().getCurrentWindow();
        }
        if (!(wndToOpenIn != null && wndToOpenIn.isFileOpen(file2) || (previewResult = PreviewManager.SERVICE.preview(this.myProject, FilePreviewPanelProvider.ID, file2, focusEditor)) == null)) {
            Pair<FileEditor[], FileEditorProvider[]> pair = previewResult;
            if (pair == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(29);
            }
            return pair;
        }
        EditorsSplitters splitters = this.getSplitters();
        if (wndToOpenIn == null) {
            wndToOpenIn = splitters.getOrCreateCurrentWindow(file2);
        }
        this.openAssociatedFile(file2, wndToOpenIn, splitters);
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl2(wndToOpenIn, file2, focusEditor);
        if (pair == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(30);
        }
        return pair;
    }

    public Pair<FileEditor[], FileEditorProvider[]> openFileInNewWindow(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(31);
        }
        return ((DockManagerImpl)DockManager.getInstance(this.getProject())).createNewDockContainerFor(file2, this);
    }

    private static boolean isOpenInNewWindow() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent && ((MouseEvent)event).getModifiersEx() == 64 && (event.getID() == 500 || event.getID() == 501 || event.getID() == 502)) {
            return true;
        }
        if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            Keymap keymap2 = KeymapManager.getInstance().getActiveKeymap();
            String[] ids = keymap2.getActionIds(KeyStroke.getKeyStroke(ke.getKeyCode(), ke.getModifiers()));
            return Arrays.asList(ids).contains("OpenElementInNewWindow");
        }
        return false;
    }

    private void openAssociatedFile(VirtualFile file2, EditorWindow wndToOpenIn, @NotNull EditorsSplitters splitters) {
        if (splitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(32);
        }
        EditorWindow[] windows = splitters.getWindows();
        if (file2 != null && windows.length == 2) {
            for (FileEditorAssociateFinder finder : FileEditorAssociateFinder.EP_NAME.getExtensionList()) {
                VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, file2);
                if (associatedFile == null) continue;
                EditorWindow currentWindow = splitters.getCurrentWindow();
                int idx = windows[0] == wndToOpenIn ? 1 : 0;
                this.openFileImpl2(windows[idx], associatedFile, false);
                if (currentWindow == null) break;
                splitters.setCurrentWindow(currentWindow, false);
                break;
            }
        }
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(33);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(34);
        }
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl2(window, file2, focusEditor);
        if (pair == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(35);
        }
        return pair;
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileImpl2(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(36);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(37);
        }
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(window, file2, focusEditor, null)), "", null);
        Pair pair = (Pair)result2.get();
        if (pair == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(38);
        }
        return pair;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor, @Nullable HistoryEntry entry) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(39);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(40);
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl4(window, file2, entry, new FileEditorOpenOptions().withCurrentTab(true).withFocusEditor(focusEditor));
        if (pair == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(41);
        }
        return pair;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl4(@NotNull EditorWindow window, @NotNull VirtualFile file2, @Nullable HistoryEntry entry, FileEditorOpenOptions options) {
        AsyncFileEditorProvider.Builder[] builders;
        FileEditorProvider[] newProviders;
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(42);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(43);
        }
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "must not open files under read action since we are doing a lot of invokeAndWaits here";
        Ref compositeRef = new Ref();
        if (!options.isReopeningEditorsOnStartup()) {
            UIUtil.invokeAndWaitIfNeeded(() -> compositeRef.set(window.findFileComposite(file2)));
        }
        if (compositeRef.isNull()) {
            newProviders = FileEditorProviderManager.getInstance().getProviders(this.myProject, file2);
            if (newProviders.length == 0) {
                Pair<FileEditor[], FileEditorProvider[]> pair = Pair.create(EMPTY_EDITOR_ARRAY, EMPTY_PROVIDER_ARRAY);
                if (pair == null) {
                    FileEditorManagerImpl.$$$reportNull$$$0(44);
                }
                return pair;
            }
            builders = new AsyncFileEditorProvider.Builder[newProviders.length];
            for (int i = 0; i < newProviders.length; ++i) {
                try {
                    FileEditorProvider provider = newProviders[i];
                    LOG.assertTrue(provider != null, "Provider for file " + file2 + " is null. All providers: " + Arrays.asList(newProviders));
                    builders[i] = ReadAction.compute(() -> {
                        if (this.myProject.isDisposed() || !file2.isValid()) {
                            return null;
                        }
                        LOG.assertTrue(provider.accept(this.myProject, file2), "Provider " + provider + " doesn't accept file " + file2);
                        return provider instanceof AsyncFileEditorProvider ? ((AsyncFileEditorProvider)provider).createEditorAsync(this.myProject, file2) : null;
                    });
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (AssertionError | Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        } else {
            newProviders = null;
            builders = null;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> this.runBulkTabChange(window.getOwner(), splitters -> this.openFileImpl4Edt(window, file2, entry, options, compositeRef, newProviders, builders)));
        EditorWithProviderComposite composite = (EditorWithProviderComposite)compositeRef.get();
        Pair<FileEditor[], FileEditorProvider[]> pair = Pair.create(composite == null ? EMPTY_EDITOR_ARRAY : composite.getEditors(), composite == null ? EMPTY_PROVIDER_ARRAY : composite.getProviders());
        if (pair == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(45);
        }
        return pair;
    }

    private void openFileImpl4Edt(@NotNull EditorWindow window, @NotNull VirtualFile file2, @Nullable HistoryEntry entry, FileEditorOpenOptions options, Ref<EditorWithProviderComposite> compositeRef, FileEditorProvider[] newProviders, AsyncFileEditorProvider.Builder[] builders) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(46);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(47);
        }
        if (this.myProject.isDisposed() || !file2.isValid()) {
            return;
        }
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        compositeRef.set(window.findFileComposite(file2));
        boolean newEditor = compositeRef.isNull();
        if (newEditor) {
            this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER).beforeFileOpened(this, file2);
            FileEditor[] newEditors = new FileEditor[newProviders.length];
            for (int i = 0; i < newProviders.length; ++i) {
                try {
                    FileEditorProvider provider = newProviders[i];
                    FileEditor editor = builders[i] == null ? provider.createEditor(this.myProject, file2) : builders[i].build();
                    LOG.assertTrue(editor.isValid(), "Invalid editor created by provider " + (provider == null ? null : provider.getClass().getName()));
                    newEditors[i] = editor;
                    editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
                    editor.putUserData(DUMB_AWARE, DumbService.isDumbAware(provider));
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (AssertionError | Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            EditorWithProviderComposite composite = this.createComposite(file2, newEditors, newProviders);
            if (composite == null) {
                return;
            }
            if (options.getIndex() >= 0) {
                composite.getFile().putUserData(EditorWindow.INITIAL_INDEX_KEY, options.getIndex());
            }
            compositeRef.set(composite);
            this.myOpenedEditors.add(composite);
        }
        EditorWithProviderComposite composite = compositeRef.get();
        FileEditor[] editors = composite.getEditors();
        FileEditorProvider[] providers = composite.getProviders();
        window.setEditor(composite, options.isCurrentTab(), options.isFocusEditor());
        for (int i = 0; i < editors.length; ++i) {
            this.restoreEditorState(file2, providers[i], editors[i], entry, newEditor, options.isExactState());
        }
        FileEditorProvider selectedProvider = entry == null ? ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).getSelectedFileEditorProvider(EditorHistoryManager.getInstance(this.myProject), file2, providers) : entry.getSelectedProvider();
        if (selectedProvider != null) {
            for (int i = editors.length - 1; i >= 0; --i) {
                FileEditorProvider provider = providers[i];
                if (!provider.equals(selectedProvider)) continue;
                composite.setSelectedEditor(i);
                break;
            }
        }
        window.getOwner().setCurrentWindow(window, options.isFocusEditor());
        window.getOwner().afterFileOpen(file2);
        this.addSelectionRecord(file2, window);
        composite.getSelectedEditor().selectNotify();
        if (!ApplicationManager.getApplication().isUnitTestMode() && options.isFocusEditor()) {
            window.setAsCurrentWindow(true);
            Window windowAncestor = SwingUtilities.getWindowAncestor(window.myPanel);
            if (windowAncestor != null && windowAncestor.equals(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
                EditorsSplitters.focusDefaultComponentInSplittersIfPresent(this.myProject);
                IdeFocusManager.getInstance(this.myProject).toFront(window.getOwner());
            }
        }
        if (newEditor) {
            ourOpenFilesSetModificationCount.incrementAndGet();
        }
        ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(this.myProject)).onSelectionChanged();
        this.updateFileName(file2);
        IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
        if (options.getPin() != null) {
            window.setFilePinned(file2, options.getPin());
        }
        if (newEditor) {
            this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER).fileOpenedSync(this, file2, Pair.pair(editors, providers));
            this.notifyPublisher(() -> {
                if (this.isFileOpen(file2)) {
                    this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER).fileOpened(this, file2);
                }
            });
        }
    }

    @Nullable
    private EditorWithProviderComposite createComposite(@NotNull VirtualFile file2, FileEditor @NotNull [] editors, FileEditorProvider @NotNull [] providers) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(48);
        }
        if (editors == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(49);
        }
        if (providers == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(50);
        }
        if (ArrayUtil.contains(null, editors) || ArrayUtil.contains(null, providers)) {
            ArrayList<FileEditor> editorList = new ArrayList<FileEditor>(editors.length);
            ArrayList<FileEditorProvider> providerList = new ArrayList<FileEditorProvider>(providers.length);
            for (int i = 0; i < editors.length; ++i) {
                FileEditor editor = editors[i];
                FileEditorProvider provider = providers[i];
                if (editor == null || provider == null) continue;
                editorList.add(editor);
                providerList.add(provider);
            }
            if (editorList.isEmpty()) {
                return null;
            }
            editors = editorList.toArray(new FileEditor[0]);
            providers = providerList.toArray(new FileEditorProvider[0]);
        }
        return new EditorWithProviderComposite(file2, editors, providers, this);
    }

    private void restoreEditorState(@NotNull VirtualFile file2, @NotNull FileEditorProvider provider, @NotNull FileEditor editor, HistoryEntry entry, boolean newEditor, boolean exactState) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(51);
        }
        if (provider == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(52);
        }
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(53);
        }
        FileEditorState state = null;
        if (entry != null) {
            state = entry.getState(provider);
        }
        if (state == null && newEditor) {
            state = EditorHistoryManager.getInstance(this.myProject).getState(file2, provider);
        }
        if (state != null) {
            if (!FileEditorManagerImpl.isDumbAware(editor)) {
                FileEditorState finalState = state;
                DumbService.getInstance(this.getProject()).runWhenSmart(() -> editor.setState(finalState, exactState));
            } else {
                editor.setState(state, exactState);
            }
        }
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(54);
        }
        final IdeFocusManager focusManager = IdeFocusManager.getInstance(this.myProject);
        final ActionCallback done = new ActionCallback();
        ActionCallback actionCallback = this.myBusyObject.execute(new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                focusManager.doWhenFocusSettlesDown(ExpirableRunnable.forProject(FileEditorManagerImpl.this.myProject, () -> {
                    runnable2.run();
                    done.setDone();
                }), ModalityState.current());
                ActionCallback actionCallback = done;
                if (actionCallback == null) {
                    6.$$$reportNull$$$0(0);
                }
                return actionCallback;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$6", "run"));
            }
        });
        if (actionCallback == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(55);
        }
        return actionCallback;
    }

    @Override
    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(56);
        }
        if (fileEditorProviderId == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(57);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file2);
        if (composite == null) {
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            if (composites.isEmpty()) {
                return;
            }
            composite = composites.get(0);
        }
        FileEditorProvider[] editorProviders = composite.getProviders();
        FileEditorProvider selectedProvider = composite.getSelectedWithProvider().getProvider();
        for (int i = 0; i < editorProviders.length; ++i) {
            if (!editorProviders[i].getEditorTypeId().equals(fileEditorProviderId) || selectedProvider.equals(editorProviders[i])) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
        }
    }

    @Nullable
    EditorWithProviderComposite newEditorComposite(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        FileEditorProvider[] providers = editorProviderManager.getProviders(this.myProject, file2);
        if (providers.length == 0) {
            return null;
        }
        FileEditor[] editors = new FileEditor[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            FileEditor editor;
            FileEditorProvider provider = providers[i];
            LOG.assertTrue(provider != null);
            LOG.assertTrue(provider.accept(this.myProject, file2));
            editors[i] = editor = provider.createEditor(this.myProject, file2);
            LOG.assertTrue(editor.isValid());
            editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
        }
        EditorWithProviderComposite newComposite = new EditorWithProviderComposite(file2, editors, providers, this);
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance(this.myProject);
        for (int i = 0; i < editors.length; ++i) {
            FileEditor editor = editors[i];
            FileEditorProvider provider = providers[i];
            FileEditorState state = editorHistoryManager.getState(file2, provider);
            if (state == null) continue;
            editor.setState(state);
        }
        return newComposite;
    }

    @Override
    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(58);
        }
        List list2 = (List)this.openEditorImpl((OpenFileDescriptor)descriptor2, (boolean)focusEditor).first;
        if (list2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(59);
        }
        return list2;
    }

    private Pair<List<FileEditor>, FileEditor> openEditorImpl(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        OpenFileDescriptor realDescriptor;
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(60);
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (descriptor2.getFile() instanceof VirtualFileWindow) {
            VirtualFileWindow delegate = (VirtualFileWindow)((Object)descriptor2.getFile());
            int hostOffset = delegate.getDocumentWindow().injectedToHost(descriptor2.getOffset());
            realDescriptor = new OpenFileDescriptor(descriptor2.getProject(), delegate.getDelegate(), hostOffset);
            realDescriptor.setUseCurrentWindow(descriptor2.isUseCurrentWindow());
        } else {
            realDescriptor = descriptor2;
        }
        SmartList result2 = new SmartList();
        Ref selectedEditor = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            VirtualFile file2 = realDescriptor.getFile();
            FileEditor[] editors = this.openFile(file2, focusEditor, !realDescriptor.isUseCurrentWindow());
            ContainerUtil.addAll(result2, editors);
            boolean navigated = false;
            for (FileEditor editor : editors) {
                if (!(editor instanceof NavigatableFileEditor) || this.getSelectedEditor(realDescriptor.getFile()) != editor || !(navigated = this.navigateAndSelectEditor((NavigatableFileEditor)editor, realDescriptor))) continue;
                selectedEditor.set(editor);
                break;
            }
            if (!navigated) {
                for (FileEditor editor : editors) {
                    if (!(editor instanceof NavigatableFileEditor) || this.getSelectedEditor(realDescriptor.getFile()) == editor || !this.navigateAndSelectEditor((NavigatableFileEditor)editor, realDescriptor)) continue;
                    selectedEditor.set(editor);
                    break;
                }
            }
        }, "", null);
        return Pair.create(result2, selectedEditor.get());
    }

    private boolean navigateAndSelectEditor(@NotNull NavigatableFileEditor editor, @NotNull OpenFileDescriptor descriptor2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(61);
        }
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(62);
        }
        if (editor.canNavigateTo(descriptor2)) {
            this.setSelectedEditor(editor);
            editor.navigateTo(descriptor2);
            return true;
        }
        return false;
    }

    private void setSelectedEditor(@NotNull FileEditor editor) {
        EditorWithProviderComposite composite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(63);
        }
        if ((composite = this.getEditorComposite(editor)) == null) {
            return;
        }
        FileEditor[] editors = composite.getEditors();
        for (int i = 0; i < editors.length; ++i) {
            FileEditor each = editors[i];
            if (editor != each) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
            break;
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(64);
        }
        return project2;
    }

    @Override
    @Nullable
    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        TextEditor textEditor;
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(65);
        }
        return (textEditor = this.doOpenTextEditor(descriptor2, focusEditor)) == null ? null : textEditor.getEditor();
    }

    @Nullable
    private TextEditor doOpenTextEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        TextEditor target2;
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(66);
        }
        Pair<List<FileEditor>, FileEditor> editorsWithSelected = this.openEditorImpl(descriptor2, focusEditor);
        Collection fileEditors = (Collection)editorsWithSelected.first;
        FileEditor selectedEditor = (FileEditor)editorsWithSelected.second;
        if (fileEditors.isEmpty()) {
            return null;
        }
        if (fileEditors.size() == 1) {
            return ObjectUtils.tryCast(ContainerUtil.getFirstItem(fileEditors), TextEditor.class);
        }
        List<TextEditor> textEditors = ContainerUtil.mapNotNull(fileEditors, e -> ObjectUtils.tryCast(e, TextEditor.class));
        if (textEditors.isEmpty()) {
            return null;
        }
        TextEditor textEditor = target2 = selectedEditor instanceof TextEditor ? (TextEditor)selectedEditor : textEditors.get(0);
        if (textEditors.size() > 1) {
            EditorWithProviderComposite composite = this.getEditorComposite(target2);
            assert (composite != null);
            FileEditor[] editors = composite.getEditors();
            FileEditorProvider[] providers = composite.getProviders();
            String textProviderId = TextEditorProvider.getInstance().getEditorTypeId();
            for (int i = 0; i < editors.length; ++i) {
                FileEditor editor = editors[i];
                if (!(editor instanceof TextEditor) || !providers[i].getEditorTypeId().equals(textProviderId)) continue;
                target2 = (TextEditor)editor;
                break;
            }
        }
        this.setSelectedEditor(target2);
        return target2;
    }

    @Override
    public Editor getSelectedTextEditor() {
        return this.getSelectedTextEditor(false);
    }

    public Editor getSelectedTextEditor(boolean lockfree) {
        EditorWithProviderComposite selectedEditor;
        EditorWindow currentWindow;
        if (!lockfree) {
            FileEditorManagerImpl.assertDispatchThread();
        }
        EditorWindow editorWindow = currentWindow = lockfree ? this.getMainSplitters().getCurrentWindow() : this.getSplitters().getCurrentWindow();
        if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && selectedEditor.getSelectedEditor() instanceof TextEditor) {
            return ((TextEditor)selectedEditor.getSelectedEditor()).getEditor();
        }
        return null;
    }

    @Override
    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(67);
        }
        for (EditorComposite editor : this.myOpenedEditors) {
            if (!editor.getFile().equals(file2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public VirtualFile @NotNull [] getOpenFiles() {
        LinkedHashSet<VirtualFile> files2 = new LinkedHashSet<VirtualFile>();
        for (EditorComposite composite : this.myOpenedEditors) {
            files2.add(composite.getFile());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files2);
        if (virtualFileArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(68);
        }
        return virtualFileArray;
    }

    @Override
    public boolean hasOpenFiles() {
        return !this.myOpenedEditors.isEmpty();
    }

    @Override
    public VirtualFile @NotNull [] getSelectedFiles() {
        LinkedHashSet selectedFiles = new LinkedHashSet();
        EditorsSplitters activeSplitters = this.getSplitters();
        ContainerUtil.addAll(selectedFiles, activeSplitters.getSelectedFiles());
        for (EditorsSplitters each : this.getAllSplitters()) {
            if (each == activeSplitters) continue;
            ContainerUtil.addAll(selectedFiles, each.getSelectedFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(selectedFiles);
        if (virtualFileArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(69);
        }
        return virtualFileArray;
    }

    @Override
    public FileEditor @NotNull [] getSelectedEditors() {
        LinkedHashSet selectedEditors = new LinkedHashSet();
        for (EditorsSplitters each : this.getAllSplitters()) {
            ContainerUtil.addAll(selectedEditors, each.getSelectedEditors());
        }
        FileEditor[] fileEditorArray = selectedEditors.toArray(new FileEditor[0]);
        if (fileEditorArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(70);
        }
        return fileEditorArray;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        EditorsSplitters active = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            active = this.getActiveSplittersSync();
        }
        EditorsSplitters editorsSplitters = active == null ? this.getMainSplitters() : active;
        if (editorsSplitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(71);
        }
        return editorsSplitters;
    }

    @Override
    @Nullable
    public FileEditor getSelectedEditor() {
        EditorWithProviderComposite selected2;
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (selected2 = window.getSelectedEditor()) != null) {
            return selected2.getSelectedEditor();
        }
        return super.getSelectedEditor();
    }

    @Override
    @Nullable
    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        FileEditorWithProvider editorWithProvider;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(72);
        }
        return (editorWithProvider = this.getSelectedEditorWithProvider(file2)) == null ? null : editorWithProvider.getFileEditor();
    }

    @Override
    @Nullable
    public FileEditorWithProvider getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(73);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2 = BackedVirtualFile.getOriginFileIfBacked(file2))) != null) {
            return composite.getSelectedWithProvider();
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        return composites.isEmpty() ? null : composites.get(0).getSelectedWithProvider();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(74);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file2);
        if (composite != null) {
            Pair<FileEditor[], FileEditorProvider[]> pair = Pair.create(composite.getEditors(), composite.getProviders());
            if (pair == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(75);
            }
            return pair;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            Pair<FileEditor[], FileEditorProvider[]> pair = Pair.create(composites.get(0).getEditors(), composites.get(0).getProviders());
            if (pair == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(76);
            }
            return pair;
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = Pair.create(EMPTY_EDITOR_ARRAY, EMPTY_PROVIDER_ARRAY);
        if (pair == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(77);
        }
        return pair;
    }

    @Override
    public FileEditor @NotNull [] getEditors(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(78);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2 = BackedVirtualFile.getOriginFileIfBacked(file2))) != null) {
            FileEditor[] fileEditorArray = composite.getEditors();
            if (fileEditorArray == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(79);
            }
            return fileEditorArray;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            FileEditor[] fileEditorArray = composites.get(0).getEditors();
            if (fileEditorArray == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(80);
            }
            return fileEditorArray;
        }
        if (EMPTY_EDITOR_ARRAY == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(81);
        }
        return EMPTY_EDITOR_ARRAY;
    }

    @Override
    public FileEditor @NotNull [] getAllEditors(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(82);
        }
        ArrayList result2 = new ArrayList();
        this.myOpenedEditors.forEach(composite -> {
            if (composite.getFile().equals(file2)) {
                ContainerUtil.addAll(result2, composite.myEditors);
            }
        });
        FileEditor[] fileEditorArray = result2.toArray(new FileEditor[0]);
        if (fileEditorArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(83);
        }
        return fileEditorArray;
    }

    @Nullable
    private EditorWithProviderComposite getCurrentEditorWithProviderComposite(@NotNull VirtualFile virtualFile2) {
        EditorWindow editorWindow;
        if (virtualFile2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(84);
        }
        if ((editorWindow = this.getSplitters().getCurrentWindow()) != null) {
            return editorWindow.findFileComposite(virtualFile2);
        }
        return null;
    }

    @NotNull
    private List<EditorWithProviderComposite> getEditorComposites(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(85);
        }
        ArrayList<EditorWithProviderComposite> result2 = new ArrayList<EditorWithProviderComposite>();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            result2.addAll(each.findEditorComposites(file2));
        }
        ArrayList<EditorWithProviderComposite> arrayList = result2;
        if (arrayList == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(86);
        }
        return arrayList;
    }

    @Override
    public FileEditor @NotNull [] getAllEditors() {
        ArrayList result2 = new ArrayList();
        this.myOpenedEditors.forEach(composite -> ContainerUtil.addAll(result2, composite.myEditors));
        FileEditor[] fileEditorArray = result2.toArray(new FileEditor[0]);
        if (fileEditorArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(87);
        }
        return fileEditorArray;
    }

    @NotNull
    public List<JComponent> getTopComponents(@NotNull FileEditor editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(88);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        List<JComponent> list2 = composite != null ? composite.getTopComponents(editor) : Collections.emptyList();
        if (list2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(89);
        }
        return list2;
    }

    @Override
    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(90);
        }
        if (component2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(91);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addTopComponent(editor, component2);
        }
    }

    @Override
    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(92);
        }
        if (component2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(93);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeTopComponent(editor, component2);
        }
    }

    @Override
    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(94);
        }
        if (component2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(95);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addBottomComponent(editor, component2);
        }
    }

    @Override
    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(96);
        }
        if (component2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(97);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeBottomComponent(editor, component2);
        }
    }

    @Override
    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(98);
        }
        this.myListenerList.add(listener2);
    }

    @Override
    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(99);
        }
        if (parentDisposable == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(100);
        }
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, listener2);
    }

    @Override
    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(101);
        }
        this.myListenerList.remove(listener2);
    }

    protected void projectOpened(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(102);
        }
        this.getMainSplitters().startListeningFocus();
        FileStatusManager fileStatusManager = FileStatusManager.getInstance(this.myProject);
        if (fileStatusManager != null) {
            fileStatusManager.addFileStatusListener(new MyFileStatusListener(), this.myProject);
        }
        connection.subscribe(FileTypeManager.TOPIC, new MyFileTypeListener());
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, new MyRootsListener());
        connection.subscribe(VirtualFileManager.VFS_CHANGES, new MyVirtualFileListener());
        connection.subscribe(UISettingsListener.TOPIC, new MyUISettingsListener());
        StartupManager.getInstance(this.myProject).registerPostStartupDumbAwareActivity(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().invokeLater(() -> {
                Long startTime = this.myProject.getUserData(ProjectImpl.CREATION_TIME);
                if (startTime != null) {
                    long time = TimeoutUtil.getDurationMillis(startTime);
                    LifecycleUsageTriggerCollector.onProjectOpenFinished(this.myProject, time);
                    LOG.info("Project opening took " + time + " ms");
                }
            }, this.myProject.getDisposed()), "", null), this.myProject.getDisposed());
        });
    }

    @Override
    @Nullable
    public Element getState() {
        if (this.mySplitters == null) {
            return null;
        }
        Element state = new Element("state");
        this.getMainSplitters().writeExternal(state);
        return state;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(103);
        }
        this.getMainSplitters().readExternal(state);
    }

    @Nullable
    private EditorWithProviderComposite getEditorComposite(@NotNull FileEditor editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(104);
        }
        for (EditorsSplitters splitters : this.getAllSplitters()) {
            List<EditorWithProviderComposite> editorsComposites = splitters.getEditorComposites();
            for (int i = editorsComposites.size() - 1; i >= 0; --i) {
                EditorWithProviderComposite composite = editorsComposites.get(i);
                FileEditor[] editors = composite.getEditors();
                for (int j = editors.length - 1; j >= 0; --j) {
                    FileEditor _editor = editors[j];
                    LOG.assertTrue(_editor != null);
                    if (!editor.equals(_editor)) continue;
                    return composite;
                }
            }
        }
        return null;
    }

    private static void assertDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    public void fireSelectionChanged(@Nullable EditorComposite newSelectedComposite) {
        boolean editorsEqual;
        boolean filesEqual;
        Trinity<VirtualFile, FileEditor, FileEditorProvider> oldData = FileEditorManagerImpl.extract(SoftReference.dereference(this.myLastSelectedComposite));
        Trinity<VirtualFile, FileEditor, FileEditorProvider> newData = FileEditorManagerImpl.extract(newSelectedComposite);
        WeakReference<EditorComposite> weakReference = this.myLastSelectedComposite = newSelectedComposite == null ? null : new WeakReference<EditorComposite>(newSelectedComposite);
        boolean bl = oldData.first == null ? newData.first == null : (filesEqual = ((VirtualFile)oldData.first).equals(newData.first));
        boolean bl2 = oldData.second == null ? newData.second == null : (editorsEqual = ((FileEditor)oldData.second).equals(newData.second));
        if (!filesEqual || !editorsEqual) {
            JComponent component2;
            EditorWindowHolder holder;
            if (oldData.first != null && newData.first != null) {
                for (FileEditorAssociateFinder finder : FileEditorAssociateFinder.EP_NAME.getExtensionList()) {
                    VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, (VirtualFile)oldData.first);
                    if (!Comparing.equal(associatedFile, newData.first)) continue;
                    return;
                }
            }
            FileEditorManagerEvent event = new FileEditorManagerEvent(this, (VirtualFile)oldData.first, (FileEditor)oldData.second, (FileEditorProvider)oldData.third, (VirtualFile)newData.first, (FileEditor)newData.second, (FileEditorProvider)newData.third);
            FileEditorManagerListener publisher = this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
            if (newData.first != null && (holder = ComponentUtil.getParentOfType(EditorWindowHolder.class, component2 = ((FileEditor)newData.second).getComponent())) != null) {
                this.addSelectionRecord((VirtualFile)newData.first, holder.getEditorWindow());
            }
            this.notifyPublisher(() -> publisher.selectionChanged(event));
        }
    }

    @NotNull
    private static Trinity<VirtualFile, FileEditor, FileEditorProvider> extract(@Nullable EditorComposite composite) {
        FileEditorProvider provider;
        FileEditor editor;
        VirtualFile file2;
        if (composite == null) {
            file2 = null;
            editor = null;
            provider = null;
        } else {
            file2 = composite.getFile();
            FileEditorWithProvider pair = composite.getSelectedWithProvider();
            editor = pair.getFileEditor();
            provider = pair.getProvider();
        }
        return new Trinity<VirtualFile, FileEditor, FileEditorProvider>(file2, editor, provider);
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        FileStatusManager fileStatusManager;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(105);
        }
        if ((fileStatusManager = FileStatusManager.getInstance(this.myProject)) == null) {
            return false;
        }
        FileStatus status = fileStatusManager.getStatus(editor.getFile());
        return status != FileStatus.UNKNOWN && status != FileStatus.NOT_CHANGED;
    }

    void disposeComposite(@NotNull EditorWithProviderComposite editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(106);
        }
        this.myOpenedEditors.remove(editor);
        if (this.getAllEditors().length == 0) {
            this.setCurrentWindow(null);
        }
        if (editor.equals(this.getLastSelected())) {
            editor.getSelectedEditor().deselectNotify();
            this.getSplitters().setCurrentWindow(null, false);
        }
        FileEditor[] editors = editor.getEditors();
        FileEditorProvider[] providers = editor.getProviders();
        FileEditor selectedEditor = editor.getSelectedEditor();
        for (int i = editors.length - 1; i >= 0; --i) {
            FileEditor editor1 = editors[i];
            FileEditorProvider provider = providers[i];
            if (!editor.equals(selectedEditor) && selectedEditor.equals(editor1)) {
                editor1.deselectNotify();
            }
            editor1.removePropertyChangeListener(this.myEditorPropertyChangeListener);
            provider.disposeEditor(editor1);
        }
        Disposer.dispose(editor);
    }

    @Nullable
    private EditorComposite getLastSelected() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            return currentWindow.getSelectedEditor();
        }
        return null;
    }

    void runChange(@NotNull FileEditorManagerChange change, @Nullable EditorsSplitters splitters) {
        if (change == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(107);
        }
        HashSet<EditorsSplitters> target2 = new HashSet<EditorsSplitters>();
        if (splitters == null) {
            target2.addAll(this.getAllSplitters());
        } else {
            target2.add(splitters);
        }
        for (EditorsSplitters each : target2) {
            this.runBulkTabChange(each, change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBulkTabChange(@NotNull EditorsSplitters splitters, @NotNull FileEditorManagerChange change) {
        if (splitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(108);
        }
        if (change == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(109);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            change.run(splitters);
        } else {
            ++splitters.myInsideChange;
            try {
                change.run(splitters);
            }
            finally {
                --splitters.myInsideChange;
                if (!splitters.isInsideChange()) {
                    splitters.validate();
                    for (EditorWindow window : splitters.getWindows()) {
                        ((JBTabsImpl)window.getTabbedPane().getTabs()).revalidateAndRepaint();
                    }
                }
            }
        }
    }

    @Override
    public boolean isInsideChange() {
        return this.getSplitters().isInsideChange();
    }

    @Override
    public void closeAllFiles() {
        this.runBulkTabChange(this.getSplitters(), splitters -> {
            for (VirtualFile openFile2 : splitters.getOpenFileList()) {
                this.closeFile(openFile2);
            }
        });
    }

    @Override
    public VirtualFile @NotNull [] getSiblings(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(110);
        }
        VirtualFile[] virtualFileArray = this.getOpenFiles();
        if (virtualFileArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(111);
        }
        return virtualFileArray;
    }

    void queueUpdateFile(final @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(112);
        }
        this.myQueue.queue(new Update((Object)file2){

            @Override
            public void run() {
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileColor(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                }
            }
        });
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        EditorsSplitters splitters = null;
        DockContainer dockContainer = this.myDockManager.getContainerFor(c);
        if (dockContainer instanceof DockableEditorTabbedContainer) {
            splitters = ((DockableEditorTabbedContainer)dockContainer).getSplitters();
        }
        if (splitters == null) {
            splitters = this.getMainSplitters();
        }
        return splitters;
    }

    @NotNull
    public List<Pair<VirtualFile, EditorWindow>> getSelectionHistory() {
        ArrayList<Pair<Object, EditorWindow>> copy2 = new ArrayList<Pair<Object, EditorWindow>>();
        for (Pair<VirtualFile, EditorWindow> pair : this.mySelectionHistory) {
            if (((EditorWindow)pair.second).getFiles().length == 0) {
                Pair p;
                EditorWindow[] windows = ((EditorWindow)pair.second).getOwner().getWindows();
                if (windows.length <= 0 || windows[0] == null || windows[0].getFiles().length <= 0 || copy2.contains(p = Pair.create(pair.first, windows[0]))) continue;
                copy2.add(p);
                continue;
            }
            if (copy2.contains(pair)) continue;
            copy2.add(pair);
        }
        this.mySelectionHistory.clear();
        this.mySelectionHistory.addAll(copy2);
        List<Pair<VirtualFile, EditorWindow>> list2 = this.mySelectionHistory;
        if (list2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(113);
        }
        return list2;
    }

    public void addSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(114);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(115);
        }
        Pair<VirtualFile, EditorWindow> record = Pair.create(file2, window);
        this.mySelectionHistory.remove(record);
        this.mySelectionHistory.add(0, record);
    }

    void removeSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(116);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(117);
        }
        this.mySelectionHistory.remove(Pair.create(file2, window));
        this.updateFileName(file2);
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(118);
        }
        ActionCallback actionCallback = this.myBusyObject.getReady(requestor);
        if (actionCallback == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(119);
        }
        return actionCallback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 55: 
            case 59: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 87: 
            case 89: 
            case 111: 
            case 113: 
            case 119: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 55: 
            case 59: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 87: 
            case 89: 
            case 111: 
            case 113: 
            case 119: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 15: 
            case 53: 
            case 61: 
            case 63: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 104: 
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 55: 
            case 59: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 87: 
            case 89: 
            case 111: 
            case 113: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 33: 
            case 37: 
            case 40: 
            case 43: 
            case 47: 
            case 48: 
            case 51: 
            case 56: 
            case 67: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 82: 
            case 85: 
            case 110: 
            case 112: 
            case 114: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 34: 
            case 36: 
            case 39: 
            case 42: 
            case 46: 
            case 115: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 32: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitters";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorProviderId";
                break;
            }
            case 58: 
            case 60: 
            case 62: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 91: 
            case 93: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 98: 
            case 99: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSplitters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSplittersAsync";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initUI";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTooltipText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindows";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileWithProviders";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl2";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl3";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl4";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyPublisher";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditor";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitters";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsWithProviders";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 83: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditors";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComposites";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopComponents";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblings";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionHistory";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDumbAware";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 55: 
            case 59: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 87: 
            case 89: 
            case 111: 
            case 113: 
            case 119: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileColor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isProblem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileTooltipText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateFilePresentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateFileColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateFileBackgroundColor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateFileIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNextWindow";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPrevWindow";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "closeFileImpl";
                break;
            }
            case 27: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "openFileWithProviders";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "openFileInNewWindow";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "openAssociatedFile";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl2";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl3";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl4";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl4Edt";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "restoreEditorState";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "notifyPublisher";
                break;
            }
            case 56: 
            case 57: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedEditor";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "openEditorImpl";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "navigateAndSelectEditor";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "openTextEditor";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "doOpenTextEditor";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditor";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditorWithProvider";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsWithProviders";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getAllEditors";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentEditorWithProviderComposite";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getEditorComposites";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getTopComponents";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "addTopComponent";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "removeTopComponent";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addBottomComponent";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "removeBottomComponent";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "addFileEditorManagerListener";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "removeFileEditorManagerListener";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "projectOpened";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getEditorComposite";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "disposeComposite";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "runChange";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "runBulkTabChange";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getSiblings";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdateFile";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionRecord";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionRecord";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 55: 
            case 59: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 87: 
            case 89: 
            case 111: 
            case 113: 
            case 119: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        @Override
        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            if (uiSettings == null) {
                MyUISettingsListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            FileEditorManagerImpl.this.mySplitters.revalidate();
            for (EditorsSplitters each : FileEditorManagerImpl.this.getAllSplitters()) {
                each.setTabsPlacement(uiSettings.getEditorTabPlacement());
                each.trimToSize();
                if (JBTabsImpl.NEW_TABS) {
                    TabsLayoutInfo tabsLayoutInfo = TabsLayoutSettingsManager.getInstance().getSelectedTabsLayoutInfo();
                    each.updateTabsLayout(tabsLayoutInfo);
                    continue;
                }
                if (uiSettings.getScrollTabLayoutInEditor()) {
                    each.setTabLayoutPolicy(1);
                    continue;
                }
                each.setTabLayoutPolicy(0);
            }
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                FileEditorManagerImpl.this.updateFileIcon(file2);
                FileEditorManagerImpl.this.updateFileName(file2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
            }
            FileEditorManagerImpl.this.updateFrameTitle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyUISettingsListener", "uiSettingsChanged"));
        }
    }

    private class MyRootsListener
    implements ModuleRootListener {
        private MyRootsListener() {
        }

        @Override
        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyRootsListener.$$$reportNull$$$0(0);
            }
            List allEditors = StreamEx.of((Object[])FileEditorManagerImpl.this.getWindows()).flatArray(EditorWindow::getEditors).toList();
            ReadAction.nonBlocking(() -> this.calcEditorReplacements(allEditors)).inSmartMode(FileEditorManagerImpl.this.myProject).finishOnUiThread(ModalityState.defaultModalityState(), this::replaceEditors).coalesceBy(this).submit(AppExecutorUtil.getAppExecutorService());
        }

        private Map<EditorWithProviderComposite, Pair<VirtualFile, Integer>> calcEditorReplacements(List<EditorWithProviderComposite> allEditors) {
            List<EditorFileSwapper> swappers = EditorFileSwapper.EP_NAME.getExtensionList();
            return StreamEx.of(allEditors).mapToEntry(editor -> {
                if (editor.getFile().isValid()) {
                    for (EditorFileSwapper each : swappers) {
                        Pair<VirtualFile, Integer> fileAndOffset = each.getFileToSwapTo(FileEditorManagerImpl.this.myProject, (EditorWithProviderComposite)editor);
                        if (fileAndOffset == null) continue;
                        return fileAndOffset;
                    }
                }
                return null;
            }).nonNullValues().toMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceEditors(Map<EditorWithProviderComposite, Pair<VirtualFile, Integer>> replacements) {
            if (replacements.isEmpty()) {
                return;
            }
            for (EditorWindow eachWindow : FileEditorManagerImpl.this.getWindows()) {
                EditorWithProviderComposite selected2 = eachWindow.getSelectedEditor();
                EditorWithProviderComposite[] editors = eachWindow.getEditors();
                for (int i = 0; i < editors.length; ++i) {
                    VirtualFile newFile;
                    Pair<VirtualFile, Integer> newFilePair;
                    EditorWithProviderComposite editor = editors[i];
                    VirtualFile file2 = editor.getFile();
                    if (!file2.isValid() || (newFilePair = replacements.get(editor)) == null || (newFile = (VirtualFile)newFilePair.first) == null || eachWindow.findFileIndex(newFile) != -1) continue;
                    try {
                        TextEditorImpl openedEditor;
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, i);
                        Pair<FileEditor[], FileEditorProvider[]> pair = FileEditorManagerImpl.this.openFileImpl2(eachWindow, newFile, editor == selected2);
                        if (newFilePair.second != null && (openedEditor = EditorFileSwapper.findSinglePsiAwareEditor((FileEditor[])pair.first)) != null) {
                            openedEditor.getEditor().getCaretModel().moveToOffset((Integer)newFilePair.second);
                            openedEditor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                        }
                    }
                    finally {
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, null);
                    }
                    FileEditorManagerImpl.this.closeFile(file2, eachWindow);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyRootsListener", "rootsChanged"));
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        @Override
        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            if (event == null) {
                MyFileTypeListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                LOG.assertTrue(file2 != null);
                FileEditorManagerImpl.this.updateFileIcon(file2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileTypeListener", "fileTypesChanged"));
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        @Override
        public void fileStatusesChanged() {
            FileEditorManagerImpl.assertDispatchThread();
            LOG.debug("FileEditorManagerImpl.MyFileStatusListener.fileStatusesChanged()");
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                LOG.assertTrue(file2 != null);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("updating file status in tab for " + file2.getPath());
                    }
                    this.updateFileStatus(file2);
                }, ModalityState.NON_MODAL, FileEditorManagerImpl.this.myProject.getDisposed());
            }
        }

        @Override
        public void fileStatusChanged(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyFileStatusListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                this.updateFileStatus(file2);
            }
        }

        private void updateFileStatus(VirtualFile file2) {
            FileEditorManagerImpl.this.updateFileColor(file2);
            FileEditorManagerImpl.this.updateFileIcon(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileStatusListener", "fileStatusChanged"));
        }
    }

    private final class MyEditorPropertyChangeListener
    implements PropertyChangeListener {
        private MyEditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent e) {
            boolean valid;
            if (e == null) {
                MyEditorPropertyChangeListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            String propertyName = e.getPropertyName();
            if ("modified".equals(propertyName)) {
                FileEditor editor = (FileEditor)e.getSource();
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.updateFileIcon(composite.getFile());
                }
            } else if ("valid".equals(propertyName) && !(valid = ((Boolean)e.getNewValue()).booleanValue())) {
                FileEditor editor = (FileEditor)e.getSource();
                LOG.assertTrue(editor != null);
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.closeFile(composite.getFile());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyEditorPropertyChangeListener", "propertyChange"));
        }
    }

    private final class MyVirtualFileListener
    implements BulkFileListener {
        private MyVirtualFileListener() {
        }

        @Override
        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                this.beforeFileDeletion((VFileDeleteEvent)vFileEvent);
            }
        }

        @Override
        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    this.propertyChanged((VFilePropertyChangeEvent)vFileEvent);
                    continue;
                }
                if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                this.fileMoved((VFileMoveEvent)vFileEvent);
            }
        }

        private void beforeFileDeletion(@NotNull VFileDeleteEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(2);
            }
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file2 = event.getFile();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                if (!VfsUtilCore.isAncestor(file2, openFiles[i], false)) continue;
                FileEditorManagerImpl.this.closeFile(openFiles[i], true, true);
            }
        }

        private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(3);
            }
            if ("name".equals(event.getPropertyName())) {
                FileEditorManagerImpl.assertDispatchThread();
                VirtualFile file2 = event.getFile();
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileName(file2);
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                }
            } else if ("writable".equals(event.getPropertyName()) || "encoding".equals(event.getPropertyName())) {
                this.updateIcon(event);
            }
        }

        private void updateIcon(@NotNull VFilePropertyChangeEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(4);
            }
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file2 = event.getFile();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                FileEditorManagerImpl.this.updateFileIcon(file2);
            }
        }

        private void fileMoved(@NotNull VFileMoveEvent e) {
            if (e == null) {
                MyVirtualFileListener.$$$reportNull$$$0(5);
            }
            VirtualFile file2 = e.getFile();
            for (VirtualFile openFile2 : FileEditorManagerImpl.this.getOpenFiles()) {
                if (!VfsUtilCore.isAncestor(file2, openFile2, false)) continue;
                FileEditorManagerImpl.this.updateFileName(openFile2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(openFile2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "before";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateIcon";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

