/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InconsistentLineSeparatorsInspection
extends LocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InconsistentLineSeparatorsInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            @Override
            public void visitFile(@NotNull PsiFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file2.getLanguage().equals(file2.getViewProvider().getBaseLanguage())) {
                    return;
                }
                VirtualFile virtualFile2 = file2.getVirtualFile();
                if (virtualFile2 == null || !AbstractConvertLineSeparatorsAction.shouldProcess(virtualFile2)) {
                    return;
                }
                Project project2 = holder.getProject();
                String projectLineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project2);
                Set<String> allLineSeparators = LoadTextUtil.detectAllLineSeparators(virtualFile2);
                if (allLineSeparators.size() > 1 || !allLineSeparators.isEmpty() && !allLineSeparators.contains(projectLineSeparator)) {
                    ArrayList<String> allSorted = new ArrayList<String>(allLineSeparators);
                    Collections.sort(allSorted);
                    String presentableSeparators = StringUtil.join(allSorted, sep -> StringUtil.escapeStringCharacters(sep), ", ");
                    holder.registerProblem((PsiElement)file2, "Line separators in the current file (" + presentableSeparators + ") differ from the project defaults (" + StringUtil.escapeStringCharacters(projectLineSeparator) + ")", new ChangeLineSeparatorFix());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection$1", "visitFile"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection", "buildVisitor"));
    }

    private static class ChangeLineSeparatorFix
    implements LocalQuickFix {
        private ChangeLineSeparatorFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return "Convert to project line separators";
        }

        @Override
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement;
            if (project2 == null) {
                ChangeLineSeparatorFix.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                ChangeLineSeparatorFix.$$$reportNull$$$0(1);
            }
            if (!((psiElement = descriptor2.getPsiElement()) instanceof PsiFile)) {
                return;
            }
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project2);
            VirtualFile virtualFile2 = ((PsiFile)psiElement).getVirtualFile();
            if (virtualFile2 != null) {
                AbstractConvertLineSeparatorsAction.changeLineSeparators(project2, virtualFile2, lineSeparator);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection$ChangeLineSeparatorFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

