/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance(LoadTextUtil.class);
    private static final int UNLIMITED = -1;
    private static final Charset INTERNAL_SEVEN_BIT_UTF8 = new SevenBitCharset(StandardCharsets.UTF_8);
    private static final Charset INTERNAL_SEVEN_BIT_ISO_8859_1 = new SevenBitCharset(CharsetToolkit.ISO_8859_1_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_WIN_1251 = new SevenBitCharset(CharsetToolkit.WIN_1251_CHARSET);
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<AutoDetectionReason> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create("CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(@NotNull CharBuffer buffer) {
        if (buffer == null) {
            LoadTextUtil.$$$reportNull$$$0(0);
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        CharBuffer result2 = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        return new ConvertResult(result2, crCount, lfCount, crlfCount);
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(byte @NotNull [] charsAsBytes, int startOffset, int endOffset) {
        int crIndex;
        if (charsAsBytes == null) {
            LoadTextUtil.$$$reportNull$$$0(1);
        }
        if ((crIndex = LoadTextUtil.indexOf(charsAsBytes, (byte)13, startOffset, endOffset)) == -1) {
            ByteArrayCharSequence sequence = new ByteArrayCharSequence(charsAsBytes, startOffset, endOffset);
            int lfIndex = LoadTextUtil.indexOf(charsAsBytes, (byte)10, startOffset, endOffset);
            return new ConvertResult(sequence, 0, lfIndex == -1 ? 0 : 1, 0);
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        byte[] result2 = new byte[endOffset - startOffset];
        for (int src = startOffset; src < endOffset; ++src) {
            char c = (char)charsAsBytes[src];
            switch (c) {
                case '\r': {
                    result2[dst++] = 10;
                    ++crCount;
                    break;
                }
                case '\n': {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    result2[dst++] = 10;
                    ++lfCount;
                    break;
                }
                default: {
                    result2[dst++] = (byte)c;
                }
            }
            prev = c;
        }
        ByteArrayCharSequence sequence = new ByteArrayCharSequence(result2, 0, dst);
        return new ConvertResult(sequence, crCount, lfCount, crlfCount);
    }

    private static int indexOf(byte[] ints, byte value2, int start2, int end) {
        for (int i = start2; i < end; ++i) {
            if (ints[i] != value2) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private static DetectResult detectHardCharset(@NotNull VirtualFile virtualFile2, byte @NotNull [] content2, int length, @NotNull FileType fileType) {
        Charset hardCodedCharset;
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            LoadTextUtil.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            LoadTextUtil.$$$reportNull$$$0(4);
        }
        String charsetName = fileType.getCharset(virtualFile2, content2);
        DetectResult guessed = LoadTextUtil.guessFromContent(virtualFile2, content2, length);
        Charset charset = hardCodedCharset = charsetName == null ? guessed.hardCodedCharset : CharsetToolkit.forName(charsetName);
        if (hardCodedCharset == null && guessed.guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            return new DetectResult(StandardCharsets.UTF_8, guessed.guessed, guessed.BOM);
        }
        return new DetectResult(hardCodedCharset, guessed.guessed, guessed.BOM);
    }

    @NotNull
    public static Charset detectCharsetAndSetBOM(@NotNull VirtualFile virtualFile2, byte @NotNull [] content2, @NotNull FileType fileType) {
        Charset internalCharset;
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            LoadTextUtil.$$$reportNull$$$0(6);
        }
        if (content2 == null) {
            LoadTextUtil.$$$reportNull$$$0(7);
        }
        Charset charset = (internalCharset = LoadTextUtil.detectInternalCharsetAndSetBOM((VirtualFile)virtualFile2, (byte[])content2, (int)content2.length, (boolean)true, (FileType)fileType).hardCodedCharset) instanceof SevenBitCharset ? ((SevenBitCharset)internalCharset).myBaseCharset : internalCharset;
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(8);
        }
        return charset;
    }

    @NotNull
    private static Charset getDefaultCharsetFromEncodingManager(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(9);
        }
        Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile2, true);
        Charset charset = ObjectUtils.notNull(specifiedExplicitly, EncodingRegistry.getInstance().getDefaultCharset());
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(10);
        }
        return charset;
    }

    @NotNull
    private static DetectResult detectInternalCharsetAndSetBOM(@NotNull VirtualFile file2, byte @NotNull [] content2, int length, boolean saveBOM, @NotNull FileType fileType) {
        if (file2 == null) {
            LoadTextUtil.$$$reportNull$$$0(11);
        }
        if (fileType == null) {
            LoadTextUtil.$$$reportNull$$$0(12);
        }
        if (content2 == null) {
            LoadTextUtil.$$$reportNull$$$0(13);
        }
        DetectResult info = LoadTextUtil.detectHardCharset(file2, content2, length, fileType);
        Charset charset = info.hardCodedCharset == null ? (file2.isCharsetSet() ? file2.getCharset() : LoadTextUtil.getDefaultCharsetFromEncodingManager(file2)) : info.hardCodedCharset;
        byte[] bom = info.BOM;
        if (saveBOM && bom != null && bom.length != 0) {
            file2.setBOM(bom);
            LoadTextUtil.setCharsetAutoDetectionReason(file2, AutoDetectionReason.FROM_BOM);
        }
        file2.setCharset(charset);
        Charset result2 = charset;
        if (info.guessed == CharsetToolkit.GuessedEncoding.SEVEN_BIT) {
            if (charset == StandardCharsets.UTF_8) {
                result2 = INTERNAL_SEVEN_BIT_UTF8;
            } else if (charset == CharsetToolkit.ISO_8859_1_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_ISO_8859_1;
            } else if (charset == CharsetToolkit.WIN_1251_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_WIN_1251;
            }
        }
        return new DetectResult(result2, info.guessed, bom);
    }

    @NotNull
    public static DetectResult guessFromContent(@NotNull VirtualFile virtualFile2, byte @NotNull [] content2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(14);
        }
        if (content2 == null) {
            LoadTextUtil.$$$reportNull$$$0(15);
        }
        return LoadTextUtil.guessFromContent(virtualFile2, content2, content2.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static DetectResult guessFromContent(@NotNull VirtualFile virtualFile2, byte @NotNull [] content2, int length) {
        DetectResult detectResult;
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(16);
        }
        if (content2 == null) {
            LoadTextUtil.$$$reportNull$$$0(17);
        }
        AutoDetectionReason detectedFromBytes = null;
        try {
            DetectResult info;
            if (GUESS_UTF) {
                info = LoadTextUtil.guessFromBytes(content2, 0, length, LoadTextUtil.getDefaultCharsetFromEncodingManager(virtualFile2));
                if (info.BOM != null) {
                    detectedFromBytes = AutoDetectionReason.FROM_BOM;
                } else if (info.guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                    detectedFromBytes = AutoDetectionReason.FROM_BYTES;
                }
            } else {
                info = new DetectResult(null, null, null);
            }
            detectResult = info;
        }
        catch (Throwable throwable) {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile2, detectedFromBytes);
            throw throwable;
        }
        LoadTextUtil.setCharsetAutoDetectionReason(virtualFile2, detectedFromBytes);
        DetectResult detectResult2 = detectResult;
        if (detectResult2 == null) {
            LoadTextUtil.$$$reportNull$$$0(18);
        }
        return detectResult2;
    }

    @NotNull
    private static DetectResult guessFromBytes(byte @NotNull [] content2, int startOffset, int endOffset, @NotNull Charset defaultCharset) {
        if (defaultCharset == null) {
            LoadTextUtil.$$$reportNull$$$0(19);
        }
        if (content2 == null) {
            LoadTextUtil.$$$reportNull$$$0(20);
        }
        CharsetToolkit toolkit = new CharsetToolkit(content2, defaultCharset);
        toolkit.setEnforce8Bit(true);
        Charset charset = toolkit.guessFromBOM();
        if (charset != null) {
            byte[] bom = ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(charset), CharsetToolkit.UTF8_BOM);
            return new DetectResult(charset, null, bom);
        }
        CharsetToolkit.GuessedEncoding guessed = toolkit.guessFromContent(startOffset, endOffset);
        if (guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            return new DetectResult(StandardCharsets.UTF_8, CharsetToolkit.GuessedEncoding.VALID_UTF8, null);
        }
        return new DetectResult(null, guessed, null);
    }

    public static String getTextFromBytesOrNull(byte @NotNull [] bytes, int startOffset, int endOffset) {
        Charset charset;
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(21);
        }
        Charset defaultCharset = EncodingManager.getInstance().getDefaultCharset();
        DetectResult info = LoadTextUtil.guessFromBytes(bytes, startOffset, endOffset, defaultCharset);
        if (info.hardCodedCharset != null) {
            charset = info.hardCodedCharset;
        } else {
            switch (info.guessed) {
                case SEVEN_BIT: {
                    charset = CharsetToolkit.US_ASCII_CHARSET;
                    break;
                }
                case VALID_UTF8: {
                    charset = StandardCharsets.UTF_8;
                    break;
                }
                case INVALID_UTF8: 
                case BINARY: {
                    return null;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)info.guessed));
                }
            }
        }
        byte[] bom = info.BOM;
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(startOffset + (bom == null ? 0 : bom.length), endOffset), endOffset, charset);
        return result2.text.toString();
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> getOverriddenCharsetByBOM(byte @NotNull [] content2, @NotNull Charset charset) {
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(22);
        }
        if (content2 == null) {
            LoadTextUtil.$$$reportNull$$$0(23);
        }
        if (charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom(content2)) {
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(charset, CharsetToolkit.UTF8_BOM);
            if (nonNull == null) {
                LoadTextUtil.$$$reportNull$$$0(24);
            }
            return nonNull;
        }
        Charset charsetFromBOM = CharsetToolkit.guessFromBOM(content2);
        if (charsetFromBOM != null) {
            byte[] bom = ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(charsetFromBOM), ArrayUtilRt.EMPTY_BYTE_ARRAY);
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(charsetFromBOM, bom);
            if (nonNull == null) {
                LoadTextUtil.$$$reportNull$$$0(25);
            }
            return nonNull;
        }
        Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(charset, ArrayUtilRt.EMPTY_BYTE_ARRAY);
        if (nonNull == null) {
            LoadTextUtil.$$$reportNull$$$0(26);
        }
        return nonNull;
    }

    public static void changeLineSeparators(@Nullable Project project2, @NotNull VirtualFile file2, @NotNull String newSeparator, @NotNull Object requestor) throws IOException {
        if (file2 == null) {
            LoadTextUtil.$$$reportNull$$$0(27);
        }
        if (newSeparator == null) {
            LoadTextUtil.$$$reportNull$$$0(28);
        }
        if (requestor == null) {
            LoadTextUtil.$$$reportNull$$$0(29);
        }
        CharSequence currentText = LoadTextUtil.getTextByBinaryPresentation(file2.contentsToByteArray(), file2, true, false);
        String newText = StringUtil.convertLineSeparators(currentText.toString(), newSeparator);
        file2.setDetectedLineSeparator(newSeparator);
        LoadTextUtil.write(project2, file2, requestor, newText, -1L);
    }

    public static void write(@Nullable Project project2, @NotNull VirtualFile virtualFile2, @NotNull Object requestor, @NotNull String text2, long newModificationStamp) throws IOException {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(30);
        }
        if (requestor == null) {
            LoadTextUtil.$$$reportNull$$$0(31);
        }
        if (text2 == null) {
            LoadTextUtil.$$$reportNull$$$0(32);
        }
        Charset existing = virtualFile2.getCharset();
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project2, virtualFile2, text2, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (!charset.equals(existing)) {
            virtualFile2.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile2, buffer);
        virtualFile2.setBinaryContent(buffer, newModificationStamp, -1L, requestor);
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> charsetForWriting(@Nullable Project project2, @NotNull VirtualFile virtualFile2, @NotNull String text2, @NotNull Charset existing) {
        Charset fromBom;
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(33);
        }
        if (text2 == null) {
            LoadTextUtil.$$$reportNull$$$0(34);
        }
        if (existing == null) {
            LoadTextUtil.$$$reportNull$$$0(35);
        }
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project2, virtualFile2, text2);
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text2);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile2.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM(bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.createNonNull(fromBom, text2.getBytes(fromBom));
        }
        Pair.NonNull<Charset, byte[]> nonNull = chosen;
        if (nonNull == null) {
            LoadTextUtil.$$$reportNull$$$0(36);
        }
        return nonNull;
    }

    private static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile2, byte @NotNull [] content2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(37);
        }
        if (content2 == null) {
            LoadTextUtil.$$$reportNull$$$0(38);
        }
        if (virtualFile2.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile2, content2);
        } else {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile2, AutoDetectionReason.FROM_BOM);
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> chooseMostlyHarmlessCharset(@NotNull Charset existing, @NotNull Charset specified, @NotNull String text2) {
        block15: {
            byte[] out;
            block14: {
                block13: {
                    Pair.NonNull<Charset, byte[]> nonNull;
                    if (existing == null) {
                        LoadTextUtil.$$$reportNull$$$0(39);
                    }
                    if (specified == null) {
                        LoadTextUtil.$$$reportNull$$$0(40);
                    }
                    if (text2 == null) {
                        LoadTextUtil.$$$reportNull$$$0(41);
                    }
                    try {
                        if (!specified.equals(existing)) break block13;
                        nonNull = Pair.createNonNull(specified, text2.getBytes(existing));
                    }
                    catch (RuntimeException e) {
                        Charset defaultCharset = Charset.defaultCharset();
                        Pair.NonNull<Charset, byte[]> nonNull2 = Pair.createNonNull(defaultCharset, text2.getBytes(defaultCharset));
                        if (nonNull2 == null) {
                            LoadTextUtil.$$$reportNull$$$0(46);
                        }
                        return nonNull2;
                    }
                    if (nonNull == null) {
                        LoadTextUtil.$$$reportNull$$$0(42);
                    }
                    return nonNull;
                }
                out = LoadTextUtil.isSupported(specified, text2);
                if (out == null) break block14;
                Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, out);
                if (nonNull == null) {
                    LoadTextUtil.$$$reportNull$$$0(43);
                }
                return nonNull;
            }
            out = LoadTextUtil.isSupported(existing, text2);
            if (out == null) break block15;
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(existing, out);
            if (nonNull == null) {
                LoadTextUtil.$$$reportNull$$$0(44);
            }
            return nonNull;
        }
        Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, text2.getBytes(specified));
        if (nonNull == null) {
            LoadTextUtil.$$$reportNull$$$0(45);
        }
        return nonNull;
    }

    private static byte @Nullable(value="null means not supported, otherwise it is converted byte stream") [] isSupported(@NotNull Charset charset, @NotNull String str) {
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(47);
        }
        if (str == null) {
            LoadTextUtil.$$$reportNull$$$0(48);
        }
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Charset extractCharsetFromFileContent(@Nullable Project project2, @NotNull VirtualFile virtualFile2, @NotNull CharSequence text2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(49);
        }
        if (text2 == null) {
            LoadTextUtil.$$$reportNull$$$0(50);
        }
        Charset charset = ObjectUtils.notNull(LoadTextUtil.charsetFromContentOrNull(project2, virtualFile2, text2), virtualFile2.getCharset());
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(51);
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static @Nullable(value="returns null if cannot determine from content") Charset charsetFromContentOrNull(@Nullable Project project2, @NotNull VirtualFile virtualFile2, @NotNull CharSequence text2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(52);
        }
        if (text2 == null) {
            LoadTextUtil.$$$reportNull$$$0(53);
        }
        return CharsetUtil.extractCharsetFromFileContent(project2, virtualFile2, virtualFile2.getFileType(), text2);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2) {
        FileType type;
        if (file2 == null) {
            LoadTextUtil.$$$reportNull$$$0(54);
        }
        if ((type = file2.getFileType()).isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.getInstance().forFileType(type);
            if (decompiler != null) {
                CharSequence text2 = decompiler.decompile(file2);
                try {
                    StringUtil.assertValidSeparators(text2);
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
                CharSequence charSequence = text2;
                if (charSequence == null) {
                    LoadTextUtil.$$$reportNull$$$0(55);
                }
                return charSequence;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file2.getPresentableUrl() + ". File type: " + type.getName());
        }
        return LoadTextUtil.loadText(file2, -1);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2, int limit) {
        FileType type;
        if (file2 == null) {
            LoadTextUtil.$$$reportNull$$$0(56);
        }
        if ((type = file2.getFileType()).isBinary()) {
            throw new IllegalArgumentException("Attempt to load truncated text for binary file: " + file2.getPresentableUrl() + ". File type: " + type.getName());
        }
        if (file2 instanceof LightVirtualFile) {
            return LoadTextUtil.limitCharSequence(((LightVirtualFile)file2).getContent(), limit);
        }
        if (file2.isDirectory()) {
            throw new AssertionError((Object)("'" + file2.getPresentableUrl() + "' is a directory"));
        }
        try {
            byte[] bytes = limit == -1 ? file2.contentsToByteArray() : FileUtil.loadFirstAndClose(file2.getInputStream(), limit);
            return LoadTextUtil.getTextByBinaryPresentation(bytes, file2);
        }
        catch (IOException e) {
            CharSequence charSequence = ArrayUtil.EMPTY_CHAR_SEQUENCE;
            if (charSequence == null) {
                LoadTextUtil.$$$reportNull$$$0(57);
            }
            return charSequence;
        }
    }

    @NotNull
    private static CharSequence limitCharSequence(@NotNull CharSequence sequence, int limit) {
        if (sequence == null) {
            LoadTextUtil.$$$reportNull$$$0(58);
        }
        CharSequence charSequence = limit == -1 ? sequence : sequence.subSequence(0, Math.min(limit, sequence.length()));
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(59);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(byte @NotNull [] bytes, @NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(60);
        }
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(61);
        }
        return LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile2, true, true);
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(byte @NotNull [] bytes, @NotNull VirtualFile virtualFile2, boolean saveDetectedSeparators, boolean saveBOM) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(62);
        }
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(63);
        }
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile2, bytes, bytes.length, saveBOM, virtualFile2.getFileType());
        byte[] bom = info.BOM;
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(bom == null ? 0 : bom.length, bytes.length), bytes.length, info.hardCodedCharset);
        if (saveDetectedSeparators) {
            virtualFile2.setDetectedLineSeparator(result2.majorLineSeparator());
        }
        CharSequence charSequence = result2.text;
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(64);
        }
        return charSequence;
    }

    @NotNull
    static Set<String> detectAllLineSeparators(@NotNull VirtualFile virtualFile2) {
        byte[] bytes;
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(65);
        }
        try {
            bytes = virtualFile2.contentsToByteArray();
        }
        catch (IOException e) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                LoadTextUtil.$$$reportNull$$$0(66);
            }
            return set;
        }
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile2, bytes, bytes.length, false, virtualFile2.getFileType());
        byte[] bom = info.BOM;
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(bom == null ? 0 : bom.length, bytes.length), bytes.length, info.hardCodedCharset);
        Set<String> set = result2.allLineSeparators();
        if (set == null) {
            LoadTextUtil.$$$reportNull$$$0(67);
        }
        return set;
    }

    @NotNull
    public static FileType processTextFromBinaryPresentationOrNull(byte @NotNull [] bytes, int length, @NotNull VirtualFile virtualFile2, boolean saveDetectedSeparators, boolean saveBOM, @NotNull FileType fileType, @NotNull NotNullFunction<? super CharSequence, ? extends FileType> fileTextProcessor) {
        CharSequence toProcess2;
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(68);
        }
        if (fileType == null) {
            LoadTextUtil.$$$reportNull$$$0(69);
        }
        if (fileTextProcessor == null) {
            LoadTextUtil.$$$reportNull$$$0(70);
        }
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(71);
        }
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile2, bytes, length, saveBOM, fileType);
        Charset internalCharset = info.hardCodedCharset;
        CharsetToolkit.GuessedEncoding guessed = info.guessed;
        if (internalCharset == null || guessed == CharsetToolkit.GuessedEncoding.BINARY || guessed == CharsetToolkit.GuessedEncoding.INVALID_UTF8) {
            toProcess2 = null;
        } else {
            byte[] bom = info.BOM;
            int BOMEndOffset = Math.min(length, bom == null ? 0 : bom.length);
            ConvertResult result2 = LoadTextUtil.convertBytes(bytes, BOMEndOffset, length, internalCharset);
            if (saveDetectedSeparators) {
                virtualFile2.setDetectedLineSeparator(result2.majorLineSeparator());
            }
            toProcess2 = result2.text;
        }
        FileType fileType2 = fileTextProcessor.fun(toProcess2);
        if (fileType2 == null) {
            LoadTextUtil.$$$reportNull$$$0(72);
        }
        return fileType2;
    }

    @Nullable
    public static String detectLineSeparator(@NotNull VirtualFile file2, boolean checkFile) {
        String lineSeparator;
        if (file2 == null) {
            LoadTextUtil.$$$reportNull$$$0(73);
        }
        if ((lineSeparator = file2.getDetectedLineSeparator()) == null && checkFile) {
            try {
                LoadTextUtil.getTextByBinaryPresentation(file2.contentsToByteArray(), file2);
                lineSeparator = file2.getDetectedLineSeparator();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lineSeparator;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(byte @NotNull [] bytes, @NotNull Charset charset) {
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(74);
        }
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(75);
        }
        Pair.NonNull<Charset, byte[]> pair = LoadTextUtil.getOverriddenCharsetByBOM(bytes, charset);
        byte[] bom = (byte[])pair.getSecond();
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(bom.length, bytes.length), bytes.length, (Charset)pair.first);
        CharSequence charSequence = result2.text;
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(76);
        }
        return charSequence;
    }

    @NotNull
    private static ConvertResult convertBytes(byte @NotNull [] bytes, int startOffset, int endOffset, @NotNull Charset internalCharset) {
        CharBuffer charBuffer;
        if (internalCharset == null) {
            LoadTextUtil.$$$reportNull$$$0(77);
        }
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(78);
        }
        assert (startOffset >= 0 && startOffset <= endOffset && endOffset <= bytes.length) : startOffset + "," + endOffset + ": " + bytes.length;
        if (internalCharset instanceof SevenBitCharset || internalCharset == CharsetToolkit.US_ASCII_CHARSET) {
            return LoadTextUtil.convertLineSeparatorsToSlashN(bytes, startOffset, endOffset);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, endOffset - startOffset);
        try {
            charBuffer = internalCharset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtilRt.EMPTY_CHAR_ARRAY);
        }
        return LoadTextUtil.convertLineSeparatorsToSlashN(charBuffer);
    }

    @Nullable(value="null if was not detected, otherwise the reason it was")
    public static @Nullable(value="null if was not detected, otherwise the reason it was") AutoDetectionReason getCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(79);
        }
        return virtualFile2.getUserData(CHARSET_WAS_DETECTED_FROM_BYTES);
    }

    private static void setCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile2, @Nullable(value="null if was not detected, otherwise the reason it was") @Nullable(value="null if was not detected, otherwise the reason it was") AutoDetectionReason reason) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(80);
        }
        virtualFile2.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, reason);
    }

    public static void clearCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(81);
        }
        virtualFile2.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 55: 
            case 57: 
            case 59: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 55: 
            case 57: 
            case 59: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsAsBytes";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: 
            case 16: 
            case 30: 
            case 33: 
            case 37: 
            case 49: 
            case 52: 
            case 60: 
            case 62: 
            case 65: 
            case 68: 
            case 79: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 55: 
            case 57: 
            case 59: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/LoadTextUtil";
                break;
            }
            case 11: 
            case 27: 
            case 54: 
            case 56: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 21: 
            case 61: 
            case 63: 
            case 71: 
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 22: 
            case 47: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 32: 
            case 34: 
            case 41: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specified";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTextProcessor";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/LoadTextUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "detectCharsetAndSetBOM";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharsetFromEncodingManager";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFromContent";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenCharsetByBOM";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "charsetForWriting";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseMostlyHarmlessCharset";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCharsetFromFileContent";
                break;
            }
            case 55: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "limitCharSequence";
                break;
            }
            case 64: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextByBinaryPresentation";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllLineSeparators";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "processTextFromBinaryPresentationOrNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparatorsToSlashN";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectHardCharset";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectCharsetAndSetBOM";
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 55: 
            case 57: 
            case 59: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 76: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCharsetFromEncodingManager";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "detectInternalCharsetAndSetBOM";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "guessFromContent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "guessFromBytes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromBytesOrNull";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenCharsetByBOM";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "changeLineSeparators";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "charsetForWriting";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setDetectedFromBytesFlagBack";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "chooseMostlyHarmlessCharset";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "charsetFromContentOrNull";
                break;
            }
            case 54: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "limitCharSequence";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getTextByBinaryPresentation";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "detectAllLineSeparators";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processTextFromBinaryPresentationOrNull";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "detectLineSeparator";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "convertBytes";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getCharsetAutoDetectionReason";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetAutoDetectionReason";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "clearCharsetAutoDetectionReason";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 55: 
            case 57: 
            case 59: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertResult {
        @NotNull
        private final CharSequence text;
        private final int CR_count;
        private final int LF_count;
        private final int CRLF_count;

        ConvertResult(@NotNull CharSequence text2, int CR_count, int LF_count, int CRLF_count) {
            if (text2 == null) {
                ConvertResult.$$$reportNull$$$0(0);
            }
            this.text = text2;
            this.CR_count = CR_count;
            this.LF_count = LF_count;
            this.CRLF_count = CRLF_count;
        }

        String majorLineSeparator() {
            String detectedLineSeparator = null;
            if (this.CRLF_count > this.CR_count && this.CRLF_count > this.LF_count) {
                detectedLineSeparator = "\r\n";
            } else if (this.CR_count > this.LF_count) {
                detectedLineSeparator = "\r";
            } else if (this.LF_count > 0) {
                detectedLineSeparator = "\n";
            }
            return detectedLineSeparator;
        }

        @NotNull
        Set<String> allLineSeparators() {
            THashSet<String> result2 = new THashSet<String>();
            if (this.CR_count > 0) {
                result2.add(LineSeparator.CR.getSeparatorString());
            }
            if (this.LF_count > 0) {
                result2.add(LineSeparator.LF.getSeparatorString());
            }
            if (this.CRLF_count > 0) {
                result2.add(LineSeparator.CRLF.getSeparatorString());
            }
            THashSet<String> tHashSet = result2;
            if (tHashSet == null) {
                ConvertResult.$$$reportNull$$$0(1);
            }
            return tHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/LoadTextUtil$ConvertResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/LoadTextUtil$ConvertResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allLineSeparators";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DetectResult {
        public final Charset hardCodedCharset;
        public final CharsetToolkit.GuessedEncoding guessed;
        public final byte @Nullable [] BOM;

        DetectResult(Charset hardCodedCharset, CharsetToolkit.GuessedEncoding guessed, byte @Nullable [] BOM) {
            this.hardCodedCharset = hardCodedCharset;
            this.guessed = guessed;
            this.BOM = BOM;
        }
    }

    private static class SevenBitCharset
    extends Charset {
        private final Charset myBaseCharset;

        SevenBitCharset(@NotNull Charset baseCharset) {
            if (baseCharset == null) {
                SevenBitCharset.$$$reportNull$$$0(0);
            }
            super("IJ__7BIT_" + baseCharset.name(), ArrayUtilRt.EMPTY_STRING_ARRAY);
            this.myBaseCharset = baseCharset;
        }

        @Override
        public boolean contains(Charset cs) {
            throw new IllegalStateException();
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new IllegalStateException();
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new IllegalStateException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseCharset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil$SevenBitCharset", "<init>"));
        }
    }

    public static enum AutoDetectionReason {
        FROM_BOM,
        FROM_BYTES;

    }
}

