/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.ui.UIBundle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

class MemoryDiskConflictResolver {
    private static final Logger LOG = Logger.getInstance(MemoryDiskConflictResolver.class);
    private final Set<VirtualFile> myConflicts = new LinkedHashSet<VirtualFile>();
    private Throwable myConflictAppeared;

    MemoryDiskConflictResolver() {
    }

    void beforeContentChange(@NotNull VFileContentChangeEvent event) {
        long oldFileStamp;
        if (event == null) {
            MemoryDiskConflictResolver.$$$reportNull$$$0(0);
        }
        if (event.isFromSave()) {
            return;
        }
        VirtualFile file2 = event.getFile();
        if (!file2.isValid() || this.hasConflict(file2)) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (document == null || !FileDocumentManager.getInstance().isDocumentUnsaved(document)) {
            return;
        }
        long documentStamp = document.getModificationStamp();
        if (documentStamp != (oldFileStamp = event.getOldModificationStamp())) {
            LOG.info("reload " + file2.getName() + " from disk?");
            LOG.info("  documentStamp:" + documentStamp);
            LOG.info("  oldFileStamp:" + oldFileStamp);
            if (this.myConflicts.isEmpty()) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this.myConflictAppeared = new Throwable();
                }
                ApplicationManager.getApplication().invokeLater(this::processConflicts);
            }
            this.myConflicts.add(file2);
        }
    }

    boolean hasConflict(VirtualFile file2) {
        return this.myConflicts.contains(file2);
    }

    private void processConflicts() {
        ArrayList<VirtualFile> conflicts = new ArrayList<VirtualFile>(this.myConflicts);
        this.myConflicts.clear();
        for (VirtualFile file2 : conflicts) {
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document == null || file2.getModificationStamp() == document.getModificationStamp() || !this.askReloadFromDisk(file2, document)) continue;
            FileDocumentManager.getInstance().reloadFromDisk(document);
        }
        this.myConflictAppeared = null;
    }

    boolean askReloadFromDisk(final VirtualFile file2, final Document document) {
        if (this.myConflictAppeared != null) {
            Throwable trace = this.myConflictAppeared;
            this.myConflictAppeared = null;
            throw new IllegalStateException("Unexpected memory-disk conflict in tests for " + file2.getPath() + ", please use FileDocumentManager#reloadFromDisk or avoid VFS refresh", trace);
        }
        String message = UIBundle.message("file.cache.conflict.message.text", file2.getPresentableUrl());
        final DialogBuilder builder2 = new DialogBuilder();
        builder2.setCenterPanel(new JLabel(message, Messages.getQuestionIcon(), 0));
        builder2.addOkAction().setText(UIBundle.message("file.cache.conflict.load.fs.changes.button", new Object[0]));
        builder2.addCancelAction().setText(UIBundle.message("file.cache.conflict.keep.memory.changes.button", new Object[0]));
        builder2.addAction(new AbstractAction(UIBundle.message("file.cache.conflict.show.difference.button", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project2 = ProjectLocator.getInstance().guessProjectForFile(file2);
                String fsContent = LoadTextUtil.loadText(file2).toString();
                DocumentContent content1 = DiffContentFactory.getInstance().create(project2, fsContent, file2.getFileType());
                DocumentContent content2 = DiffContentFactory.getInstance().create(project2, document, file2);
                String title = UIBundle.message("file.cache.conflict.for.file.dialog.title", file2.getPresentableUrl());
                String title1 = UIBundle.message("file.cache.conflict.diff.content.file.system.content", new Object[0]);
                String title2 = UIBundle.message("file.cache.conflict.diff.content.memory.content", new Object[0]);
                SimpleDiffRequest request2 = new SimpleDiffRequest(title, content1, content2, title1, title2);
                request2.putUserData(DiffUserDataKeys.GO_TO_SOURCE_DISABLE, true);
                DialogBuilder diffBuilder = new DialogBuilder(project2);
                DiffRequestPanel diffPanel = DiffManager.getInstance().createRequestPanel(project2, diffBuilder, diffBuilder.getWindow());
                diffPanel.setRequest(request2);
                diffBuilder.setCenterPanel(diffPanel.getComponent());
                diffBuilder.setDimensionServiceKey("FileDocumentManager.FileCacheConflict");
                diffBuilder.addOkAction().setText(UIBundle.message("file.cache.conflict.save.changes.button", new Object[0]));
                diffBuilder.addCancelAction();
                diffBuilder.setTitle(title);
                if (diffBuilder.show() == 0) {
                    builder2.getDialogWrapper().close(1);
                }
            }
        });
        builder2.setTitle(UIBundle.message("file.cache.conflict.dialog.title", new Object[0]));
        builder2.setButtonsAlignment(0);
        builder2.setHelpId("reference.dialogs.fileCacheConflict");
        return builder2.show() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/MemoryDiskConflictResolver", "beforeContentChange"));
    }
}

