/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class OpenFilesActivity
implements StartupActivity {
    OpenFilesActivity() {
    }

    @Override
    public void runActivity(@NotNull Project project2) {
        FileEditorManager fileEditorManager;
        if (project2 == null) {
            OpenFilesActivity.$$$reportNull$$$0(0);
        }
        if (!((fileEditorManager = FileEditorManager.getInstance(project2)) instanceof FileEditorManagerImpl)) {
            return;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(IdeBundle.message("progress.text.reopening.files", new Object[0]));
        }
        FileEditorManagerImpl manager = (FileEditorManagerImpl)fileEditorManager;
        EditorsSplitters editorSplitters = manager.getMainSplitters();
        Ref<JPanel> panelRef = editorSplitters.restoreEditors();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (panelRef != null) {
                editorSplitters.doOpenFiles((JPanel)panelRef.get());
            }
            manager.initDockableContentFactory();
            if (!manager.hasOpenFiles()) {
                EditorsSplitters.stopOpenFilesActivity(project2);
                if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    if (Registry.is("ide.open.readme.md.on.startup")) {
                        RunOnceUtil.runOnceForProject(project2, "ShowReadmeOnStart", () -> OpenFilesActivity.findAndOpenReadme(project2, manager));
                    }
                    if (Registry.is("ide.open.project.view.on.startup")) {
                        RunOnceUtil.runOnceForProject(project2, "OpenProjectViewOnStart", () -> OpenFilesActivity.openProjectView(project2));
                    }
                }
            }
        }, project2.getDisposed());
    }

    private static void findAndOpenReadme(@NotNull Project project2, @NotNull FileEditorManagerImpl manager) {
        VirtualFile readme;
        VirtualFile dir;
        if (project2 == null) {
            OpenFilesActivity.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            OpenFilesActivity.$$$reportNull$$$0(2);
        }
        if ((dir = ProjectUtil.guessProjectDir(project2)) != null && (readme = dir.findChild("README.md")) != null && !readme.isDirectory()) {
            readme.putUserData(TextEditorWithPreview.DEFAULT_LAYOUT_FOR_FILE, TextEditorWithPreview.Layout.SHOW_PREVIEW);
            ApplicationManager.getApplication().invokeLater(() -> manager.openFile(readme, true), project2.getDisposed());
        }
    }

    private static void openProjectView(@NotNull Project project2) {
        if (project2 == null) {
            OpenFilesActivity.$$$reportNull$$$0(3);
        }
        ToolWindowManager manager = ToolWindowManager.getInstance(project2);
        manager.invokeLater(() -> {
            ToolWindow window;
            if (null == manager.getActiveToolWindowId() && (window = manager.getToolWindow("Project")) != null) {
                window.activate(null);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/OpenFilesActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndOpenReadme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "openProjectView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

