/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorImpl
extends UserDataHolderBase
implements TextEditor {
    private static final Logger LOG = Logger.getInstance(TextEditorImpl.class);
    private static final Key<TransientEditorState> TRANSIENT_EDITOR_STATE_KEY = Key.create("transientState");
    protected final Project myProject;
    private final PropertyChangeSupport myChangeSupport;
    @NotNull
    private final TextEditorComponent myComponent;
    @NotNull
    protected final VirtualFile myFile;
    private final AsyncEditorLoader myAsyncLoader;

    TextEditorImpl(@NotNull Project project2, @NotNull VirtualFile file2, TextEditorProvider provider) {
        if (project2 == null) {
            TextEditorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            TextEditorImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myFile = file2;
        this.myChangeSupport = new PropertyChangeSupport(this);
        this.myComponent = this.createEditorComponent(project2, file2);
        TransientEditorState state = this.myFile.getUserData(TRANSIENT_EDITOR_STATE_KEY);
        if (state != null) {
            state.applyTo(this.getEditor());
            this.myFile.putUserData(TRANSIENT_EDITOR_STATE_KEY, null);
        }
        Disposer.register(this, this.myComponent);
        this.myAsyncLoader = new AsyncEditorLoader(this, this.myComponent, provider);
        this.myAsyncLoader.start();
    }

    @NotNull
    protected Runnable loadEditorInBackground() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myFile, scheme, this.myProject);
        EditorEx editor = (EditorEx)this.getEditor();
        highlighter.setText(editor.getDocument().getImmutableCharSequence());
        Runnable runnable2 = () -> {
            editor.getSettings().setLanguageSupplier(() -> TextEditorImpl.getDocumentLanguage(editor));
            editor.setHighlighter(highlighter);
        };
        if (runnable2 == null) {
            TextEditorImpl.$$$reportNull$$$0(2);
        }
        return runnable2;
    }

    @Nullable
    public static Language getDocumentLanguage(@NotNull Editor editor) {
        Project project2;
        if (editor == null) {
            TextEditorImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((project2 = editor.getProject()) != null);
        if (!project2.isDisposed()) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
            PsiFile file2 = documentManager.getPsiFile(editor.getDocument());
            if (file2 != null) {
                return file2.getLanguage();
            }
        } else {
            LOG.warn("Attempting to get a language for document on a disposed project: " + project2.getName());
        }
        return null;
    }

    @NotNull
    protected TextEditorComponent createEditorComponent(Project project2, VirtualFile file2) {
        return new TextEditorComponent(project2, file2, this);
    }

    @Override
    public void dispose() {
        if (Boolean.TRUE.equals(this.myFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
            this.myFile.putUserData(TRANSIENT_EDITOR_STATE_KEY, TransientEditorState.forEditor(this.getEditor()));
        }
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            TextEditorImpl.$$$reportNull$$$0(4);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public TextEditorComponent getComponent() {
        TextEditorComponent textEditorComponent = this.myComponent;
        if (textEditorComponent == null) {
            TextEditorImpl.$$$reportNull$$$0(5);
        }
        return textEditorComponent;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.getActiveEditor().getContentComponent();
        if (jComponent == null) {
            TextEditorImpl.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        return this.getActiveEditor();
    }

    @NotNull
    private Editor getActiveEditor() {
        Editor editor = this.myComponent.getEditor();
        if (editor == null) {
            TextEditorImpl.$$$reportNull$$$0(7);
        }
        return editor;
    }

    @Override
    @NotNull
    public String getName() {
        return "Text";
    }

    @Override
    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            TextEditorImpl.$$$reportNull$$$0(8);
        }
        TextEditorState textEditorState = this.myAsyncLoader.getEditorState(level);
        if (textEditorState == null) {
            TextEditorImpl.$$$reportNull$$$0(9);
        }
        return textEditorState;
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            TextEditorImpl.$$$reportNull$$$0(10);
        }
        this.setState(state, false);
    }

    @Override
    public void setState(@NotNull FileEditorState state, boolean exactState) {
        if (state == null) {
            TextEditorImpl.$$$reportNull$$$0(11);
        }
        if (state instanceof TextEditorState) {
            this.myAsyncLoader.setEditorState((TextEditorState)state, exactState);
        }
    }

    @Override
    public boolean isModified() {
        return this.myComponent.isModified();
    }

    @Override
    public boolean isValid() {
        return this.myComponent.isEditorValid();
    }

    @Override
    public void selectNotify() {
    }

    @Override
    public void deselectNotify() {
    }

    public void updateModifiedProperty() {
        this.myComponent.updateModifiedProperty();
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorImpl.$$$reportNull$$$0(12);
        }
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorImpl.$$$reportNull$$$0(13);
        }
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    @Override
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Override
    public FileEditorLocation getCurrentLocation() {
        return new TextEditorLocation(this.getEditor().getCaretModel().getLogicalPosition(), (TextEditor)this);
    }

    @Override
    public StructureViewBuilder getStructureViewBuilder() {
        Document document = this.myComponent.getEditor().getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, this.myProject);
    }

    @Override
    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            TextEditorImpl.$$$reportNull$$$0(14);
        }
        return navigatable instanceof OpenFileDescriptor && (((OpenFileDescriptor)navigatable).getLine() >= 0 || ((OpenFileDescriptor)navigatable).getOffset() >= 0);
    }

    @Override
    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            TextEditorImpl.$$$reportNull$$$0(15);
        }
        ((OpenFileDescriptor)navigatable).navigateIn(this.getEditor());
    }

    public String toString() {
        return "Editor: " + this.myComponent.getFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadEditorInBackground";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TransientEditorState {
        private boolean softWrapsEnabled;

        private TransientEditorState() {
        }

        private static TransientEditorState forEditor(Editor editor) {
            TransientEditorState state = new TransientEditorState();
            state.softWrapsEnabled = editor.getSettings().isUseSoftWraps();
            return state;
        }

        private void applyTo(Editor editor) {
            editor.getSettings().setUseSoftWraps(this.softWrapsEnabled);
        }
    }
}

