/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtensionFileNameMatcher
implements FileNameMatcher {
    private final String myExtension;
    private final String myDotExtension;

    public ExtensionFileNameMatcher(@NotNull @NonNls String extension) {
        if (extension == null) {
            ExtensionFileNameMatcher.$$$reportNull$$$0(0);
        }
        this.myExtension = StringUtil.toLowerCase(extension);
        this.myDotExtension = "." + this.myExtension;
    }

    @Override
    public boolean acceptsCharSequence(@NonNls @NotNull CharSequence fileName) {
        if (fileName == null) {
            ExtensionFileNameMatcher.$$$reportNull$$$0(1);
        }
        return StringUtilRt.endsWithIgnoreCase(fileName, this.myDotExtension);
    }

    @Override
    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = "*." + this.myExtension;
        if (string == null) {
            ExtensionFileNameMatcher.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getExtension() {
        String string = this.myExtension;
        if (string == null) {
            ExtensionFileNameMatcher.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionFileNameMatcher that = (ExtensionFileNameMatcher)o;
        return this.myExtension.equals(that.myExtension);
    }

    public int hashCode() {
        return this.myExtension.hashCode();
    }

    public String toString() {
        return this.getPresentableString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/ExtensionFileNameMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/ExtensionFileNameMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCharSequence";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

