/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.awt.Component;
import java.awt.im.InputContext;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeyboardSettings", storages={@Storage(value="keyboard.xml")})
public class KeyboardSettingsExternalizable
implements PersistentStateComponent<OptionSet> {
    private static final String[] supportedNonEnglishLanguages = new String[]{"de", "fr", "it", "uk"};
    private OptionSet myOptions = new OptionSet();

    public static boolean isSupportedKeyboardLayout(@NotNull Component component2) {
        if (component2 == null) {
            KeyboardSettingsExternalizable.$$$reportNull$$$0(0);
        }
        String keyboardLayoutLanguage = KeyboardSettingsExternalizable.getLanguageForComponent(component2);
        for (String language2 : supportedNonEnglishLanguages) {
            if (!language2.equals(keyboardLayoutLanguage)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getLanguageForComponent(@NotNull Component component2) {
        Locale locale;
        if (component2 == null) {
            KeyboardSettingsExternalizable.$$$reportNull$$$0(1);
        }
        return (locale = KeyboardSettingsExternalizable.getLocaleForComponent(component2)) == null ? null : locale.getLanguage();
    }

    @Nullable
    protected static Locale getLocaleForComponent(@NotNull Component component2) {
        InputContext context;
        if (component2 == null) {
            KeyboardSettingsExternalizable.$$$reportNull$$$0(2);
        }
        return (context = component2.getInputContext()) == null ? null : context.getLocale();
    }

    @Nullable
    public static String getDisplayLanguageNameForComponent(@NotNull Component component2) {
        Locale locale;
        if (component2 == null) {
            KeyboardSettingsExternalizable.$$$reportNull$$$0(3);
        }
        return (locale = KeyboardSettingsExternalizable.getLocaleForComponent(component2)) == null ? null : locale.getDisplayLanguage();
    }

    public static KeyboardSettingsExternalizable getInstance() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return new KeyboardSettingsExternalizable();
        }
        return ServiceManager.getService(KeyboardSettingsExternalizable.class);
    }

    @Override
    @Nullable
    public OptionSet getState() {
        return this.myOptions;
    }

    @Override
    public void loadState(@NotNull OptionSet state) {
        if (state == null) {
            KeyboardSettingsExternalizable.$$$reportNull$$$0(4);
        }
        state.PREFER_KEY_POSITION_OVER_CHAR_OPTION = state.PREFER_KEY_POSITION_OVER_CHAR_OPTION || "true".equals(System.getProperty("com.jetbrains.use.old.keyevent.processing"));
        this.myOptions = state;
    }

    public boolean isPreferKeyPositionOverCharOption() {
        return this.myOptions.PREFER_KEY_POSITION_OVER_CHAR_OPTION;
    }

    public void setPreferKeyPositionOverCharOption(boolean enabled) {
        this.myOptions.PREFER_KEY_POSITION_OVER_CHAR_OPTION = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/keymap/KeyboardSettingsExternalizable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedKeyboardLayout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguageForComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocaleForComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisplayLanguageNameForComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class OptionSet {
        public boolean PREFER_KEY_POSITION_OVER_CHAR_OPTION = "true".equals(System.getProperty("com.jetbrains.use.old.keyevent.processing"));
    }
}

