/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortcut;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.MacKeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapUtil {
    @NonNls
    private static final String CANCEL_KEY_TEXT = "Cancel";
    @NonNls
    private static final String BREAK_KEY_TEXT = "Break";
    @NonNls
    private static final String SHIFT = "shift";
    @NonNls
    private static final String CONTROL = "control";
    @NonNls
    private static final String CTRL = "ctrl";
    @NonNls
    private static final String META = "meta";
    @NonNls
    private static final String ALT = "alt";
    @NonNls
    private static final String ALT_GRAPH = "altGraph";
    @NonNls
    private static final String DOUBLE_CLICK = "doubleClick";
    private static final Set<Integer> ourTooltipKeys = new HashSet<Integer>();
    private static final Set<Integer> ourOtherTooltipKeys = new HashSet<Integer>();
    private static RegistryValue ourTooltipKeysProperty;

    private KeymapUtil() {
    }

    @NotNull
    public static String getShortcutText(@NotNull @NonNls String actionId) {
        KeyboardShortcut shortcut;
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(0);
        }
        if ((shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId)) == null) {
            return "<no shortcut>";
        }
        return KeymapUtil.getShortcutText(shortcut);
    }

    @NotNull
    public static String getShortcutText(@NotNull Shortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(1);
        }
        String s = "";
        if (shortcut instanceof KeyboardShortcut) {
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            String acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getFirstKeyStroke());
            if (!acceleratorText.isEmpty()) {
                s = acceleratorText;
            }
            if (!(acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getSecondKeyStroke())).isEmpty()) {
                s = s + ", " + acceleratorText;
            }
        } else if (shortcut instanceof MouseShortcut) {
            s = KeymapUtil.getMouseShortcutText((MouseShortcut)shortcut);
        } else if (shortcut instanceof KeyboardModifierGestureShortcut) {
            KeyboardModifierGestureShortcut gestureShortcut = (KeyboardModifierGestureShortcut)shortcut;
            s = gestureShortcut.getType() == KeyboardGestureAction.ModifierType.dblClick ? "Press, release and hold " : "Hold ";
            s = s + KeymapUtil.getKeystrokeText(gestureShortcut.getStroke());
        } else {
            throw new IllegalArgumentException("unknown shortcut class: " + shortcut.getClass().getCanonicalName());
        }
        String string = s;
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getMouseShortcutText(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(3);
        }
        if (shortcut instanceof PressureShortcut) {
            String string = shortcut.toString();
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        return KeymapUtil.getMouseShortcutText(shortcut.getButton(), shortcut.getModifiers(), shortcut.getClickCount());
    }

    @NotNull
    private static String getMouseShortcutText(int button2, @JdkConstants.InputEventMask int modifiers, int clickCount) {
        String resource;
        if (button2 == 143) {
            resource = "mouse.wheel.rotate.up.shortcut.text";
        } else if (button2 == 142) {
            resource = "mouse.wheel.rotate.down.shortcut.text";
        } else if (clickCount < 2) {
            resource = "mouse.click.shortcut.text";
        } else if (clickCount < 3) {
            resource = "mouse.double.click.shortcut.text";
        } else {
            throw new IllegalStateException("unknown clickCount: " + clickCount);
        }
        String string = KeyMapBundle.message(resource, KeymapUtil.getModifiersText(KeymapUtil.mapNewModifiers(modifiers)), button2);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @JdkConstants.InputEventMask
    private static int mapNewModifiers(@JdkConstants.InputEventMask int modifiers) {
        if ((modifiers & 0x40) != 0) {
            modifiers |= 1;
        }
        if ((modifiers & 0x200) != 0) {
            modifiers |= 8;
        }
        if ((modifiers & 0x2000) != 0) {
            modifiers |= 0x20;
        }
        if ((modifiers & 0x80) != 0) {
            modifiers |= 2;
        }
        if ((modifiers & 0x100) != 0) {
            modifiers |= 4;
        }
        return modifiers;
    }

    @NotNull
    public static String getKeystrokeText(KeyStroke accelerator) {
        if (accelerator == null) {
            return "";
        }
        if (SystemInfo.isMac) {
            String string = MacKeymapUtil.getKeyStrokeText(accelerator);
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String acceleratorText = "";
        int modifiers = accelerator.getModifiers();
        if (modifiers > 0) {
            acceleratorText = KeymapUtil.getModifiersText(modifiers);
        }
        acceleratorText = acceleratorText + KeymapUtil.getKeyText(accelerator.getKeyCode());
        String string = acceleratorText.trim();
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getKeyText(int code) {
        switch (code) {
            case 192: {
                return "`";
            }
            case 108: {
                return ",";
            }
            case 110: {
                return ".";
            }
            case 47: {
                return "/";
            }
            case 92: {
                return "\\";
            }
            case 46: {
                return ".";
            }
            case 59: {
                return ";";
            }
            case 93: {
                return "]";
            }
            case 91: {
                return "[";
            }
            case 61: {
                return "=";
            }
        }
        String result2 = SystemInfo.isMac ? MacKeymapUtil.getKeyText(code) : KeyEvent.getKeyText(code);
        String string = CANCEL_KEY_TEXT.equals(result2) ? BREAK_KEY_TEXT : result2;
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        if (SystemInfo.isMac) {
            String string = MacKeymapUtil.getModifiersText(modifiers);
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        String keyModifiersText = KeyEvent.getKeyModifiersText(modifiers);
        String string = keyModifiersText.isEmpty() ? keyModifiersText : keyModifiersText + "+";
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static ShortcutSet getActiveKeymapShortcuts(@Nullable @NonNls String actionId) {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null || actionId == null) {
            return new CustomShortcutSet(Shortcut.EMPTY_ARRAY);
        }
        return new CustomShortcutSet(keymapManager2.getActiveKeymap().getShortcuts(actionId));
    }

    @Nullable
    public static Shortcut getPrimaryShortcut(@Nullable @NonNls String actionId) {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null || actionId == null) {
            return null;
        }
        return ArrayUtil.getFirstElement(keymapManager2.getActiveKeymap().getShortcuts(actionId));
    }

    @NotNull
    public static String getFirstKeyboardShortcutText(@NotNull @NonNls String actionId) {
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(11);
        }
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return KeymapUtil.getShortcutText(shortcut);
        }
        return "";
    }

    public static boolean isEventForAction(@NotNull KeyEvent keyEvent, @NotNull @NonNls String actionId) {
        if (keyEvent == null) {
            KeymapUtil.$$$reportNull$$$0(12);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(13);
        }
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut) || AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent) != ((KeyboardShortcut)shortcut).getFirstKeyStroke()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getFirstKeyboardShortcutText(@NotNull AnAction action2) {
        if (action2 == null) {
            KeymapUtil.$$$reportNull$$$0(14);
        }
        return KeymapUtil.getFirstKeyboardShortcutText(action2.getShortcutSet());
    }

    @NotNull
    public static String getFirstKeyboardShortcutText(@NotNull ShortcutSet set) {
        Shortcut[] shortcuts;
        KeyboardShortcut shortcut;
        if (set == null) {
            KeymapUtil.$$$reportNull$$$0(15);
        }
        return (shortcut = ContainerUtil.findInstance(shortcuts = set.getShortcuts(), KeyboardShortcut.class)) == null ? "" : KeymapUtil.getShortcutText(shortcut);
    }

    @NotNull
    public static String getPreferredShortcutText(Shortcut @NotNull [] shortcuts) {
        KeyboardShortcut shortcut;
        if (shortcuts == null) {
            KeymapUtil.$$$reportNull$$$0(16);
        }
        return (shortcut = ContainerUtil.findInstance(shortcuts, KeyboardShortcut.class)) != null ? KeymapUtil.getShortcutText(shortcut) : (shortcuts.length > 0 ? KeymapUtil.getShortcutText(shortcuts[0]) : "");
    }

    @NotNull
    public static String getShortcutsText(Shortcut @NotNull [] shortcuts) {
        if (shortcuts == null) {
            KeymapUtil.$$$reportNull$$$0(17);
        }
        if (shortcuts.length == 0) {
            return "";
        }
        String string = Arrays.stream(shortcuts).map(KeymapUtil::getShortcutText).collect(Collectors.joining(" "));
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static MouseShortcut parseMouseShortcut(@NotNull String keystrokeString) throws InvalidDataException {
        if (keystrokeString == null) {
            KeymapUtil.$$$reportNull$$$0(19);
        }
        if (Registry.is("ide.mac.forceTouch") && keystrokeString.startsWith("Force touch")) {
            return new PressureShortcut(2.0);
        }
        int button2 = -1;
        int modifiers = 0;
        int clickCount = 1;
        StringTokenizer tokenizer = new StringTokenizer(keystrokeString);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (SHIFT.equals(token)) {
                modifiers |= 0x40;
                continue;
            }
            if (CONTROL.equals(token) || CTRL.equals(token)) {
                modifiers |= 0x80;
                continue;
            }
            if (META.equals(token)) {
                modifiers |= 0x100;
                continue;
            }
            if (ALT.equals(token)) {
                modifiers |= 0x200;
                continue;
            }
            if (ALT_GRAPH.equals(token)) {
                modifiers |= 0x2000;
                continue;
            }
            if (token.startsWith("button") && token.length() > 6) {
                try {
                    button2 = Integer.parseInt(token.substring(6));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidDataException("unparsable token: " + token);
                }
            }
            if (DOUBLE_CLICK.equals(token)) {
                clickCount = 2;
                continue;
            }
            throw new InvalidDataException("unknown token: " + token);
        }
        return new MouseShortcut(button2, modifiers, clickCount);
    }

    @NotNull
    public static String getMouseShortcutString(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(20);
        }
        if (Registry.is("ide.mac.forceTouch") && shortcut instanceof PressureShortcut) {
            return "Force touch";
        }
        StringBuilder buffer = new StringBuilder();
        int modifiers = shortcut.getModifiers();
        if ((0x40 & modifiers) > 0) {
            buffer.append(SHIFT);
            buffer.append(' ');
        }
        if ((0x80 & modifiers) > 0) {
            buffer.append(CONTROL);
            buffer.append(' ');
        }
        if ((0x100 & modifiers) > 0) {
            buffer.append(META);
            buffer.append(' ');
        }
        if ((0x200 & modifiers) > 0) {
            buffer.append(ALT);
            buffer.append(' ');
        }
        if ((0x2000 & modifiers) > 0) {
            buffer.append(ALT_GRAPH);
            buffer.append(' ');
        }
        buffer.append("button").append(shortcut.getButton()).append(' ');
        if (shortcut.getClickCount() > 1) {
            buffer.append(DOUBLE_CLICK);
        }
        String string = buffer.toString().trim();
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String getKeyModifiersTextForMacOSLeopard(@JdkConstants.InputEventMask int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 4) != 0) {
            buf.append("\u2318");
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("AWT.control", "Ctrl"));
        }
        if ((modifiers & 8) != 0) {
            buf.append("\u2325");
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("AWT.shift", "Shift"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        String string = buf.toString();
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    public static boolean isTooltipRequest(@NotNull KeyEvent keyEvent) {
        if (keyEvent == null) {
            KeymapUtil.$$$reportNull$$$0(23);
        }
        if (ourTooltipKeysProperty == null) {
            ourTooltipKeysProperty = Registry.get("ide.forcedShowTooltip");
            ourTooltipKeysProperty.addListener(new RegistryValueListener(){

                @Override
                public void afterValueChanged(@NotNull RegistryValue value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    KeymapUtil.updateTooltipRequestKey(value2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/keymap/KeymapUtil$1", "afterValueChanged"));
                }
            }, Disposer.get("ui"));
            KeymapUtil.updateTooltipRequestKey(ourTooltipKeysProperty);
        }
        if (keyEvent.getID() != 401) {
            return false;
        }
        for (Integer each : ourTooltipKeys) {
            if ((keyEvent.getModifiers() & each) != 0) continue;
            return false;
        }
        for (Integer each : ourOtherTooltipKeys) {
            if ((keyEvent.getModifiers() & each) <= 0) continue;
            return false;
        }
        int code = keyEvent.getKeyCode();
        return code == 157 || code == 17 || code == 16 || code == 18;
    }

    private static void updateTooltipRequestKey(@NotNull RegistryValue value2) {
        if (value2 == null) {
            KeymapUtil.$$$reportNull$$$0(24);
        }
        String text2 = value2.asString();
        ourTooltipKeys.clear();
        ourOtherTooltipKeys.clear();
        KeymapUtil.processKey(text2.contains(META), 4);
        KeymapUtil.processKey(text2.contains(CONTROL) || text2.contains(CTRL), 2);
        KeymapUtil.processKey(text2.contains(SHIFT), 1);
        KeymapUtil.processKey(text2.contains(ALT), 8);
    }

    private static void processKey(boolean condition2, int value2) {
        if (condition2) {
            ourTooltipKeys.add(value2);
        } else {
            ourOtherTooltipKeys.add(value2);
        }
    }

    public static boolean isEmacsKeymap() {
        return KeymapUtil.isEmacsKeymap(KeymapManager.getInstance().getActiveKeymap());
    }

    public static boolean isEmacsKeymap(@Nullable Keymap keymap2) {
        while (keymap2 != null) {
            if ("Emacs".equalsIgnoreCase(keymap2.getName())) {
                return true;
            }
            keymap2 = keymap2.getParent();
        }
        return false;
    }

    @Nullable
    public static KeyStroke getKeyStroke(@NotNull ShortcutSet shortcutSet) {
        Shortcut[] shortcuts;
        if (shortcutSet == null) {
            KeymapUtil.$$$reportNull$$$0(25);
        }
        if ((shortcuts = shortcutSet.getShortcuts()).length == 0 || !(shortcuts[0] instanceof KeyboardShortcut)) {
            return null;
        }
        KeyboardShortcut shortcut = (KeyboardShortcut)shortcuts[0];
        if (shortcut.getSecondKeyStroke() != null) {
            return null;
        }
        return shortcut.getFirstKeyStroke();
    }

    @NotNull
    public static Collection<KeyStroke> getKeyStrokes(@NotNull ShortcutSet shortcutSet) {
        Shortcut[] shortcuts;
        if (shortcutSet == null) {
            KeymapUtil.$$$reportNull$$$0(26);
        }
        if ((shortcuts = shortcutSet.getShortcuts()).length == 0) {
            Set<KeyStroke> set = Collections.emptySet();
            if (set == null) {
                KeymapUtil.$$$reportNull$$$0(27);
            }
            return set;
        }
        SmartHashSet result2 = new SmartHashSet();
        for (Shortcut shortcut : shortcuts) {
            KeyboardShortcut kbShortcut;
            if (!(shortcut instanceof KeyboardShortcut) || (kbShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            result2.add(kbShortcut.getFirstKeyStroke());
        }
        Set<KeyStroke> set = result2.isEmpty() ? Collections.emptySet() : result2;
        if (set == null) {
            KeymapUtil.$$$reportNull$$$0(28);
        }
        return set;
    }

    @NotNull
    public static String createTooltipText(@NotNull String name, @NotNull @NonNls String actionId) {
        String text2;
        if (name == null) {
            KeymapUtil.$$$reportNull$$$0(29);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(30);
        }
        String string = (text2 = KeymapUtil.getFirstKeyboardShortcutText(actionId)).isEmpty() ? name : name + " (" + text2 + ")";
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String createTooltipText(@Nullable String name, @NotNull AnAction action2) {
        String toolTipText;
        if (action2 == null) {
            KeymapUtil.$$$reportNull$$$0(32);
        }
        String string = toolTipText = name == null ? "" : name;
        while (StringUtil.endsWithChar(toolTipText, '.')) {
            toolTipText = toolTipText.substring(0, toolTipText.length() - 1);
        }
        String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText(action2);
        if (!shortcutsText.isEmpty()) {
            toolTipText = toolTipText + " (" + shortcutsText + ")";
        }
        String string2 = toolTipText;
        if (string2 == null) {
            KeymapUtil.$$$reportNull$$$0(33);
        }
        return string2;
    }

    public static boolean matchActionMouseShortcutsModifiers(@NotNull Keymap activeKeymap, @JdkConstants.InputEventMask int modifiers, @NotNull @NonNls String actionId) {
        if (activeKeymap == null) {
            KeymapUtil.$$$reportNull$$$0(34);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(35);
        }
        MouseShortcut syntheticShortcut = new MouseShortcut(1, modifiers, 1);
        for (Shortcut shortcut : activeKeymap.getShortcuts(actionId)) {
            MouseShortcut mouseShortcut;
            if (!(shortcut instanceof MouseShortcut) || (mouseShortcut = (MouseShortcut)shortcut).getModifiers() != syntheticShortcut.getModifiers()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static MouseShortcut createMouseShortcut(@NotNull MouseEvent e) {
        if (e == null) {
            KeymapUtil.$$$reportNull$$$0(36);
        }
        int button2 = MouseShortcut.getButton(e);
        int modifiers = e.getModifiersEx();
        if (button2 == 0 && e.getID() == 506) {
            if ((modifiers & 0x400) != 0) {
                button2 = 1;
            } else if ((modifiers & 0x800) != 0) {
                button2 = 2;
            }
        }
        return new MouseShortcut(button2, modifiers, 1);
    }

    public static boolean reassignAction(@NotNull JComponent component2, @NotNull KeyStroke oldKeyStroke, @Nullable KeyStroke newKeyStroke, int condition2) {
        if (component2 == null) {
            KeymapUtil.$$$reportNull$$$0(37);
        }
        if (oldKeyStroke == null) {
            KeymapUtil.$$$reportNull$$$0(38);
        }
        return KeymapUtil.reassignAction(component2, oldKeyStroke, newKeyStroke, condition2, true);
    }

    public static boolean reassignAction(@NotNull JComponent component2, @NotNull KeyStroke oldKeyStroke, @Nullable KeyStroke newKeyStroke, int condition2, boolean muteOldKeystroke) {
        ActionListener action2;
        if (component2 == null) {
            KeymapUtil.$$$reportNull$$$0(39);
        }
        if (oldKeyStroke == null) {
            KeymapUtil.$$$reportNull$$$0(40);
        }
        if ((action2 = component2.getActionForKeyStroke(oldKeyStroke)) == null) {
            return false;
        }
        if (newKeyStroke != null) {
            component2.registerKeyboardAction(action2, newKeyStroke, condition2);
        }
        if (muteOldKeystroke) {
            component2.registerKeyboardAction(new RedispatchEventAction(component2), oldKeyStroke, condition2);
        }
        return true;
    }

    @Nullable
    public static ShortcutSet filterKeyStrokes(@NotNull ShortcutSet source, KeyStroke ... toLeaveOut) {
        if (source == null) {
            KeymapUtil.$$$reportNull$$$0(41);
        }
        ArrayList<Shortcut> filtered2 = new ArrayList<Shortcut>(Arrays.asList(source.getShortcuts()));
        for (Shortcut shortcut : source.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut) || ArrayUtil.find(toLeaveOut, ((KeyboardShortcut)shortcut).getFirstKeyStroke()) == -1) continue;
            filtered2.remove(shortcut);
        }
        return filtered2.isEmpty() ? null : new CustomShortcutSet(filtered2.toArray(Shortcut.EMPTY_ARRAY));
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static String getEventCallerKeystrokeText(@NotNull AnActionEvent event) {
        if (event == null) {
            KeymapUtil.$$$reportNull$$$0(42);
        }
        if (event.getInputEvent() instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event.getInputEvent();
            return KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(ke.getKeyCode(), ke.getModifiers()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 1: 
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/KeymapUtil";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyEvent";
                break;
            }
            case 14: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keystrokeString";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeKeymap";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeyStroke";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/KeymapUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeystrokeText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutsText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyModifiersTextForMacOSLeopard";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokes";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutText";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutText";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFirstKeyboardShortcutText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEventForAction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredShortcutText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutsText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseMouseShortcut";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutString";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isTooltipRequest";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateTooltipRequestKey";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStroke";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokes";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createTooltipText";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "matchActionMouseShortcutsModifiers";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createMouseShortcut";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "reassignAction";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "filterKeyStrokes";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getEventCallerKeystrokeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RedispatchEventAction
    extends AbstractAction {
        private final Component myComponent;

        RedispatchEventAction(@NotNull Component component2) {
            if (component2 == null) {
                RedispatchEventAction.$$$reportNull$$$0(0);
            }
            this.myComponent = component2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container parent;
            AWTEvent event = EventQueue.getCurrentEvent();
            if (event instanceof KeyEvent && event.getSource() == this.myComponent && (parent = this.myComponent.getParent()) != null) {
                KeyEvent keyEvent = (KeyEvent)event;
                parent.dispatchEvent(new KeyEvent(parent, event.getID(), ((KeyEvent)event).getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/KeymapUtil$RedispatchEventAction", "<init>"));
        }
    }
}

