/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.BundledKeymapBean;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\b\u0010\r\u001a\u00020\u0004H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0018\u0010\b\u001a\u00020\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "effectiveFile", "", "Lcom/intellij/openapi/keymap/impl/BundledKeymapBean;", "getEffectiveFile", "(Lcom/intellij/openapi/keymap/impl/BundledKeymapBean;)Ljava/lang/String;", "keymapName", "getKeymapName", "isKnownLinuxKeymap", "", "isKnownMacOSKeymap", "osName", "intellij.platform.ide.impl"})
public final class DefaultKeymapKt {
    private static final Logger LOG;

    @NotNull
    public static final String getEffectiveFile(@NotNull BundledKeymapBean $this$effectiveFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$effectiveFile, (String)"$this$effectiveFile");
        StringBuilder stringBuilder = new StringBuilder().append("keymaps/");
        String string = $this$effectiveFile.file;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file");
        return stringBuilder.append(StringsKt.replace$default((String)string, (String)"$OS$", (String)DefaultKeymapKt.osName(), (boolean)false, (int)4, null)).toString();
    }

    @NotNull
    public static final String getKeymapName(@NotNull BundledKeymapBean $this$keymapName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$keymapName, (String)"$this$keymapName");
        String string = FileUtil.getNameWithoutExtension($this$keymapName.file);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.getNameWithoutExtension(file)");
        return StringsKt.removePrefix((String)string, (CharSequence)"$OS$/");
    }

    private static final String osName() {
        return SystemInfo.isMac ? "macos" : (SystemInfo.isWindows ? "windows" : (SystemInfo.isLinux ? "linux" : "other"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isKnownLinuxKeymap(String keymapName) {
        String string = keymapName;
        if (string == null) return false;
        String string2 = string;
        switch (string2.hashCode()) {
            case -153522550: {
                if (!string2.equals("Default for GNOME")) return false;
                return true;
            }
            case 192022326: {
                if (!string2.equals("Default for KDE")) return false;
                return true;
            }
            case 1658131578: {
                if (!string2.equals("Default for XWin")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isKnownMacOSKeymap(String keymapName) {
        String string = keymapName;
        if (string == null) return false;
        String string2 = string;
        switch (string2.hashCode()) {
            case -187773587: {
                if (!string2.equals("Mac OS X")) return false;
                return true;
            }
            case 84329029: {
                if (!string2.equals("Xcode")) return false;
                return true;
            }
            case 1976263100: {
                if (!string2.equals("Sublime Text (Mac OS X)")) return false;
                return true;
            }
            case -1650442035: {
                if (!string2.equals("Eclipse (Mac OS X)")) return false;
                return true;
            }
            case -1087610798: {
                if (!string2.equals("Mac OS X 10.5+")) return false;
                return true;
            }
            case 984080664: {
                if (!string2.equals("ReSharper OSX")) return false;
                return true;
            }
        }
        return false;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DefaultKeymap.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ String access$osName() {
        return DefaultKeymapKt.osName();
    }

    public static final /* synthetic */ boolean access$isKnownMacOSKeymap(String keymapName) {
        return DefaultKeymapKt.isKnownMacOSKeymap(keymapName);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$isKnownLinuxKeymap(String keymapName) {
        return DefaultKeymapKt.isKnownLinuxKeymap(keymapName);
    }
}

