/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.actions.CtrlYActionChooser;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.BundledKeymapBean;
import com.intellij.openapi.keymap.impl.BundledKeymapProvider;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.keymap.impl.DefaultKeymapKt;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapImplKt;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.WeakKeymapManagerListener;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeymapManager", storages={@Storage(value="keymap.xml", roamingType=RoamingType.PER_OS)}, additionalExportFile="keymaps")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 ;2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020\u0007H\u0016J\b\u0010\"\u001a\u00020\u0010H\u0016J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100$H\u0016\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00102\u0006\u0010)\u001a\u00020\u0007H\u0016J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010,J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010.\u001a\u00020\u0003H\u0016J\u0010\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0003H\u0016J\b\u00101\u001a\u00020\u0012H\u0002J\u0010\u00102\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\nH\u0016J\u0010\u00105\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J.\u00106\u001a\u00020\u00122\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\b\u00108\u001a\u0004\u0018\u00010\u00102\u000e\u00109\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010,J\u0010\u0010:\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\b\u001a.\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\r\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapManagerImpl;", "Lcom/intellij/openapi/keymap/ex/KeymapManagerEx;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "boundShortcuts", "Lgnu/trove/THashMap;", "", "listeners", "", "Lcom/intellij/openapi/keymap/KeymapManagerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/openapi/keymap/Keymap;", "addKeymapManagerListener", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addWeakListener", "bindShortcuts", "sourceActionId", "targetActionId", "fireActiveKeymapChanged", "newScheme", "fireKeymapAdded", "keymap", "fireKeymapRemoved", "fireShortcutChanged", "actionId", "getActionBinding", "getActiveKeymap", "getAllKeymaps", "", "()[Lcom/intellij/openapi/keymap/Keymap;", "getBoundActions", "", "getKeymap", "name", "getKeymaps", "additionalFilter", "Ljava/util/function/Predicate;", "getSchemeManager", "getState", "loadState", "state", "pollQueue", "removeKeymapManagerListener", "removeWeakListener", "listenerToRemove", "setActiveKeymap", "setKeymaps", "keymaps", "active", "removeCondition", "unbindShortcuts", "Companion", "intellij.platform.ide.impl"})
public final class KeymapManagerImpl
extends KeymapManagerEx
implements PersistentStateComponent<Element> {
    private final List<KeymapManagerListener> listeners;
    private final THashMap<String, String> boundShortcuts;
    private final SchemeManager<Keymap> schemeManager;
    private static boolean isKeymapManagerInitialized;
    public static final Companion Companion;

    private final void fireKeymapAdded(Keymap keymap2) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().syncPublisher(KeymapManagerListener.TOPIC).keymapAdded(keymap2);
        for (KeymapManagerListener listener2 : this.listeners) {
            listener2.keymapAdded(keymap2);
        }
    }

    private final void fireKeymapRemoved(Keymap keymap2) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().syncPublisher(KeymapManagerListener.TOPIC).keymapRemoved(keymap2);
        for (KeymapManagerListener listener2 : this.listeners) {
            listener2.keymapRemoved(keymap2);
        }
    }

    private final void fireActiveKeymapChanged(Keymap newScheme) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().syncPublisher(KeymapManagerListener.TOPIC).activeKeymapChanged(this.getActiveKeymap());
        for (KeymapManagerListener listener2 : this.listeners) {
            listener2.activeKeymapChanged(newScheme);
        }
    }

    @Override
    @NotNull
    public Keymap[] getAllKeymaps() {
        Collection $this$toTypedArray$iv = this.getKeymaps(null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Keymap[] keymapArray = thisCollection$iv.toArray(new Keymap[0]);
        if (keymapArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return keymapArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Keymap> getKeymaps(@Nullable Predicate<Keymap> additionalFilter) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.schemeManager.getAllSchemes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Keymap it = (Keymap)element$iv$iv;
            boolean bl = false;
            String string = it.getPresentableName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.presentableName");
            if (!(!StringsKt.startsWith$default((String)string, (String)"$", (boolean)false, (int)2, null) && (additionalFilter == null || additionalFilter.test(it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Keymap getKeymap(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.schemeManager.findSchemeByName(name);
    }

    @Override
    @NotNull
    public Keymap getActiveKeymap() {
        Keymap keymap2;
        Keymap keymap3 = this.schemeManager.getActiveScheme();
        if (keymap3 == null) {
            keymap3 = keymap2 = this.schemeManager.findSchemeByName(DefaultKeymap.Companion.getInstance().getDefaultKeymapName());
        }
        if (keymap3 == null) {
            Keymap keymap4 = this.schemeManager.findSchemeByName("$default");
            if (keymap4 == null) {
                Intrinsics.throwNpe();
            }
            keymap2 = keymap4;
        }
        return keymap2;
    }

    @Override
    public void setActiveKeymap(@NotNull Keymap keymap2) {
        Intrinsics.checkParameterIsNotNull((Object)keymap2, (String)"keymap");
        SchemeManager.setCurrent$default(this.schemeManager, keymap2, false, false, 6, null);
    }

    @Override
    public void bindShortcuts(@NotNull String sourceActionId, @NotNull String targetActionId) {
        Intrinsics.checkParameterIsNotNull((Object)sourceActionId, (String)"sourceActionId");
        Intrinsics.checkParameterIsNotNull((Object)targetActionId, (String)"targetActionId");
        this.boundShortcuts.put(targetActionId, sourceActionId);
    }

    @Override
    public void unbindShortcuts(@NotNull String targetActionId) {
        Intrinsics.checkParameterIsNotNull((Object)targetActionId, (String)"targetActionId");
        this.boundShortcuts.remove(targetActionId);
    }

    @Override
    @NotNull
    public Set<String> getBoundActions() {
        Set<String> set = this.boundShortcuts.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"boundShortcuts.keys");
        return set;
    }

    @Override
    @Nullable
    public String getActionBinding(@NotNull String actionId) {
        String next;
        Intrinsics.checkParameterIsNotNull((Object)actionId, (String)"actionId");
        Set visited = null;
        String id2 = actionId;
        do {
            if (this.boundShortcuts.get(id2) == null) {
                break;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)next, (String)"boundShortcuts.get(id) ?: break");
            if (visited != null) continue;
            visited = new SmartHashSet();
        } while (visited.add(id2 = next));
        return Intrinsics.areEqual((Object)id2, (Object)actionId) ? null : id2;
    }

    @Override
    @NotNull
    public SchemeManager<Keymap> getSchemeManager() {
        return this.schemeManager;
    }

    public final void setKeymaps(@NotNull List<? extends Keymap> keymaps, @Nullable Keymap active, @Nullable Predicate<Keymap> removeCondition) {
        Intrinsics.checkParameterIsNotNull(keymaps, (String)"keymaps");
        this.schemeManager.setSchemes(keymaps, active, removeCondition);
        this.fireActiveKeymapChanged(active);
    }

    @Override
    @NotNull
    public Element getState() {
        Element result2;
        block1: {
            result2 = new Element("state");
            Keymap keymap2 = this.schemeManager.getActiveScheme();
            if (keymap2 == null) break block1;
            Keymap keymap3 = keymap2;
            boolean bl = false;
            boolean bl2 = false;
            Keymap it = keymap3;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)DefaultKeymap.Companion.getInstance().getDefaultKeymapName()) ^ true) {
                Element e = new Element("active_keymap");
                e.setAttribute("name", it.getName());
                result2.addContent(e);
            }
        }
        return result2;
    }

    @Override
    public void loadState(@NotNull Element state) {
        Element child2;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Element element2 = child2 = state.getChild("active_keymap");
        String activeKeymapName = element2 != null ? element2.getAttributeValue("name") : null;
        CharSequence charSequence = activeKeymapName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.schemeManager.setCurrentSchemeName(activeKeymapName);
            if (Intrinsics.areEqual((Object)this.schemeManager.getCurrentSchemeName(), (Object)activeKeymapName) ^ true) {
                KeymapImplKt.notifyAboutMissingKeymap(activeKeymapName, "Cannot find keymap \"" + activeKeymapName + '\"');
            }
        }
    }

    @Override
    public void addKeymapManagerListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.add(listener2);
    }

    @Override
    public void addKeymapManagerListener(@NotNull KeymapManagerListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.pollQueue();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect(parentDisposable).subscribe(KeymapManagerListener.TOPIC, listener2);
    }

    private final void pollQueue() {
        CollectionsKt.removeAll(this.listeners, (Function1)pollQueue.1.INSTANCE);
    }

    @Override
    public void removeKeymapManagerListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.remove(listener2);
    }

    @Override
    public void addWeakListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.add(new WeakKeymapManagerListener(this, listener2));
    }

    @Override
    public void removeWeakListener(@NotNull KeymapManagerListener listenerToRemove) {
        Intrinsics.checkParameterIsNotNull((Object)listenerToRemove, (String)"listenerToRemove");
        CollectionsKt.removeAll(this.listeners, (Function1)((Function1)new Function1<KeymapManagerListener, Boolean>(listenerToRemove){
            final /* synthetic */ KeymapManagerListener $listenerToRemove;

            public final boolean invoke(KeymapManagerListener it) {
                return it instanceof WeakKeymapManagerListener && ((WeakKeymapManagerListener)it).isWrapped(this.$listenerToRemove);
            }
            {
                this.$listenerToRemove = keymapManagerListener;
                super(1);
            }
        }));
    }

    public final void fireShortcutChanged(@NotNull Keymap keymap2, @NotNull String actionId) {
        Intrinsics.checkParameterIsNotNull((Object)keymap2, (String)"keymap");
        Intrinsics.checkParameterIsNotNull((Object)actionId, (String)"actionId");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().syncPublisher(KeymapManagerListener.TOPIC).shortcutChanged(keymap2, actionId);
    }

    public KeymapManagerImpl() {
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ContainerUtil.createLock\u2026<KeymapManagerListener>()");
        this.listeners = list2;
        this.boundShortcuts = new THashMap();
        this.schemeManager = SchemeManagerFactory.create$default(SchemeManagerFactory.Companion.getInstance(), "keymaps", new LazySchemeProcessor<Keymap, KeymapImpl>(){

            @Override
            @NotNull
            public KeymapImpl createScheme(@NotNull SchemeDataHolder<? super KeymapImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                Intrinsics.checkParameterIsNotNull(dataHolder, (String)"dataHolder");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull(attributeProvider, (String)"attributeProvider");
                return KeymapImplKt.KeymapImpl(name, dataHolder);
            }

            @Override
            public void onCurrentSchemeSwitched(@Nullable Keymap oldScheme, @Nullable Keymap newScheme, boolean processChangeSynchronously) {
                this.fireActiveKeymapChanged(newScheme);
            }

            @Override
            public void reloaded(@NotNull SchemeManager<Keymap> schemeManager2, @NotNull Collection<? extends Keymap> schemes) {
                Intrinsics.checkParameterIsNotNull(schemeManager2, (String)"schemeManager");
                Intrinsics.checkParameterIsNotNull(schemes, (String)"schemes");
                if (schemeManager2.getActiveScheme() == null) {
                    AppUIUtil.invokeOnEdt(new Runnable(schemeManager2){
                        final /* synthetic */ SchemeManager $schemeManager;

                        public final void run() {
                            this.$schemeManager.setCurrentSchemeName(DefaultKeymap.Companion.getInstance().getDefaultKeymapName(), true);
                        }
                        {
                            this.$schemeManager = schemeManager2;
                        }
                    });
                }
            }
        }, null, null, 12, null);
        DefaultKeymap defaultKeymapManager = DefaultKeymap.Companion.getInstance();
        String systemDefaultKeymap = WelcomeWizardUtil.getWizardMacKeymap() == null ? defaultKeymapManager.getDefaultKeymapName() : WelcomeWizardUtil.getWizardMacKeymap();
        Iterator<Keymap> iterator2 = defaultKeymapManager.getKeymaps$intellij_platform_ide_impl().iterator();
        while (iterator2.hasNext()) {
            Keymap keymap2;
            Keymap keymap3 = keymap2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)keymap3, (String)"keymap");
            this.schemeManager.addScheme(keymap3);
            if (!Intrinsics.areEqual((Object)keymap2.getName(), (Object)systemDefaultKeymap)) continue;
            SchemeManager.setCurrent$default(this.schemeManager, keymap2, false, false, 6, null);
        }
        this.schemeManager.loadSchemes();
        isKeymapManagerInitialized = true;
        if (ConfigImportHelper.isFirstSession() && !ConfigImportHelper.isConfigImported()) {
            CtrlYActionChooser.askAboutShortcut();
        }
        Function1<String, Unit> $fun$removeKeymap$2 = new Function1<String, Unit>(){

            public final void invoke(@NotNull String keymapName) {
                Intrinsics.checkParameterIsNotNull((Object)keymapName, (String)"keymapName");
                Keymap keymap2 = (Keymap)schemeManager.getActiveScheme();
                boolean isCurrent = StringsKt.equals$default((String)(keymap2 != null ? keymap2.getName() : null), (String)keymapName, (boolean)false, (int)2, null);
                Keymap keymap3 = (Keymap)schemeManager.removeScheme(keymapName);
                if (keymap3 != null) {
                    this.fireKeymapRemoved(keymap3);
                }
                DefaultKeymap.Companion.getInstance().removeKeymap$intellij_platform_ide_impl(keymapName);
                if (isCurrent && !schemeManager.isEmpty()) {
                    Keymap newActiveKeymap = this.getActiveKeymap();
                    schemeManager.setCurrent(this.getActiveKeymap(), true, true);
                    this.fireActiveKeymapChanged(newActiveKeymap);
                }
            }
        };
        BundledKeymapBean.EP_NAME.addExtensionPointListener(new ExtensionPointListener<BundledKeymapBean>($fun$removeKeymap$2){
            final /* synthetic */ 2 $removeKeymap$2;

            @Override
            public void extensionAdded(@NotNull BundledKeymapBean ep, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)ep, (String)"ep");
                Intrinsics.checkParameterIsNotNull((Object)pluginDescriptor, (String)"pluginDescriptor");
                String keymapName = DefaultKeymapKt.getKeymapName(ep);
                DefaultKeymapImpl keymap2 = DefaultKeymap.Companion.getInstance().loadKeymap$intellij_platform_ide_impl(keymapName, (SchemeDataHolder<? super KeymapImpl>)new SchemeDataHolder<KeymapImpl>(pluginDescriptor, ep){
                    final /* synthetic */ PluginDescriptor $pluginDescriptor;
                    final /* synthetic */ BundledKeymapBean $ep;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Element read() {
                        Element element2;
                        Closeable closeable = this.$pluginDescriptor.getPluginClassLoader().getResourceAsStream(DefaultKeymapKt.getEffectiveFile(this.$ep));
                        boolean bl = false;
                        Throwable throwable = null;
                        try {
                            InputStream it = (InputStream)closeable;
                            boolean bl2 = false;
                            element2 = JDOMUtil.load(it);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return element2;
                    }
                    {
                        this.$pluginDescriptor = $captured_local_variable$0;
                        this.$ep = $captured_local_variable$1;
                    }

                    public void updateDigest(@NotNull KeymapImpl scheme) {
                        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
                        SchemeDataHolder.DefaultImpls.updateDigest(this, scheme);
                    }

                    public void updateDigest(@Nullable Element data2) {
                        SchemeDataHolder.DefaultImpls.updateDigest(this, data2);
                    }
                }, pluginDescriptor);
                schemeManager.addScheme(keymap2);
                this.fireKeymapAdded(keymap2);
            }

            @Override
            public void extensionRemoved(@NotNull BundledKeymapBean ep, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)ep, (String)"ep");
                Intrinsics.checkParameterIsNotNull((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.$removeKeymap$2.invoke(DefaultKeymapKt.getKeymapName(ep));
            }
            {
                this.$removeKeymap$2 = $captured_local_variable$1;
            }
        }, (Disposable)ApplicationManager.getApplication());
        BundledKeymapProvider.EP_NAME.addExtensionPointListener(new ExtensionPointListener<BundledKeymapProvider>($fun$removeKeymap$2){
            final /* synthetic */ 2 $removeKeymap$2;

            @Override
            public void extensionAdded(@NotNull BundledKeymapProvider ep, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)ep, (String)"ep");
                Intrinsics.checkParameterIsNotNull((Object)pluginDescriptor, (String)"pluginDescriptor");
                for (String fileName : ep.getKeymapFileNames()) {
                    DefaultKeymap defaultKeymap = DefaultKeymap.Companion.getInstance();
                    String string = ep.getKeyFromFileName(fileName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ep.getKeyFromFileName(fileName)");
                    DefaultKeymapImpl keymap2 = defaultKeymap.loadKeymap$intellij_platform_ide_impl(string, (SchemeDataHolder<? super KeymapImpl>)new SchemeDataHolder<KeymapImpl>(ep, fileName){
                        final /* synthetic */ BundledKeymapProvider $ep;
                        final /* synthetic */ String $fileName;

                        public Element read() {
                            return (Element)this.$ep.load(this.$fileName, extensionAdded.keymap.read.1.INSTANCE);
                        }
                        {
                            this.$ep = $captured_local_variable$0;
                            this.$fileName = $captured_local_variable$1;
                        }

                        public void updateDigest(@NotNull KeymapImpl scheme) {
                            Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
                            SchemeDataHolder.DefaultImpls.updateDigest(this, scheme);
                        }

                        public void updateDigest(@Nullable Element data2) {
                            SchemeDataHolder.DefaultImpls.updateDigest(this, data2);
                        }
                    }, pluginDescriptor);
                    schemeManager.addScheme(keymap2);
                    this.fireKeymapAdded(keymap2);
                }
            }

            @Override
            public void extensionRemoved(@NotNull BundledKeymapProvider ep, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)ep, (String)"ep");
                Intrinsics.checkParameterIsNotNull((Object)pluginDescriptor, (String)"pluginDescriptor");
                for (String fileName : ep.getKeymapFileNames()) {
                    String string = ep.getKeyFromFileName(fileName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ep.getKeyFromFileName(fileName)");
                    this.$removeKeymap$2.invoke(string);
                }
            }
            {
                this.$removeKeymap$2 = $captured_local_variable$1;
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    static {
        Companion = new Companion(null);
    }

    public static final boolean isKeymapManagerInitialized() {
        Companion companion = Companion;
        return isKeymapManagerInitialized;
    }

    private static final void setKeymapManagerInitialized(boolean bl) {
        Companion companion = Companion;
        isKeymapManagerInitialized = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R,\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapManagerImpl$Companion;", "", "()V", "<set-?>", "", "isKeymapManagerInitialized", "isKeymapManagerInitialized$annotations", "()Z", "setKeymapManagerInitialized", "(Z)V", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void isKeymapManagerInitialized$annotations() {
        }

        public final boolean isKeymapManagerInitialized() {
            return isKeymapManagerInitialized;
        }

        private final void setKeymapManagerInitialized(boolean bl) {
            isKeymapManagerInitialized = bl;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isKeymapManagerInitialized$p(Companion $this) {
            return $this.isKeymapManagerInitialized();
        }

        public static final /* synthetic */ void access$setKeymapManagerInitialized$p(Companion $this, boolean bl) {
            $this.setKeymapManagerInitialized(bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

