/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutFilteringPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseActionsDialog
extends DialogWrapper {
    private final ActionsTree myActionsTree;
    private FilterComponent myFilterComponent;
    private final TreeExpansionMonitor myTreeExpansionMonitor;
    private final ShortcutFilteringPanel myFilteringPanel = new ShortcutFilteringPanel();
    private final Keymap myKeymap;
    private final QuickList[] myQuicklists;

    public ChooseActionsDialog(Component parent, Keymap keymap2, QuickList[] quicklists) {
        super(parent, true);
        this.myKeymap = keymap2;
        this.myQuicklists = quicklists;
        this.myActionsTree = new ActionsTree();
        this.myActionsTree.reset(keymap2, quicklists);
        this.myActionsTree.getTree().getSelectionModel().setSelectionMode(4);
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                ChooseActionsDialog.this.doOKAction();
                return true;
            }
        }.installOn(this.myActionsTree.getTree());
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        this.myFilteringPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                ChooseActionsDialog.this.filterTreeByShortcut(ChooseActionsDialog.this.myFilteringPanel.getShortcut());
            }
        });
        this.setTitle(IdeBundle.message("dialog.title.add.actions.to.quick.list", new Object[0]));
        this.init();
    }

    @Override
    protected JComponent createNorthPanel() {
        return this.createToolbarPanel();
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myFilterComponent.getTextEditor();
    }

    @Override
    protected JComponent createCenterPanel() {
        return JBUI.Panels.simplePanel(this.myActionsTree.getComponent()).withPreferredSize(400, 500);
    }

    public String[] getTreeSelectedActionIds() {
        TreePath[] paths = this.myActionsTree.getTree().getSelectionPaths();
        if (paths == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> actions = new ArrayList<String>();
        for (TreePath path2 : paths) {
            Object node = path2.getLastPathComponent();
            if (!(node instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode defNode = (DefaultMutableTreeNode)node;
            Object userObject = defNode.getUserObject();
            if (userObject instanceof String) {
                actions.add((String)userObject);
                continue;
            }
            if (!(userObject instanceof QuickList)) continue;
            actions.add(((QuickList)userObject).getActionId());
        }
        return ArrayUtilRt.toStringArray(actions);
    }

    private JPanel createToolbarPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("ChooseActionsDialog", group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = KeymapPanel.createTreeExpander(this.myActionsTree);
        group.add(commonActionsManager.createExpandAllAction(treeExpander, this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, this.myActionsTree.getTree()));
        panel2.add((Component)toolbar, "West");
        group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ChooseActionsDialog", group, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent searchToolbar = actionToolbar.getComponent();
        final Alarm alarm2 = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP_IN_QUICK_LISTS", 5){

            @Override
            public void filter() {
                alarm2.cancelAllRequests();
                alarm2.addRequest(() -> {
                    if (!ChooseActionsDialog.this.myFilterComponent.isShowing()) {
                        return;
                    }
                    if (!ChooseActionsDialog.this.myTreeExpansionMonitor.isFreeze()) {
                        ChooseActionsDialog.this.myTreeExpansionMonitor.freeze();
                    }
                    ChooseActionsDialog.this.myFilteringPanel.setShortcut(null);
                    String filter2 = this.getFilter();
                    ChooseActionsDialog.this.myActionsTree.filter(filter2, ChooseActionsDialog.this.myQuicklists);
                    JTree tree = ChooseActionsDialog.this.myActionsTree.getTree();
                    TreeUtil.expandAll(tree);
                    if (filter2 == null || filter2.length() == 0) {
                        TreeUtil.collapseAll(tree, 0);
                        ChooseActionsDialog.this.myTreeExpansionMonitor.restore();
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel2.add((Component)this.myFilterComponent, "Center");
        group.add(new AnAction(KeyMapBundle.message("filter.shortcut.action.text", new Object[0]), KeyMapBundle.message("filter.shortcut.action.text", new Object[0]), AllIcons.Actions.ShortcutFilter){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                ChooseActionsDialog.this.myFilterComponent.reset();
                ChooseActionsDialog.this.myActionsTree.reset(ChooseActionsDialog.this.myKeymap, ChooseActionsDialog.this.myQuicklists);
                ChooseActionsDialog.this.myFilteringPanel.showPopup(searchToolbar, e.getInputEvent().getComponent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/ChooseActionsDialog$4", "actionPerformed"));
            }
        });
        group.add(new AnAction(KeyMapBundle.message("filter.clear.action.text", new Object[0]), KeyMapBundle.message("filter.clear.action.text", new Object[0]), AllIcons.Actions.GC){

            @Override
            public void update(@NotNull AnActionEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                boolean enabled = null != ChooseActionsDialog.this.myFilteringPanel.getShortcut();
                Presentation presentation = event.getPresentation();
                presentation.setEnabled(enabled);
                presentation.setIcon(enabled ? AllIcons.Actions.Cancel : EmptyIcon.ICON_16);
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                ChooseActionsDialog.this.myFilteringPanel.setShortcut(null);
                ChooseActionsDialog.this.myActionsTree.filter(null, ChooseActionsDialog.this.myQuicklists);
                TreeUtil.collapseAll(ChooseActionsDialog.this.myActionsTree.getTree(), 0);
                ChooseActionsDialog.this.myTreeExpansionMonitor.restore();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ChooseActionsDialog$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        panel2.add((Component)searchToolbar, "East");
        return panel2;
    }

    private void filterTreeByShortcut(Shortcut shortcut) {
        if (!this.myTreeExpansionMonitor.isFreeze()) {
            this.myTreeExpansionMonitor.freeze();
        }
        this.myActionsTree.reset(this.myKeymap, this.myQuicklists);
        this.myActionsTree.filterTree(shortcut, this.myQuicklists);
        JTree tree = this.myActionsTree.getTree();
        TreeUtil.expandAll(tree);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myFilteringPanel.hidePopup();
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
    }
}

