/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeyboardSettingsExternalizable;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.SystemShortcuts;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.keymap.impl.ui.KeymapSelector;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.ShortcutFilteringPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.util.Alarm;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll,
KeymapListener,
Disposable {
    private JCheckBox preferKeyPositionOverCharOption;
    private final KeymapSelector myKeymapSelector = new KeymapSelector(this::currentKeymapChanged);
    private final KeymapSchemeManager myManager = this.myKeymapSelector.getManager();
    private final ActionsTree myActionsTree = new ActionsTree();
    private FilterComponent myFilterComponent;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private final ShortcutFilteringPanel myFilteringPanel = new ShortcutFilteringPanel();
    private boolean myQuickListsModified = false;
    private QuickList[] myQuickLists = QuickListsManager.getInstance().getAllQuickLists();
    private ShowFNKeysSettingWrapper myShowFN;
    private boolean myShowOnlyConflicts;
    private JPanel mySystemShortcutConflictsPanel;
    private ToggleActionButton myShowOnlyConflictsButton;

    public KeymapPanel() {
        this(false);
    }

    public KeymapPanel(boolean showOnlyConflicts) {
        this.myShowOnlyConflicts = showOnlyConflicts;
        this.setLayout(new BorderLayout());
        JPanel keymapPanel = new JPanel(new BorderLayout());
        keymapPanel.add(this.myManager.getSchemesPanel(), "North");
        keymapPanel.add((Component)this.createKeymapSettingsPanel(), "Center");
        IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (ideFrame != null && KeyboardSettingsExternalizable.isSupportedKeyboardLayout(ideFrame.getComponent())) {
            this.preferKeyPositionOverCharOption = new JCheckBox(new AbstractAction(KeyMapBundle.message("prefer.key.position", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardSettingsExternalizable.getInstance().setPreferKeyPositionOverCharOption(KeymapPanel.this.preferKeyPositionOverCharOption.isSelected());
                    VMOptions.writeOption("com.jetbrains.use.old.keyevent.processing", "=", Boolean.toString(KeyboardSettingsExternalizable.getInstance().isPreferKeyPositionOverCharOption()));
                    ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().restart(), ModalityState.NON_MODAL);
                }
            });
            this.preferKeyPositionOverCharOption.setBorder(JBUI.Borders.empty());
            keymapPanel.add((Component)this.preferKeyPositionOverCharOption, "South");
        }
        this.add((Component)keymapPanel, "Center");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null && KeymapPanel.this.myQuickListsModified) {
                    KeymapPanel.this.currentKeymapChanged();
                    KeymapPanel.this.myQuickListsModified = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "propertyChange"));
            }
        });
        this.myFilteringPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                KeymapPanel.this.filterTreeByShortcut(KeymapPanel.this.myFilteringPanel.getShortcut());
            }
        });
        this.mySystemShortcutConflictsPanel = new JPanel(new FlowLayout(0, 0, 5));
        this.add((Component)this.mySystemShortcutConflictsPanel, "South");
    }

    private void fillConflictsPanel(@NotNull Keymap keymap2) {
        if (keymap2 == null) {
            KeymapPanel.$$$reportNull$$$0(0);
        }
        this.mySystemShortcutConflictsPanel.removeAll();
        SystemShortcuts systemShortcuts = SystemShortcuts.getInstance();
        @NotNull Collection<SystemShortcuts.ConflictItem> allConflicts = systemShortcuts.getUnmutedKeymapConflicts();
        if (allConflicts.isEmpty()) {
            return;
        }
        String htmlBody = "";
        final HashMap<String, Runnable> href2linkAction = new HashMap<String, Runnable>();
        int count = 0;
        boolean empty = true;
        for (SystemShortcuts.ConflictItem conf : allConflicts) {
            String actText;
            String actId = conf.getActionIds()[0];
            href2linkAction.put(actId, () -> {
                KeyboardShortcut confShortcut = KeymapPanel.findKeyboardShortcut(keymap2, conf.getSysKeyStroke(), actId);
                KeymapPanel.addKeyboardShortcut(actId, ActionShortcutRestrictions.getInstance().getForActionId(actId), keymap2, (Component)this, confShortcut, systemShortcuts, this.myQuickLists);
            });
            AnAction act = ActionManager.getInstance().getAction(actId);
            String string = actText = act == null ? actId : act.getTemplateText();
            if (!empty) {
                htmlBody = htmlBody + ", ";
            }
            htmlBody = htmlBody + "<a href='" + actId + "'>" + actText + "</a>";
            empty = false;
            if (++count <= 2) continue;
            break;
        }
        if (count > 2 && allConflicts.size() > count) {
            @NotNull String text2 = String.format("%d more", allConflicts.size() - count);
            htmlBody = htmlBody + " and <a href='" + text2 + "'>" + text2 + "</a>";
            href2linkAction.put(text2, () -> {
                this.myShowOnlyConflicts = true;
                this.myActionsTree.setBaseFilter(systemShortcuts.createKeymapConflictsActionFilter());
                this.myActionsTree.filter(null, this.myQuickLists);
                TreeUtil.expandAll(this.myActionsTree.getTree());
            });
        }
        htmlBody = htmlBody + " shortcuts conflict with macOS system shortcuts.<br>Modify shortcuts or change macOS system settings.</p></html>";
        JBLabel jbLabel = new JBLabel(KeymapPanel.createWarningHtmlText(htmlBody)){

            @Override
            @NotNull
            protected HyperlinkListener createHyperlinkListener() {
                return new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        String href;
                        Runnable act;
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (act = (Runnable)href2linkAction.get(href = e.getDescription())) != null) {
                            act.run();
                        }
                    }
                };
            }
        };
        jbLabel.setCopyable(true);
        jbLabel.setAllowAutoWrapping(true);
        jbLabel.setIconWithAlignment(AllIcons.General.Warning, 2, 1);
        this.mySystemShortcutConflictsPanel.add(jbLabel);
        this.validate();
        this.repaint();
    }

    private static String createWarningHtmlText(@Nullable String htmlBody) {
        if (htmlBody == null) {
            return null;
        }
        String css = "<head><style type=\"text/css\">\na, a:link {color:#" + ColorUtil.toHex(JBUI.CurrentTheme.Link.linkColor()) + ";}\na:visited {color:#" + ColorUtil.toHex(JBUI.CurrentTheme.Link.linkVisitedColor()) + ";}\na:hover {color:#" + ColorUtil.toHex(JBUI.CurrentTheme.Link.linkHoverColor()) + ";}\na:active {color:#" + ColorUtil.toHex(JBUI.CurrentTheme.Link.linkPressedColor()) + ";}\n</style>\n</head>";
        return String.format("<html>" + css + "<body><div>%s</div></body></html>", htmlBody);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myFilteringPanel != null) {
            SwingUtilities.updateComponentTreeUI(this.myFilteringPanel);
        }
    }

    @Override
    public void quickListRenamed(@NotNull QuickList oldQuickList, @NotNull QuickList newQuickList) {
        if (oldQuickList == null) {
            KeymapPanel.$$$reportNull$$$0(1);
        }
        if (newQuickList == null) {
            KeymapPanel.$$$reportNull$$$0(2);
        }
        this.myManager.visitMutableKeymaps(keymap2 -> {
            String actionId = oldQuickList.getActionId();
            Shortcut[] shortcuts = keymap2.getShortcuts(actionId);
            if (shortcuts.length != 0) {
                String newActionId = newQuickList.getActionId();
                for (Shortcut shortcut : shortcuts) {
                    keymap2.removeShortcut(actionId, shortcut);
                    keymap2.addShortcut(newActionId, shortcut);
                }
            }
        });
        this.myQuickListsModified = true;
    }

    @Override
    public Runnable enableSearch(String option2) {
        return () -> this.showOption(option2);
    }

    @Override
    public void processCurrentKeymapChanged() {
        this.currentKeymapChanged();
    }

    @Override
    public void processCurrentKeymapChanged(QuickList @NotNull [] ids) {
        if (ids == null) {
            KeymapPanel.$$$reportNull$$$0(3);
        }
        this.myQuickLists = ids;
        this.currentKeymapChanged();
    }

    private void currentKeymapChanged() {
        this.currentKeymapChanged(this.myManager.getSelectedKeymap());
    }

    private void currentKeymapChanged(Keymap selectedKeymap) {
        if (selectedKeymap == null) {
            selectedKeymap = new KeymapImpl();
        }
        SystemShortcuts systemShortcuts = SystemShortcuts.getInstance();
        systemShortcuts.updateKeymapConflicts(selectedKeymap);
        this.myShowOnlyConflictsButton.setVisible(!systemShortcuts.getUnmutedKeymapConflicts().isEmpty());
        this.myActionsTree.setBaseFilter(this.myShowOnlyConflicts ? systemShortcuts.createKeymapConflictsActionFilter() : null);
        this.myActionsTree.reset(selectedKeymap, this.myQuickLists);
        this.fillConflictsPanel(selectedKeymap);
    }

    private JPanel createKeymapSettingsPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.createToolbarPanel(), "North");
        panel2.add((Component)this.myActionsTree.getComponent(), "Center");
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                KeymapPanel.this.editSelection(e, true);
                return true;
            }
        }.installOn(this.myActionsTree.getTree());
        this.myActionsTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (TouchBarsManager.isTouchBarAvailable()) {
            this.myShowFN = new ShowFNKeysSettingWrapper();
            if (this.myShowFN.getCheckbox() != null) {
                panel2.add((Component)this.myShowFN.getCheckbox(), "South");
            }
            Disposer.register(this, this.myShowFN);
        }
        return panel2;
    }

    private JPanel createToolbarPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("KeymapEdit", group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = KeymapPanel.createTreeExpander(this.myActionsTree);
        group.add(commonActionsManager.createExpandAllAction(treeExpander, this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, this.myActionsTree.getTree()));
        group.add(new AnAction(IdeBundle.message("action.text.edit.shortcut", new Object[0]), IdeBundle.message("action.text.edit.shortcut", new Object[0]), AllIcons.Actions.Edit){
            {
                this.registerCustomShortcutSet(CommonShortcuts.ENTER, KeymapPanel.this.myActionsTree.getTree());
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
                e.getPresentation().setEnabled(actionId != null);
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                KeymapPanel.this.editSelection(e.getInputEvent(), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myShowOnlyConflictsButton = new ToggleActionButton(KeyMapBundle.messagePointer("action.AnActionButton.text.show.conflicts.with.system.shortcuts", new Object[0]), AllIcons.General.ShowWarning){

            @Override
            public boolean isSelected(AnActionEvent e) {
                return KeymapPanel.this.myShowOnlyConflicts;
            }

            @Override
            public void setSelected(AnActionEvent e, boolean state) {
                KeymapPanel.this.myShowOnlyConflicts = state;
                KeymapPanel.this.myActionsTree.setBaseFilter(KeymapPanel.this.myShowOnlyConflicts ? SystemShortcuts.getInstance().createKeymapConflictsActionFilter() : null);
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
                JTree tree = KeymapPanel.this.myActionsTree.getTree();
                if (KeymapPanel.this.myShowOnlyConflicts) {
                    TreeUtil.expandAll(tree);
                } else {
                    TreeUtil.collapseAll(tree, 0);
                }
            }
        };
        group.add(this.myShowOnlyConflictsButton);
        panel2.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, JBUI.insetsTop(8), 0, 0));
        group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Keymap", group, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent searchToolbar = actionToolbar.getComponent();
        final Alarm alarm2 = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP", 5){

            @Override
            public void filter() {
                alarm2.cancelAllRequests();
                alarm2.addRequest(() -> {
                    if (!KeymapPanel.this.myFilterComponent.isShowing()) {
                        return;
                    }
                    KeymapPanel.this.myTreeExpansionMonitor.freeze();
                    KeymapPanel.this.myFilteringPanel.setShortcut(null);
                    String filter2 = this.getFilter();
                    KeymapPanel.this.myActionsTree.filter(filter2, KeymapPanel.this.myQuickLists);
                    JTree tree = KeymapPanel.this.myActionsTree.getTree();
                    TreeUtil.expandAll(tree);
                    if (filter2 == null || filter2.length() == 0) {
                        TreeUtil.collapseAll(tree, 0);
                        KeymapPanel.this.myTreeExpansionMonitor.restore();
                    } else {
                        KeymapPanel.this.myTreeExpansionMonitor.unfreeze();
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel2.add((Component)this.myFilterComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, JBUI.insetsTop(8), 0, 0));
        group.add(new DumbAwareAction(KeyMapBundle.message("filter.shortcut.action.text", new Object[0]), KeyMapBundle.message("filter.shortcut.action.text", new Object[0]), AllIcons.Actions.ShortcutFilter){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                KeymapPanel.this.myFilterComponent.reset();
                KeymapPanel.this.currentKeymapChanged();
                KeymapPanel.this.myFilteringPanel.showPopup(searchToolbar, e.getInputEvent().getComponent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$10", "actionPerformed"));
            }
        });
        group.add(new DumbAwareAction(KeyMapBundle.message("filter.clear.action.text", new Object[0]), KeyMapBundle.message("filter.clear.action.text", new Object[0]), AllIcons.Actions.GC){

            @Override
            public void update(@NotNull AnActionEvent event) {
                if (event == null) {
                    11.$$$reportNull$$$0(0);
                }
                boolean enabled = null != KeymapPanel.this.myFilteringPanel.getShortcut();
                Presentation presentation = event.getPresentation();
                presentation.setEnabled(enabled);
                presentation.setIcon(enabled ? AllIcons.Actions.Cancel : EmptyIcon.ICON_16);
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(1);
                }
                KeymapPanel.this.myTreeExpansionMonitor.freeze();
                KeymapPanel.this.myFilteringPanel.setShortcut(null);
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
                TreeUtil.collapseAll(KeymapPanel.this.myActionsTree.getTree(), 0);
                KeymapPanel.this.myTreeExpansionMonitor.restore();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        panel2.add((Component)searchToolbar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, JBUI.insetsTop(8), 0, 0));
        return panel2;
    }

    @NotNull
    public static TreeExpander createTreeExpander(final ActionsTree actionsTree) {
        return new TreeExpander(){

            @Override
            public void expandAll() {
                TreeUtil.expandAll(actionsTree.getTree());
            }

            @Override
            public boolean canExpand() {
                return true;
            }

            @Override
            public void collapseAll() {
                TreeUtil.collapseAll(actionsTree.getTree(), 0);
            }

            @Override
            public boolean canCollapse() {
                return true;
            }
        };
    }

    private void filterTreeByShortcut(Shortcut shortcut) {
        boolean wasFreezed = this.myTreeExpansionMonitor.isFreeze();
        if (!wasFreezed) {
            this.myTreeExpansionMonitor.freeze();
        }
        this.myActionsTree.filterTree(shortcut, this.myQuickLists);
        JTree tree = this.myActionsTree.getTree();
        TreeUtil.expandAll(tree);
        if (!wasFreezed) {
            this.myTreeExpansionMonitor.restore();
        }
    }

    public void showOption(String option2) {
        this.currentKeymapChanged();
        this.myFilterComponent.setFilter(option2);
        this.myFilteringPanel.setShortcut(null);
        this.myActionsTree.filter(option2, this.myQuickLists);
    }

    public static void addKeyboardShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(4);
        }
        if (restrictions == null) {
            KeymapPanel.$$$reportNull$$$0(5);
        }
        if (keymapSelected == null) {
            KeymapPanel.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            KeymapPanel.$$$reportNull$$$0(7);
        }
        if (quickLists == null) {
            KeymapPanel.$$$reportNull$$$0(8);
        }
        KeymapPanel.addKeyboardShortcut(actionId, restrictions, keymapSelected, parent, null, null, quickLists);
    }

    public static void addKeyboardShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, @Nullable KeyboardShortcut selectedShortcut, @Nullable SystemShortcuts systemShortcuts, QuickList ... quickLists) {
        Keymap keymap2;
        Map<KeyboardShortcut, String> kscs;
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(9);
        }
        if (restrictions == null) {
            KeymapPanel.$$$reportNull$$$0(10);
        }
        if (keymapSelected == null) {
            KeymapPanel.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            KeymapPanel.$$$reportNull$$$0(12);
        }
        if (quickLists == null) {
            KeymapPanel.$$$reportNull$$$0(13);
        }
        if (!restrictions.allowKeyboardShortcut) {
            return;
        }
        KeyboardShortcutDialog dialog2 = new KeyboardShortcutDialog(parent, restrictions.allowKeyboardSecondStroke, systemShortcuts == null ? null : systemShortcuts.createKeystroke2SysShortcutMap());
        KeyboardShortcut keyboardShortcut = dialog2.showAndGet(actionId, keymapSelected, selectedShortcut, quickLists);
        if (keyboardShortcut == null) {
            return;
        }
        SafeKeymapAccessor accessor = new SafeKeymapAccessor(parent, keymapSelected);
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                Keymap keymap3 = accessor.keymap();
                Map<String, List<KeyboardShortcut>> conflicts = keymap3.getConflicts(actionId, keyboardShortcut);
                for (String id2 : conflicts.keySet()) {
                    for (KeyboardShortcut s : conflicts.get(id2)) {
                        keymap3.removeShortcut(id2, s);
                    }
                }
            } else if (result2 != 1) {
                return;
            }
        }
        if (systemShortcuts != null && (kscs = systemShortcuts.calculateConflicts(keymap2 = accessor.keymap(), actionId)) != null && !kscs.isEmpty()) {
            for (KeyboardShortcut ksc : kscs.keySet()) {
                int result3;
                String keyDesc = StringUtil.notNullize(KeymapUtil.getKeystrokeText(ksc.getFirstKeyStroke()));
                if (ksc.getSecondKeyStroke() != null) {
                    keyDesc = keyDesc + ", " + KeymapUtil.getKeystrokeText(ksc.getSecondKeyStroke());
                }
                if ((result3 = Messages.showYesNoCancelDialog(parent, IdeBundle.message("message.action.shortcut.0.is.already.assigned.to.system.action.1.do.you.want.to.remove.this.shortcut", keyDesc, kscs.get(ksc)), KeyMapBundle.message("conflict.shortcut.dialog.title", new Object[0]), KeyMapBundle.message("conflict.shortcut.dialog.remove.button", new Object[0]), KeyMapBundle.message("conflict.shortcut.dialog.leave.button", new Object[0]), KeyMapBundle.message("conflict.shortcut.dialog.cancel.button", new Object[0]), Messages.getWarningIcon())) != 0) continue;
                keymap2.removeShortcut(actionId, ksc);
            }
        }
        accessor.add(actionId, keyboardShortcut);
        if (systemShortcuts != null) {
            systemShortcuts.updateKeymapConflicts(accessor.keymap());
        }
    }

    private static void addMouseShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(14);
        }
        if (restrictions == null) {
            KeymapPanel.$$$reportNull$$$0(15);
        }
        if (keymapSelected == null) {
            KeymapPanel.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            KeymapPanel.$$$reportNull$$$0(17);
        }
        if (quickLists == null) {
            KeymapPanel.$$$reportNull$$$0(18);
        }
        if (!restrictions.allowMouseShortcut) {
            return;
        }
        MouseShortcutDialog dialog2 = new MouseShortcutDialog(parent, restrictions.allowMouseDoubleClick);
        MouseShortcut mouseShortcut = (MouseShortcut)dialog2.showAndGet(actionId, keymapSelected, quickLists);
        if (mouseShortcut == null) {
            return;
        }
        SafeKeymapAccessor accessor = new SafeKeymapAccessor(parent, keymapSelected);
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                Keymap keymap2 = accessor.keymap();
                for (String id2 : keymap2.getActionIds(mouseShortcut)) {
                    keymap2.removeShortcut(id2, mouseShortcut);
                }
            } else if (result2 != 1) {
                return;
            }
        }
        accessor.add(actionId, mouseShortcut);
    }

    private void repaintLists() {
        this.myActionsTree.getComponent().repaint();
    }

    @Override
    @NotNull
    public String getId() {
        return "preferences.keymap";
    }

    @Override
    public void reset() {
        if (this.preferKeyPositionOverCharOption != null) {
            this.preferKeyPositionOverCharOption.setSelected(KeyboardSettingsExternalizable.getInstance().isPreferKeyPositionOverCharOption());
        }
        this.myManager.reset();
    }

    @Override
    public void apply() throws ConfigurationException {
        String error = this.myManager.apply();
        if (error != null) {
            throw new ConfigurationException(error);
        }
        ActionToolbarImpl.updateAllToolbarsImmediately();
        if (this.myShowFN != null) {
            this.myShowFN.applyChanges();
        }
    }

    @Override
    public boolean isModified() {
        return this.myManager.isModified() || this.myShowFN != null && this.myShowFN.isModified();
    }

    public void selectAction(String actionId) {
        this.myActionsTree.selectAction(actionId);
    }

    @Override
    @Nls
    public String getDisplayName() {
        return KeyMapBundle.message("keymap.display.name", new Object[0]);
    }

    @Override
    public String getHelpTopic() {
        return "preferences.keymap";
    }

    @Override
    public JComponent createComponent() {
        this.myKeymapSelector.attachKeymapListener(this);
        ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(CHANGE_TOPIC, this);
        return this;
    }

    @Override
    public void disposeUIResources() {
        this.myFilteringPanel.hidePopup();
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
        Disposer.dispose(this);
    }

    @Override
    public void dispose() {
    }

    public Shortcut @Nullable [] getCurrentShortcuts(@NotNull String actionId) {
        Keymap keymap2;
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(19);
        }
        return (keymap2 = this.myManager.getSelectedKeymap()) == null ? null : keymap2.getShortcuts(actionId);
    }

    private void editSelection(InputEvent e, boolean isDoubleClick) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        Keymap selectedKeymap = this.myManager.getSelectedKeymap();
        if (selectedKeymap == null) {
            return;
        }
        DefaultActionGroup group = this.createEditActionGroup(actionId, selectedKeymap);
        if (e instanceof MouseEvent && ((MouseEvent)e).isPopupTrigger()) {
            ActionManager.getInstance().createActionPopupMenu("unknown", group).getComponent().show(e.getComponent(), ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        } else if (!isDoubleClick || !ActionManager.getInstance().isGroup(actionId)) {
            DataContext dataContext = DataManager.getInstance().getDataContext(this);
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message("popup.title.edit.shortcuts", new Object[0]), group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            if (e instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)e));
            } else {
                popup2.showInBestPositionFor(dataContext);
            }
        }
    }

    @NotNull
    private DefaultActionGroup createEditActionGroup(final @NotNull String actionId, final Keymap selectedKeymap) {
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(20);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        final ShortcutRestrictions restrictions = ActionShortcutRestrictions.getInstance().getForActionId(actionId);
        if (restrictions.allowKeyboardShortcut) {
            group.add(new DumbAwareAction(IdeBundle.messagePointer("action.Anonymous.text.add.keyboard.shortcut", new Object[0])){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        13.$$$reportNull$$$0(0);
                    }
                    KeymapPanel.addKeyboardShortcut(actionId, restrictions, selectedKeymap, (Component)KeymapPanel.this, null, SystemShortcuts.getInstance(), KeymapPanel.this.myQuickLists);
                    KeymapPanel.this.currentKeymapChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$13", "actionPerformed"));
                }
            });
        }
        if (restrictions.allowMouseShortcut) {
            group.add(new DumbAwareAction(IdeBundle.messagePointer("action.Anonymous.text.add.mouse.shortcut", new Object[0])){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        14.$$$reportNull$$$0(0);
                    }
                    KeymapPanel.addMouseShortcut(actionId, restrictions, selectedKeymap, KeymapPanel.this, KeymapPanel.this.myQuickLists);
                    KeymapPanel.this.currentKeymapChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$14", "actionPerformed"));
                }
            });
        }
        if (Registry.is("actionSystem.enableAbbreviations") && restrictions.allowAbbreviation) {
            group.add(new DumbAwareAction(IdeBundle.messagePointer("action.Anonymous.text.add.abbreviation", new Object[0])){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    String abbr;
                    if (e == null) {
                        15.$$$reportNull$$$0(0);
                    }
                    if ((abbr = Messages.showInputDialog(IdeBundle.message("label.enter.new.abbreviation", new Object[0]), IdeBundle.message("dialog.title.abbreviation", new Object[0]), null)) != null) {
                        AbbreviationManager.getInstance().register(abbr, actionId);
                        KeymapPanel.this.repaintLists();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$15", "actionPerformed"));
                }
            });
        }
        group.addSeparator();
        for (final Shortcut shortcut : selectedKeymap.getShortcuts(actionId)) {
            group.add(new DumbAwareAction(IdeBundle.message("action.text.remove.0", KeymapUtil.getShortcutText(shortcut))){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        16.$$$reportNull$$$0(0);
                    }
                    Keymap keymap2 = KeymapPanel.this.myManager.getMutableKeymap(selectedKeymap);
                    keymap2.removeShortcut(actionId, shortcut);
                    if (StringUtil.startsWithChar(actionId, '$')) {
                        keymap2.removeShortcut(KeyMapBundle.message("editor.shortcut", actionId.substring(1)), shortcut);
                    }
                    KeymapPanel.this.currentKeymapChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$16", "actionPerformed"));
                }
            });
        }
        if (Registry.is("actionSystem.enableAbbreviations")) {
            for (final String abbreviation : AbbreviationManager.getInstance().getAbbreviations(actionId)) {
                group.addAction(new DumbAwareAction(IdeBundle.message("action.text.remove.abbreviation.0", abbreviation)){

                    @Override
                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            17.$$$reportNull$$$0(0);
                        }
                        AbbreviationManager.getInstance().remove(abbreviation, actionId);
                        KeymapPanel.this.repaintLists();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$17", "actionPerformed"));
                    }
                });
            }
        }
        if (this.myManager.canResetActionInKeymap(selectedKeymap, actionId)) {
            group.add(new Separator());
            group.add(new DumbAwareAction(IdeBundle.messagePointer("action.Anonymous.text.reset.shortcuts", new Object[0])){

                @Override
                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        18.$$$reportNull$$$0(0);
                    }
                    KeymapPanel.this.myManager.resetActionInKeymap(selectedKeymap, actionId);
                    KeymapPanel.this.repaintLists();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$18", "actionPerformed"));
                }
            });
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            KeymapPanel.$$$reportNull$$$0(21);
        }
        return defaultActionGroup;
    }

    private static int showConfirmationDialog(Component parent) {
        return Messages.showYesNoCancelDialog(parent, KeyMapBundle.message("conflict.shortcut.dialog.message", new Object[0]), KeyMapBundle.message("conflict.shortcut.dialog.title", new Object[0]), KeyMapBundle.message("conflict.shortcut.dialog.remove.button", new Object[0]), KeyMapBundle.message("conflict.shortcut.dialog.leave.button", new Object[0]), KeyMapBundle.message("conflict.shortcut.dialog.cancel.button", new Object[0]), Messages.getWarningIcon());
    }

    @Nullable
    private static KeyboardShortcut findKeyboardShortcut(@NotNull Keymap keymap2, @NotNull KeyStroke ks, @NotNull String actionId) {
        Shortcut[] actionShortcuts;
        if (keymap2 == null) {
            KeymapPanel.$$$reportNull$$$0(22);
        }
        if (ks == null) {
            KeymapPanel.$$$reportNull$$$0(23);
        }
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(24);
        }
        if ((actionShortcuts = keymap2.getShortcuts(actionId)) == null || actionShortcuts.length == 0) {
            return null;
        }
        for (Shortcut sc : actionShortcuts) {
            KeyboardShortcut ksc;
            if (!(sc instanceof KeyboardShortcut) || !ks.equals((ksc = (KeyboardShortcut)sc).getFirstKeyStroke()) && !ks.equals(ksc.getSecondKeyStroke())) continue;
            return ksc;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldQuickList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQuickList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictions";
                break;
            }
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapSelected";
                break;
            }
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickLists";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillConflictsPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "quickListRenamed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processCurrentKeymapChanged";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addKeyboardShortcut";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addMouseShortcut";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentShortcuts";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createEditActionGroup";
                break;
            }
            case 21: {
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findKeyboardShortcut";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SafeKeymapAccessor {
        private final Component parent;
        private final Keymap selected;
        private KeymapSchemeManager manager;
        private Keymap mutable;

        SafeKeymapAccessor(@NotNull Component parent, @NotNull Keymap selected2) {
            if (parent == null) {
                SafeKeymapAccessor.$$$reportNull$$$0(0);
            }
            if (selected2 == null) {
                SafeKeymapAccessor.$$$reportNull$$$0(1);
            }
            this.parent = parent;
            this.selected = selected2;
        }

        Keymap keymap() {
            if (this.mutable == null) {
                if (this.parent instanceof KeymapPanel) {
                    KeymapPanel panel2 = (KeymapPanel)this.parent;
                    this.mutable = panel2.myManager.getMutableKeymap(this.selected);
                } else {
                    if (this.manager == null) {
                        this.manager = new KeymapSelector(selectedKeymap -> {}).getManager();
                        this.manager.reset();
                    }
                    this.mutable = this.manager.getMutableKeymap(this.selected);
                }
            }
            return this.mutable;
        }

        void add(@NotNull String actionId, @NotNull Shortcut newShortcut) {
            Shortcut[] shortcuts;
            if (actionId == null) {
                SafeKeymapAccessor.$$$reportNull$$$0(2);
            }
            if (newShortcut == null) {
                SafeKeymapAccessor.$$$reportNull$$$0(3);
            }
            Keymap keymap2 = this.keymap();
            for (Shortcut shortcut : shortcuts = keymap2.getShortcuts(actionId)) {
                if (!shortcut.equals(newShortcut)) continue;
                if (this.manager != null) {
                    this.manager.apply();
                }
                return;
            }
            keymap2.addShortcut(actionId, newShortcut);
            if (StringUtil.startsWithChar(actionId, '$')) {
                keymap2.addShortcut(KeyMapBundle.message("editor.shortcut", actionId.substring(1)), newShortcut);
            }
            if (this.manager != null) {
                this.manager.apply();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newShortcut";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$SafeKeymapAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShowFNKeysSettingWrapper
    implements Disposable {
        private boolean myShowFnInitial = false;
        private JCheckBox myCheckbox = null;
        private volatile boolean myDisposed;

        ShowFNKeysSettingWrapper() {
            if (TouchBarsManager.isTouchBarAvailable()) {
                String appId = Utils.getAppId();
                if (appId != null && !appId.isEmpty()) {
                    this.myShowFnInitial = NSDefaults.isShowFnKeysEnabled(appId);
                    this.myCheckbox = new JCheckBox(KeyMapBundle.message("keymap.show.f.on.touch.bar", new Object[0]), this.myShowFnInitial);
                } else {
                    Logger.getInstance(KeymapPanel.class).error("can't obtain application id from NSBundle");
                }
            }
        }

        JCheckBox getCheckbox() {
            return this.myCheckbox;
        }

        boolean isModified() {
            return this.myCheckbox == null ? false : this.myShowFnInitial != this.myCheckbox.isSelected();
        }

        void applyChanges() {
            if (!TouchBarsManager.isTouchBarAvailable() || this.myCheckbox == null || !this.isModified()) {
                return;
            }
            String appId = Utils.getAppId();
            if (appId == null || appId.isEmpty()) {
                Logger.getInstance(KeymapPanel.class).error("can't obtain application id from NSBundle");
                return;
            }
            boolean prevVal = this.myShowFnInitial;
            this.myShowFnInitial = this.myCheckbox.isSelected();
            NSDefaults.setShowFnKeysEnabled(appId, this.myShowFnInitial);
            if (this.myShowFnInitial != NSDefaults.isShowFnKeysEnabled(appId)) {
                NSDefaults.setShowFnKeysEnabled(appId, this.myShowFnInitial, true);
                if (this.myShowFnInitial != NSDefaults.isShowFnKeysEnabled(appId)) {
                    return;
                }
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                boolean result2 = Utils.restartTouchBarServer();
                if (!result2) {
                    this.myShowFnInitial = prevVal;
                    NSDefaults.setShowFnKeysEnabled(appId, this.myShowFnInitial);
                    if (!this.myDisposed) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!this.myDisposed) {
                                this.myCheckbox.setSelected(prevVal);
                            }
                        }, ModalityState.stateForComponent(this.myCheckbox));
                    }
                }
            });
        }

        @Override
        public void dispose() {
            if (!this.myDisposed) {
                this.myDisposed = true;
                this.myCheckbox = null;
            }
        }
    }
}

