/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.options.Scheme;
import org.jetbrains.annotations.NotNull;

final class KeymapScheme
implements Scheme {
    private final KeymapImpl original;
    private KeymapImpl mutable;

    KeymapScheme(@NotNull Keymap keymap2) {
        if (keymap2 == null) {
            KeymapScheme.$$$reportNull$$$0(0);
        }
        this.original = (KeymapImpl)keymap2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getCurrent().getPresentableName();
        if (string == null) {
            KeymapScheme.$$$reportNull$$$0(1);
        }
        return string;
    }

    void setName(@NotNull String name) {
        if (name == null) {
            KeymapScheme.$$$reportNull$$$0(2);
        }
        this.getMutable().setName(name);
    }

    Keymap getParent() {
        return !this.isMutable() ? null : this.original.getParent();
    }

    @NotNull
    Keymap getOriginal() {
        KeymapImpl keymapImpl = this.original;
        if (keymapImpl == null) {
            KeymapScheme.$$$reportNull$$$0(3);
        }
        return keymapImpl;
    }

    @NotNull
    KeymapImpl getCurrent() {
        KeymapImpl keymapImpl = this.mutable != null ? this.mutable : this.original;
        if (keymapImpl == null) {
            KeymapScheme.$$$reportNull$$$0(4);
        }
        return keymapImpl;
    }

    @NotNull
    KeymapImpl getMutable() {
        if (this.mutable != null) {
            KeymapImpl keymapImpl = this.mutable;
            if (keymapImpl == null) {
                KeymapScheme.$$$reportNull$$$0(5);
            }
            return keymapImpl;
        }
        assert (this.isMutable()) : "create a mutable copy for immutable keymap";
        KeymapImpl keymapImpl = this.mutable = this.original.copyTo(new KeymapImpl());
        if (keymapImpl == null) {
            KeymapScheme.$$$reportNull$$$0(6);
        }
        return keymapImpl;
    }

    boolean isMutable() {
        return this.original.canModify();
    }

    boolean contains(@NotNull Keymap keymap2) {
        if (keymap2 == null) {
            KeymapScheme.$$$reportNull$$$0(7);
        }
        return keymap2 == this.original || keymap2 == this.mutable;
    }

    private static boolean contains(@NotNull Keymap keymap2, @NotNull String name) {
        if (keymap2 == null) {
            KeymapScheme.$$$reportNull$$$0(8);
        }
        if (name == null) {
            KeymapScheme.$$$reportNull$$$0(9);
        }
        return name.equals(keymap2.getName()) || name.equals(keymap2.getPresentableName());
    }

    boolean contains(@NotNull String name) {
        if (name == null) {
            KeymapScheme.$$$reportNull$$$0(10);
        }
        return KeymapScheme.contains(this.original, name) || this.mutable != null && KeymapScheme.contains(this.mutable, name);
    }

    boolean canReset() {
        return this.isMutable() && this.getCurrent().getOwnActionIds().length > 0;
    }

    void reset() {
        assert (this.canReset()) : "reset all modified shortcuts unexpectedly";
        this.getMutable().clearOwnActionsIds();
    }

    boolean canReset(@NotNull String actionId) {
        if (actionId == null) {
            KeymapScheme.$$$reportNull$$$0(11);
        }
        return this.isMutable() && this.getCurrent().hasOwnActionId(actionId);
    }

    void reset(@NotNull String actionId) {
        if (actionId == null) {
            KeymapScheme.$$$reportNull$$$0(12);
        }
        assert (this.canReset(actionId)) : "reset modified action shortcuts unexpectedly";
        this.getMutable().clearOwnActionsId(actionId);
    }

    @NotNull
    Keymap apply() {
        if (this.mutable != null) {
            this.mutable.copyTo(this.original);
        }
        KeymapImpl keymapImpl = this.original;
        if (keymapImpl == null) {
            KeymapScheme.$$$reportNull$$$0(13);
        }
        return keymapImpl;
    }

    @NotNull
    KeymapScheme copy(@NotNull String name) {
        if (name == null) {
            KeymapScheme.$$$reportNull$$$0(14);
        }
        KeymapImpl keymap2 = this.original.deriveKeymap(name);
        if (this.mutable != null) {
            this.mutable.copyTo(keymap2);
        }
        return new KeymapScheme(keymap2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/KeymapScheme";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapScheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canReset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

