/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutDialog;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

final class MouseShortcutDialog
extends ShortcutDialog<MouseShortcut> {
    private final JLabel myText = new JLabel("", 0);

    MouseShortcutDialog(Component component2, boolean allowDoubleClick) {
        super(component2, "mouse.shortcut.dialog.title", new MouseShortcutPanel(allowDoubleClick));
        this.myShortcutPanel.add("North", new JLabel(AllIcons.General.Mouse, 0));
        this.myShortcutPanel.add("Center", this.myText);
        this.myShortcutPanel.setBorder(BorderFactory.createCompoundBorder(JBUI.Borders.customLine(MouseShortcutPanel.BORDER, 1, 0, 1, 0), JBUI.Borders.empty(20)));
        this.init();
    }

    @Override
    protected String getHelpId() {
        return "preferences.mouse.shortcut";
    }

    @Override
    MouseShortcut toShortcut(Object value2) {
        return value2 instanceof MouseShortcut ? (MouseShortcut)value2 : null;
    }

    @Override
    void setShortcut(MouseShortcut shortcut) {
        super.setShortcut(shortcut);
        if (shortcut == null) {
            this.myText.setForeground(MouseShortcutPanel.FOREGROUND);
            this.myText.setText(KeyMapBundle.message("dialog.mouse.pad.default.text", new Object[0]));
        } else {
            this.myText.setForeground(UIUtil.getLabelForeground());
            this.myText.setText(KeyMapBundle.message("dialog.mouse.pad.shortcut.text", KeymapUtil.getMouseShortcutText(shortcut)));
        }
    }

    @Override
    @NotNull
    Collection<String> getConflicts(MouseShortcut shortcut, String actionId, Keymap keymap2) {
        List<String> list2 = keymap2.getActionIds(shortcut);
        if (list2 == null) {
            MouseShortcutDialog.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/MouseShortcutDialog", "getConflicts"));
    }
}

