/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.ShortcutPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

abstract class ShortcutDialog<T extends Shortcut>
extends DialogWrapper {
    private final SimpleColoredComponent myAction = new SimpleColoredComponent();
    private final JBPanel myConflictsContainer = new JBPanel(new VerticalLayout(0));
    private final JBPanel myConflictsPanel = ((JBPanel)((JBPanel)new JBPanel(new BorderLayout()).withBorder(JBUI.Borders.empty(10, 10, 0, 10))).withPreferredHeight(64)).withMinimumHeight(64);
    protected final ShortcutPanel<T> myShortcutPanel;
    private final Project myProject;
    private String myActionId;
    private Keymap myKeymap;
    private Group myGroup;

    ShortcutDialog(Component parent, @PropertyKey(resourceBundle="messages.KeyMapBundle") String titleKey, ShortcutPanel<T> panel2) {
        super(parent, true);
        this.myShortcutPanel = panel2;
        this.myProject = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parent));
        this.setTitle(KeyMapBundle.message(titleKey, new Object[0]));
    }

    String getActionPath(String actionId) {
        return this.myGroup == null ? null : this.myGroup.getActionQualifiedPath(actionId);
    }

    boolean hasConflicts() {
        return this.myConflictsPanel.isVisible();
    }

    @NotNull
    abstract Collection<String> getConflicts(T var1, String var2, Keymap var3);

    abstract T toShortcut(Object var1);

    void setShortcut(T shortcut) {
        this.setOKActionEnabled(shortcut != null);
        if (!ShortcutDialog.equal(shortcut, this.myShortcutPanel.getShortcut())) {
            this.myShortcutPanel.setShortcut(shortcut);
        }
        this.myConflictsContainer.removeAll();
        if (shortcut != null) {
            for (String id2 : this.getConflicts(shortcut, this.myActionId, this.myKeymap)) {
                String path2 = id2.equals(this.myActionId) ? null : this.getActionPath(id2);
                if (path2 == null) continue;
                SimpleColoredComponent component2 = new SimpleColoredComponent();
                ShortcutDialog.fill(component2, id2, path2);
                if (ScreenReader.isActive()) {
                    component2.setFocusable(true);
                }
                this.myConflictsContainer.add("TOP", component2);
            }
            this.myConflictsPanel.revalidate();
            this.myConflictsPanel.repaint();
        }
        this.myConflictsPanel.setVisible(0 < this.myConflictsContainer.getComponentCount());
    }

    T showAndGet(String id2, Keymap keymap2, QuickList ... lists) {
        return this.showAndGet(id2, keymap2, (T)null, lists);
    }

    T showAndGet(String id2, Keymap keymap2, @Nullable T selectedShortcut, QuickList ... lists) {
        this.myActionId = id2;
        this.myKeymap = keymap2;
        this.myGroup = ActionsTreeUtil.createMainGroup(this.myProject, keymap2, lists, null, false, null);
        this.addSystemActionsIfPresented(this.myGroup);
        ShortcutDialog.fill(this.myAction, id2, this.getActionPath(id2));
        if (selectedShortcut == null) {
            Shortcut shortcut;
            Shortcut[] shortcutArray = keymap2.getShortcuts(id2);
            int n = shortcutArray.length;
            for (int i = 0; i < n && (selectedShortcut = this.toShortcut(shortcut = shortcutArray[i])) == null; ++i) {
            }
        }
        this.setShortcut(selectedShortcut);
        return this.showAndGet() ? (T)this.myShortcutPanel.getShortcut() : null;
    }

    protected void addSystemActionsIfPresented(Group group) {
    }

    @Override
    @Nullable
    protected Border createContentPaneBorder() {
        return JBUI.Borders.empty();
    }

    @Override
    @Nullable
    protected JComponent createSouthPanel() {
        JComponent panel2 = super.createSouthPanel();
        if (panel2 != null) {
            panel2.setBorder(JBUI.Borders.empty(8, 12));
        }
        return panel2;
    }

    @Override
    @Nullable
    protected JComponent createNorthPanel() {
        this.myAction.setIpad(JBUI.insets(10, 10, 5, 10));
        this.myShortcutPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                ShortcutDialog.this.setShortcut(ShortcutDialog.this.toShortcut(event.getNewValue()));
            }
        });
        Object result2 = ((JBPanel)new JBPanel(new BorderLayout()).withPreferredWidth(300)).withMinimumWidth(200);
        ((Container)result2).add("North", this.myAction);
        ((Container)result2).add("South", this.myShortcutPanel);
        return result2;
    }

    @Override
    protected JComponent createCenterPanel() {
        JLabel icon2 = new JLabel(AllIcons.General.BalloonWarning);
        icon2.setVerticalAlignment(1);
        JLabel label2 = new JLabel(KeyMapBundle.message("dialog.conflicts.text", new Object[0]));
        label2.setBorder(JBUI.Borders.emptyLeft(2));
        if (ScreenReader.isActive()) {
            label2.setFocusable(true);
        }
        JScrollPane scroll = ScrollPaneFactory.createScrollPane(null, true);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setViewport(new GradientViewport(this.myConflictsContainer, JBUI.insets(5), false));
        scroll.getVerticalScrollBar().setOpaque(false);
        scroll.getViewport().setOpaque(false);
        scroll.setOpaque(false);
        JBPanel panel2 = new JBPanel(new BorderLayout());
        panel2.add("North", label2);
        panel2.add("Center", scroll);
        this.myConflictsPanel.add("West", icon2);
        this.myConflictsPanel.add("Center", panel2);
        this.myConflictsContainer.setOpaque(false);
        return this.myConflictsPanel;
    }

    private static boolean equal(Shortcut newShortcut, Shortcut oldShortcut) {
        return newShortcut == null ? oldShortcut == null : newShortcut.equals(oldShortcut);
    }

    private static void fill(SimpleColoredComponent component2, String id2, String path2) {
        if (path2 == null) {
            component2.append(id2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        } else {
            int index = path2.lastIndexOf(" | ");
            if (index < 0) {
                component2.append(path2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                component2.append(path2.substring(index + 3), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                component2.append(" in ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                component2.append(path2.substring(0, index), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }
}

