/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutPanel;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

final class ShortcutFilteringPanel
extends JPanel {
    private final KeyboardShortcutPanel myKeyboardPanel = new KeyboardShortcutPanel(false, new VerticalLayout(JBUIScale.scale(2)));
    private final MouseShortcutPanel myMousePanel = new MouseShortcutPanel(true);
    private Shortcut myShortcut;
    private JBPopup myPopup;
    private final ChangeListener myChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            boolean selected2 = ((ShortcutFilteringPanel)ShortcutFilteringPanel.this).myKeyboardPanel.mySecondStrokeEnable.isSelected();
            ((ShortcutFilteringPanel)ShortcutFilteringPanel.this).myKeyboardPanel.mySecondStroke.setVisible(selected2);
            ShortcutFilteringPanel.this.myMousePanel.setVisible(!selected2);
            if (selected2 && ShortcutFilteringPanel.this.myShortcut instanceof MouseShortcut) {
                ShortcutFilteringPanel.this.setShortcut(null);
            }
        }
    };
    private final PropertyChangeListener myPropertyListener = new PropertyChangeListener(){
        private volatile boolean myInternal;

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            boolean internal = this.myInternal;
            this.myInternal = true;
            Object value2 = event.getNewValue();
            if (ShortcutFilteringPanel.this == event.getSource()) {
                if (value2 instanceof KeyboardShortcut) {
                    KeyboardShortcut shortcut = (KeyboardShortcut)value2;
                    ShortcutFilteringPanel.this.myMousePanel.setShortcut((MouseShortcut)null);
                    ShortcutFilteringPanel.this.myKeyboardPanel.setShortcut(shortcut);
                    if (null != shortcut.getSecondKeyStroke()) {
                        ((ShortcutFilteringPanel)ShortcutFilteringPanel.this).myKeyboardPanel.mySecondStrokeEnable.setSelected(true);
                    }
                } else {
                    MouseShortcut shortcut = value2 instanceof MouseShortcut ? (MouseShortcut)value2 : null;
                    String text2 = shortcut == null ? null : KeymapUtil.getMouseShortcutText(shortcut);
                    ShortcutFilteringPanel.this.myMousePanel.setShortcut(shortcut);
                    ShortcutFilteringPanel.this.myKeyboardPanel.setShortcut(null);
                    ((ShortcutFilteringPanel)ShortcutFilteringPanel.this).myKeyboardPanel.myFirstStroke.setText(text2);
                    ((ShortcutFilteringPanel)ShortcutFilteringPanel.this).myKeyboardPanel.mySecondStroke.setText(null);
                    ((ShortcutFilteringPanel)ShortcutFilteringPanel.this).myKeyboardPanel.mySecondStroke.setEnabled(false);
                }
            } else if (value2 instanceof Shortcut) {
                ShortcutFilteringPanel.this.setShortcut((Shortcut)value2);
            } else if (!internal) {
                ShortcutFilteringPanel.this.setShortcut(null);
            }
            this.myInternal = internal;
        }
    };

    ShortcutFilteringPanel() {
        super(new VerticalLayout(JBUIScale.scale(2)));
        this.myKeyboardPanel.myFirstStroke.setColumns(13);
        this.myKeyboardPanel.myFirstStroke.putClientProperty("JTextField.variant", "search");
        this.myKeyboardPanel.mySecondStroke.setColumns(13);
        this.myKeyboardPanel.mySecondStroke.putClientProperty("JTextField.variant", "search");
        this.myKeyboardPanel.mySecondStroke.setVisible(false);
        this.myKeyboardPanel.mySecondStrokeEnable.setText(KeyMapBundle.message("filter.enable.second.stroke.checkbox", new Object[0]));
        this.myKeyboardPanel.mySecondStrokeEnable.addChangeListener(this.myChangeListener);
        this.myKeyboardPanel.add("TOP", this.myKeyboardPanel.myFirstStroke);
        this.myKeyboardPanel.add("TOP", this.myKeyboardPanel.mySecondStrokeEnable);
        this.myKeyboardPanel.add("TOP", this.myKeyboardPanel.mySecondStroke);
        this.myKeyboardPanel.addPropertyChangeListener("shortcut", this.myPropertyListener);
        this.myKeyboardPanel.setBorder(JBUI.Borders.empty(4));
        JLabel label2 = new JLabel(KeyMapBundle.message("filter.mouse.pad.label", new Object[0]));
        label2.setOpaque(false);
        label2.setIcon(AllIcons.General.Mouse);
        label2.setForeground(MouseShortcutPanel.FOREGROUND);
        label2.setBorder(JBUI.Borders.empty(14, 4));
        this.myMousePanel.add("Center", label2);
        this.myMousePanel.addPropertyChangeListener("shortcut", this.myPropertyListener);
        this.myMousePanel.setBorder(JBUI.Borders.customLine(MouseShortcutPanel.BORDER, 1, 0, 0, 0));
        this.add("TOP", this.myKeyboardPanel);
        this.add("TOP", this.myMousePanel);
        this.addPropertyChangeListener("shortcut", this.myPropertyListener);
    }

    Shortcut getShortcut() {
        return this.myShortcut;
    }

    void setShortcut(Shortcut shortcut) {
        Shortcut old = this.myShortcut;
        if (old != null || shortcut != null) {
            this.myShortcut = shortcut;
            this.firePropertyChange("shortcut", old, shortcut);
        }
    }

    void showPopup(Component component2, Component emitter) {
        if (this.myPopup == null || this.myPopup.isDisposed()) {
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(this, this.myKeyboardPanel.myFirstStroke).setRequestFocus(true).setTitle(KeyMapBundle.message("filter.settings.popup.title", new Object[0])).setCancelKeyEnabled(false).setMovable(true).createPopup();
            IdeEventQueue.getInstance().addPostprocessor(new IdeEventQueue.EventDispatcher(){
                boolean isEscWasPressed;

                @Override
                public boolean dispatch(@NotNull AWTEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (e instanceof KeyEvent && e.getID() == 401) {
                        boolean isEsc;
                        boolean bl = isEsc = ((KeyEvent)e).getKeyCode() == 27;
                        if (this.isEscWasPressed && isEsc) {
                            ShortcutFilteringPanel.this.myPopup.cancel();
                        }
                        this.isEscWasPressed = isEsc;
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/ShortcutFilteringPanel$3", "dispatch"));
                }
            }, this.myPopup);
        }
        HelpTooltip.setMasterPopup(emitter, this.myPopup);
        this.myPopup.showUnderneathOf(component2);
    }

    void hidePopup() {
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
        }
    }
}

