/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.InternalModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ModuleType<T extends ModuleBuilder> {
    public static final ModuleType<?> EMPTY = ModuleType.instantiate("com.intellij.openapi.module.EmptyModuleType");
    @NotNull
    private final String myId;
    private final FrameworkRole myFrameworkRole;

    protected ModuleType(@NotNull @NonNls String id2) {
        if (id2 == null) {
            ModuleType.$$$reportNull$$$0(0);
        }
        this.myId = id2;
        this.myFrameworkRole = new FrameworkRole(id2);
    }

    @NotNull
    public abstract T createModuleBuilder();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getName();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public abstract String getDescription();

    @NotNull
    public Icon getIcon() {
        Icon icon2 = this.getNodeIcon(false);
        if (icon2 == null) {
            ModuleType.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    @NotNull
    public abstract Icon getNodeIcon(@Deprecated boolean var1);

    public ModuleWizardStep @NotNull [] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull T moduleBuilder, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            ModuleType.$$$reportNull$$$0(2);
        }
        if (moduleBuilder == null) {
            ModuleType.$$$reportNull$$$0(3);
        }
        if (modulesProvider == null) {
            ModuleType.$$$reportNull$$$0(4);
        }
        if (ModuleWizardStep.EMPTY_ARRAY == null) {
            ModuleType.$$$reportNull$$$0(5);
        }
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder) {
        if (settingsStep == null) {
            ModuleType.$$$reportNull$$$0(6);
        }
        if (moduleBuilder == null) {
            ModuleType.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder) {
        if (settingsStep == null) {
            ModuleType.$$$reportNull$$$0(8);
        }
        if (moduleBuilder == null) {
            ModuleType.$$$reportNull$$$0(9);
        }
        return null;
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            ModuleType.$$$reportNull$$$0(10);
        }
        return string;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleType)) {
            return false;
        }
        ModuleType moduleType = (ModuleType)o;
        return this.myId.equals(moduleType.myId);
    }

    public final int hashCode() {
        return this.myId.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    private static ModuleType instantiate(String className) {
        ModuleType moduleType;
        try {
            moduleType = (ModuleType)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (moduleType == null) {
            ModuleType.$$$reportNull$$$0(11);
        }
        return moduleType;
    }

    public boolean isValidSdk(@NotNull Module module2, @Nullable Sdk projectSdk) {
        if (module2 == null) {
            ModuleType.$$$reportNull$$$0(12);
        }
        return true;
    }

    public static boolean is(@NotNull Module module2, @NotNull ModuleType moduleType) {
        if (module2 == null) {
            ModuleType.$$$reportNull$$$0(13);
        }
        if (moduleType == null) {
            ModuleType.$$$reportNull$$$0(14);
        }
        return moduleType.getId().equals(module2.getModuleTypeName());
    }

    public static boolean isInternal(@NotNull Module module2) {
        if (module2 == null) {
            ModuleType.$$$reportNull$$$0(15);
        }
        return ModuleType.get(module2) instanceof InternalModuleType;
    }

    @NotNull
    public static ModuleType get(@NotNull Module module2) {
        ModuleTypeManager instance2;
        if (module2 == null) {
            ModuleType.$$$reportNull$$$0(16);
        }
        if ((instance2 = ModuleTypeManager.getInstance()) == null) {
            ModuleType<?> moduleType = EMPTY;
            if (moduleType == null) {
                ModuleType.$$$reportNull$$$0(17);
            }
            return moduleType;
        }
        ModuleType<?> moduleType = instance2.findByID(module2.getModuleTypeName());
        if (moduleType == null) {
            ModuleType.$$$reportNull$$$0(18);
        }
        return moduleType;
    }

    @NotNull
    public FrameworkRole getDefaultAcceptableRole() {
        FrameworkRole frameworkRole = this.myFrameworkRole;
        if (frameworkRole == null) {
            ModuleType.$$$reportNull$$$0(19);
        }
        return frameworkRole;
    }

    public boolean isSupportedRootType(JpsModuleSourceRootType type) {
        return true;
    }

    public boolean isMarkInnerSupportedFor(JpsModuleSourceRootType type) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/ModuleType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/ModuleType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createWizardSteps";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAcceptableRole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modifySettingsStep";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "modifyProjectTypeStep";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdk";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

