/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.impl.scopes.LibraryScopeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import org.jetbrains.annotations.NotNull;

public class LibraryScope
extends LibraryScopeBase {
    private final Library myLibrary;
    private final String myLibraryName;

    public LibraryScope(Project project2, Library library) {
        super(project2, library.getFiles(OrderRootType.CLASSES), library.getFiles(OrderRootType.SOURCES));
        this.myLibraryName = LibraryUtil.getPresentableName(library);
        this.myLibrary = library;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = "Library '" + this.myLibraryName + "'";
        if (string == null) {
            LibraryScope.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myLibrary.equals(((LibraryScope)o).myLibrary);
    }

    @Override
    public int calcHashCode() {
        return 31 * super.calcHashCode() + this.myLibrary.hashCode();
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/LibraryScope", "getDisplayName"));
    }
}

