/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleWithDependentsScope
extends GlobalSearchScope {
    private final Set<Module> myRootModules;
    private final ProjectFileIndexImpl myProjectFileIndex;
    private final Set<Module> myModules;
    private final Set<Module> myProductionOnTestModules;

    ModuleWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(0);
        }
        this(module2.getProject(), Collections.singleton(module2));
    }

    public ModuleWithDependentsScope(@NotNull Project project2, @NotNull Collection<? extends Module> modules) {
        if (project2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(2);
        }
        super(project2);
        this.myModules = new THashSet<Module>();
        this.myProductionOnTestModules = new THashSet<Module>();
        this.myRootModules = new LinkedHashSet<Module>(modules);
        this.myProjectFileIndex = (ProjectFileIndexImpl)ProjectRootManager.getInstance(project2).getFileIndex();
        this.myModules.addAll(this.myRootModules);
        ModuleIndex index = ModuleWithDependentsScope.getModuleIndex(project2);
        HashSetQueue walkingQueue = new HashSetQueue();
        walkingQueue.addAll(this.myRootModules);
        for (Module current2 : walkingQueue) {
            Collection<Module> usages = index.allUsages.get(current2);
            this.myModules.addAll(usages);
            walkingQueue.addAll(index.exportingUsages.get(current2));
            if (this.myProductionOnTestModules.contains(current2)) {
                this.myProductionOnTestModules.addAll(usages);
            }
            this.myProductionOnTestModules.addAll(index.productionOnTestUsages.get(current2));
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = Objects.requireNonNull(super.getProject());
        if (project2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(3);
        }
        return project2;
    }

    @NotNull
    private static ModuleIndex getModuleIndex(@NotNull Project project2) {
        if (project2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(4);
        }
        ModuleIndex moduleIndex = (ModuleIndex)CachedValuesManager.getManager(project2).getCachedValue(project2, () -> {
            ModuleIndex index = new ModuleIndex();
            for (Module module2 : ModuleManager.getInstance(project2).getModules()) {
                for (OrderEntry orderEntry : ModuleRootManager.getInstance(module2).getOrderEntries()) {
                    Module referenced;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    index.allUsages.putValue(referenced, module2);
                    if (((ModuleOrderEntry)orderEntry).isExported()) {
                        index.exportingUsages.putValue(referenced, module2);
                    }
                    if (!((ModuleOrderEntry)orderEntry).isProductionOnTestDependency()) continue;
                    index.productionOnTestUsages.putValue(referenced, module2);
                }
            }
            return CachedValueProvider.Result.create(index, ProjectRootManager.getInstance(project2));
        });
        if (moduleIndex == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(5);
        }
        return moduleIndex;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(6);
        }
        return this.contains(file2, false);
    }

    boolean contains(@NotNull VirtualFile file2, boolean fromTests) {
        DirectoryInfo info;
        Module moduleOfFile;
        if (file2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(7);
        }
        if ((moduleOfFile = (info = this.myProjectFileIndex.getInfoForFileOrDirectory(file2)).getModule()) == null || !this.myModules.contains(moduleOfFile)) {
            return false;
        }
        if (fromTests && !this.myProductionOnTestModules.contains(moduleOfFile) && !TestSourcesFilter.isTestSources(file2, moduleOfFile.getProject())) {
            return false;
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module module2) {
        if (module2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(8);
        }
        return this.myModules.contains(module2);
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project2 = this.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance(project2);
        Collection collection = this.myRootModules.stream().flatMap(module2 -> DirectoryIndex.getInstance(project2).getDependentUnloadedModules((Module)module2).stream()).map(moduleManager::getUnloadedModuleDescription).filter(Objects::nonNull).collect(Collectors.toList());
        if (collection == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NonNls
    public String toString() {
        return "Modules with dependents:" + StringUtil.join(this.myRootModules, Module::getName, ",");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ModuleWithDependentsScope && this.myModules.equals(((ModuleWithDependentsScope)o).myModules);
    }

    @Override
    public int calcHashCode() {
        return this.myModules.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleIndex";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleIndex";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleIndex {
        final MultiMap<Module, Module> allUsages = MultiMap.create();
        final MultiMap<Module, Module> exportingUsages = MultiMap.create();
        final MultiMap<Module, Module> productionOnTestUsages = MultiMap.create();

        private ModuleIndex() {
        }
    }
}

