/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Configurable
extends UnnamedConfigurable {
    public static final ExtensionPointName<ConfigurableEP<Configurable>> APPLICATION_CONFIGURABLE = new ExtensionPointName("com.intellij.applicationConfigurable");
    public static final ExtensionPointName<ConfigurableEP<Configurable>> PROJECT_CONFIGURABLE = new ExtensionPointName("com.intellij.projectConfigurable");

    @Nls(capitalization=Nls.Capitalization.Title)
    @Contract(pure=true)
    public String getDisplayName();

    @Nullable
    @NonNls
    @Contract(pure=true)
    default public String getHelpTopic() {
        return null;
    }

    default public boolean isModified(@NotNull JTextField textField2, @NotNull String value2) {
        if (textField2 == null) {
            Configurable.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            Configurable.$$$reportNull$$$0(1);
        }
        return !StringUtil.equals(textField2.getText().trim(), value2);
    }

    default public boolean isModified(@NotNull JTextField textField2, int value2, @NotNull UINumericRange range2) {
        if (textField2 == null) {
            Configurable.$$$reportNull$$$0(2);
        }
        if (range2 == null) {
            Configurable.$$$reportNull$$$0(3);
        }
        try {
            int currentValue = Integer.parseInt(textField2.getText().trim());
            return range2.fit(currentValue) == currentValue && currentValue != value2;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    default public boolean isModified(@NotNull JToggleButton toggleButton, boolean value2) {
        if (toggleButton == null) {
            Configurable.$$$reportNull$$$0(4);
        }
        return toggleButton.isSelected() != value2;
    }

    default public <T> boolean isModified(@NotNull ComboBox<T> comboBox2, T value2) {
        if (comboBox2 == null) {
            Configurable.$$$reportNull$$$0(5);
        }
        return !Comparing.equal(comboBox2.getSelectedItem(), value2);
    }

    default public JComponent getPreferredFocusedComponent() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "textField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "toggleButton";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "comboBox";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/options/Configurable";
        objectArray[2] = "isModified";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface TopComponentProvider {
        default public boolean isAvailable() {
            return true;
        }

        @NotNull
        public Component getCenterComponent(@NotNull TopComponentController var1);
    }

    public static interface TopComponentController {
        public void setLeftComponent(@Nullable Component var1);

        public void showProgress(boolean var1);
    }

    public static interface WithEpDependencies {
        @NotNull
        public Collection<BaseExtensionPointName<?>> getDependencies();
    }

    public static interface VariableProjectAppLevel {
        public boolean isProjectLevel();
    }

    public static interface NoMargin {
    }

    public static interface NoScroll {
    }

    @FunctionalInterface
    public static interface Composite {
        public Configurable @NotNull [] getConfigurables();
    }
}

