/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors.pages;

import com.intellij.ide.highlighter.custom.CustomFileHighlighter;
import com.intellij.ide.highlighter.custom.CustomHighlighterColors;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.util.PlatformIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CustomColorsPage
implements ColorSettingsPage,
DisplayPrioritySortable {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.keyword1", new Object[0]), CustomHighlighterColors.CUSTOM_KEYWORD1_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.keyword2", new Object[0]), CustomHighlighterColors.CUSTOM_KEYWORD2_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.keyword3", new Object[0]), CustomHighlighterColors.CUSTOM_KEYWORD3_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.keyword4", new Object[0]), CustomHighlighterColors.CUSTOM_KEYWORD4_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.number", new Object[0]), CustomHighlighterColors.CUSTOM_NUMBER_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.string", new Object[0]), CustomHighlighterColors.CUSTOM_STRING_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.line.comment", new Object[0]), CustomHighlighterColors.CUSTOM_LINE_COMMENT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.block.comment", new Object[0]), CustomHighlighterColors.CUSTOM_MULTI_LINE_COMMENT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.valid.string.escape", new Object[0]), CustomHighlighterColors.CUSTOM_VALID_STRING_ESCAPE), new AttributesDescriptor(OptionsBundle.message("options.custom.attribute.descriptor.invalid.string.escape", new Object[0]), CustomHighlighterColors.CUSTOM_INVALID_STRING_ESCAPE)};
    @NonNls
    private static final SyntaxTable SYNTAX_TABLE = new SyntaxTable();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = OptionsBundle.message("options.custom.display.name", new Object[0]);
        if (string == null) {
            CustomColorsPage.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return PlatformIcons.CUSTOM_FILE_ICON;
    }

    @Override
    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATTRS == null) {
            CustomColorsPage.$$$reportNull$$$0(1);
        }
        return ATTRS;
    }

    @Override
    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            CustomColorsPage.$$$reportNull$$$0(2);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new CustomFileHighlighter(SYNTAX_TABLE);
    }

    @Override
    @NotNull
    public String getDemoText() {
        return "# Line comment\naKeyword1 variable = 123;\nanotherKeyword1 someString = \"SomeString\";\naKeyword2 variable = 123;\nanotherKeyword2 someString = \"SomeString\";\naKeyword3 variable = 123;\nanotherKeyword3 someString = \"SomeString\";\naKeyword4 variable = 123;\nanotherKeyword4 someString = \"SomeString \\n\\x  \\& \\g \";\n/* \n * Block comment\n */\n\n";
    }

    @Override
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return null;
    }

    @Override
    public DisplayPriority getPriority() {
        return DisplayPriority.COMMON_SETTINGS;
    }

    static {
        SYNTAX_TABLE.setLineComment("#");
        SYNTAX_TABLE.setStartComment("/*");
        SYNTAX_TABLE.setEndComment("*/");
        SYNTAX_TABLE.setHexPrefix("0x");
        SYNTAX_TABLE.setNumPostfixChars("dDlL");
        SYNTAX_TABLE.setHasStringEscapes(true);
        SYNTAX_TABLE.addKeyword1("aKeyword1");
        SYNTAX_TABLE.addKeyword1("anotherKeyword1");
        SYNTAX_TABLE.addKeyword2("aKeyword2");
        SYNTAX_TABLE.addKeyword2("anotherKeyword2");
        SYNTAX_TABLE.addKeyword3("aKeyword3");
        SYNTAX_TABLE.addKeyword3("anotherKeyword3");
        SYNTAX_TABLE.addKeyword4("aKeyword4");
        SYNTAX_TABLE.addKeyword4("anotherKeyword4");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/options/colors/pages/CustomColorsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

