/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors.pages;

import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.ui.EditorCustomization;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralColorsPage
implements ColorSettingsPage,
InspectionColorSettingsPage,
DisplayPrioritySortable,
EditorCustomization {
    private static final String STRING_TO_FOLD = "Folded text with highlighting";
    private static final String DEMO_TEXT = "<todo>//TODO: Visit JB Web resources:</todo>\nJetBrains Home Page: <hyperlink_f>http://www.jetbrains.com</hyperlink_f>\nJetBrains Developer Community: <hyperlink>https://www.jetbrains.com/devnet</hyperlink>\n<ref_hyperlink>ReferenceHyperlink</ref_hyperlink>\nInactive hyperlink in code: \"<inactive_hyperlink>http://jetbrains.com</inactive_hyperlink>\"\n\nSearch:\n  <search_result_wr>result</search_result_wr> = \"<search_text>text</search_text>, <search_text>text</search_text>, <search_text>text</search_text>\";\n  <identifier_write>i</identifier_write> = <search_result>result</search_result>\n  return <identifier>i;</identifier>\n\n<folded_text>Folded text</folded_text>\n<folded_text_with_highlighting>Folded text with highlighting</folded_text_with_highlighting>\n<deleted_text>Deleted text</deleted_text>\nTemplate <template_var>VARIABLE</template_var>\nInjected language: <injected_lang>\\.(gif|jpg|png)$</injected_lang>\n\nCode Inspections:\n  <error>Error</error>\n  <warning>Warning</warning>\n  <weak_warning>Weak warning</weak_warning>\n  <deprecated>Deprecated symbol</deprecated>\n  <for_removal>Deprecated symbol marked for removal</for_removal>\n  <unused>Unused symbol</unused>\n  <wrong_ref>Unknown symbol</wrong_ref>\n  <runtime_error>Runtime problem</runtime_error>\n  <server_error>Problem from server</server_error>\n  <server_duplicate>Duplicate from server</server_duplicate>\n" + GeneralColorsPage.getCustomSeveritiesDemoText();
    private static final AttributesDescriptor[] ATT_DESCRIPTORS = new AttributesDescriptor[]{new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptor.default.text", new Object[0]), HighlighterColors.TEXT), new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptor.folded.text", new Object[0]), EditorColors.FOLDED_TEXT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptor.deleted.text", new Object[0]), EditorColors.DELETED_TEXT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptor.search.result", new Object[0]), EditorColors.SEARCH_RESULT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptor.search.result.write.access", new Object[0]), EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptior.identifier.under.caret", new Object[0]), EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptior.identifier.under.caret.write", new Object[0]), EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptor.text.search.result", new Object[0]), EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptor.live.template", new Object[0]), EditorColors.LIVE_TEMPLATE_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.attribute.descriptor.template.variable", new Object[0]), TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.injected.language.fragment", new Object[0]), EditorColors.INJECTED_LANGUAGE_FRAGMENT), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.hyperlink.new", new Object[0]), CodeInsightColors.HYPERLINK_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.hyperlink.followed", new Object[0]), CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.reference.hyperlink", new Object[0]), EditorColors.REFERENCE_HYPERLINK_COLOR), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.hyperlink.inactive", new Object[0]), CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.java.attribute.descriptor.matched.brace", new Object[0]), CodeInsightColors.MATCHED_BRACE_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.java.attribute.descriptor.unmatched.brace", new Object[0]), CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.todo.defaults", new Object[0]), CodeInsightColors.TODO_DEFAULT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.bookmarks", new Object[0]), CodeInsightColors.BOOKMARKS_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message("options.java.color.descriptor.full.coverage", new Object[0]), CodeInsightColors.LINE_FULL_COVERAGE), new AttributesDescriptor(OptionsBundle.message("options.java.color.descriptor.partial.coverage", new Object[0]), CodeInsightColors.LINE_PARTIAL_COVERAGE), new AttributesDescriptor(OptionsBundle.message("options.java.color.descriptor.none.coverage", new Object[0]), CodeInsightColors.LINE_NONE_COVERAGE), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.breadcrumbs.default", new Object[0]), EditorColors.BREADCRUMBS_DEFAULT), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.breadcrumbs.hovered", new Object[0]), EditorColors.BREADCRUMBS_HOVERED), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.breadcrumbs.current", new Object[0]), EditorColors.BREADCRUMBS_CURRENT), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.breadcrumbs.inactive", new Object[0]), EditorColors.BREADCRUMBS_INACTIVE), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.tabs.selected.tab", new Object[0]), EditorColors.TAB_SELECTED), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.tabs.selected.tab.inactive", new Object[0]), EditorColors.TAB_SELECTED_INACTIVE), new AttributesDescriptor(OptionsBundle.message("options.general.color.descriptor.popups.lens", new Object[0]), EditorColors.CODE_LENS_BORDER_COLOR)};
    private static final ColorDescriptor[] COLOR_DESCRIPTORS = new ColorDescriptor[]{new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.background.in.readonly.files", new Object[0]), EditorColors.READONLY_BACKGROUND_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.readonly.fragment.background", new Object[0]), EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.gutter.background", new Object[0]), EditorColors.GUTTER_BACKGROUND, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.notification.background", new Object[0]), EditorColors.NOTIFICATION_BACKGROUND, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.selection.background", new Object[0]), EditorColors.SELECTION_BACKGROUND_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.selection.foreground", new Object[0]), EditorColors.SELECTION_FOREGROUND_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.scrollbar.thumb.while.scrolling", new Object[0]), EditorColors.SCROLLBAR_THUMB_WHILE_SCROLLING_COLOR, ColorDescriptor.Kind.BACKGROUND_WITH_TRANSPARENCY), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.scrollbar.thumb", new Object[0]), EditorColors.SCROLLBAR_THUMB_COLOR, ColorDescriptor.Kind.BACKGROUND_WITH_TRANSPARENCY), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.tabs.selected.underline", new Object[0]), EditorColors.TAB_UNDERLINE, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.tabs.selected.underline.inactive", new Object[0]), EditorColors.TAB_UNDERLINE_INACTIVE, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.caret", new Object[0]), EditorColors.CARET_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.caret.row", new Object[0]), EditorColors.CARET_ROW_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.right.margin", new Object[0]), EditorColors.RIGHT_MARGIN_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.whitespaces", new Object[0]), EditorColors.WHITESPACES_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.tabs", new Object[0]), EditorColors.TABS_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.indent.guide", new Object[0]), EditorColors.INDENT_GUIDE_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.indent.guide.selected", new Object[0]), EditorColors.SELECTED_INDENT_GUIDE_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.line.number", new Object[0]), EditorColors.LINE_NUMBERS_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.line.number.on.caret.row", new Object[0]), EditorColors.LINE_NUMBER_ON_CARET_ROW_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.tearline", new Object[0]), EditorColors.TEARLINE_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.tearline.selected", new Object[0]), EditorColors.SELECTED_TEARLINE_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.separator.above", new Object[0]), EditorColors.SEPARATOR_ABOVE_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.separator.below", new Object[0]), EditorColors.SEPARATOR_BELOW_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.java.color.descriptor.method.separator.color", new Object[0]), CodeInsightColors.METHOD_SEPARATORS_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.soft.wrap.sign", new Object[0]), EditorColors.SOFT_WRAP_SIGN_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.popups.documentation", new Object[0]), EditorColors.DOCUMENTATION_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.popups.information", new Object[0]), HintUtil.INFORMATION_COLOR_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.popups.question", new Object[0]), HintUtil.QUESTION_COLOR_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.popups.error", new Object[0]), HintUtil.ERROR_COLOR_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.popups.recent.locations.selection", new Object[0]), HintUtil.RECENT_LOCATIONS_SELECTION_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.popups.tooltip", new Object[0]), IdeTooltipManager.TOOLTIP_COLOR_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.popups.promotion", new Object[0]), HintUtil.PROMOTION_PANE_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.visual.guides", new Object[0]), EditorColors.VISUAL_INDENT_GUIDE_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message("options.general.color.descriptor.highlighted.folding.border", new Object[0]), EditorColors.FOLDED_TEXT_BORDER_COLOR, ColorDescriptor.Kind.BACKGROUND)};
    private static final Map<String, TextAttributesKey> ADDITIONAL_HIGHLIGHT_DESCRIPTORS = new HashMap<String, TextAttributesKey>();
    private static final Map<String, ColorKey> ADDITIONAL_COLOR_KEY_MAPPING;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = GeneralColorsPage.getDisplayNameText();
        if (string == null) {
            GeneralColorsPage.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return FileTypes.PLAIN_TEXT.getIcon();
    }

    @Override
    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATT_DESCRIPTORS == null) {
            GeneralColorsPage.$$$reportNull$$$0(1);
        }
        return ATT_DESCRIPTORS;
    }

    @Override
    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (COLOR_DESCRIPTORS == null) {
            GeneralColorsPage.$$$reportNull$$$0(2);
        }
        return COLOR_DESCRIPTORS;
    }

    @Override
    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new PlainSyntaxHighlighter();
    }

    @Override
    @NotNull
    public String getDemoText() {
        String string = DEMO_TEXT;
        if (string == null) {
            GeneralColorsPage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ADDITIONAL_HIGHLIGHT_DESCRIPTORS;
    }

    @Override
    @Nullable
    public Map<String, ColorKey> getAdditionalHighlightingTagToColorKeyMap() {
        return ADDITIONAL_COLOR_KEY_MAPPING;
    }

    @Override
    public DisplayPriority getPriority() {
        return DisplayPriority.GENERAL_SETTINGS;
    }

    @Override
    public void customize(@NotNull EditorEx editor) {
        if (editor == null) {
            GeneralColorsPage.$$$reportNull$$$0(4);
        }
        editor.getSettings().setSoftMargins(Arrays.asList(50, 70));
        int foldPos = editor.getDocument().getText().indexOf(STRING_TO_FOLD);
        if (foldPos >= 0) {
            FoldingModelEx foldingModel = editor.getFoldingModel();
            foldingModel.runBatchFoldingOperation(() -> foldingModel.createFoldRegion(foldPos, foldPos + STRING_TO_FOLD.length(), STRING_TO_FOLD, null, true));
        }
    }

    private static String getCustomSeveritiesDemoText() {
        StringBuilder buff = new StringBuilder();
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                String tag2 = GeneralColorsPage.getHighlightDescTagName(highlightInfoType);
                buff.append("  <").append(tag2).append(">");
                buff.append(StringUtil.toLowerCase(tag2));
                buff.append("</").append(tag2).append(">").append("\n");
            }
        }
        return buff.toString();
    }

    private static String getHighlightDescTagName(HighlightInfoType highlightInfoType) {
        return highlightInfoType.getSeverity(null).myName;
    }

    public static String getDisplayNameText() {
        return OptionsBundle.message("options.general.display.name", new Object[0]);
    }

    static {
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("folded_text", EditorColors.FOLDED_TEXT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("folded_text_with_highlighting", CodeInsightColors.WARNINGS_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("deleted_text", EditorColors.DELETED_TEXT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("search_result", EditorColors.SEARCH_RESULT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("search_result_wr", EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("search_text", EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("identifier", EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("identifier_write", EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("template_var", TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("injected_lang", EditorColors.INJECTED_LANGUAGE_FRAGMENT);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("todo", CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("hyperlink", CodeInsightColors.HYPERLINK_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("hyperlink_f", CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("ref_hyperlink", EditorColors.REFERENCE_HYPERLINK_COLOR);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("inactive_hyperlink", CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("wrong_ref", CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("deprecated", CodeInsightColors.DEPRECATED_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("for_removal", CodeInsightColors.MARKED_FOR_REMOVAL_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("unused", CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("error", CodeInsightColors.ERRORS_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("warning", CodeInsightColors.WARNINGS_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("weak_warning", CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("server_error", CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("server_duplicate", CodeInsightColors.DUPLICATE_FROM_SERVER);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("runtime_error", CodeInsightColors.RUNTIME_ERROR);
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put(GeneralColorsPage.getHighlightDescTagName(highlightInfoType), highlightInfoType.getAttributesKey());
            }
        }
        ADDITIONAL_COLOR_KEY_MAPPING = new HashMap<String, ColorKey>();
        ADDITIONAL_COLOR_KEY_MAPPING.put("folded_text_with_highlighting", EditorColors.FOLDED_TEXT_BORDER_COLOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/colors/pages/GeneralColorsPage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDemoText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/colors/pages/GeneralColorsPage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

