/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.AbstractBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.options.ex.ConfigurableGroupEP;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.EpBasedConfigurableGroup;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurableExtensionPointUtil {
    private static final Logger LOG = Logger.getInstance(ConfigurableExtensionPointUtil.class);

    private ConfigurableExtensionPointUtil() {
    }

    @NotNull
    public static List<Configurable> buildConfigurablesList(@NotNull List<? extends ConfigurableEP<Configurable>> extensions2, @Nullable ConfigurableFilter filter2) {
        if (extensions2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(0);
        }
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        HashMap<String, ConfigurableWrapper> idToConfigurable = new HashMap<String, ConfigurableWrapper>();
        ArrayList<String> idsInEpOrder = new ArrayList<String>();
        for (ConfigurableEP<Configurable> configurableEP : extensions2) {
            Configurable configurable2 = ConfigurableWrapper.wrapConfigurable(configurableEP);
            if (ConfigurableExtensionPointUtil.isSuppressed(configurable2, filter2)) continue;
            if (configurable2 instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable2;
                idToConfigurable.put(wrapper2.getId(), wrapper2);
                idsInEpOrder.add(wrapper2.getId());
                continue;
            }
            ContainerUtil.addIfNotNull(result2, configurable2);
        }
        HashSet visited = new HashSet();
        Map<String, List<String>> map2 = ConfigurableExtensionPointUtil.buildIdTree(idToConfigurable, idsInEpOrder);
        for (String id2 : idsInEpOrder) {
            ConfigurableExtensionPointUtil.addChildrenRec(id2, idToConfigurable, visited, map2);
        }
        for (String id2 : idsInEpOrder) {
            ConfigurableWrapper wrapper3 = (ConfigurableWrapper)idToConfigurable.get(id2);
            String parentId = wrapper3.getParentId();
            if (parentId != null && idToConfigurable.containsKey(parentId)) continue;
            result2.add(wrapper3);
        }
        ArrayList<Configurable> arrayList = result2;
        if (arrayList == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static ConfigurableWrapper addChildrenRec(@NotNull String id2, @NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull Set<? super String> visited, @NotNull Map<String, List<String>> idTree) {
        if (id2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(2);
        }
        if (idToConfigurable == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(3);
        }
        if (visited == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(4);
        }
        if (idTree == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(5);
        }
        ConfigurableWrapper wrapper2 = idToConfigurable.get(id2);
        if (visited.contains(id2)) {
            ConfigurableWrapper configurableWrapper = wrapper2;
            if (configurableWrapper == null) {
                ConfigurableExtensionPointUtil.$$$reportNull$$$0(6);
            }
            return configurableWrapper;
        }
        visited.add(id2);
        List<String> childIds = idTree.get(id2);
        if (childIds != null) {
            for (String childId : childIds) {
                ConfigurableWrapper childWrapper = ConfigurableExtensionPointUtil.addChildrenRec(childId, idToConfigurable, visited, idTree);
                wrapper2 = wrapper2.addChild(childWrapper);
            }
            idToConfigurable.put(id2, wrapper2);
        }
        ConfigurableWrapper configurableWrapper = wrapper2;
        if (configurableWrapper == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(7);
        }
        return configurableWrapper;
    }

    @NotNull
    private static Map<String, List<String>> buildIdTree(@NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull List<String> idsInEpOrder) {
        if (idToConfigurable == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(8);
        }
        if (idsInEpOrder == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(9);
        }
        HashMap<String, List<String>> tree = new HashMap<String, List<String>>();
        for (String id2 : idsInEpOrder) {
            ConfigurableWrapper wrapper2 = idToConfigurable.get(id2);
            String parentId = wrapper2.getParentId();
            if (parentId == null) continue;
            ConfigurableWrapper parent = idToConfigurable.get(parentId);
            if (parent == null) {
                LOG.warn("Can't find parent for " + parentId + " (" + wrapper2 + ")");
                continue;
            }
            ArrayList<String> children2 = (ArrayList<String>)tree.get(parentId);
            if (children2 == null) {
                children2 = new ArrayList<String>(5);
                tree.put(parentId, children2);
            }
            children2.add(id2);
        }
        HashMap<String, List<String>> hashMap = tree;
        if (hashMap == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    public static ConfigurableGroup getConfigurableGroup(@Nullable Project project2, boolean withIdeSettings) {
        if (!withIdeSettings && project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        Project finalProject = project2;
        return new EpBasedConfigurableGroup(finalProject, () -> ConfigurableExtensionPointUtil.getConfigurableGroup(ConfigurableExtensionPointUtil.getConfigurables(finalProject, withIdeSettings), finalProject));
    }

    @Nullable
    public static ConfigurableGroup getConfigurableGroup(@NotNull List<? extends Configurable> configurables, @Nullable Project project2) {
        if (configurables == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(11);
        }
        Map<String, List<Configurable>> map2 = ConfigurableExtensionPointUtil.groupConfigurables(configurables);
        THashMap<String, Node<SortedConfigurableGroup>> tree = new THashMap<String, Node<SortedConfigurableGroup>>();
        for (Map.Entry<String, List<Configurable>> entry : map2.entrySet()) {
            ConfigurableExtensionPointUtil.addGroup(tree, project2, entry.getKey(), entry.getValue(), null);
        }
        SortedConfigurableGroup root = ConfigurableExtensionPointUtil.getGroup(tree, "root");
        if (!tree.isEmpty()) {
            LOG.warn("ignore groups: " + tree.keySet());
        }
        if (root != null && root.myList != null && Registry.is("ide.settings.replace.group.with.single.configurable")) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(root.myList);
        }
        return root;
    }

    private static void replaceGroupWithSingleConfigurable(List<Configurable> list2) {
        for (int i = 0; i < list2.size(); ++i) {
            SortedConfigurableGroup group;
            Configurable configurable2 = list2.get(i);
            if (!(configurable2 instanceof SortedConfigurableGroup) || (configurable2 = ConfigurableExtensionPointUtil.getConfigurableToReplace(group.myList, (group = (SortedConfigurableGroup)configurable2).getWeight())) == null) continue;
            list2.set(i, configurable2);
        }
    }

    private static Configurable getConfigurableToReplace(List<Configurable> list2, int weight2) {
        if (list2 != null) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(list2);
            if (1 == list2.size()) {
                Configurable configurable2 = list2.get(0);
                if (configurable2 instanceof SortedConfigurableGroup) {
                    SortedConfigurableGroup group = (SortedConfigurableGroup)configurable2;
                    group.myWeight = weight2;
                    return group;
                }
                if (configurable2 instanceof ConfigurableWrapper) {
                    ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable2;
                    wrapper2.myWeight = weight2;
                    return wrapper2;
                }
            }
        }
        return null;
    }

    private static SortedConfigurableGroup getGroup(Map<String, Node<SortedConfigurableGroup>> tree, String groupId2) {
        Node<SortedConfigurableGroup> node = tree.remove(groupId2);
        if (node.myChildren != null) {
            Iterator<Object> iterator2 = node.myChildren.iterator();
            while (iterator2.hasNext()) {
                String childId = (String)iterator2.next();
                ((SortedConfigurableGroup)node.myValue).myList.add(ConfigurableExtensionPointUtil.getGroup(tree, childId));
                iterator2.remove();
            }
        }
        return (SortedConfigurableGroup)node.myValue;
    }

    private static void addGroup(@NotNull Map<String, Node<SortedConfigurableGroup>> tree, Project project2, String groupId2, List<? extends Configurable> configurables, ResourceBundle alternative) {
        if (tree == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(12);
        }
        boolean root = "root".equals(groupId2);
        String id2 = "configurable.group." + groupId2;
        ResourceBundle bundle = ConfigurableExtensionPointUtil.getBundle(id2 + ".settings.display.name", configurables, alternative);
        if (bundle == null) {
            bundle = OptionsBundle.INSTANCE.getResourceBundle();
            if (!root) {
                LOG.warn("use other group instead of unexpected one: " + groupId2);
                groupId2 = "other";
                id2 = "configurable.group." + groupId2;
            }
        }
        ConfigurableGroupEP ep = root ? null : ConfigurableGroupEP.find(groupId2);
        Node node = Node.get(tree, groupId2);
        if (node.myValue == null) {
            if (ep != null) {
                String name = project2 == null || project2.isDefault() || !"project".equals(groupId2) ? ep.getDisplayName() : StringUtil.first(MessageFormat.format(ep.getResourceValue("configurable.group.project.named.settings.display.name"), project2.getName()), 30, true);
                node.myValue = new SortedConfigurableGroup(id2, name, ep.getDescription(), ep.helpTopic, ep.weight);
            } else if (root) {
                node.myValue = new SortedConfigurableGroup(id2, "ROOT GROUP", null, null, 0);
            } else {
                LOG.warn("Use <groupConfigurable> to specify custom configurable group: " + groupId2);
                int weight2 = ConfigurableExtensionPointUtil.getInt(bundle, id2 + ".settings.weight");
                String help = ConfigurableExtensionPointUtil.getString(bundle, id2 + ".settings.help.topic");
                String name = ConfigurableExtensionPointUtil.getName(bundle, id2 + ".settings.display.name");
                String desc = ConfigurableExtensionPointUtil.getString(bundle, id2 + ".settings.description");
                if (name != null && project2 != null) {
                    if (!project2.isDefault() && !name.contains("{")) {
                        String named = ConfigurableExtensionPointUtil.getString(bundle, id2 + ".named.settings.display.name");
                        String string = name = named != null ? named : name;
                    }
                    if (name.contains("{")) {
                        name = StringUtil.first(MessageFormat.format(name, project2.getName()), 30, true);
                    }
                }
                node.myValue = new SortedConfigurableGroup(id2, name, desc, help, weight2);
            }
        }
        if (configurables != null) {
            ((SortedConfigurableGroup)node.myValue).myList.addAll(configurables);
        }
        if (!root && node.myParent == null) {
            String parentId = ep != null ? ep.parentId : ConfigurableExtensionPointUtil.getString(bundle, id2 + ".settings.parent");
            parentId = (String)Node.cyclic(tree, parentId, "root", groupId2, node);
            node.myParent = Node.add(tree, parentId, groupId2);
            ConfigurableExtensionPointUtil.addGroup(tree, project2, parentId, null, bundle);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Map<String, List<Configurable>> groupConfigurables(@NotNull List<? extends Configurable> configurables) {
        if (configurables == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(13);
        }
        THashMap<String, Node<ConfigurableWrapper>> tree = new THashMap<String, Node<ConfigurableWrapper>>();
        for (Configurable configurable2 : configurables) {
            void id2;
            if (!(configurable2 instanceof ConfigurableWrapper)) {
                Node.add(tree, "other", configurable2);
                continue;
            }
            ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable2;
            try {
                String id22 = wrapper2.getId();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Cannot create configurable", e);
                continue;
            }
            Node node = Node.get(tree, id2);
            if (node.myValue != null) {
                LOG.warn("ignore configurable with duplicated id: " + (String)id2);
                continue;
            }
            String parentId = wrapper2.getParentId();
            String groupId2 = wrapper2.getExtensionPoint().groupId;
            if (groupId2 != null) {
                if (parentId != null) {
                    LOG.warn("ignore deprecated groupId: " + groupId2 + " for id: " + (String)id2);
                } else {
                    parentId = groupId2;
                }
            }
            parentId = (String)Node.cyclic(tree, parentId, "other", id2, node);
            node.myParent = Node.add(tree, parentId, node);
            node.myValue = wrapper2;
        }
        THashMap<String, List<Configurable>> map2 = new THashMap<String, List<Configurable>>();
        for (String id3 : ArrayUtilRt.toStringArray(tree.keySet())) {
            List<Configurable> list2;
            Node node = (Node)tree.get(id3);
            if (node == null || (list2 = ConfigurableExtensionPointUtil.getConfigurables(tree, node)) == null) continue;
            map2.put(id3, list2);
            tree.remove(id3);
        }
        THashMap<String, List<Configurable>> tHashMap = map2;
        if (tHashMap == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(14);
        }
        return tHashMap;
    }

    private static List<Configurable> getConfigurables(Map<String, Node<ConfigurableWrapper>> tree, Node<ConfigurableWrapper> node) {
        if (node.myChildren == null) {
            if (node.myValue == null) {
                return new ArrayList<Configurable>();
            }
            return null;
        }
        ArrayList<Configurable> list2 = new ArrayList<Configurable>(node.myChildren.size());
        Iterator<Object> iterator2 = node.myChildren.iterator();
        while (iterator2.hasNext()) {
            Object child2 = iterator2.next();
            if (child2 instanceof Configurable) {
                list2.add((Configurable)child2);
            } else {
                Node value2 = (Node)child2;
                if (ConfigurableExtensionPointUtil.getConfigurables(tree, value2) != null) {
                    throw new IllegalStateException("unexpected algorithm state");
                }
                list2.add((Configurable)value2.myValue);
                tree.remove(((ConfigurableWrapper)value2.myValue).getId());
            }
            iterator2.remove();
        }
        if (node.myValue == null) {
            return list2;
        }
        for (Configurable configurable2 : list2) {
            node.myValue = ((ConfigurableWrapper)node.myValue).addChild(configurable2);
        }
        return null;
    }

    @NotNull
    private static List<Configurable> getConfigurables(@Nullable Project project2, boolean withIdeSettings) {
        Application application;
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        if (withIdeSettings && (application = ApplicationManager.getApplication()) != null) {
            for (ConfigurableEP<Configurable> extension : Configurable.APPLICATION_CONFIGURABLE.getExtensionList()) {
                ConfigurableExtensionPointUtil.addValid(list2, ConfigurableWrapper.wrapConfigurable(extension, true), null);
            }
        }
        if (project2 != null && !project2.isDisposed()) {
            for (ConfigurableEP<Configurable> extension : Configurable.PROJECT_CONFIGURABLE.getExtensionList(project2)) {
                ConfigurableExtensionPointUtil.addValid(list2, ConfigurableWrapper.wrapConfigurable(extension, true), project2);
            }
        }
        ArrayList<Configurable> arrayList = list2;
        if (arrayList == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void addValid(List<? super Configurable> list2, Configurable configurable2, Project project2) {
        if (ConfigurableExtensionPointUtil.isValid(configurable2, project2)) {
            list2.add(configurable2);
        }
    }

    private static boolean isValid(Configurable configurable2, Project project2) {
        if (configurable2 == null) {
            return false;
        }
        return project2 == null || !project2.isDefault() || !ConfigurableWrapper.isNonDefaultProject(configurable2);
    }

    @Nullable
    public static ResourceBundle getBundle(@NonNls @NotNull String resource, @Nullable Iterable<? extends Configurable> configurables, @Nullable ResourceBundle alternative) {
        ResourceBundle bundle;
        if (resource == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(16);
        }
        if (ConfigurableExtensionPointUtil.getString(bundle = OptionsBundle.INSTANCE.getResourceBundle(), resource) != null) {
            return bundle;
        }
        if (configurables != null) {
            for (Configurable configurable2 : configurables) {
                ConfigurableWrapper wrapper2;
                if (!(configurable2 instanceof ConfigurableWrapper) || ConfigurableExtensionPointUtil.getString(bundle = (wrapper2 = (ConfigurableWrapper)configurable2).getExtensionPoint().findBundle(), resource) == null) continue;
                return bundle;
            }
        }
        if (ConfigurableExtensionPointUtil.getString(alternative, resource) != null) {
            return alternative;
        }
        return null;
    }

    private static String getString(ResourceBundle bundle, @NonNls String resource) {
        if (bundle == null) {
            return null;
        }
        try {
            return bundle.getString(resource);
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    private static String getName(ResourceBundle bundle, @NonNls String resource) {
        if (bundle == null) {
            return null;
        }
        try {
            return AbstractBundle.message(bundle, resource, new Object[0]);
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    private static int getInt(ResourceBundle bundle, @NonNls String resource) {
        try {
            String value2 = ConfigurableExtensionPointUtil.getString(bundle, resource);
            return value2 == null ? 0 : Integer.parseInt(value2);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private static boolean isSuppressed(Configurable each, ConfigurableFilter filter2) {
        return !ConfigurableExtensionPointUtil.isValid(each, null) || filter2 != null && !filter2.isIncluded(each);
    }

    @Nullable
    public static Configurable createProjectConfigurableForProvider(@NotNull Project project2, Class<? extends ConfigurableProvider> providerClass) {
        if (project2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(17);
        }
        return ConfigurableExtensionPointUtil.createConfigurableForProvider(Configurable.PROJECT_CONFIGURABLE.getExtensionList(project2), providerClass);
    }

    @Nullable
    public static Configurable createApplicationConfigurableForProvider(Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider(Configurable.APPLICATION_CONFIGURABLE.getExtensionList(), providerClass);
    }

    @Nullable
    private static Configurable createConfigurableForProvider(@NotNull List<? extends ConfigurableEP<Configurable>> extensions2, Class<? extends ConfigurableProvider> providerClass) {
        if (extensions2 == null) {
            ConfigurableExtensionPointUtil.$$$reportNull$$$0(18);
        }
        for (ConfigurableEP<Configurable> configurableEP : extensions2) {
            Class aClass;
            if (configurableEP.providerClass == null || (aClass = configurableEP.findClassNoExceptions(configurableEP.providerClass)) == null || !providerClass.isAssignableFrom(aClass)) continue;
            return configurableEP.createConfigurable();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idsInEpOrder";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConfigurablesList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addChildrenRec";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildIdTree";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "groupConfigurables";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildConfigurablesList";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenRec";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildIdTree";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurableGroup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "groupConfigurables";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createProjectConfigurableForProvider";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurableForProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Node<V> {
        List<Object> myChildren;
        Node<V> myParent;
        V myValue;

        private Node() {
        }

        private static <I, V> Node<V> get(@NotNull Map<I, Node<V>> tree, @NotNull I id2) {
            Node<V> node;
            if (tree == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (id2 == null) {
                Node.$$$reportNull$$$0(1);
            }
            if ((node = tree.get(id2)) == null) {
                node = new Node<V>();
                tree.put(id2, node);
            }
            return node;
        }

        private static <I, V> Node<V> add(@NotNull Map<I, Node<V>> tree, @NotNull I id2, Object child2) {
            if (tree == null) {
                Node.$$$reportNull$$$0(2);
            }
            if (id2 == null) {
                Node.$$$reportNull$$$0(3);
            }
            Node<V> node = Node.get(tree, id2);
            if (node.myChildren == null) {
                node.myChildren = new SmartList<Object>();
            }
            node.myChildren.add(child2);
            return node;
        }

        private static <I, V> boolean cyclic(@NotNull Map<I, Node<V>> tree, @NotNull I id2, Node<V> parent) {
            if (tree == null) {
                Node.$$$reportNull$$$0(4);
            }
            if (id2 == null) {
                Node.$$$reportNull$$$0(5);
            }
            Node<V> node = tree.get(id2);
            while (node != null) {
                if (node == parent) {
                    return true;
                }
                node = node.myParent;
            }
            return false;
        }

        private static <I, V> I cyclic(@NotNull Map<I, Node<V>> tree, @Nullable I id2, I idDefault, I idNode, Node<V> parent) {
            if (tree == null) {
                Node.$$$reportNull$$$0(6);
            }
            if (id2 == null) {
                id2 = idDefault;
            }
            if (Node.cyclic(tree, id2, parent)) {
                LOG.warn("ignore cyclic dependency: " + id2 + " cannot contain " + idNode);
                id2 = idDefault;
            }
            return id2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil$Node";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cyclic";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

