/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.ActionCallback;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class Settings {
    public static final DataKey<Settings> KEY = DataKey.create("settings.editor");
    private final List<? extends ConfigurableGroup> myGroups;
    private final Map<UnnamedConfigurable, ConfigurableWrapper> myMap;

    protected Settings(@NotNull List<? extends ConfigurableGroup> groups) {
        if (groups == null) {
            Settings.$$$reportNull$$$0(0);
        }
        this.myMap = new IdentityHashMap<UnnamedConfigurable, ConfigurableWrapper>();
        this.myGroups = groups;
    }

    @Nullable
    public final <T extends Configurable> T find(@NotNull Class<T> type) {
        if (type == null) {
            Settings.$$$reportNull$$$0(1);
        }
        return this.unwrap(ConfigurableVisitor.findByType(type, this.myGroups), type);
    }

    @Nullable
    public final Configurable find(@NotNull String id2) {
        if (id2 == null) {
            Settings.$$$reportNull$$$0(2);
        }
        return this.unwrap(ConfigurableVisitor.findById(id2, this.myGroups), Configurable.class);
    }

    @NotNull
    public final ActionCallback select(Configurable configurable2) {
        ActionCallback actionCallback = configurable2 == null ? ActionCallback.REJECTED : Promises.toActionCallback(this.selectImpl(Settings.choose(configurable2, this.myMap.get(configurable2))));
        if (actionCallback == null) {
            Settings.$$$reportNull$$$0(3);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback select(Configurable configurable2, String option2) {
        SearchableConfigurable searchable;
        Runnable search2;
        ActionCallback callback2 = this.select(configurable2);
        if (option2 != null && configurable2 instanceof SearchableConfigurable && (search2 = (searchable = (SearchableConfigurable)configurable2).enableSearch(option2)) != null) {
            callback2.doWhenDone(search2);
        }
        ActionCallback actionCallback = callback2;
        if (actionCallback == null) {
            Settings.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    @NotNull
    protected abstract Promise<? super Object> selectImpl(Configurable var1);

    private <T extends Configurable> T unwrap(Configurable configurable2, Class<T> type) {
        Configurable result2 = (Configurable)ConfigurableWrapper.cast(type, configurable2);
        if (result2 != null && configurable2 instanceof ConfigurableWrapper) {
            this.myMap.put(result2, (ConfigurableWrapper)configurable2);
        }
        return (T)result2;
    }

    private static Configurable choose(Configurable configurable2, Configurable variant) {
        return variant != null ? variant : configurable2;
    }

    public void revalidate() {
    }

    public void reload() {
        this.myMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/Settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/Settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

