/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.CommonBundle;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleConfigurableEditor
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(SingleConfigurableEditor.class);
    private Project myProject;
    private Configurable myConfigurable;
    private JComponent myCenterPanel;
    private final String myDimensionKey;
    private final boolean myShowApplyButton;
    private boolean mySaveAllOnClose;

    public SingleConfigurableEditor(@Nullable Project project2, @NotNull Configurable configurable2, @NonNls String dimensionKey, boolean showApplyButton, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (configurable2 == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(0);
        }
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(1);
        }
        super(project2, true, ideModalityType);
        this.myDimensionKey = dimensionKey;
        this.myShowApplyButton = showApplyButton;
        String title = SingleConfigurableEditor.createTitleString(configurable2);
        if (project2 != null && project2.isDefault()) {
            title = IdeUICustomization.getInstance().projectMessage("title.for.new.projects", title);
        }
        this.setTitle(title);
        this.myProject = project2;
        this.myConfigurable = configurable2;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(Component parent, @NotNull Configurable configurable2, String dimensionServiceKey, boolean showApplyButton, DialogWrapper.IdeModalityType ideModalityType) {
        if (configurable2 == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(2);
        }
        super(parent, true);
        this.myDimensionKey = dimensionServiceKey;
        this.myShowApplyButton = showApplyButton;
        this.setTitle(SingleConfigurableEditor.createTitleString(configurable2));
        this.myConfigurable = configurable2;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable2, @NonNls String dimensionKey, boolean showApplyButton) {
        this(project2, configurable2, dimensionKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable2, String dimensionServiceKey, boolean showApplyButton) {
        this(parent, configurable2, dimensionServiceKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable2, @NonNls String dimensionKey, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(3);
        }
        this(project2, configurable2, dimensionKey, true, ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable2, @NonNls String dimensionKey) {
        this(project2, configurable2, dimensionKey, true);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable2, String dimensionServiceKey) {
        this(parent, configurable2, dimensionServiceKey, true);
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable2, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(4);
        }
        this(project2, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2), ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable2) {
        this(project2, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2));
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable2) {
        this(parent, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2));
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static String createTitleString(@NotNull Configurable configurable2) {
        String displayName;
        if (configurable2 == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((displayName = configurable2.getDisplayName()) != null, configurable2.getClass().getName());
        return displayName.replaceAll("\n", " ");
    }

    @Override
    protected String getDimensionServiceKey() {
        if (this.myDimensionKey == null) {
            return super.getDimensionServiceKey();
        }
        return this.myDimensionKey;
    }

    @Override
    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        if (this.myShowApplyButton) {
            actions.add(new ApplyAction());
        }
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    @Override
    @Nullable
    protected String getHelpId() {
        return this.myConfigurable.getHelpTopic();
    }

    @Override
    protected void doOKAction() {
        try {
            if (this.myConfigurable.isModified()) {
                this.myConfigurable.apply();
                this.mySaveAllOnClose = true;
            }
        }
        catch (ConfigurationException e) {
            if (e.getMessage() != null) {
                if (this.myProject != null) {
                    Messages.showMessageDialog(this.myProject, e.getMessage(), e.getTitle(), Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog(this.getRootPane(), e.getMessage(), e.getTitle(), Messages.getErrorIcon());
                }
            }
            return;
        }
        super.doOKAction();
    }

    protected static String createDimensionKey(Configurable configurable2) {
        String displayName = configurable2.getDisplayName();
        displayName = displayName.replaceAll("\n", "_").replaceAll(" ", "_");
        return "#" + displayName;
    }

    @Override
    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        Configurable configurable2 = this.myConfigurable;
        JComponent preferred = configurable2 == null ? null : configurable2.getPreferredFocusedComponent();
        return preferred == null ? IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel) : preferred;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myConfigurable.disposeUIResources();
        this.myConfigurable = null;
        if (this.mySaveAllOnClose) {
            SaveAndSyncHandler.getInstance().scheduleSaveDocumentsAndProjectsAndApp(this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/SingleConfigurableEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/SingleConfigurableEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTitleString";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ApplyAction
    extends AbstractAction {
        private final Alarm myUpdateAlarm;

        public ApplyAction() {
            super(CommonBundle.getApplyButtonText());
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            Runnable updateRequest = new Runnable(){

                @Override
                public void run() {
                    if (!SingleConfigurableEditor.this.isShowing()) {
                        return;
                    }
                    try {
                        ApplyAction.this.setEnabled(SingleConfigurableEditor.this.myConfigurable != null && SingleConfigurableEditor.this.myConfigurable.isModified());
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                    ApplyAction.this.addUpdateRequest(this);
                }
            };
            SwingUtilities.invokeLater(() -> {
                if (SingleConfigurableEditor.this.myConfigurable != null) {
                    this.addUpdateRequest(updateRequest);
                }
            });
        }

        private void addUpdateRequest(Runnable updateRequest) {
            this.myUpdateAlarm.addRequest(updateRequest, 500, ModalityState.stateForComponent(SingleConfigurableEditor.this.getWindow()));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (SingleConfigurableEditor.this.myPerformAction) {
                return;
            }
            try {
                SingleConfigurableEditor.this.myPerformAction = true;
                if (SingleConfigurableEditor.this.myConfigurable.isModified()) {
                    SingleConfigurableEditor.this.myConfigurable.apply();
                    SingleConfigurableEditor.this.mySaveAllOnClose = true;
                    SingleConfigurableEditor.this.setCancelButtonText(CommonBundle.getCloseButtonText());
                }
            }
            catch (ConfigurationException e) {
                if (SingleConfigurableEditor.this.myProject != null) {
                    Messages.showMessageDialog(SingleConfigurableEditor.this.myProject, e.getMessage(), e.getTitle(), Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog(SingleConfigurableEditor.this.getRootPane(), e.getMessage(), e.getTitle(), Messages.getErrorIcon());
                }
            }
            finally {
                SingleConfigurableEditor.this.myPerformAction = false;
            }
        }
    }
}

