/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.SimpleBanner;
import java.awt.Component;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class ConfigurableController
implements Configurable.TopComponentController {
    private SimpleBanner myBanner;
    private Component myCenterComponent;
    private Component myLeftComponent;
    private boolean myProgress;

    ConfigurableController() {
    }

    void setBanner(SimpleBanner banner) {
        if (banner == null) {
            this.myBanner.setLeftComponent(null);
            this.myBanner.setCenterComponent(null);
            this.myBanner.showProgress(false);
        } else {
            banner.setLeftComponent(this.myLeftComponent);
            banner.setCenterComponent(this.myCenterComponent);
            banner.showProgress(this.myProgress);
        }
        this.myBanner = banner;
    }

    void setCenterComponent(Component centerComponent) {
        this.myCenterComponent = centerComponent;
    }

    @Override
    public void setLeftComponent(@Nullable Component component2) {
        this.myLeftComponent = component2;
        if (this.myBanner != null) {
            this.myBanner.setLeftComponent(component2);
        }
    }

    @Override
    public void showProgress(boolean start2) {
        this.myProgress = start2;
        if (this.myBanner != null) {
            this.myBanner.showProgress(start2);
        }
    }

    static ConfigurableController getOrCreate(Configurable configurable2, Map<Configurable, ConfigurableController> controllers) {
        ConfigurableController controller = controllers.get(configurable2);
        if (controller != null) {
            return controller;
        }
        UnnamedConfigurable original = configurable2;
        if (configurable2 instanceof ConfigurableWrapper) {
            original = ((ConfigurableWrapper)configurable2).getConfigurable();
        }
        if (original instanceof Configurable.TopComponentProvider && ((Configurable.TopComponentProvider)((Object)original)).isAvailable()) {
            controller = new ConfigurableController();
            controller.setCenterComponent(((Configurable.TopComponentProvider)((Object)original)).getCenterComponent(controller));
            controllers.put(configurable2, controller);
            return controller;
        }
        return null;
    }
}

