/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.preview.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.preview.PreviewInfo;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.preview.impl.PreviewManagerState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PreviewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PreviewManagerImpl
implements PreviewManager,
PersistentStateComponent<PreviewManagerState> {
    private static final Key<PreviewInfo> INFO_KEY = Key.create("preview_info");
    private static final int HISTORY_LIMIT = 10;
    private final Project myProject;
    private final Alarm myAlarm = new Alarm();
    private ToolWindowEx myToolWindow;
    private ContentManager myContentManager;
    private Content myEmptyStateContent;
    private final JPanel myEmptyStatePanel;
    private final ArrayList<PreviewInfo> myHistory = new ArrayList();
    private final TreeSet<PreviewPanelProvider> myProviders = new TreeSet((o1, o2) -> {
        int result2 = Float.compare(o1.getMenuOrder(), o2.getMenuOrder());
        return result2 != 0 ? result2 : o1.toString().compareTo(o2.toString());
    });
    private final Set<PreviewProviderId> myActiveProviderIds = new HashSet<PreviewProviderId>();
    private final Set<PreviewProviderId> myLockedProviderIds = new HashSet<PreviewProviderId>();
    private boolean myInnerSelectionChange;

    private static boolean isAvailable() {
        return UISettings.getInstance().getNavigateToPreview();
    }

    public PreviewManagerImpl(Project project2) {
        PreviewPanelProvider[] providers;
        this.myProject = project2;
        this.myEmptyStatePanel = new EmptyStatePanel();
        for (PreviewPanelProvider provider : providers = PreviewPanelProvider.EP_NAME.getExtensions(project2)) {
            this.myProviders.add(provider);
            this.myActiveProviderIds.add(provider.getId());
            Disposer.register(project2, provider);
        }
        project2.getMessageBus().connect().subscribe(UISettingsListener.TOPIC, uiSettings -> this.checkGlobalState());
        this.checkGlobalState();
        this.checkEmptyState();
    }

    @Override
    @Nullable
    public PreviewManagerState getState() {
        PreviewManagerState state = new PreviewManagerState();
        state.myArtifactFilesMap = new HashMap<String, Boolean>();
        for (PreviewPanelProvider provider : this.myProviders) {
            state.myArtifactFilesMap.put(provider.toString(), this.myActiveProviderIds.contains(provider.getId()));
        }
        return state;
    }

    @Override
    public void loadState(@NotNull PreviewManagerState state) {
        if (state == null) {
            PreviewManagerImpl.$$$reportNull$$$0(0);
        }
        block0: for (Map.Entry<String, Boolean> entry : state.myArtifactFilesMap.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            Iterator<PreviewProviderId> iterator2 = this.myActiveProviderIds.iterator();
            while (iterator2.hasNext()) {
                PreviewProviderId id2 = iterator2.next();
                if (!id2.getVisualName().equals(entry.getKey())) continue;
                iterator2.remove();
                continue block0;
            }
        }
    }

    @Nullable
    private <V, C> PreviewPanelProvider<V, C> findProvider(@NotNull PreviewProviderId<V, C> id2) {
        if (id2 == null) {
            PreviewManagerImpl.$$$reportNull$$$0(1);
        }
        for (PreviewPanelProvider provider : this.myProviders) {
            if (id2 != provider.getId()) continue;
            return provider;
        }
        return null;
    }

    protected void checkGlobalState() {
        ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance(this.myProject);
        if (!PreviewManagerImpl.isAvailable() && toolWindowManager.getToolWindow("Preview") != null) {
            this.myHistory.clear();
            this.myContentManager.removeAllContents(true);
            toolWindowManager.unregisterToolWindow("Preview");
            return;
        }
        if (PreviewManagerImpl.isAvailable() && toolWindowManager.getToolWindow("Preview") == null) {
            this.myToolWindow = (ToolWindowEx)toolWindowManager.registerToolWindow("Preview", this.myEmptyStatePanel, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, false);
            this.myContentManager = this.myToolWindow.getContentManager();
            this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowPreview);
            this.myToolWindow.setContentUiType(ToolWindowContentUiType.COMBO, null);
            this.myToolWindow.setAutoHide(true);
            this.myEmptyStateContent = this.myContentManager.getContent(0);
            final MoveToStandardViewAction moveToStandardViewAction = new MoveToStandardViewAction();
            this.myContentManager.addContentManagerListener(new ContentManagerListener(){

                @Override
                public void selectionChanged(@NotNull ContentManagerEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (PreviewManagerImpl.this.myInnerSelectionChange || event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                        return;
                    }
                    PreviewInfo previewInfo = (PreviewInfo)event.getContent().getUserData(INFO_KEY);
                    if (previewInfo != null) {
                        PreviewManagerImpl.this.preview(previewInfo, false);
                        PreviewManagerImpl.this.myToolWindow.setTitleActions(previewInfo.supportsStandardPlace() ? moveToStandardViewAction : null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/preview/impl/PreviewManagerImpl$1", "selectionChanged"));
                }
            });
            moveToStandardViewAction.registerCustomShortcutSet(new ShortcutSet(){

                @Override
                public Shortcut @NotNull [] getShortcuts() {
                    Keymap keymap2 = KeymapManager.getInstance().getActiveKeymap();
                    Shortcut[] shortcutArray = keymap2.getShortcuts("ShowContent");
                    if (shortcutArray == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return shortcutArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/preview/impl/PreviewManagerImpl$2", "getShortcuts"));
                }
            }, this.myToolWindow.getComponent());
            this.myToolWindow.setTitleActions(moveToStandardViewAction);
            ArrayList<ContentTypeToggleAction> myGearActions = new ArrayList<ContentTypeToggleAction>();
            for (PreviewPanelProvider provider : this.myProviders) {
                myGearActions.add(new ContentTypeToggleAction(provider));
            }
            this.myToolWindow.setAdditionalGearActions(new DefaultActionGroup("Preview", myGearActions));
            this.myToolWindow.activate(() -> this.myToolWindow.activate(null));
        }
    }

    private void checkEmptyState() {
        if (this.myContentManager.getContents().length == 0) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "false");
            this.myContentManager.addContent(this.myEmptyStateContent);
        } else if (this.myContentManager.getContents().length > 1) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "true");
            this.myContentManager.removeContent(this.myEmptyStateContent, false);
        }
    }

    @Nullable
    private Content getContent(@NotNull PreviewInfo info) {
        if (info == null) {
            PreviewManagerImpl.$$$reportNull$$$0(2);
        }
        for (Content content2 : this.myContentManager.getContents()) {
            PreviewInfo eachInfo = content2.getUserData(INFO_KEY);
            if (!info.equals(eachInfo)) continue;
            return content2;
        }
        return null;
    }

    @NotNull
    private Content addContent(PreviewInfo info) {
        this.myHistory.add(info);
        while (this.myHistory.size() > 10) {
            this.close(this.myHistory.remove(0));
        }
        Content content2 = this.myContentManager.getFactory().createContent(info.getComponent(), info.getTitle(), false);
        this.myContentManager.addContent(content2, 0);
        this.checkEmptyState();
        Content content3 = content2;
        if (content3 == null) {
            PreviewManagerImpl.$$$reportNull$$$0(3);
        }
        return content3;
    }

    private static void updateContentWithInfo(Content content2, PreviewInfo info) {
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, Boolean.TRUE);
        content2.putUserData(INFO_KEY, info);
        content2.setIcon(info.getIcon());
        content2.setPopupIcon(info.getIcon());
    }

    private void close(@NotNull PreviewInfo info) {
        Content content2;
        if (info == null) {
            PreviewManagerImpl.$$$reportNull$$$0(4);
        }
        if ((content2 = this.getContent(info)) != null) {
            this.myContentManager.removeContent(content2, false);
            info.release();
            if (this.myContentManager.getContents().length == 0) {
                this.toggleToolWindow(false);
            }
            this.checkEmptyState();
        }
    }

    @Override
    public <V, C> C preview(@NotNull PreviewProviderId<V, C> id2, V data2, boolean requestFocus) {
        if (id2 == null) {
            PreviewManagerImpl.$$$reportNull$$$0(5);
        }
        if (!this.myActiveProviderIds.contains(id2) || this.myLockedProviderIds.contains(id2)) {
            return null;
        }
        PreviewPanelProvider<V, C> provider = this.findProvider(id2);
        if (provider == null) {
            return null;
        }
        return this.preview(PreviewInfo.create(provider, data2), requestFocus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V, C> C preview(@NotNull PreviewInfo<V, C> info, boolean requestFocus) {
        if (info == null) {
            PreviewManagerImpl.$$$reportNull$$$0(6);
        }
        this.toggleToolWindow(true);
        Content content2 = this.getContent(info);
        Content selectedContent = this.myContentManager.getSelectedContent();
        if (selectedContent != content2) {
            this.myInnerSelectionChange = true;
            try {
                PreviewInfo selectedInfo;
                PreviewInfo previewInfo = selectedInfo = selectedContent != null ? selectedContent.getUserData(INFO_KEY) : null;
                if (selectedInfo != null && selectedInfo.isModified(selectedInfo.getId() == info.getId())) {
                    this.moveToStandardPlaceImpl(selectedInfo.getId(), selectedInfo.getData());
                }
                if (content2 == null) {
                    content2 = this.addContent(info);
                }
            }
            finally {
                this.myInnerSelectionChange = false;
            }
        }
        if (content2 != null) {
            this.myContentManager.addContent(content2, 0);
        }
        this.myInnerSelectionChange = true;
        try {
            if (content2 != null) {
                PreviewManagerImpl.updateContentWithInfo(content2, info);
                this.myContentManager.setSelectedContent(content2, requestFocus);
            }
            C c = info.initComponent(requestFocus);
            return c;
        }
        finally {
            this.myInnerSelectionChange = false;
        }
    }

    @Override
    public <V, C> void close(@NotNull PreviewProviderId<V, C> id2, V data2) {
        if (id2 == null) {
            PreviewManagerImpl.$$$reportNull$$$0(7);
        }
        for (Content content2 : this.myContentManager.getContents()) {
            PreviewInfo info = content2.getUserData(INFO_KEY);
            if (info == null || info.getId() != id2 || !info.getProvider().contentsAreEqual(info.getData(), data2)) continue;
            this.close(info);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, C> void moveToStandardPlaceImpl(@NotNull PreviewProviderId<V, C> id2, V data2) {
        PreviewPanelProvider<V, C> provider;
        if (id2 == null) {
            PreviewManagerImpl.$$$reportNull$$$0(8);
        }
        if ((provider = this.findProvider(id2)) == null) {
            return;
        }
        this.myLockedProviderIds.add(id2);
        try {
            provider.showInStandardPlace(data2);
        }
        finally {
            this.myLockedProviderIds.remove(id2);
        }
        this.close(id2, data2);
    }

    private void toggleToolWindow(boolean activate2) {
        ToolWindow toolWindow = ToolWindowManager.getInstance(this.myProject).getToolWindow("Preview");
        if (toolWindow != null && activate2 != toolWindow.isActive()) {
            if (activate2) {
                toolWindow.activate(null, true);
            } else if (!this.myAlarm.isEmpty()) {
                toolWindow.hide(null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/preview/impl/PreviewManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/preview/impl/PreviewManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preview";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveToStandardPlaceImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyStatePanel
    extends JPanel {
        EmptyStatePanel() {
            this.setOpaque(true);
        }

        @Override
        public void paint(Graphics g) {
            boolean isDarkBackground = StartupUiUtil.isUnderDarcula();
            UISettings.setupAntialiasing(g);
            UIUtil.TextPainter painter = new UIUtil.TextPainter().withLineSpacing(1.5f).withColor(new JBColor(isDarkBackground ? Gray._230 : Gray._80, Gray._160)).withFont(JBUI.Fonts.label(isDarkBackground ? 24.0f : 20.0f)).withShadow(true, new JBColor(Gray._200.withAlpha(100), Gray._0.withAlpha(255)));
            painter.appendLine("No files are open");
            painter.draw(g, (width, height) -> {
                Dimension s = this.getSize();
                return Couple.of((s.width - width) / 2, (s.height - height) / 2);
            });
        }
    }

    private class ContentTypeToggleAction
    extends ToggleAction {
        private final PreviewPanelProvider myProvider;

        ContentTypeToggleAction(PreviewPanelProvider provider) {
            super(provider.getId().getVisualName());
            this.myProvider = provider;
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ContentTypeToggleAction.$$$reportNull$$$0(0);
            }
            return PreviewManagerImpl.this.myActiveProviderIds.contains(this.myProvider.getId());
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ContentTypeToggleAction.$$$reportNull$$$0(1);
            }
            if (state) {
                PreviewManagerImpl.this.myActiveProviderIds.add(this.myProvider.getId());
            } else {
                PreviewManagerImpl.this.myActiveProviderIds.remove(this.myProvider.getId());
                Iterator iterator2 = PreviewManagerImpl.this.myHistory.iterator();
                while (iterator2.hasNext()) {
                    PreviewInfo info = (PreviewInfo)iterator2.next();
                    if (!info.getId().equals(this.myProvider.getId())) continue;
                    Content content2 = PreviewManagerImpl.this.getContent(info);
                    if (content2 != null) {
                        PreviewManagerImpl.this.myContentManager.removeContent(content2, true);
                    }
                    iterator2.remove();
                }
                PreviewManagerImpl.this.checkEmptyState();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/preview/impl/PreviewManagerImpl$ContentTypeToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MoveToStandardViewAction
    extends AnAction {
        MoveToStandardViewAction() {
            super(IdeBundle.messagePointer("action.AnAction.text.move.to.standard.view", new Object[0]), IdeBundle.messagePointer("action.AnAction.description.move.to.standard.view", new Object[0]), AllIcons.Actions.MoveTo2);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Content selectedContent;
            if (e == null) {
                MoveToStandardViewAction.$$$reportNull$$$0(0);
            }
            if ((selectedContent = PreviewManagerImpl.this.myContentManager.getSelectedContent()) == null) {
                return;
            }
            PreviewInfo previewInfo = (PreviewInfo)selectedContent.getUserData(INFO_KEY);
            if (previewInfo != null) {
                PreviewManagerImpl.this.moveToStandardPlaceImpl(previewInfo.getId(), previewInfo.getData());
                PreviewManagerImpl.this.toggleToolWindow(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/preview/impl/PreviewManagerImpl$MoveToStandardViewAction", "actionPerformed"));
        }
    }
}

