/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundableProcessIndicator
extends ProgressWindow {
    protected StatusBarEx myStatusBar;
    private PerformInBackgroundOption myOption;
    private TaskInfo myInfo;
    private boolean myDisposed;

    public BackgroundableProcessIndicator(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(0);
        }
        this(task2.getProject(), task2, task2);
    }

    public BackgroundableProcessIndicator(@Nullable Project project2, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option2) {
        if (info == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(1);
        }
        if (option2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(2);
        }
        this(project2, info, option2, BackgroundableProcessIndicator.getStatusBar(project2));
    }

    BackgroundableProcessIndicator(@Nullable Project project2, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option2, @Nullable StatusBarEx statusBar) {
        if (info == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(3);
        }
        if (option2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(4);
        }
        super(info.isCancellable(), true, project2, info.getCancelText());
        this.setOwnerTask(info);
        this.myOption = option2;
        this.myInfo = info;
        this.setTitle(info.getTitle());
        this.myStatusBar = statusBar;
        this.myBackgrounded = this.shouldStartInBackground();
        if (this.myBackgrounded) {
            this.doBackground();
        }
    }

    @Nullable
    private static StatusBarEx getStatusBar(@Nullable Project project2) {
        Project nonDefaultProject = project2 == null || project2.isDisposed() || project2.isDefault() ? null : project2;
        IdeFrameEx frame = WindowManagerEx.getInstanceEx().findFrameHelper(nonDefaultProject);
        return frame != null ? (StatusBarEx)frame.getStatusBar() : null;
    }

    private boolean shouldStartInBackground() {
        return this.myOption.shouldStartInBackground() && this.myStatusBar != null;
    }

    public BackgroundableProcessIndicator(Project project2, final @Nls(capitalization=Nls.Capitalization.Title) String progressTitle, @NotNull PerformInBackgroundOption option2, final @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelButtonText, final @Nls(capitalization=Nls.Capitalization.Sentence) String backgroundStopTooltip, final boolean cancellable) {
        if (option2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(5);
        }
        this(project2, new TaskInfo(){

            @Override
            @NotNull
            public String getTitle() {
                String string = progressTitle;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public String getCancelText() {
                return cancelButtonText;
            }

            @Override
            public String getCancelTooltipText() {
                return backgroundStopTooltip;
            }

            @Override
            public boolean isCancellable() {
                return cancellable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator$1", "getTitle"));
            }
        }, option2);
    }

    @Override
    protected void showDialog() {
        if (this.myDisposed) {
            return;
        }
        if (this.shouldStartInBackground()) {
            return;
        }
        super.showDialog();
    }

    @Override
    public void background() {
        if (this.myDisposed) {
            return;
        }
        this.myOption.processSentToBackground();
        this.doBackground();
        super.background();
    }

    private void doBackground() {
        if (this.myStatusBar != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                StatusBarEx statusBar = this.myStatusBar;
                if (statusBar != null) {
                    statusBar.addProgress(this, this.myInfo);
                }
            });
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myDisposed = true;
        this.myInfo = null;
        this.myStatusBar = null;
        this.myOption = null;
    }

    @Override
    public boolean isShowing() {
        return this.isModal() || !this.isBackgrounded();
    }

    @Override
    public String toString() {
        return super.toString() + "; task=" + this.myInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "task";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "option";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

