/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.concurrency.PlainEdtExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressManagerImpl
extends CoreProgressManager
implements Disposable {
    private static final Key<Boolean> SAFE_PROGRESS_INDICATOR = Key.create("SAFE_PROGRESS_INDICATOR");
    private final Set<CoreProgressManager.CheckCanceledHook> myHooks = ContainerUtil.newConcurrentSet();
    private final CoreProgressManager.CheckCanceledHook mySleepHook = __ -> this.sleepIfNeededToGivePriorityToAnotherThread();

    public ProgressManagerImpl() {
        ExtensionPointImpl.setCheckCanceledAction(ProgressManager::checkCanceled);
    }

    @Override
    public boolean hasUnsafeProgressIndicator() {
        return super.hasUnsafeProgressIndicator() || ContainerUtil.exists(this.getCurrentIndicators(), ProgressManagerImpl::isUnsafeIndicator);
    }

    private static boolean isUnsafeIndicator(ProgressIndicator indicator) {
        return indicator instanceof ProgressWindow && ((ProgressWindow)indicator).getUserData(SAFE_PROGRESS_INDICATOR) == null;
    }

    public void markProgressSafe(@NotNull ProgressWindow progress2) {
        if (progress2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(0);
        }
        progress2.putUserData(SAFE_PROGRESS_INDICATOR, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress2) throws ProcessCanceledException {
        CoreProgressManager.CheckCanceledHook hook2;
        if (process2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(1);
        }
        CoreProgressManager.CheckCanceledHook checkCanceledHook = hook2 = progress2 instanceof PingProgress && ApplicationManager.getApplication().isDispatchThread() ? p -> {
            ((PingProgress)((Object)progress2)).interact();
            return true;
        } : null;
        if (hook2 != null) {
            this.addCheckCanceledHook(hook2);
        }
        try {
            super.executeProcessUnderProgress(process2, progress2);
        }
        finally {
            if (hook2 != null) {
                this.removeCheckCanceledHook(hook2);
            }
        }
    }

    public static void __testWhileAlwaysCheckingCanceled(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(2);
        }
        Thread fake = new Thread("fake");
        try {
            threadsUnderCanceledIndicator.add(fake);
            runnable2.run();
        }
        finally {
            threadsUnderCanceledIndicator.remove(fake);
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Task task2, @Nullable JComponent parentComponent) {
        if (task2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(3);
        }
        long start2 = System.currentTimeMillis();
        boolean result2 = super.runProcessWithProgressSynchronously(task2, parentComponent);
        if (result2) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task2.notifyFinished();
            long time = end - start2;
            if (notificationInfo != null && time > 5000L && (frame = WindowManager.getInstance().getFrame(task2.getProject())) != null && !frame.hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
        }
        return result2;
    }

    private static void systemNotify(@NotNull Task.NotificationInfo info) {
        if (info == null) {
            ProgressManagerImpl.$$$reportNull$$$0(4);
        }
        SystemNotifications.getInstance().notify(info.getNotificationName(), info.getNotificationTitle(), info.getNotificationText());
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(5);
        }
        CompletableFuture<ProgressIndicator> progressIndicator2 = CompletableFuture.supplyAsync(() -> ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task2), (Executor)PlainEdtExecutor.INSTANCE);
        Future<?> future2 = this.runProcessWithProgressAsync(task2, progressIndicator2, null, null, null);
        if (future2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(6);
        }
        return future2;
    }

    @Override
    void notifyTaskFinished(@NotNull Task.Backgroundable task2, long elapsed) {
        Window window;
        Task.NotificationInfo notificationInfo;
        if (task2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(7);
        }
        if ((notificationInfo = task2.notifyFinished()) != null && elapsed > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
            ProgressManagerImpl.systemNotify(notificationInfo);
        }
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator indicator) {
        if (action2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(8);
        }
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action2, indicator);
    }

    void addCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook2) {
        if (hook2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(9);
        }
        if (this.myHooks.add(hook2)) {
            this.updateShouldCheckCanceled();
        }
    }

    void removeCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook2) {
        if (hook2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(10);
        }
        if (this.myHooks.remove(hook2)) {
            this.updateShouldCheckCanceled();
        }
    }

    @Override
    @Nullable
    protected CoreProgressManager.CheckCanceledHook createCheckCanceledHook() {
        if (this.myHooks.isEmpty()) {
            return null;
        }
        CoreProgressManager.CheckCanceledHook[] activeHooks = this.myHooks.toArray(new CoreProgressManager.CheckCanceledHook[0]);
        return activeHooks.length == 1 ? activeHooks[0] : indicator -> {
            boolean result2 = false;
            for (CoreProgressManager.CheckCanceledHook hook2 : activeHooks) {
                if (!hook2.runHook(indicator)) continue;
                result2 = true;
            }
            return result2;
        };
    }

    @Override
    protected void prioritizingStarted() {
        this.addCheckCanceledHook(this.mySleepHook);
    }

    @Override
    protected void prioritizingFinished() {
        this.removeCheckCanceledHook(this.mySleepHook);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/ProgressManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hook";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsynchronously";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "markProgressSafe";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "__testWhileAlwaysCheckingCanceled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "systemNotify";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCheckCanceledHook";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeCheckCanceledHook";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

