/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BlockingProgressIndicator;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.EDT;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressRunner<R, P extends ProgressIndicator> {
    @NotNull
    private final Function<? super ProgressIndicator, R> myComputation;
    private final boolean isSync;
    private final boolean isModal;
    private final ThreadToUse myThreadToUse;
    @Nullable
    private final CompletableFuture<P> myProgressIndicatorFuture;

    public ProgressRunner(@NotNull Runnable computation) {
        if (computation == null) {
            ProgressRunner.$$$reportNull$$$0(0);
        }
        this((? super ProgressIndicator progress2) -> {
            computation.run();
            return null;
        });
    }

    public ProgressRunner(@NotNull Task task2) {
        if (task2 == null) {
            ProgressRunner.$$$reportNull$$$0(1);
        }
        this((? super ProgressIndicator progress2) -> {
            try {
                task2.run((ProgressIndicator)progress2);
            }
            finally {
                if (progress2 instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)progress2).finish(task2);
                }
            }
            return null;
        });
    }

    public ProgressRunner(@NotNull Function<? super ProgressIndicator, R> computation) {
        if (computation == null) {
            ProgressRunner.$$$reportNull$$$0(2);
        }
        this(computation, false, false, ThreadToUse.POOLED, null);
    }

    private ProgressRunner(@NotNull Function<? super ProgressIndicator, R> computation, boolean sync, boolean modal, @NotNull ThreadToUse use2, @Nullable CompletableFuture<P> progressIndicatorFuture) {
        if (computation == null) {
            ProgressRunner.$$$reportNull$$$0(3);
        }
        if (use2 == null) {
            ProgressRunner.$$$reportNull$$$0(4);
        }
        this.myComputation = computation;
        this.isSync = sync;
        this.isModal = modal;
        this.myThreadToUse = use2;
        this.myProgressIndicatorFuture = progressIndicatorFuture;
    }

    @NotNull
    public ProgressRunner<R, P> sync() {
        return new ProgressRunner<R, P>(this.myComputation, true, this.isModal, this.myThreadToUse, this.myProgressIndicatorFuture);
    }

    public ProgressRunner<R, P> modal() {
        return new ProgressRunner<R, P>(this.myComputation, this.isSync, true, this.myThreadToUse, this.myProgressIndicatorFuture);
    }

    @NotNull
    public ProgressRunner<R, P> onThread(@NotNull ThreadToUse thread) {
        if (thread == null) {
            ProgressRunner.$$$reportNull$$$0(5);
        }
        return new ProgressRunner<R, P>(this.myComputation, this.isSync, this.isModal, thread, this.myProgressIndicatorFuture);
    }

    @NotNull
    public <P1 extends ProgressIndicator> ProgressRunner<R, P1> withProgress(@NotNull P1 progressIndicator2) {
        if (progressIndicator2 == null) {
            ProgressRunner.$$$reportNull$$$0(6);
        }
        return new ProgressRunner<R, P1>(this.myComputation, this.isSync, this.isModal, this.myThreadToUse, CompletableFuture.completedFuture(progressIndicator2));
    }

    @NotNull
    public <P1 extends ProgressIndicator> ProgressRunner<R, P1> withProgress(@NotNull CompletableFuture<P1> progressIndicatorFuture) {
        if (progressIndicatorFuture == null) {
            ProgressRunner.$$$reportNull$$$0(7);
        }
        return new ProgressRunner<R, P1>(this.myComputation, this.isSync, this.isModal, this.myThreadToUse, progressIndicatorFuture);
    }

    @NotNull
    public ProgressResult<R> submitAndGet() {
        ProgressResult<R> progressResult;
        CompletableFuture<ProgressResult<R>> future2 = this.sync().submit();
        try {
            progressResult = future2.get();
        }
        catch (Throwable e) {
            throw new AssertionError((Object)"submit() handles exceptions and always returns successful future");
        }
        if (progressResult == null) {
            ProgressRunner.$$$reportNull$$$0(8);
        }
        return progressResult;
    }

    @NotNull
    public CompletableFuture<ProgressResult<R>> submit() {
        CompletableFuture<Object> resultFuture;
        boolean forceSyncExec = this.checkIfForceDirectExecNeeded();
        CompletionStage<EmptyProgressIndicator> progressFuture = this.myProgressIndicatorFuture == null ? CompletableFuture.completedFuture(new EmptyProgressIndicator()) : this.myProgressIndicatorFuture.thenApply(progress2 -> {
            if (progress2 instanceof Disposable) {
                Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progress2));
            }
            return progress2;
        });
        Semaphore modalityEntered = new Semaphore(forceSyncExec ? 0 : 1);
        Supplier<Object> onThreadCallable = () -> {
            ProgressIndicator progressIndicator2;
            Ref result2 = Ref.create();
            if (this.isModal) {
                modalityEntered.waitFor();
            }
            try {
                progressIndicator2 = (ProgressIndicator)progressFuture.get();
            }
            catch (Throwable e) {
                throw new RuntimeException("Can't get progress", e);
            }
            ProgressManager.getInstance().runProcess(() -> result2.set(this.myComputation.apply(progressIndicator2)), progressIndicator2);
            return result2.get();
        };
        if (forceSyncExec) {
            resultFuture = new CompletableFuture<Object>();
            try {
                resultFuture.complete(onThreadCallable.get());
            }
            catch (Throwable t) {
                resultFuture.completeExceptionally(t);
            }
        } else {
            resultFuture = ApplicationManager.getApplication().isDispatchThread() ? this.legacyExec((CompletableFuture<? extends ProgressIndicator>)progressFuture, modalityEntered, (Supplier<R>)onThreadCallable) : this.normalExec((CompletableFuture<? extends ProgressIndicator>)progressFuture, modalityEntered, (Supplier<R>)onThreadCallable);
        }
        CompletionStage completionStage = resultFuture.handle((result2, e) -> {
            Throwable throwable = ProgressRunner.unwrap(e);
            return new ProgressResult<Object>(result2, throwable instanceof ProcessCanceledException || ProgressRunner.isCanceled(progressFuture), throwable);
        });
        if (completionStage == null) {
            ProgressRunner.$$$reportNull$$$0(9);
        }
        return completionStage;
    }

    private boolean checkIfForceDirectExecNeeded() {
        boolean forceDirectExec;
        if (this.isSync && EDT.isCurrentThreadEdt() && !ApplicationManager.getApplication().isWriteThread()) {
            throw new IllegalStateException("Running sync tasks on pure EDT (w/o IW lock) is dangerous for several reasons.");
        }
        if (!this.isSync && this.isModal && EDT.isCurrentThreadEdt()) {
            throw new IllegalStateException("Running async modal tasks from EDT is impossible: modal implies sync dialog show + polling events");
        }
        boolean bl = forceDirectExec = this.isSync && ApplicationManager.getApplication().isDispatchThread() && (ApplicationManager.getApplication().isWriteAccessAllowed() || !this.isModal);
        if (forceDirectExec) {
            String reason = ApplicationManager.getApplication().isWriteAccessAllowed() ? "inside Write Action" : "not modal execution";
            String failedConstraints = "";
            if (this.isModal) {
                failedConstraints = failedConstraints + "Use Modal execution; ";
            }
            if (this.myThreadToUse == ThreadToUse.POOLED) {
                failedConstraints = failedConstraints + "Use pooled thread; ";
            }
            failedConstraints = StringUtil.defaultIfEmpty(failedConstraints, "none");
            Logger.getInstance(ProgressRunner.class).warn("Forced to sync exec on EDT. Reason: " + reason + ". Failed constraints: " + failedConstraints, new Throwable());
        }
        return forceDirectExec;
    }

    @NotNull
    private CompletableFuture<R> legacyExec(CompletableFuture<? extends ProgressIndicator> progressFuture, Semaphore modalityEntered, Supplier<R> onThreadCallable) {
        CompletionStage<Object> resultFuture;
        CompletableFuture taskFuture = this.launchTask(onThreadCallable, progressFuture);
        if (this.isModal) {
            CompletionStage blockingRunFuture = ((CompletableFuture)progressFuture.thenAccept(progressIndicator2 -> {
                if (progressIndicator2 instanceof BlockingProgressIndicator) {
                    ((BlockingProgressIndicator)progressIndicator2).startBlocking(modalityEntered::up);
                } else {
                    Logger.getInstance(ProgressRunner.class).warn("Can't go modal without BlockingProgressIndicator");
                    modalityEntered.up();
                }
            })).exceptionally(throwable -> {
                taskFuture.completeExceptionally((Throwable)throwable);
                return null;
            });
            resultFuture = taskFuture.thenCombine(blockingRunFuture, (r, __) -> r);
        } else {
            resultFuture = taskFuture;
        }
        if (this.isSync) {
            try {
                resultFuture.get();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        CompletableFuture completableFuture = resultFuture;
        if (completableFuture == null) {
            ProgressRunner.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<R> normalExec(CompletableFuture<? extends ProgressIndicator> progressFuture, Semaphore modalityEntered, Supplier<R> onThreadCallable) {
        Function<ProgressIndicator, ProgressIndicator> modalityRunnable = progressIndicator2 -> {
            LaterInvocator.enterModal(progressIndicator2, (ModalityStateEx)progressIndicator2.getModalityState());
            modalityEntered.up();
            return progressIndicator2;
        };
        if (this.isModal) {
            progressFuture = progressFuture.thenApplyAsync(modalityRunnable, r -> {
                if (ApplicationManager.getApplication().isWriteThread()) {
                    r.run();
                } else {
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(r);
                }
            });
        }
        CompletionStage<Object> resultFuture = this.launchTask(onThreadCallable, (CompletableFuture<? extends ProgressIndicator>)progressFuture);
        if (this.isModal) {
            CompletionStage modalityExitFuture = ((CompletableFuture)resultFuture.handle((r, throwable) -> r)).thenAcceptBoth(progressFuture, (r, progressIndicator2) -> {
                if (ApplicationManager.getApplication().isWriteThread()) {
                    LaterInvocator.leaveModal(progressIndicator2);
                } else {
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> LaterInvocator.leaveModal(progressIndicator2), progressIndicator2.getModalityState());
                }
            });
            resultFuture = resultFuture.thenCombine(modalityExitFuture, (r, __) -> r);
        }
        if (this.isSync) {
            ProgressRunner.waitForFutureUnlockingThread(resultFuture);
        }
        CompletableFuture<R> completableFuture = resultFuture;
        if (completableFuture == null) {
            ProgressRunner.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    private static void waitForFutureUnlockingThread(CompletableFuture<?> resultFuture) {
        if (ApplicationManager.getApplication().isWriteThread()) {
            ProgressRunner.pollLaterInvocatorActively(resultFuture, LaterInvocator::pollWriteThreadEventsOnce);
        } else {
            if (EDT.isCurrentThreadEdt()) {
                throw new UnsupportedOperationException("Sync waiting from pure EDT is dangerous.");
            }
            try {
                resultFuture.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void pollLaterInvocatorActively(CompletableFuture<?> resultFuture, @NotNull Runnable pollAction) {
        if (pollAction == null) {
            ProgressRunner.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().runUnlockingIntendedWrite(() -> {
            while (true) {
                try {
                    resultFuture.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignore) {
                    ApplicationManager.getApplication().runIntendedWriteActionOnCurrentThread(pollAction);
                }
                finally {
                    continue;
                }
                break;
            }
            return null;
        });
    }

    public static boolean isCanceled(@NotNull Future<? extends ProgressIndicator> progressFuture) {
        if (progressFuture == null) {
            ProgressRunner.$$$reportNull$$$0(13);
        }
        try {
            return progressFuture.get().isCanceled();
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Nullable
    public static Throwable unwrap(@Nullable Throwable exception) {
        return exception instanceof CompletionException || exception instanceof ExecutionException ? exception.getCause() : exception;
    }

    @NotNull
    private CompletableFuture<R> launchTask(Supplier<R> callable, CompletableFuture<? extends ProgressIndicator> progressIndicatorFuture) {
        CompletableFuture<Object> resultFuture;
        switch (this.myThreadToUse) {
            case POOLED: {
                resultFuture = CompletableFuture.supplyAsync(callable, AppExecutorUtil.getAppExecutorService());
                break;
            }
            case WRITE: {
                resultFuture = new CompletableFuture();
                Runnable runnable2 = () -> {
                    try {
                        resultFuture.complete(callable.get());
                    }
                    catch (Throwable e) {
                        resultFuture.completeExceptionally(e);
                    }
                };
                progressIndicatorFuture.whenComplete((progressIndicator2, throwable) -> {
                    if (throwable != null) {
                        resultFuture.completeExceptionally((Throwable)throwable);
                        return;
                    }
                    ModalityState processModality = progressIndicator2.getModalityState();
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(runnable2, processModality);
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.myThreadToUse));
            }
        }
        CompletableFuture<Object> completableFuture = resultFuture;
        if (completableFuture == null) {
            ProgressRunner.$$$reportNull$$$0(14);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicatorFuture";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/ProgressRunner";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pollAction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressFuture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressRunner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "submitAndGet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "legacyExec";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "normalExec";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "launchTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onThread";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withProgress";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "pollLaterInvocatorActively";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCanceled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ThreadToUse {
        WRITE,
        POOLED;

    }
}

