/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ProgressSuspender
implements AutoCloseable {
    private static final Key<ProgressSuspender> PROGRESS_SUSPENDER = Key.create("PROGRESS_SUSPENDER");
    public static final Topic<SuspenderListener> TOPIC = Topic.create("ProgressSuspender", SuspenderListener.class);
    private final Object myLock;
    private static final Application ourApp = ApplicationManager.getApplication();
    @NotNull
    private final String mySuspendedText;
    @Nullable
    private String myTempReason;
    private final SuspenderListener myPublisher;
    private volatile boolean mySuspended;
    private final CoreProgressManager.CheckCanceledHook myHook;
    private final Set<ProgressIndicator> myProgresses;
    private boolean myClosed;

    private ProgressSuspender(@NotNull ProgressIndicatorEx progress2, @NotNull String suspendedText) {
        if (progress2 == null) {
            ProgressSuspender.$$$reportNull$$$0(0);
        }
        if (suspendedText == null) {
            ProgressSuspender.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myHook = this::freezeIfNeeded;
        this.myProgresses = ContainerUtil.newConcurrentSet();
        this.mySuspendedText = suspendedText;
        assert (progress2.isRunning());
        assert (ProgressIndicatorProvider.getGlobalProgressIndicator() == progress2);
        this.myPublisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        this.attachToProgress(progress2);
        new ProgressIndicatorListenerAdapter(){

            @Override
            public void cancelled() {
                ProgressSuspender.this.resumeProcess();
            }
        }.installToProgress(progress2);
        this.myPublisher.suspendableProgressAppeared(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Iterator<ProgressIndicator> iterator2 = this.myLock;
        synchronized (iterator2) {
            this.myClosed = true;
            this.mySuspended = false;
            ((ProgressManagerImpl)ProgressManager.getInstance()).removeCheckCanceledHook(this.myHook);
        }
        for (ProgressIndicator progress2 : this.myProgresses) {
            ((UserDataHolder)((Object)progress2)).putUserData(PROGRESS_SUSPENDER, null);
        }
    }

    public static ProgressSuspender markSuspendable(@NotNull ProgressIndicator indicator, @NotNull String suspendedText) {
        if (indicator == null) {
            ProgressSuspender.$$$reportNull$$$0(2);
        }
        if (suspendedText == null) {
            ProgressSuspender.$$$reportNull$$$0(3);
        }
        return new ProgressSuspender((ProgressIndicatorEx)indicator, suspendedText);
    }

    @Nullable
    public static ProgressSuspender getSuspender(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProgressSuspender.$$$reportNull$$$0(4);
        }
        return indicator instanceof UserDataHolder ? ((UserDataHolder)((Object)indicator)).getUserData(PROGRESS_SUSPENDER) : null;
    }

    public void attachToProgress(@NotNull ProgressIndicatorEx progress2) {
        if (progress2 == null) {
            ProgressSuspender.$$$reportNull$$$0(5);
        }
        this.myProgresses.add(progress2);
        ((UserDataHolder)((Object)progress2)).putUserData(PROGRESS_SUSPENDER, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String getSuspendedText() {
        Object object = this.myLock;
        // MONITORENTER : object
        String string = this.myTempReason != null ? this.myTempReason : this.mySuspendedText;
        // MONITOREXIT : object
        if (string != null) return string;
        ProgressSuspender.$$$reportNull$$$0(6);
        return string;
    }

    public boolean isSuspended() {
        return this.mySuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendProcess(@Nullable String reason) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySuspended || this.myClosed) {
                return;
            }
            this.mySuspended = true;
            this.myTempReason = reason;
            ((ProgressManagerImpl)ProgressManager.getInstance()).addCheckCanceledHook(this.myHook);
        }
        this.myPublisher.suspendedStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeProcess() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.mySuspended) {
                return;
            }
            this.mySuspended = false;
            this.myTempReason = null;
            ((ProgressManagerImpl)ProgressManager.getInstance()).removeCheckCanceledHook(this.myHook);
            this.myLock.notifyAll();
        }
        this.myPublisher.suspendedStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean freezeIfNeeded(ProgressIndicator current2) {
        if (ProgressSuspender.isCurrentThreadHoldingKnownLocks()) {
            return false;
        }
        if (current2 == null) {
            current2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        }
        if (current2 == null || !this.myProgresses.contains(current2)) {
            return false;
        }
        Object object = this.myLock;
        synchronized (object) {
            while (this.mySuspended) {
                try {
                    this.myLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    private static boolean isCurrentThreadHoldingKnownLocks() {
        if (ourApp.isReadAccessAllowed()) {
            return true;
        }
        ThreadInfo[] infos = ManagementFactory.getThreadMXBean().getThreadInfo(new long[]{Thread.currentThread().getId()}, true, false);
        return infos.length > 0 && infos[0].getLockedMonitors().length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendedText";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/ProgressSuspender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressSuspender";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "markSuspendable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuspender";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "attachToProgress";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SuspenderListener {
        default public void suspendableProgressAppeared(@NotNull ProgressSuspender suspender) {
            if (suspender == null) {
                SuspenderListener.$$$reportNull$$$0(0);
            }
        }

        default public void suspendedStatusChanged(@NotNull ProgressSuspender suspender) {
            if (suspender == null) {
                SuspenderListener.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "suspender";
            objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressSuspender$SuspenderListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suspendableProgressAppeared";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suspendedStatusChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

