/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public abstract class AtomicCancelableLazyValue<T> {
    private static final int TIMEOUT = 50;
    private volatile T myValue;
    private final ReentrantLock myLock = new ReentrantLock();

    @NotNull
    public final T getValue() {
        T curValue = this.myValue;
        if (curValue != null) {
            T t = curValue;
            if (t == null) {
                AtomicCancelableLazyValue.$$$reportNull$$$0(0);
            }
            return t;
        }
        Object object = ProgressIndicatorUtils.computeWithLockAndCheckingCanceled(this.myLock, 50, TimeUnit.MILLISECONDS, () -> {
            T value2 = this.myValue;
            if (value2 == null) {
                RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                value2 = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value2;
                }
            }
            return value2;
        });
        if (object == null) {
            AtomicCancelableLazyValue.$$$reportNull$$$0(1);
        }
        return (T)object;
    }

    @NotNull
    protected abstract T compute();

    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> AtomicCancelableLazyValue<T> createValue(final @NotNull NotNullFactory<? extends T> value2) {
        if (value2 == null) {
            AtomicCancelableLazyValue.$$$reportNull$$$0(2);
        }
        return new AtomicCancelableLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t = value2.create();
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                return t;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/AtomicCancelableLazyValue$1", "compute"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/AtomicCancelableLazyValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/AtomicCancelableLazyValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

