/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.FileContentQueue;
import com.intellij.openapi.project.PoweredProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class CacheUpdateRunner {
    private static final Logger LOG = Logger.getInstance(CacheUpdateRunner.class);
    private static final Key<Boolean> FAILED_TO_INDEX = Key.create("FAILED_TO_INDEX");
    private static final int PROC_COUNT = Runtime.getRuntime().availableProcessors();
    public static final int DEFAULT_MAX_INDEXER_THREADS = 4;

    public static void processFiles(@NotNull ProgressIndicator indicator, @NotNull Collection<? extends VirtualFile> files2, @NotNull Project project2, @NotNull Consumer<? super FileContent> processor2) {
        if (indicator == null) {
            CacheUpdateRunner.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            CacheUpdateRunner.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            CacheUpdateRunner.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            CacheUpdateRunner.$$$reportNull$$$0(3);
        }
        final ProgressIndicator updaterProgressIndicator = PoweredProgressIndicator.apply(indicator);
        updaterProgressIndicator.checkCanceled();
        FileContentQueue queue = new FileContentQueue(project2, files2, updaterProgressIndicator);
        final double total = files2.size();
        queue.startLoading();
        updaterProgressIndicator.setIndeterminate(false);
        ProgressUpdater progressUpdater = new ProgressUpdater(){
            final Set<VirtualFile> myFilesBeingProcessed = new THashSet<VirtualFile>();
            final AtomicInteger myNumberOfFilesProcessed = new AtomicInteger();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processingStarted(@NotNull VirtualFile virtualFile2) {
                boolean added;
                if (virtualFile2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                updaterProgressIndicator.checkCanceled();
                Set<VirtualFile> set = this.myFilesBeingProcessed;
                synchronized (set) {
                    added = this.myFilesBeingProcessed.add(virtualFile2);
                }
                if (added) {
                    updaterProgressIndicator.setFraction((double)this.myNumberOfFilesProcessed.incrementAndGet() / total);
                    VirtualFile parent = virtualFile2.getParent();
                    if (parent != null) {
                        updaterProgressIndicator.setText2(parent.getPresentableUrl());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processingSuccessfullyFinished(@NotNull VirtualFile virtualFile2) {
                if (virtualFile2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                Set<VirtualFile> set = this.myFilesBeingProcessed;
                synchronized (set) {
                    boolean removed = this.myFilesBeingProcessed.remove(virtualFile2);
                    assert (removed);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "virtualFile";
                objectArray2[1] = "com/intellij/openapi/project/CacheUpdateRunner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processingStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processingSuccessfullyFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        while (!project2.isDisposed()) {
            updaterProgressIndicator.checkCanceled();
            if (!CacheUpdateRunner.processSomeFilesWhileUserIsInactive(queue, progressUpdater, updaterProgressIndicator, project2, processor2)) continue;
        }
        if (project2.isDisposed()) {
            updaterProgressIndicator.cancel();
            updaterProgressIndicator.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processSomeFilesWhileUserIsInactive(@NotNull FileContentQueue queue, @NotNull ProgressUpdater progressUpdater, @NotNull ProgressIndicator suspendableIndicator, @NotNull Project project2, @NotNull Consumer<? super FileContent> fileProcessor) {
        if (queue == null) {
            CacheUpdateRunner.$$$reportNull$$$0(4);
        }
        if (progressUpdater == null) {
            CacheUpdateRunner.$$$reportNull$$$0(5);
        }
        if (suspendableIndicator == null) {
            CacheUpdateRunner.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            CacheUpdateRunner.$$$reportNull$$$0(7);
        }
        if (fileProcessor == null) {
            CacheUpdateRunner.$$$reportNull$$$0(8);
        }
        final ProgressIndicatorBase innerIndicator = new ProgressIndicatorBase(){

            @Override
            protected boolean isCancelable() {
                return true;
            }
        };
        ApplicationListener canceller = new ApplicationListener(){

            @Override
            public void beforeWriteActionStart(@NotNull Object action2) {
                if (action2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                innerIndicator.cancel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/project/CacheUpdateRunner$3", "beforeWriteActionStart"));
            }
        };
        Application application = ApplicationManager.getApplication();
        Disposable listenerDisposable = Disposer.newDisposable();
        application.invokeAndWait(() -> application.addApplicationListener(canceller, listenerDisposable), ModalityState.any());
        AtomicBoolean isFinished = new AtomicBoolean();
        try {
            int threadsCount = CacheUpdateRunner.indexingThreadCount();
            if (threadsCount == 1 || application.isWriteAccessAllowed()) {
                Runnable process2 = CacheUpdateRunner.createRunnable(project2, queue, progressUpdater, suspendableIndicator, innerIndicator, isFinished, fileProcessor);
                ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)innerIndicator);
            } else {
                AtomicBoolean[] finishedRefs = new AtomicBoolean[threadsCount];
                Future[] futures = new Future[threadsCount];
                for (int i = 0; i < threadsCount; ++i) {
                    AtomicBoolean localFinished;
                    finishedRefs[i] = localFinished = new AtomicBoolean();
                    Runnable process3 = CacheUpdateRunner.createRunnable(project2, queue, progressUpdater, suspendableIndicator, innerIndicator, localFinished, fileProcessor);
                    futures[i] = application.executeOnPooledThread(process3);
                }
                isFinished.set(CacheUpdateRunner.waitForAll(finishedRefs, futures));
            }
        }
        finally {
            Disposer.dispose(listenerDisposable);
        }
        return isFinished.get();
    }

    public static int indexingThreadCount() {
        int threadsCount = Registry.intValue("caches.indexerThreadsCount");
        if (threadsCount <= 0) {
            int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
            threadsCount = Math.max(1, Math.min(PROC_COUNT - coresToLeaveForOtherActivity, 4));
        }
        return threadsCount;
    }

    private static boolean waitForAll(AtomicBoolean @NotNull [] finishedRefs, Future<?> @NotNull [] futures) {
        if (finishedRefs == null) {
            CacheUpdateRunner.$$$reportNull$$$0(9);
        }
        if (futures == null) {
            CacheUpdateRunner.$$$reportNull$$$0(10);
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        try {
            for (Future<?> future2 : futures) {
                ProgressIndicatorUtils.awaitWithCheckCanceled(future2);
            }
            boolean allFinished = true;
            for (AtomicBoolean ref : finishedRefs) {
                if (ref.get()) continue;
                allFinished = false;
                break;
            }
            return allFinished;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
            return false;
        }
    }

    private static Runnable createRunnable(@NotNull Project project2, @NotNull FileContentQueue queue, @NotNull ProgressUpdater progressUpdater, @NotNull ProgressIndicator suspendableIndicator, @NotNull ProgressIndicatorBase innerIndicator, @NotNull AtomicBoolean isFinished, @NotNull Consumer<? super FileContent> fileProcessor) {
        if (project2 == null) {
            CacheUpdateRunner.$$$reportNull$$$0(11);
        }
        if (queue == null) {
            CacheUpdateRunner.$$$reportNull$$$0(12);
        }
        if (progressUpdater == null) {
            CacheUpdateRunner.$$$reportNull$$$0(13);
        }
        if (suspendableIndicator == null) {
            CacheUpdateRunner.$$$reportNull$$$0(14);
        }
        if (innerIndicator == null) {
            CacheUpdateRunner.$$$reportNull$$$0(15);
        }
        if (isFinished == null) {
            CacheUpdateRunner.$$$reportNull$$$0(16);
        }
        if (fileProcessor == null) {
            CacheUpdateRunner.$$$reportNull$$$0(17);
        }
        return ConcurrencyUtil.underThreadNameRunnable("Indexing", () -> {
            while (!project2.isDisposed() && !innerIndicator.isCanceled()) {
                try {
                    suspendableIndicator.checkCanceled();
                    FileContent fileContent = queue.take(innerIndicator);
                    if (fileContent == null) {
                        isFinished.set(true);
                        return;
                    }
                    Runnable action2 = () -> {
                        innerIndicator.checkCanceled();
                        if (!project2.isDisposed()) {
                            VirtualFile file2 = fileContent.getVirtualFile();
                            try {
                                progressUpdater.processingStarted(file2);
                                if (!file2.isDirectory() && !Boolean.TRUE.equals(file2.getUserData(FAILED_TO_INDEX))) {
                                    fileProcessor.consume(fileContent);
                                }
                                progressUpdater.processingSuccessfullyFinished(file2);
                            }
                            catch (ProcessCanceledException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                CacheUpdateRunner.handleIndexingException(file2, e);
                            }
                        }
                    };
                    try {
                        ProgressManager.getInstance().runProcess(() -> {
                            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
                            if (app.isDisposed() || !app.tryRunReadAction(action2)) {
                                throw new ProcessCanceledException();
                            }
                        }, (ProgressIndicator)ProgressWrapper.wrap(innerIndicator));
                    }
                    catch (ProcessCanceledException e) {
                        queue.pushBack(fileContent);
                        return;
                    }
                    finally {
                        queue.release(fileContent);
                    }
                }
                catch (ProcessCanceledException e) {
                    return;
                }
            }
            return;
        });
    }

    private static void handleIndexingException(@NotNull VirtualFile file2, @NotNull Throwable e) {
        if (file2 == null) {
            CacheUpdateRunner.$$$reportNull$$$0(18);
        }
        if (e == null) {
            CacheUpdateRunner.$$$reportNull$$$0(19);
        }
        file2.putUserData(FAILED_TO_INDEX, Boolean.TRUE);
        LOG.error("Error while indexing " + file2.getPresentableUrl() + "\nTo reindex this file IDEA has to be restarted", e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressUpdater";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendableIndicator";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishedRefs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerIndicator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isFinished";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/CacheUpdateRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processFiles";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processSomeFilesWhileUserIsInactive";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForAll";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createRunnable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "handleIndexingException";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface ProgressUpdater {
        public void processingStarted(@NotNull VirtualFile var1);

        public void processingSuccessfullyFinished(@NotNull VirtualFile var1);
    }
}

