/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0001\u001a \u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0005\u001a.\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u000f"}, d2={"isExternalStorageEnabled", "", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "appendModuleName", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "result", "moduleOnTheLeft", "decorateWithLibraryName", "displayUrlRelativeToProject", "url", "isIncludeFilePath", "intellij.platform.projectModel"})
@JvmName(name="ProjectUtilCore")
public final class ProjectUtilCore {
    @NotNull
    public static final String displayUrlRelativeToProject(@NotNull VirtualFile file2, @NotNull String url, @NotNull Project project2, boolean isIncludeFilePath, boolean moduleOnTheLeft) {
        String urlWithLibraryName;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        String result2 = url;
        if (isIncludeFilePath) {
            String string;
            String projectHomeUrl = PathUtil.toSystemDependentName(project2.getBasePath());
            if (projectHomeUrl != null && StringsKt.startsWith$default((String)result2, (String)projectHomeUrl, (boolean)false, (int)2, null)) {
                String string2 = result2;
                int n = projectHomeUrl.length();
                StringBuilder stringBuilder = new StringBuilder().append("...");
                boolean bl = false;
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                string = stringBuilder.append(string4).toString();
            } else {
                String string5 = FileUtil.getLocationRelativeToUserHome(file2.getPresentableUrl());
                string = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"FileUtil.getLocationRela\u2026Home(file.presentableUrl)");
            }
            result2 = string;
        }
        if ((urlWithLibraryName = ProjectUtilCore.decorateWithLibraryName(file2, project2, result2)) != null) {
            return urlWithLibraryName;
        }
        if (PlatformUtils.isCidr() || PlatformUtils.isRider()) {
            return result2;
        }
        return ProjectUtilCore.appendModuleName(file2, project2, result2, moduleOnTheLeft);
    }

    @Nullable
    public static final String decorateWithLibraryName(@NotNull VirtualFile file2, @NotNull Project project2, @NotNull String result2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        if (file2.getFileSystem() instanceof LocalFileProvider) {
            VirtualFileSystem virtualFileSystem = file2.getFileSystem();
            if (virtualFileSystem == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.LocalFileProvider");
            }
            VirtualFile localFile = ((LocalFileProvider)((Object)virtualFileSystem)).getLocalVirtualFileFor(file2);
            if (localFile != null) {
                OrderEntry libraryEntry = LibraryUtil.findLibraryEntry(file2, project2);
                if (libraryEntry instanceof JdkOrderEntry) {
                    return result2 + " [" + ((JdkOrderEntry)libraryEntry).getJdkName() + ']';
                }
                if (libraryEntry != null) {
                    return result2 + " [" + libraryEntry.getPresentableName() + ']';
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String appendModuleName(@NotNull VirtualFile file2, @NotNull Project project2, @NotNull String result2, boolean moduleOnTheLeft) {
        String string;
        Module module2;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                module2 = ModuleUtilCore.findModuleForFile(file2, project2);
                if (module2 == null) break block4;
                ModuleManager moduleManager = ModuleManager.getInstance(project2);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                if (moduleManager.getModules().length != 1) break block5;
            }
            string = result2;
            return string;
        }
        if (moduleOnTheLeft) {
            string = '[' + module2.getName() + "] " + result2;
            return string;
        }
        string = result2 + " [" + module2.getName() + ']';
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExternalStorageEnabled(@NotNull Project $this$isExternalStorageEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isExternalStorageEnabled, (String)"$this$isExternalStorageEnabled");
        String string = $this$isExternalStorageEnabled.getProjectFilePath();
        if (string != null) {
            if (StringsKt.endsWith$default((String)string, (String)".ipr", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ServiceManager.getService($this$isExternalStorageEnabled, ExternalStorageConfigurationManager.class);
        if (externalStorageConfigurationManager == null) return false;
        ExternalStorageConfigurationManager manager = externalStorageConfigurationManager;
        if (manager.isEnabled()) return true;
        Application application = ApplicationManager.getApplication();
        if (application == null) return false;
        boolean bl = application.isUnitTestMode();
        if (!bl) return false;
        return true;
    }
}

